/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.impl;

import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.igtimiadapter.BulkFixReceiver;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnection;
import com.sap.sailing.domain.igtimiadapter.IgtimiConnectionFactory;
import com.sap.sailing.domain.igtimiadapter.IgtimiWindListener;
import com.sap.sailing.domain.igtimiadapter.LiveDataConnection;
import com.sap.sailing.domain.igtimiadapter.datatypes.Fix;
import com.sap.sailing.domain.igtimiadapter.shared.IgtimiWindReceiver;
import com.sap.sailing.expeditionconnector.ExpeditionListener;
import com.sap.sailing.expeditionconnector.ExpeditionMessage;
import com.sap.sailing.expeditionconnector.ExpeditionTrackerFactory;
import com.sap.sailing.expeditionconnector.UDPExpeditionReceiver;
import com.sap.sailing.server.gateway.impl.SailingServerHttpServletWithPostBasedContentReplacing;
import com.sap.sailing.udpconnector.UDPMessageListener;
import com.sap.sse.ServerInfo;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.osgi.util.tracker.ServiceTracker;

public abstract class WindStatusServlet
extends SailingServerHttpServletWithPostBasedContentReplacing
implements IgtimiWindListener,
BulkFixReceiver {
    private static final Logger logger = Logger.getLogger(WindStatusServlet.class.getName());
    private static final long serialVersionUID = -6791613843435003810L;
    protected static final String PARAM_RELOAD_WIND_RECEIVER = "reloadWindReceiver";
    protected static final String REFRESHING_CONTENT_DIV_ID = "refreshingContent";
    protected final int NUMBER_OF_MESSAGES_TO_SHOW = 100;
    protected final int NUMBER_OF_MESSAGES_PER_DEVICE_TO_SHOW = 10;
    protected static final DecimalFormat decimalFormatter2Digits = new DecimalFormat("#.##");
    protected static final DecimalFormat decimalFormatter1Digit = new DecimalFormat("#.#");
    protected static final DecimalFormat latLngDecimalFormatter = new DecimalFormat("#.######");
    protected static final DateFormat dateTimeFormatter = DateFormat.getTimeInstance(1);
    private static List<ExpeditionMessageInfo> lastExpeditionMessages;
    private static Object lock;
    private static int igtimiRawMessageCount;
    private static Map<String, Deque<IgtimiMessageInfo>> lastIgtimiMessages;
    private static IgtimiWindReceiver igtimiWindReceiver;
    private static Map<LiveDataConnection, IgtimiConnectionInfo> igtimiConnections;
    private static boolean isExpeditionListenerRegistered;
    private static boolean isIgtimiListenerRegistered;

    static {
        lock = new Object();
    }

    public WindStatusServlet() {
        isExpeditionListenerRegistered = false;
        isIgtimiListenerRegistered = false;
        igtimiConnections = new LinkedHashMap<LiveDataConnection, IgtimiConnectionInfo>();
    }

    protected int getIgtimiMessagesRawCount() {
        return igtimiRawMessageCount;
    }

    protected Map<String, Deque<IgtimiMessageInfo>> getLastIgtimiMessages() {
        return lastIgtimiMessages;
    }

    protected List<ExpeditionMessageInfo> getLastExpeditionMessages() {
        return lastExpeditionMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeWindReceiver(boolean reinitialize) {
        Object object = lock;
        synchronized (object) {
            if (!isExpeditionListenerRegistered || reinitialize) {
                isExpeditionListenerRegistered = this.registerExpeditionListener();
                lastExpeditionMessages = new ArrayList<ExpeditionMessageInfo>();
            }
        }
        object = lock;
        synchronized (object) {
            if (!isIgtimiListenerRegistered || reinitialize) {
                if (reinitialize && !igtimiConnections.isEmpty()) {
                    for (Map.Entry<LiveDataConnection, IgtimiConnectionInfo> entry : igtimiConnections.entrySet()) {
                        LiveDataConnection igtimiConnection = entry.getKey();
                        try {
                            if (igtimiConnection == null) continue;
                            igtimiConnection.stop();
                            igtimiConnection.removeListener((BulkFixReceiver)igtimiWindReceiver);
                            igtimiConnection.removeListener((BulkFixReceiver)this);
                        }
                        catch (Exception e) {
                            logger.log(Level.WARNING, "Exception trying to stop Igtimi connection " + igtimiConnection, e);
                        }
                    }
                    igtimiConnections.clear();
                }
                lastIgtimiMessages = new HashMap<String, Deque<IgtimiMessageInfo>>();
                isIgtimiListenerRegistered = this.registerIgtimiListener();
                igtimiRawMessageCount = 0;
            }
        }
    }

    private boolean registerIgtimiListener() {
        boolean result = false;
        ServiceTracker igtimiServiceTracker = new ServiceTracker(this.getContext(), IgtimiConnectionFactory.class, null);
        igtimiServiceTracker.open();
        IgtimiConnectionFactory igtimiConnectionFactory = (IgtimiConnectionFactory)igtimiServiceTracker.getService();
        igtimiWindReceiver = new IgtimiWindReceiver(DeclinationService.INSTANCE);
        igtimiWindReceiver.addListener((IgtimiWindListener)this);
        IgtimiConnection igtimiConnection = igtimiConnectionFactory.getOrCreateConnection(() -> this.getSecurityService().getCurrentUser() == null ? null : this.getSecurityService().getAccessToken(this.getSecurityService().getCurrentUser().getName()));
        try {
            LiveDataConnection newIgtimiConnection = igtimiConnection.getOrCreateLiveConnection(igtimiConnection.getWindDevices());
            boolean bl = result = newIgtimiConnection != null;
            if (result) {
                newIgtimiConnection.addListener((BulkFixReceiver)igtimiWindReceiver);
                newIgtimiConnection.addListener((BulkFixReceiver)this);
                IgtimiConnectionInfo newIgtimiConnectionInfo = new IgtimiConnectionInfo(newIgtimiConnection, igtimiConnection.getWindDevices());
                igtimiConnections.put(newIgtimiConnection, newIgtimiConnectionInfo);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception trying to stop Igtimi connection " + igtimiConnection, e);
        }
        return result;
    }

    private boolean registerExpeditionListener() {
        boolean result = false;
        try {
            ServiceTracker expeditionServiceTracker = new ServiceTracker(this.getContext(), ExpeditionTrackerFactory.class.getName(), null);
            expeditionServiceTracker.open();
            UDPExpeditionReceiver receiver = ((ExpeditionTrackerFactory)expeditionServiceTracker.getService()).getOrCreateWindReceiverOnDefaultPort();
            receiver.addListener((UDPMessageListener)new ExpeditionListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void received(ExpeditionMessage message) {
                    if (message != null && message.getBoatID() >= 0) {
                        ExpeditionMessageInfo info = new ExpeditionMessageInfo();
                        info.boatID = message.getBoatID();
                        info.message = message;
                        info.messageReceivedAt = new Date();
                        List list = lastExpeditionMessages;
                        synchronized (list) {
                            lastExpeditionMessages.add(info);
                        }
                    }
                }
            }, false);
            result = true;
        }
        catch (SocketException e) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void windDataReceived(Wind wind, Set<Fix> fixesUsed, String deviceSerialNumber) {
        Deque<IgtimiMessageInfo> messagesPerDevice = lastIgtimiMessages.get(deviceSerialNumber);
        if (messagesPerDevice == null) {
            messagesPerDevice = new ArrayDeque<IgtimiMessageInfo>(10);
            lastIgtimiMessages.put(deviceSerialNumber, messagesPerDevice);
        }
        Deque<IgtimiMessageInfo> deque = messagesPerDevice;
        synchronized (deque) {
            messagesPerDevice.addFirst(new IgtimiMessageInfo(wind, fixesUsed));
            if (messagesPerDevice.size() > 10) {
                messagesPerDevice.pollLast();
            }
        }
    }

    @Override
    public void destroy() {
        for (Map.Entry<LiveDataConnection, IgtimiConnectionInfo> entry : igtimiConnections.entrySet()) {
            LiveDataConnection igtimiConnection = entry.getKey();
            try {
                igtimiConnection.stop();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception trying to stop Igtimi connection " + igtimiConnection, e);
            }
        }
        igtimiConnections.clear();
        isIgtimiListenerRegistered = false;
    }

    public void received(Iterable<Fix> fixes) {
        ++igtimiRawMessageCount;
    }

    protected static String getPermissionToReload() {
        return SecuredSecurityTypes.SERVER.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)SecuredSecurityTypes.ServerActions.CONFIGURE_LOCAL_SERVER, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()}));
    }

    public static Map<LiveDataConnection, IgtimiConnectionInfo> getIgtimiConnections() {
        return igtimiConnections;
    }

    protected class ExpeditionMessageInfo {
        Integer boatID;
        ExpeditionMessage message;
        Date messageReceivedAt;

        protected ExpeditionMessageInfo() {
        }

        public String toString() {
            if (this.message.getTrueWind() != null) {
                return String.valueOf(this.messageReceivedAt.toString()) + ": [" + this.boatID + "] Knots: " + this.message.getTrueWind().getKnots() + " From: " + this.getFromAsDegrees();
            }
            return String.valueOf(this.messageReceivedAt.toString()) + ": [" + this.boatID + "] " + this.message.getOriginalMessage();
        }

        private double getFromAsDegrees() {
            return this.message.getTrueWindBearing().reverse().getDegrees();
        }
    }

    protected class IgtimiConnectionInfo {
        private final LiveDataConnection igtimiLiveConnection;
        private final Iterable<String> deviceIDs;

        public IgtimiConnectionInfo(LiveDataConnection newIgtimiConnection, Iterable<String> deviceIDs) {
            this.igtimiLiveConnection = newIgtimiConnection;
            ArrayList<String> deviceIDsList = new ArrayList<String>();
            this.deviceIDs = deviceIDsList;
            Util.addAll(deviceIDs, deviceIDsList);
        }

        public InetSocketAddress getRemoteAddress() {
            return this.igtimiLiveConnection.getRemoteAddress();
        }

        public Iterable<String> getDeviceIDs() {
            return this.deviceIDs;
        }
    }

    protected class IgtimiMessageInfo {
        private final Wind wind;
        private final Set<Fix> fixesUsed;

        public IgtimiMessageInfo(Wind wind, Set<Fix> fixesUsed) {
            this.wind = wind;
            this.fixesUsed = fixesUsed;
        }

        public Wind getWind() {
            return this.wind;
        }

        public String toString() {
            StringBuilder formattedInfo = new StringBuilder();
            if (this.wind.getTimePoint() != null) {
                formattedInfo.append("Time: " + dateTimeFormatter.format(this.wind.getTimePoint().asDate()));
            }
            if (this.wind.getPosition() != null) {
                formattedInfo.append(", Pos: " + latLngDecimalFormatter.format(this.wind.getPosition().getLatDeg()) + " " + latLngDecimalFormatter.format(this.wind.getPosition().getLngDeg()));
            }
            formattedInfo.append(", Wind: " + decimalFormatter2Digits.format(this.wind.getKnots()) + "kn");
            if (this.wind.getFrom() != null) {
                formattedInfo.append(" from " + decimalFormatter1Digit.format(this.wind.getFrom().getDegrees()) + "&deg;");
            }
            Iterable sortedFixes = this.fixesUsed.stream().sorted((f1, f2) -> f1.toString().compareTo(f2.toString()))::iterator;
            formattedInfo.append(Util.joinStrings((String)", ", sortedFixes));
            return formattedInfo.toString();
        }
    }
}

