/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway;

import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.tractracadapter.TracTracAdapterFactory;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.InvalidDateException;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.osgi.CachedOsgiTypeBasedServiceFinderFactory;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.util.DateParser;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public abstract class SailingServerHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = -6514453597593669376L;
    protected static final String PARAM_ACTION = "action";
    protected static final String PARAM_NAME_REGATTANAME = "regattaname";
    protected static final String PARAM_NAME_RACENAME = "racename";
    protected static final String PARAM_NAME_TIME = "time";
    protected static final String PARAM_NAME_TIME_MILLIS = "timeasmillis";
    private static final String OSGI_RFC66_WEBBUNDLE_BUNDLECONTEXT_NAME = "osgi-bundlecontext";
    private BundleContext context;
    private FullyInitializedReplicableTracker<RacingEventService> racingEventServiceTracker;
    private ServiceTracker<SecurityService, SecurityService> securityServiceTracker;
    private TypeBasedServiceFinderFactory serviceFinderFactory;
    private ServiceTracker<TracTracAdapterFactory, TracTracAdapterFactory> tracTracAdapterFactoryTracker;

    protected SailingServerHttpServlet() {
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.context = (BundleContext)config.getServletContext().getAttribute(OSGI_RFC66_WEBBUNDLE_BUNDLECONTEXT_NAME);
        this.racingEventServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)this.context, RacingEventService.class);
        this.securityServiceTracker = new ServiceTracker(this.context, SecurityService.class.getName(), null);
        this.securityServiceTracker.open();
        this.tracTracAdapterFactoryTracker = new ServiceTracker(this.context, TracTracAdapterFactory.class.getName(), null);
        this.tracTracAdapterFactoryTracker.open();
        this.serviceFinderFactory = new CachedOsgiTypeBasedServiceFinderFactory(this.context);
    }

    protected BundleContext getContext() {
        return this.context;
    }

    public void destroy() {
        super.destroy();
        if (this.racingEventServiceTracker != null) {
            this.racingEventServiceTracker.close();
        }
    }

    public RacingEventService getService() {
        return (RacingEventService)this.racingEventServiceTracker.getService();
    }

    public SecurityService getSecurityService() {
        return (SecurityService)this.securityServiceTracker.getService();
    }

    public TracTracAdapterFactory getTracTracAdapterFactory() {
        return (TracTracAdapterFactory)this.tracTracAdapterFactoryTracker.getService();
    }

    protected Regatta getRegatta(HttpServletRequest req) {
        Regatta regatta = this.getService().getRegattaByName(req.getParameter(PARAM_NAME_REGATTANAME));
        return regatta;
    }

    protected RaceDefinition getRaceDefinition(HttpServletRequest req) {
        Regatta regatta = this.getRegatta(req);
        if (regatta != null) {
            String racename = req.getParameter(PARAM_NAME_RACENAME);
            for (RaceDefinition race : regatta.getAllRaces()) {
                if (!race.getName().equals(racename)) continue;
                return race;
            }
        }
        return null;
    }

    protected RaceDefinition getRaceDefinition(Regatta regatta, HttpServletRequest req) {
        String racename = req.getParameter(PARAM_NAME_RACENAME);
        for (RaceDefinition race : regatta.getAllRaces()) {
            if (!race.getName().equals(racename)) continue;
            return race;
        }
        return null;
    }

    protected TimePoint readTimePointParam(HttpServletRequest req, String nameOfISOTimeParam, String nameOfMillisTime) throws InvalidDateException {
        return this.readTimePointParam(req, nameOfISOTimeParam, nameOfMillisTime, null);
    }

    protected TimePoint readTimePointParam(HttpServletRequest req, String nameOfISOTimeParam, String nameOfMillisTime, TimePoint defaultValue) throws InvalidDateException {
        String timeAsMillis;
        String time = req.getParameter(nameOfISOTimeParam);
        Object timePoint = time != null && time.length() > 0 ? new MillisecondsTimePoint(DateParser.parse((String)time).getTime()) : ((timeAsMillis = req.getParameter(nameOfMillisTime)) != null && timeAsMillis.length() > 0 ? new MillisecondsTimePoint(Long.valueOf(timeAsMillis).longValue()) : defaultValue);
        return timePoint;
    }

    protected TypeBasedServiceFinderFactory getServiceFinderFactory() {
        return this.serviceFinderFactory;
    }
}

