/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.client.widgets.startanalysis;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.Cookies;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FocusPanel;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sailing.dashboards.gwt.client.DashboardClientFactory;
import com.sap.sailing.dashboards.gwt.client.actions.GetCompetitorInLeaderboardAction;
import com.sap.sailing.dashboards.gwt.client.actions.GetStartAnalysesAction;
import com.sap.sailing.dashboards.gwt.client.notifications.bottom.BottomNotification;
import com.sap.sailing.dashboards.gwt.client.notifications.bottom.BottomNotificationClickListener;
import com.sap.sailing.dashboards.gwt.client.notifications.bottom.BottomNotificationType;
import com.sap.sailing.dashboards.gwt.client.popups.competitorselection.CompetitorSelectionListener;
import com.sap.sailing.dashboards.gwt.client.popups.competitorselection.CompetitorSelectionPopup;
import com.sap.sailing.dashboards.gwt.client.popups.competitorselection.util.SettingsButtonWithSelectionIndicationLabel;
import com.sap.sailing.dashboards.gwt.client.widgets.ActionPanel;
import com.sap.sailing.dashboards.gwt.client.widgets.PollsLiveDataEvery5Seconds;
import com.sap.sailing.dashboards.gwt.client.widgets.header.DashboardWidgetHeaderAndNoDataMessage;
import com.sap.sailing.dashboards.gwt.client.widgets.startanalysis.DashboardRaceMapResources;
import com.sap.sailing.dashboards.gwt.client.widgets.startanalysis.StartAnalysisPageChangeListener;
import com.sap.sailing.dashboards.gwt.client.widgets.startanalysis.StartAnalysisWidget;
import com.sap.sailing.dashboards.gwt.client.widgets.startanalysis.StartAnalysisWidgetResources;
import com.sap.sailing.dashboards.gwt.client.widgets.startanalysis.card.StartAnalysisCard;
import com.sap.sailing.dashboards.gwt.shared.DashboardURLParameters;
import com.sap.sailing.dashboards.gwt.shared.dto.StartAnalysisDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.gwt.ui.client.StringMessages;
import com.sap.sailing.gwt.ui.client.shared.racemap.RaceMapResources;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StartAnalysisWidget
extends Composite
implements HasWidgets,
PollsLiveDataEvery5Seconds {
    private static StartAnalysisWidgetUiBinder uiBinder = (StartAnalysisWidgetUiBinder)GWT.create(StartAnalysisWidgetUiBinder.class);
    @UiField(provided=true)
    DashboardWidgetHeaderAndNoDataMessage dashboardWidgetHeaderAndNoDataMessage;
    @UiField(provided=true)
    SettingsButtonWithSelectionIndicationLabel selectedCompetitorWithSettingsButton;
    @UiField
    HTMLPanel currentStartPanel;
    @UiField
    HTMLPanel rightButton;
    @UiField
    HTMLPanel leftButton;
    @UiField
    Image rightButtonImage;
    @UiField
    Image leftButtonImage;
    @UiField
    FocusPanel left_focus_panel;
    @UiField
    FocusPanel right_focus_panel;
    @UiField
    HTMLPanel startanalysis_card_container;
    private double currentScrollPosition = 0.0;
    private int page = 0;
    private int numberOfStartAnalysisCards = 0;
    private boolean displaysCards;
    private final List<StartAnalysisDTO> starts;
    private final List<StartAnalysisCard> pageChangeListener;
    private BottomNotification bottomNotification;
    private CompetitorSelectionPopup competitorSelectionPopup;
    private final DashboardClientFactory dashboardClientFactory;
    private final ErrorReporter errorReporter;
    private final String cookieKeyForSelectedCompetitorInLeaderboard;
    private static final String SELECTED_COMPETITOR_IN_LEADERBOARD_COOKIE_KEY_FIRST_PART = "competitorId";
    private static final int SELECTED_COMPETITOR_ID_COOKIE_KEY_EXPIRE_TIME_IN_MILLIS = 18000000;
    private static final int SCROLL_OFFSET_STARTANALYSIS_CARDS = 80;
    private static final double MARGIN_LEFT_STARTANALYSIS_CARD = 12.5;
    private static final Logger logger = Logger.getLogger(StartAnalysisWidget.class.getName());
    private static final RaceMapResources raceMapResources = (RaceMapResources)GWT.create(DashboardRaceMapResources.class);

    public StartAnalysisWidget(DashboardClientFactory dashboardClientFactory, ErrorReporter errorReporter) {
        StartAnalysisWidgetResources.INSTANCE.gss().ensureInjected();
        this.errorReporter = errorReporter;
        this.dashboardWidgetHeaderAndNoDataMessage = new DashboardWidgetHeaderAndNoDataMessage();
        this.selectedCompetitorWithSettingsButton = new SettingsButtonWithSelectionIndicationLabel();
        this.selectedCompetitorWithSettingsButton.disable();
        this.selectedCompetitorWithSettingsButton.setSelectionIndicationTextOnLabel(StringMessages.INSTANCE.dashboardSelectCompetitor());
        this.addClickListenerToSettingsButtonAndLabel();
        raceMapResources.raceMapStyle().ensureInjected();
        this.dashboardClientFactory = dashboardClientFactory;
        this.pageChangeListener = new ArrayList();
        this.starts = new ArrayList();
        this.cookieKeyForSelectedCompetitorInLeaderboard = this.computeCookieKeyForSelectedCompetitorInLeaderboard();
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
        this.dashboardWidgetHeaderAndNoDataMessage.setHeaderText(StringMessages.INSTANCE.dashboardStartAnalysesHeader());
        this.initCompetitorSelectionPopupAndAddCompetitorSelectionListener();
        this.initLeftRightButtons();
        this.initAndAddBottomNotification();
        this.registerForDashboardFiveSecondsTimer(dashboardClientFactory);
    }

    private String computeCookieKeyForSelectedCompetitorInLeaderboard() {
        String result = SELECTED_COMPETITOR_IN_LEADERBOARD_COOKIE_KEY_FIRST_PART + DashboardURLParameters.LEADERBOARD_NAME.getValue();
        return result;
    }

    private String getCachedSelectedCompetitorId() {
        String result = null;
        String selectedCompetitorId = Cookies.getCookie((String)this.cookieKeyForSelectedCompetitorInLeaderboard);
        result = selectedCompetitorId == null || "undefined".equals(selectedCompetitorId) ? null : selectedCompetitorId;
        return result;
    }

    private void initLeftRightButtons() {
        this.leftButtonImage.setResource(StartAnalysisWidgetResources.INSTANCE.leftdisabled());
        this.left_focus_panel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        this.rightButtonImage.setResource(StartAnalysisWidgetResources.INSTANCE.rightdisabled());
        this.right_focus_panel.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadStartAnalysisDTOsForCompetitorID(String competitorIdAsString) {
        logger.log(Level.INFO, "Loading startanalysis for competitor id " + competitorIdAsString);
        this.dashboardClientFactory.getDispatch().execute((Action)new GetStartAnalysesAction(DashboardURLParameters.LEADERBOARD_NAME.getValue(), competitorIdAsString), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void initAndAddBottomNotification() {
        this.bottomNotification = new BottomNotification();
        this.bottomNotification.addBottomNotificationClickListener((BottomNotificationClickListener)new /* Unavailable Anonymous Inner Class!! */);
        RootPanel.get().add((Widget)this.bottomNotification);
    }

    private void initCompetitorSelectionPopupAndAddCompetitorSelectionListener() {
        this.competitorSelectionPopup = new CompetitorSelectionPopup();
        this.competitorSelectionPopup.addListener((CompetitorSelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void loadCompetitorsAndShowCompetitorSelectionPopup() {
        logger.log(Level.INFO, "Requesting Competitors in Leaderboard");
        this.dashboardClientFactory.getDispatch().execute((Action)new GetCompetitorInLeaderboardAction(DashboardURLParameters.LEADERBOARD_NAME.getValue()), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addClickListenerToSettingsButtonAndLabel() {
        this.selectedCompetitorWithSettingsButton.addActionListener((ActionPanel.ActionPanelListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void clickedArrowButton(boolean clickedLeft) {
        if (this.displaysCards) {
            if (clickedLeft) {
                if (this.page != 0) {
                    this.currentScrollPosition += 80.0;
                    --this.page;
                    this.startanalysis_card_container.getElement().getStyle().setLeft(this.currentScrollPosition, Style.Unit.PCT);
                    this.notifyStartAnalysisPageChangeListener(this.page);
                    int displayPage = this.page + 1;
                    this.currentStartPanel.getElement().setInnerHTML(((StartAnalysisDTO)this.starts.get((int)(displayPage - 1))).raceName);
                    if (this.page != this.numberOfStartAnalysisCards - 1) {
                        this.rightButtonImage.setResource(StartAnalysisWidgetResources.INSTANCE.right());
                        this.rightButton.getElement().getStyle().setProperty("disabled", "false");
                    }
                    if (this.page == 0) {
                        this.leftButtonImage.setResource(StartAnalysisWidgetResources.INSTANCE.leftdisabled());
                        this.leftButtonImage.getElement().getStyle().setProperty("disabled", "true");
                    }
                }
            } else if (this.page != this.numberOfStartAnalysisCards - 1) {
                this.currentScrollPosition -= 80.0;
                ++this.page;
                this.startanalysis_card_container.getElement().getStyle().setLeft(this.currentScrollPosition, Style.Unit.PCT);
                this.notifyStartAnalysisPageChangeListener(this.page);
                int displayPage = this.page + 1;
                this.currentStartPanel.getElement().setInnerHTML(((StartAnalysisDTO)this.starts.get((int)(displayPage - 1))).raceName);
                if (this.page >= 0) {
                    this.leftButtonImage.setResource(StartAnalysisWidgetResources.INSTANCE.left());
                    this.leftButton.getElement().getStyle().setProperty("disabled", "false");
                }
                if (this.page == this.numberOfStartAnalysisCards - 1) {
                    this.rightButtonImage.setResource(StartAnalysisWidgetResources.INSTANCE.rightdisabled());
                    this.rightButton.getElement().getStyle().setProperty("disabled", "true");
                }
            }
        }
    }

    private void showControllHeaderButtons() {
        this.leftButton.getElement().addClassName(StartAnalysisWidgetResources.INSTANCE.gss().controll_header_button_visible());
        this.rightButton.getElement().addClassName(StartAnalysisWidgetResources.INSTANCE.gss().controll_header_button_visible());
    }

    private void scrollToLast() {
        if (this.numberOfStartAnalysisCards > 1) {
            this.currentScrollPosition -= (double)((this.numberOfStartAnalysisCards - this.page - 1) * 80);
            this.page = this.numberOfStartAnalysisCards - 1;
            this.startanalysis_card_container.getElement().getStyle().setLeft(this.currentScrollPosition, Style.Unit.PCT);
            this.currentStartPanel.getElement().setInnerHTML(((StartAnalysisDTO)this.starts.get((int)this.page)).raceName);
            this.notifyStartAnalysisPageChangeListener(this.page);
            this.rightButtonImage.setResource(StartAnalysisWidgetResources.INSTANCE.rightdisabled());
            this.rightButton.getElement().getStyle().setProperty("disabled", "true");
            this.leftButtonImage.setResource(StartAnalysisWidgetResources.INSTANCE.left());
            this.leftButton.getElement().getStyle().setProperty("disabled", "false");
        }
    }

    private void addStartAnalysisCard(StartAnalysisDTO startAnalysisDTO) {
        logger.log(Level.INFO, "Adding Startanalysis Card");
        if (!this.displaysCards) {
            this.displaysCards = true;
            this.currentStartPanel.getElement().setInnerHTML(startAnalysisDTO.raceName);
        }
        if (this.numberOfStartAnalysisCards > 0) {
            this.rightButtonImage.setResource(StartAnalysisWidgetResources.INSTANCE.right());
        }
        StartAnalysisCard startlineAnalysisCard = new StartAnalysisCard((double)(this.numberOfStartAnalysisCards * 80) + 12.5, this.numberOfStartAnalysisCards, startAnalysisDTO, this.dashboardClientFactory.getSailingService(), this.errorReporter, raceMapResources, this.dashboardClientFactory.getSubscriptionServiceFactory(), this.dashboardClientFactory.getUserService());
        this.startanalysis_card_container.add((Widget)startlineAnalysisCard);
        startlineAnalysisCard.startAnalysisComponentPageChangedToIndexAndStartAnalysis(this.page, startAnalysisDTO);
        this.registerPageChangeListener(startlineAnalysisCard);
        ++this.numberOfStartAnalysisCards;
    }

    private void removeAllStartAnalysisCards() {
        this.startanalysis_card_container.clear();
        this.numberOfStartAnalysisCards = 0;
        this.starts.clear();
    }

    private void showNotificationForNewStartAnalysis() {
        this.bottomNotification.show(BottomNotificationType.NEW_STARTANALYSIS_AVAILABLE);
    }

    public void registerPageChangeListener(StartAnalysisCard s) {
        this.pageChangeListener.add(s);
    }

    public void removeDataObserver(StartAnalysisPageChangeListener s) {
        this.pageChangeListener.remove(s);
    }

    public void notifyStartAnalysisPageChangeListener(int newPageIndex) {
        for (StartAnalysisPageChangeListener sO : this.pageChangeListener) {
            if (this.starts.get(newPageIndex) == null) continue;
            sO.startAnalysisComponentPageChangedToIndexAndStartAnalysis(newPageIndex, (StartAnalysisDTO)this.starts.get(newPageIndex));
        }
    }

    private void addNewStartAnalysisCards(List<StartAnalysisDTO> startAnalysisDTOs) {
        int i = this.numberOfStartAnalysisCards;
        while (i <= startAnalysisDTOs.size() - 1) {
            this.addStartAnalysisCard(startAnalysisDTOs.get(i));
            this.starts.add(startAnalysisDTOs.get(i));
            ++i;
        }
    }

    private String getCompetitorIdAsStringFromFirstDisplayedStartAnalysis() {
        CompetitorDTO competitor;
        String result = null;
        if (this.starts != null && this.starts.size() > 0 && (competitor = ((StartAnalysisDTO)this.starts.get((int)0)).competitor) != null) {
            result = ((StartAnalysisDTO)this.starts.get((int)0)).competitor.getIdAsString();
        }
        return result;
    }

    private boolean displayedStartAnalysisForDifferentCompetitorToRequestedOne() {
        String competitorIDFromDispalyedStartAnalysisDTOs = this.getCompetitorIdAsStringFromFirstDisplayedStartAnalysis();
        return competitorIDFromDispalyedStartAnalysisDTOs != this.getCachedSelectedCompetitorId() || competitorIDFromDispalyedStartAnalysisDTOs == null && this.getCachedSelectedCompetitorId() != null;
    }

    public void timeChanged(Date newTime, Date oldTime) {
        this.loadStartAnalysisDTOsForCompetitorID(this.getCachedSelectedCompetitorId());
    }

    public void registerForDashboardFiveSecondsTimer(DashboardClientFactory dashboardClientFactory) {
        if (dashboardClientFactory != null) {
            dashboardClientFactory.getDashboardFiveSecondsTimer().addTimeListener((TimeListener)this);
        }
    }

    public void add(Widget w) {
        throw new UnsupportedOperationException("The method add(Widget w) is not supported.");
    }

    public void clear() {
        throw new UnsupportedOperationException("The method clear() is not supported.");
    }

    public Iterator<Widget> iterator() {
        return null;
    }

    public boolean remove(Widget w) {
        return false;
    }

    static /* synthetic */ void access$0(StartAnalysisWidget startAnalysisWidget, boolean bl) {
        startAnalysisWidget.clickedArrowButton(bl);
    }

    static /* synthetic */ Logger access$1() {
        return logger;
    }

    static /* synthetic */ boolean access$2(StartAnalysisWidget startAnalysisWidget) {
        return startAnalysisWidget.displayedStartAnalysisForDifferentCompetitorToRequestedOne();
    }

    static /* synthetic */ void access$3(StartAnalysisWidget startAnalysisWidget) {
        startAnalysisWidget.removeAllStartAnalysisCards();
    }

    static /* synthetic */ List access$4(StartAnalysisWidget startAnalysisWidget) {
        return startAnalysisWidget.starts;
    }

    static /* synthetic */ void access$5(StartAnalysisWidget startAnalysisWidget) {
        startAnalysisWidget.showNotificationForNewStartAnalysis();
    }

    static /* synthetic */ void access$6(StartAnalysisWidget startAnalysisWidget, List list) {
        startAnalysisWidget.addNewStartAnalysisCards(list);
    }

    static /* synthetic */ void access$7(StartAnalysisWidget startAnalysisWidget) {
        startAnalysisWidget.showControllHeaderButtons();
    }

    static /* synthetic */ void access$8(StartAnalysisWidget startAnalysisWidget) {
        startAnalysisWidget.scrollToLast();
    }

    static /* synthetic */ String access$9(StartAnalysisWidget startAnalysisWidget) {
        return startAnalysisWidget.cookieKeyForSelectedCompetitorInLeaderboard;
    }

    static /* synthetic */ void access$10(StartAnalysisWidget startAnalysisWidget, String string) {
        startAnalysisWidget.loadStartAnalysisDTOsForCompetitorID(string);
    }

    static /* synthetic */ CompetitorSelectionPopup access$11(StartAnalysisWidget startAnalysisWidget) {
        return startAnalysisWidget.competitorSelectionPopup;
    }

    static /* synthetic */ void access$12(StartAnalysisWidget startAnalysisWidget) {
        startAnalysisWidget.loadCompetitorsAndShowCompetitorSelectionPopup();
    }
}

