/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.dashboards.gwt.client.dataretriever;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sailing.dashboards.gwt.client.DashboardClientFactory;
import com.sap.sailing.dashboards.gwt.client.actions.GetIDFromRaceThatTakesWindFixesNowAction;
import com.sap.sailing.dashboards.gwt.client.dataretriever.NumberOfWindBotsChangeListener;
import com.sap.sailing.dashboards.gwt.client.dataretriever.WindBotDataRetrieverListener;
import com.sap.sailing.dashboards.gwt.client.dataretriever.WindBotDataRetrieverProvider;
import com.sap.sailing.dashboards.gwt.client.widgets.PollsLiveDataEvery5Seconds;
import com.sap.sailing.dashboards.gwt.shared.DashboardURLParameters;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.gwt.ui.actions.GetWindInfoAction;
import com.sap.sailing.gwt.ui.shared.WindInfoForRaceDTO;
import com.sap.sse.gwt.client.async.AsyncAction;
import com.sap.sse.gwt.client.async.AsyncActionsExecutor;
import com.sap.sse.gwt.client.player.TimeListener;
import com.sap.sse.gwt.dispatch.shared.commands.Action;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WindBotDataRetriever
implements PollsLiveDataEvery5Seconds,
WindBotDataRetrieverProvider {
    private AsyncActionsExecutor asyncActionsExecutor;
    private List<NumberOfWindBotsChangeListener> numberOfWindBotsChangeListeners;
    private List<WindBotDataRetrieverListener> windBotDataRetrieverListeners;
    private List<String> windBotIDsInLiveRace;
    private final Set<String> windSourceTypeNames;
    private final int WIND_CHART_RESOLUTION_IN_MILLISECONDS = 5000;
    private final int ONE_HOUR_IN_MILLISECONDS = 3600000;
    private final String LODA_WIND_CHART_DATA_CATEGORY = "loadWindChartData";
    private boolean didInitialLoading;
    private DashboardClientFactory dashboardClientFactory;
    private static final Logger logger = Logger.getLogger(WindBotDataRetriever.class.getName());

    public WindBotDataRetriever(DashboardClientFactory dashboardClientFactory) {
        this.dashboardClientFactory = dashboardClientFactory;
        this.didInitialLoading = false;
        this.asyncActionsExecutor = new AsyncActionsExecutor();
        this.numberOfWindBotsChangeListeners = new ArrayList();
        this.windBotDataRetrieverListeners = new ArrayList();
        this.windBotIDsInLiveRace = new ArrayList();
        this.windSourceTypeNames = new HashSet();
        this.windSourceTypeNames.add(WindSourceType.EXPEDITION.name());
        this.registerForDashboardFiveSecondsTimer(dashboardClientFactory);
    }

    private void loadWindBotData(Date from, Date to, RegattaAndRaceIdentifier selectedRaceIdentifier) {
        if (!this.didInitialLoading) {
            this.didInitialLoading = true;
            from = new Date(from.getTime() - 3600000L);
        }
        logger.log(Level.INFO, "Executing GetWindInfoAction with from " + from + " and to " + to);
        GetWindInfoAction getWindInfoAction = new GetWindInfoAction(this.dashboardClientFactory.getSailingService(), selectedRaceIdentifier, from, to, 5000L, (Collection)this.windSourceTypeNames, true);
        this.asyncActionsExecutor.execute((AsyncAction)getWindInfoAction, "loadWindChartData", (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public List<String> getWindBotIdsFrom(WindInfoForRaceDTO windInfoForRaceDTO) {
        ArrayList<String> windBotIds = new ArrayList<String>();
        for (WindSource windSource : windInfoForRaceDTO.windTrackInfoByWindSource.keySet()) {
            if (!windSource.getType().equals((Object)WindSourceType.EXPEDITION) || windSource.getId() == null) continue;
            windBotIds.add(windSource.getId().toString());
        }
        return windBotIds;
    }

    public void addNumberOfWindBotsChangeListeners(NumberOfWindBotsChangeListener numberOfWindBotsChangeListener) {
        this.numberOfWindBotsChangeListeners.add(numberOfWindBotsChangeListener);
    }

    public void removeNumberOfWindBotsChangeListeners(NumberOfWindBotsChangeListener numberOfWindBotsChangeListener) {
        this.numberOfWindBotsChangeListeners.remove(numberOfWindBotsChangeListener);
    }

    private void notifyListenersAboutNumberOfWindBotChange(List<String> windBotIDs) {
        for (NumberOfWindBotsChangeListener numberOfWindBotsChangeListener : this.numberOfWindBotsChangeListeners) {
            numberOfWindBotsChangeListener.numberOfWindBotsReceivedChanged(windBotIDs, (WindBotDataRetrieverProvider)this);
        }
    }

    public void addWindBotDataRetrieverListener(WindBotDataRetrieverListener windBotDataRetrieverListener) {
        this.windBotDataRetrieverListeners.add(windBotDataRetrieverListener);
    }

    public void removeWindBotDataRetrieverListener(WindBotDataRetrieverListener windBotDataRetrieverListener) {
        this.windBotDataRetrieverListeners.remove(windBotDataRetrieverListener);
    }

    public void notifyWindBotDataRetrieverListeners(WindInfoForRaceDTO windInfoForRaceDTO) {
        logger.log(Level.INFO, "Notifing WindBotDataRetrieverListener about new WindInfoForRaceDTO");
        for (WindBotDataRetrieverListener windBotDataRetrieverListener : this.windBotDataRetrieverListeners) {
            logger.log(Level.INFO, "Notifying WindBotDataRetrieverListener");
            windBotDataRetrieverListener.updateWindBotUI(windInfoForRaceDTO);
        }
    }

    public void timeChanged(Date newTime, Date oldTime) {
        Date finalNewTime = newTime;
        Date finaloldTime = oldTime;
        logger.log(Level.INFO, "Executing GetIDFromRaceThatTakesWindFixesNowAction");
        this.dashboardClientFactory.getDispatch().execute((Action)new GetIDFromRaceThatTakesWindFixesNowAction(DashboardURLParameters.LEADERBOARD_NAME.getValue()), (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void registerForDashboardFiveSecondsTimer(DashboardClientFactory dashboardClientFactory) {
        if (dashboardClientFactory != null) {
            dashboardClientFactory.getDashboardFiveSecondsTimer().addTimeListener((TimeListener)this);
        }
    }

    static /* synthetic */ Logger access$0() {
        return logger;
    }

    static /* synthetic */ List access$1(WindBotDataRetriever windBotDataRetriever) {
        return windBotDataRetriever.windBotIDsInLiveRace;
    }

    static /* synthetic */ void access$2(WindBotDataRetriever windBotDataRetriever, List list) {
        windBotDataRetriever.windBotIDsInLiveRace = list;
    }

    static /* synthetic */ void access$3(WindBotDataRetriever windBotDataRetriever, List list) {
        windBotDataRetriever.notifyListenersAboutNumberOfWindBotChange(list);
    }

    static /* synthetic */ void access$4(WindBotDataRetriever windBotDataRetriever, Date date, Date date2, RegattaAndRaceIdentifier regattaAndRaceIdentifier) {
        windBotDataRetriever.loadWindBotData(date, date2, regattaAndRaceIdentifier);
    }
}

