/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.ReleaseRepository;
import com.sap.sse.landscape.impl.AbstractReleaseRepository;
import com.sap.sse.landscape.impl.GithubRelease;
import com.sap.sse.util.HttpUrlConnectionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GithubReleasesRepository
extends AbstractReleaseRepository
implements ReleaseRepository {
    private static final Logger logger = Logger.getLogger(GithubReleasesRepository.class.getName());
    private static final SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");
    private static final String GITHUB_API_BASE_URL = "https://api.github.com";
    private static final String GITHUB_BASE_URL = "https://github.com";
    private static final int NUMBER_OF_RELEASES_PER_PAGE = 100;
    private final String owner;
    private final String repositoryName;
    private final ConcurrentNavigableMap<TimePoint, Release> releasesByPublishingTimePoint;
    private boolean cacheContainsOldestRelease;
    private String nextPageURLForOlderReleases;
    private TimePoint lastFetchOfNewestReleases;
    private static final Duration RELOAD_NEWEST_RELEASES_AFTER_DURATION = Duration.ONE_MINUTE.times(2L);
    private static final Pattern nextPagePattern = Pattern.compile(".*<([^<]*)>; rel=\"next\".*");

    public GithubReleasesRepository(String owner, String repositoryName, String defaultReleaseNamePrefix) {
        super(defaultReleaseNamePrefix);
        this.owner = owner;
        this.repositoryName = repositoryName;
        this.releasesByPublishingTimePoint = new ConcurrentSkipListMap<TimePoint, Release>();
        this.cacheContainsOldestRelease = false;
        this.nextPageURLForOlderReleases = this.getReleasesURL();
        this.lastFetchOfNewestReleases = null;
    }

    private synchronized Util.Pair<String, Iterable<Util.Pair<TimePoint, GithubRelease>>> getReleasesFromPage(String pageURL) throws IOException, ParseException {
        logger.info("Requesting releases page " + pageURL);
        URLConnection connection = HttpUrlConnectionHelper.redirectConnection((URL)new URL(pageURL));
        InputStream index = (InputStream)connection.getContent();
        String xRatelimitRemaining = connection.getHeaderField("x-ratelimit-remaining");
        logger.fine(() -> xRatelimitRemaining + " requests left in this hour");
        if (xRatelimitRemaining != null && Integer.valueOf(xRatelimitRemaining) <= 0) {
            throw new RuntimeException("You hit the rate limit of " + connection.getHeaderField("x-ratelimit-limit"));
        }
        String linkHeader = connection.getHeaderField("link");
        String nextPageURL = this.getNextPageURL(linkHeader);
        logger.fine(() -> nextPageURL == null ? "This was the last page" : "Next page will be " + nextPageURL);
        LinkedList<Util.Pair<TimePoint, GithubRelease>> publishingTimePointsAndReleases = new LinkedList<Util.Pair<TimePoint, GithubRelease>>();
        JSONArray releasesJson = (JSONArray)new JSONParser().parse((Reader)new InputStreamReader(index));
        for (Object releaseObject : releasesJson) {
            publishingTimePointsAndReleases.add(this.getPublishedAtAndReleaseFromJson((JSONObject)releaseObject));
        }
        return new Util.Pair((Object)nextPageURL, publishingTimePointsAndReleases);
    }

    private synchronized void fillCacheWithNewestReleases() throws IOException, ParseException {
        boolean cacheWasEmpty = this.releasesByPublishingTimePoint.isEmpty();
        TimePoint publishingTimePointOfLatestReleaseSoFar = cacheWasEmpty ? null : (TimePoint)this.releasesByPublishingTimePoint.lastKey();
        String nextPageURL = this.getReleasesURL();
        boolean overlap = false;
        do {
            Util.Pair<String, Iterable<Util.Pair<TimePoint, GithubRelease>>> pageResults = this.getReleasesFromPage(nextPageURL);
            for (Util.Pair publishingTimePointAndRelease : (Iterable)pageResults.getB()) {
                boolean bl = overlap = !cacheWasEmpty && !((TimePoint)publishingTimePointAndRelease.getA()).after(publishingTimePointOfLatestReleaseSoFar);
                if (!cacheWasEmpty && !((TimePoint)publishingTimePointAndRelease.getA()).after(publishingTimePointOfLatestReleaseSoFar)) continue;
                this.releasesByPublishingTimePoint.put((TimePoint)publishingTimePointAndRelease.getA(), (Release)publishingTimePointAndRelease.getB());
            }
            nextPageURL = (String)pageResults.getA();
            if (!cacheWasEmpty) continue;
            this.rememberNextPageForOlderReleases(nextPageURL);
        } while (!cacheWasEmpty && !overlap);
    }

    private void rememberNextPageForOlderReleases(String nextPageURL) {
        this.nextPageURLForOlderReleases = nextPageURL;
        if (nextPageURL == null) {
            this.cacheContainsOldestRelease = true;
        }
    }

    private synchronized void loadPageWithNextOlderReleases() throws IOException, ParseException {
        assert (!this.cacheContainsOldestRelease);
        TimePoint publishingTimePointOfOldestReleaseInCacheSoFar = (TimePoint)this.releasesByPublishingTimePoint.firstKey();
        boolean addedAtLeastOneReleaseToCache = false;
        do {
            Util.Pair<String, Iterable<Util.Pair<TimePoint, GithubRelease>>> pageResults = this.getReleasesFromPage(this.nextPageURLForOlderReleases);
            for (Util.Pair publishedAtAndRelease : (Iterable)pageResults.getB()) {
                if (!((TimePoint)publishedAtAndRelease.getA()).before(publishingTimePointOfOldestReleaseInCacheSoFar)) continue;
                addedAtLeastOneReleaseToCache = true;
                this.releasesByPublishingTimePoint.put((TimePoint)publishedAtAndRelease.getA(), (Release)publishedAtAndRelease.getB());
            }
            this.rememberNextPageForOlderReleases((String)pageResults.getA());
        } while (!addedAtLeastOneReleaseToCache && !this.cacheContainsOldestRelease);
    }

    @Override
    public Release getLatestRelease(String releaseNamePrefix) {
        Release result = null;
        for (Release release : this) {
            if (!release.getBaseName().equals(releaseNamePrefix)) continue;
            result = release;
            break;
        }
        return result;
    }

    private String getRepositoryPath() {
        return String.valueOf(this.owner) + "/" + this.repositoryName;
    }

    private String getReleasesURL() {
        return "https://api.github.com/repos/" + this.getRepositoryPath() + "/releases?per_page=" + 100;
    }

    @Override
    public Release getRelease(String releaseName) {
        return new GithubRelease(releaseName, "https://github.com/" + this.getRepositoryPath() + "/releases/download/" + releaseName + "/" + releaseName + ".tar.gz", "https://github.com/" + this.getRepositoryPath() + "/releases/download/" + releaseName + "/" + "release-notes.txt");
    }

    @Override
    public Iterator<Release> iterator() {
        try {
            return new ReleaseIterator();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Util.Pair<TimePoint, GithubRelease> getPublishedAtAndReleaseFromJson(JSONObject releaseJson) {
        TimePoint publishedAt;
        String name = releaseJson.get((Object)"name").toString();
        String publishedAtISO = releaseJson.get((Object)"published_at").toString();
        try {
            publishedAt = TimePoint.of((Date)isoDateTimeFormat.parse(publishedAtISO));
        }
        catch (java.text.ParseException e) {
            logger.warning("Couldn't read published_at time stamp for release " + name + ": " + publishedAtISO);
            throw new RuntimeException(e);
        }
        String archiveDownloadURL = null;
        String releaseNotesURL = null;
        for (Object archiveAsset : (JSONArray)releaseJson.get((Object)"assets")) {
            JSONObject archiveAssetJson = (JSONObject)archiveAsset;
            if (archiveAssetJson.get((Object)"content_type").equals("application/x-tar")) {
                archiveDownloadURL = archiveAssetJson.get((Object)"browser_download_url").toString();
                continue;
            }
            if (!archiveAssetJson.get((Object)"name").equals("release-notes.txt")) continue;
            releaseNotesURL = archiveAssetJson.get((Object)"browser_download_url").toString();
        }
        GithubRelease release = new GithubRelease(name, archiveDownloadURL, releaseNotesURL);
        return new Util.Pair((Object)publishedAt, (Object)release);
    }

    String getNextPageURL(String linkHeader) {
        Matcher m = nextPagePattern.matcher(linkHeader);
        String result = m.matches() ? m.group(1) : null;
        return result;
    }

    private class ReleaseIterator
    implements Iterator<Release> {
        private Iterator<Release> cachedReleasesIterator;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ReleaseIterator() throws MalformedURLException, IOException, ParseException {
            GithubReleasesRepository githubReleasesRepository2 = GithubReleasesRepository.this;
            synchronized (githubReleasesRepository2) {
                TimePoint now = TimePoint.now();
                if (GithubReleasesRepository.this.lastFetchOfNewestReleases != null && GithubReleasesRepository.this.lastFetchOfNewestReleases.until(now).compareTo((Object)RELOAD_NEWEST_RELEASES_AFTER_DURATION) < 0) {
                    logger.fine(() -> "No need to fetch page with newest releases; did that at " + GithubReleasesRepository.this.lastFetchOfNewestReleases);
                } else {
                    logger.fine(() -> "Need to fetch page with newest releases because last request was at " + (GithubReleasesRepository.this.lastFetchOfNewestReleases == null ? "<never>" : GithubReleasesRepository.this.lastFetchOfNewestReleases));
                    GithubReleasesRepository.this.lastFetchOfNewestReleases = now;
                    GithubReleasesRepository.this.fillCacheWithNewestReleases();
                }
                this.cachedReleasesIterator = GithubReleasesRepository.this.releasesByPublishingTimePoint.descendingMap().values().iterator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            GithubReleasesRepository githubReleasesRepository = GithubReleasesRepository.this;
            synchronized (githubReleasesRepository) {
                return this.cachedReleasesIterator.hasNext() || !GithubReleasesRepository.this.cacheContainsOldestRelease;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Release next() {
            GithubReleasesRepository githubReleasesRepository = GithubReleasesRepository.this;
            synchronized (githubReleasesRepository) {
                Release result;
                if (this.cachedReleasesIterator.hasNext()) {
                    result = this.cachedReleasesIterator.next();
                } else {
                    if (GithubReleasesRepository.this.cacheContainsOldestRelease) {
                        throw new NoSuchElementException();
                    }
                    TimePoint oldestReleaseSoFar = (TimePoint)GithubReleasesRepository.this.releasesByPublishingTimePoint.firstKey();
                    try {
                        GithubReleasesRepository.this.loadPageWithNextOlderReleases();
                    }
                    catch (IOException | ParseException e) {
                        throw new RuntimeException(e);
                    }
                    this.cachedReleasesIterator = GithubReleasesRepository.this.releasesByPublishingTimePoint.headMap(oldestReleaseSoFar).descendingMap().values().iterator();
                    if (!this.cachedReleasesIterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    result = this.cachedReleasesIterator.next();
                }
                return result;
            }
        }
    }
}

