/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape.application;

import com.sap.sse.common.Duration;
import com.sap.sse.common.Named;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.application.ApplicationProcess;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.application.Scope;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;

public interface ApplicationReplicaSet<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends ApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends Named {
    default public Release getVersion(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return this.getMaster().getVersion(optionalTimeout, optionalKeyName, privateKeyEncryptionPassphrase);
    }

    public void upgrade(Release var1);

    public ProcessT getMaster();

    public Iterable<ProcessT> getReplicas();

    default public Iterable<ProcessT> getReadyReplicas(Optional<Duration> optionalTimeout) {
        return Util.filter(this.getReplicas(), r -> {
            try {
                return r.isReady(optionalTimeout);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    default public int getPort() throws InterruptedException, ExecutionException {
        return this.getMaster().getPort();
    }

    public Iterable<Scope<ShardingKey>> getScopes();

    public void importScope(ApplicationReplicaSet<ShardingKey, MetricsT, ProcessT> var1, Scope<ShardingKey> var2, boolean var3, boolean var4, boolean var5);

    public void removeScope(Scope<ShardingKey> var1);

    public void setReadFromMaster(boolean var1) throws IllegalStateException;

    public boolean isReadFromMaster();

    public String getHostname() throws InterruptedException, ExecutionException;

    default public String getServerName() {
        return this.getName();
    }
}

