/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape;

import com.sap.sse.common.Named;
import com.sap.sse.common.TimePoint;
import com.sap.sse.landscape.DefaultProcessConfigurationVariables;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.UserDataProvider;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;

public interface Release
extends UserDataProvider,
Named {
    public static final Logger logger = Logger.getLogger(Release.class.getName());
    public static final String RELEASE_NOTES_FILE_NAME = "release-notes.txt";
    public static final String ARCHIVE_EXTENSION = ".tar.gz";

    default public String getBaseName() {
        return this.getName().substring(0, this.getName().lastIndexOf("-"));
    }

    default public TimePoint getCreationDate() {
        String dateSubstring = this.getName().substring(this.getName().lastIndexOf("-") + 1);
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            return TimePoint.of((Date)simpleDateFormat.parse(dateSubstring));
        }
        catch (ParseException e) {
            logger.log(Level.WARNING, "Error parsing release date " + dateSubstring + ". Returning null instead.", e);
            return null;
        }
    }

    public URL getReleaseNotesURL();

    public URL getDeployableArchiveURL();

    @Override
    default public Map<ProcessConfigurationVariable, String> getUserData() {
        HashMap<ProcessConfigurationVariable, String> result = new HashMap<ProcessConfigurationVariable, String>();
        result.put(DefaultProcessConfigurationVariables.INSTALL_FROM_RELEASE, this.getName());
        return result;
    }
}

