/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape;

import com.sap.sse.common.Duration;
import com.sap.sse.landscape.Host;
import com.sap.sse.landscape.Log;
import com.sap.sse.landscape.Metrics;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.util.Optional;
import java.util.concurrent.TimeoutException;

public interface Process<LogT extends Log, MetricsT extends Metrics> {
    public int getPort();

    default public int[] getAllTCPPorts(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return new int[]{this.getPort()};
    }

    default public int[] getAllUDPPorts(Optional<Duration> optionalTimeout, Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        return new int[0];
    }

    public Host getHost();

    default public String getHostname() {
        return this.getHost().getHostname();
    }

    default public String getHostname(Optional<Duration> timeoutEmptyMeaningForever) {
        return this.getHost().getHostname(timeoutEmptyMeaningForever);
    }

    public LogT getLog();

    public MetricsT getMetrics();

    default public boolean isAlive(Optional<Duration> optionalTimeout) throws TimeoutException, Exception {
        try (Socket socket = null;){
            boolean result;
            InetAddress publicAddress = this.getHost().getPublicAddress(optionalTimeout);
            if (publicAddress != null) {
                socket = new Socket(publicAddress, this.getPort());
                result = socket.isConnected();
            } else {
                result = false;
            }
            boolean bl = result;
            return bl;
        }
    }

    public boolean isReady(Optional<Duration> var1) throws MalformedURLException, IOException;
}

