/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.landscape;

import com.jcraft.jsch.ChannelSftp;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.WithID;
import com.sap.sse.landscape.AvailabilityZone;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.SecurityGroup;
import com.sap.sse.landscape.ssh.SshCommandChannel;
import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.util.Optional;
import java.util.concurrent.TimeoutException;

public interface Host
extends WithID {
    public InetAddress getPublicAddress();

    public InetAddress getPublicAddress(Optional<Duration> var1) throws TimeoutException, Exception;

    public InetAddress getPrivateAddress();

    public InetAddress getPrivateAddress(Optional<Duration> var1);

    default public String getHostname() {
        return this.getPrivateAddress().getHostAddress();
    }

    default public String getHostname(Optional<Duration> timeoutEmptyMeaningForever) {
        return this.getPrivateAddress(timeoutEmptyMeaningForever).getHostAddress();
    }

    public SshCommandChannel createSshChannel(String var1, Optional<Duration> var2, Optional<String> var3, byte[] var4) throws Exception;

    public SshCommandChannel createRootSshChannel(Optional<Duration> var1, Optional<String> var2, byte[] var3) throws Exception;

    public ChannelSftp createSftpChannel(String var1, Optional<Duration> var2, Optional<String> var3, byte[] var4) throws Exception;

    public ChannelSftp createRootSftpChannel(Optional<Duration> var1, Optional<String> var2, byte[] var3) throws Exception;

    public AvailabilityZone getAvailabilityZone();

    default public Region getRegion() {
        return this.getAvailabilityZone().getRegion();
    }

    public Iterable<SecurityGroup> getSecurityGroups();

    public TimePoint getLaunchTimePoint();

    default public boolean isReady(Optional<String> optionalKeyName, byte[] privateKeyEncryptionPassphrase) throws Exception {
        boolean result;
        SshCommandChannel channel = this.createRootSshChannel(Optional.of(Duration.ONE_SECOND.times(10L)), optionalKeyName, privateKeyEncryptionPassphrase);
        if (channel != null) {
            channel.sendCommandLineSynchronously("pwd", new ByteArrayOutputStream());
            String response = channel.getStreamContentsAsString();
            result = Util.hasLength((String)response);
        } else {
            result = false;
        }
        return result;
    }

    default public boolean isSharedHost() {
        return false;
    }

    public String getNameTag();

    public String getImageId();
}

