/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.datamining.shared.impl.dto.parameters;

import com.sap.sse.common.Util;
import com.sap.sse.datamining.shared.impl.dto.parameters.AbstractParameterizedDimensionFilter;
import com.sap.sse.datamining.shared.impl.dto.parameters.ParameterModelListener;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class ValueListFilterParameter
extends AbstractParameterizedDimensionFilter {
    private static final long serialVersionUID = -8440835683986197499L;
    private static final Logger logger = Logger.getLogger(ValueListFilterParameter.class.getName());
    private HashSet<? extends Serializable> values;
    private transient Set<ParameterModelListener> parameterModelListeners;
    private HashSet<ParameterModelListener> nonTransientParameterModelListeners;

    @Deprecated
    ValueListFilterParameter() {
    }

    public <T extends Serializable> ValueListFilterParameter(String name, String typeName, Iterable<T> values) {
        super(name, typeName);
        logger.info("Creating parameter " + name + " of type " + typeName + " with values " + values);
        HashSet set = new HashSet();
        Util.addAll(values, set);
        this.values = set;
        this.parameterModelListeners = new HashSet<ParameterModelListener>();
        this.nonTransientParameterModelListeners = new HashSet();
    }

    @Override
    public Iterable<? extends Serializable> getValues() {
        return new HashSet<Serializable>(this.values);
    }

    @Override
    public <T extends Serializable> void setValues(Iterable<T> newValue) {
        Iterable<? extends Serializable> oldValues = this.getValues();
        logger.info("Setting value of parameter " + this.getName() + " from " + oldValues + " to " + newValue);
        if (Util.isEmpty(newValue)) {
            logger.info("Setting value of parameter " + this.getName() + " to empty set");
        }
        HashSet set = new HashSet();
        Util.addAll(newValue, set);
        this.values = set;
        new HashSet<ParameterModelListener>(this.getParameterModelListeners()).forEach(l -> l.parameterValueChanged(this, oldValues));
    }

    @Override
    public void addParameterModelListener(ParameterModelListener listener) {
        if (listener instanceof Serializable) {
            this.nonTransientParameterModelListeners.add(listener);
        } else {
            this.getTransientParameterModelListeners().add(listener);
        }
    }

    @Override
    public void removeParameterModelListener(ParameterModelListener listener) {
        this.nonTransientParameterModelListeners.remove(listener);
        this.getTransientParameterModelListeners().remove(listener);
    }

    private Set<ParameterModelListener> getParameterModelListeners() {
        HashSet<ParameterModelListener> result = new HashSet<ParameterModelListener>();
        result.addAll(this.nonTransientParameterModelListeners);
        result.addAll(this.getTransientParameterModelListeners());
        return result;
    }

    private Set<ParameterModelListener> getTransientParameterModelListeners() {
        if (this.parameterModelListeners == null) {
            this.parameterModelListeners = new HashSet<ParameterModelListener>();
        }
        return this.parameterModelListeners;
    }
}

