/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.tagging;

import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogTagEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogTagEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.abstractlog.NotRevokableException;
import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sailing.domain.common.tagging.RaceLogNotFoundException;
import com.sap.sailing.domain.common.tagging.ServiceNotFoundException;
import com.sap.sailing.domain.common.tagging.TagAlreadyExistsException;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.TaggingService;
import com.sap.sailing.server.tagging.TagDTODeSerializer;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.User;
import java.util.ArrayList;
import java.util.List;
import org.apache.shiro.authz.AuthorizationException;

public class TaggingServiceImpl
implements TaggingService {
    private final RacingEventService racingService;
    private final TagDTODeSerializer serializer;

    public TaggingServiceImpl(RacingEventService racingService) {
        this.racingService = racingService;
        this.serializer = new TagDTODeSerializer();
    }

    private String getCurrentUsername() throws AuthorizationException {
        User user = this.getSecurityService().getCurrentUser();
        if (user == null) {
            throw new AuthorizationException();
        }
        return user.getName();
    }

    private SecurityService getSecurityService() {
        return this.racingService.getSecurityService();
    }

    private void addPublicTag(String leaderboardName, String raceColumnName, String fleetName, String tag, String comment, String hiddenInfo, String imageURL, String resizedImageURL, TimePoint raceTimepoint) throws RaceLogNotFoundException, TagAlreadyExistsException {
        RaceLog raceLog = this.racingService.getRaceLog(leaderboardName, raceColumnName, fleetName);
        if (raceLog == null) {
            throw new RaceLogNotFoundException();
        }
        List<TagDTO> publicTags = this.getPublicTags(leaderboardName, raceColumnName, fleetName, null, false);
        for (TagDTO publicTag : publicTags) {
            if (!publicTag.equals(tag, comment, hiddenInfo, imageURL, resizedImageURL, true, this.racingService.getServerAuthor().getName(), raceTimepoint)) continue;
            throw new TagAlreadyExistsException();
        }
        raceLog.add((AbstractLogEvent)new RaceLogTagEventImpl(tag, comment, hiddenInfo, imageURL, resizedImageURL, raceTimepoint, this.racingService.getServerAuthor(), raceLog.getCurrentPassId()));
    }

    private void addPrivateTag(String leaderboardName, String raceColumnName, String fleetName, String tag, String comment, String hiddenInfo, String imageURL, String resizedImageURL, TimePoint raceTimepoint) throws AuthorizationException, ServiceNotFoundException, TagAlreadyExistsException {
        TagDTO tagToAdd;
        String key;
        String username;
        TagDTODeSerializer serializer = new TagDTODeSerializer();
        SecurityService securityService = this.getSecurityService();
        String privateTagsJson = securityService.getPreference(username = this.getCurrentUsername(), key = serializer.generateUniqueKey(leaderboardName, raceColumnName, fleetName));
        List<TagDTO> privateTags = serializer.deserializeTags(privateTagsJson);
        if (privateTags.contains(tagToAdd = new TagDTO(tag, comment, hiddenInfo, imageURL, resizedImageURL, false, username, raceTimepoint, MillisecondsTimePoint.now()))) {
            throw new TagAlreadyExistsException();
        }
        privateTags.add(tagToAdd);
        securityService.setPreference(username, key, serializer.serializeTags(privateTags));
    }

    private void removePublicTag(String leaderboardName, String raceColumnName, String fleetName, TagDTO tag) throws AuthorizationException, NotRevokableException, RaceLogNotFoundException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.racingService.getLeaderboardByName(leaderboardName));
        RaceLog raceLog = this.racingService.getRaceLog(leaderboardName, raceColumnName, fleetName);
        if (raceLog == null) {
            throw new RaceLogNotFoundException();
        }
        ReadonlyRaceState raceState = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.racingService, (RaceLog)raceLog);
        Iterable foundTagEvents = raceState.getTagEvents();
        for (RaceLogTagEvent tagEvent : foundTagEvents) {
            if (tagEvent.getRevokedAt() != null || !this.tagEventEqualsTagDTO(tagEvent, tag)) continue;
            raceLog.revokeEvent(tagEvent.getAuthor(), (AbstractLogEvent)tagEvent, "Revoked");
            break;
        }
    }

    private boolean tagEventEqualsTagDTO(RaceLogTagEvent tagEvent, TagDTO tag) {
        return tagEvent.getTag().equals(tag.getTag()) && tagEvent.getComment().equals(tag.getComment()) && tagEvent.getImageURL().equals(tag.getImageURL()) && tagEvent.getUsername().equals(tag.getUsername()) && tagEvent.getLogicalTimePoint().equals(tag.getRaceTimepoint());
    }

    private void removePrivateTag(String leaderboardName, String raceColumnName, String fleetName, TagDTO tag) throws AuthorizationException, ServiceNotFoundException {
        String username = this.getCurrentUsername();
        List<TagDTO> privateTags = this.getPrivateTags(leaderboardName, raceColumnName, fleetName);
        privateTags.remove(tag);
        SecurityService securityService = this.getSecurityService();
        String key = this.serializer.generateUniqueKey(leaderboardName, raceColumnName, fleetName);
        if (username != null && securityService != null && key != null) {
            if (privateTags.isEmpty()) {
                securityService.unsetPreference(username, key);
            } else {
                securityService.setPreference(username, key, this.serializer.serializeTags(privateTags));
            }
        }
    }

    public void addTag(String leaderboardName, String raceColumnName, String fleetName, String tag, String comment, String hiddenInfo, String imageURL, String resizedImageURL, boolean visibleForPublic, TimePoint raceTimepoint) throws AuthorizationException, IllegalArgumentException, RaceLogNotFoundException, ServiceNotFoundException, TagAlreadyExistsException {
        comment = comment == null ? "" : comment;
        imageURL = imageURL == null ? "" : imageURL;
        String string = resizedImageURL = resizedImageURL == null ? "" : resizedImageURL;
        if (tag == null || tag.isEmpty()) {
            throw new IllegalArgumentException("Tag may not be empty!");
        }
        if (raceTimepoint == null || raceTimepoint.asMillis() == 0L) {
            throw new IllegalArgumentException("Timepoint may not be empty!");
        }
        if (visibleForPublic) {
            this.addPublicTag(leaderboardName, raceColumnName, fleetName, tag, comment, hiddenInfo, imageURL, resizedImageURL, raceTimepoint);
        } else {
            this.addPrivateTag(leaderboardName, raceColumnName, fleetName, tag, comment, hiddenInfo, imageURL, resizedImageURL, raceTimepoint);
        }
    }

    public void removeTag(String leaderboardName, String raceColumnName, String fleetName, TagDTO tag) throws AuthorizationException, IllegalArgumentException, NotRevokableException, RaceLogNotFoundException, ServiceNotFoundException {
        if (tag == null) {
            throw new IllegalArgumentException("Tag may not be empty!");
        }
        if (tag.isVisibleForPublic()) {
            this.removePublicTag(leaderboardName, raceColumnName, fleetName, tag);
        } else {
            this.removePrivateTag(leaderboardName, raceColumnName, fleetName, tag);
        }
    }

    public void updateTag(String leaderboardName, String raceColumnName, String fleetName, TagDTO tagToUpdate, String tag, String comment, String hiddenInfo, String imageURL, String resizedImageURL, boolean visibleForPublic) throws AuthorizationException, IllegalArgumentException, NotRevokableException, RaceLogNotFoundException, ServiceNotFoundException, TagAlreadyExistsException {
        String username = this.getCurrentUsername();
        if (username != null && tagToUpdate.getUsername().equals(username)) {
            this.removeTag(leaderboardName, raceColumnName, fleetName, tagToUpdate);
            this.addTag(leaderboardName, raceColumnName, fleetName, tag, comment, hiddenInfo, imageURL, resizedImageURL, visibleForPublic, tagToUpdate.getRaceTimepoint());
        }
    }

    public List<TagDTO> getTags(String leaderboardName, String raceColumnName, String fleetName, TimePoint searchSince, boolean returnRevokedTags) throws RaceLogNotFoundException, ServiceNotFoundException {
        ArrayList<TagDTO> result = new ArrayList<TagDTO>();
        Util.addAll(this.getPublicTags(leaderboardName, raceColumnName, fleetName, searchSince, returnRevokedTags), result);
        Util.addAll(this.getPrivateTags(leaderboardName, raceColumnName, fleetName), result);
        return result;
    }

    public List<TagDTO> getTags(Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet, TimePoint searchSince, boolean returnRevokedTags) throws RaceLogNotFoundException, ServiceNotFoundException {
        ArrayList<TagDTO> result = new ArrayList<TagDTO>();
        if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderboard)) {
            this.extractPublicTagsFromLogInternal(raceColumn.getRaceLog(fleet), searchSince, returnRevokedTags, result);
        }
        Util.addAll(this.getPrivateTags(leaderboard.getName(), raceColumn.getName(), fleet.getName()), result);
        return result;
    }

    public List<TagDTO> getPublicTags(String leaderboardName, String raceColumnName, String fleetName, TimePoint searchSince, boolean returnRevokedTags) throws RaceLogNotFoundException {
        ArrayList<TagDTO> result = new ArrayList<TagDTO>();
        if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)this.racingService.getLeaderboardByName(leaderboardName))) {
            RaceLog raceLog = this.racingService.getRaceLog(leaderboardName, raceColumnName, fleetName);
            this.extractPublicTagsFromLogInternal(raceLog, searchSince, returnRevokedTags, result);
        }
        return result;
    }

    private void extractPublicTagsFromLogInternal(RaceLog raceLog, TimePoint searchSince, boolean returnRevokedTags, List<TagDTO> result) {
        if (raceLog == null) {
            throw new RaceLogNotFoundException();
        }
        ReadonlyRaceState raceState = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this.racingService, (RaceLog)raceLog);
        Iterable foundTagEvents = raceState.getTagEvents();
        for (RaceLogTagEvent tagEvent : foundTagEvents) {
            if (!returnRevokedTags && (returnRevokedTags || tagEvent.getRevokedAt() != null) || searchSince != null && (searchSince == null || !tagEvent.getCreatedAt().after(searchSince) || tagEvent.getRevokedAt() != null && (tagEvent.getRevokedAt() == null || !tagEvent.getRevokedAt().after(searchSince)))) continue;
            result.add(new TagDTO(tagEvent.getTag(), tagEvent.getComment(), tagEvent.getHiddenInfo(), tagEvent.getImageURL(), tagEvent.getResizedImageURL(), true, tagEvent.getUsername(), tagEvent.getLogicalTimePoint(), tagEvent.getCreatedAt(), tagEvent.getRevokedAt()));
        }
    }

    public List<TagDTO> getPublicTags(RegattaAndRaceIdentifier raceIdentifier, TimePoint searchSince) {
        Leaderboard leaderBoard = this.racingService.getLeaderboardByName(raceIdentifier.getRegattaName());
        this.getSecurityService().checkCurrentUserReadPermission((WithQualifiedObjectIdentifier)leaderBoard);
        ArrayList<TagDTO> result = new ArrayList<TagDTO>();
        DynamicTrackedRace trackedRace = this.racingService.getExistingTrackedRace(raceIdentifier);
        if (trackedRace != null) {
            Iterable raceLogs = trackedRace.getAttachedRaceLogs();
            for (RaceLog raceLog : raceLogs) {
                this.extractPublicTagsFromLogInternal(raceLog, searchSince, false, result);
            }
        }
        return result;
    }

    public List<TagDTO> getPrivateTags(String leaderboardName, String raceColumnName, String fleetName) throws AuthorizationException, ServiceNotFoundException {
        ArrayList<TagDTO> result = new ArrayList<TagDTO>();
        if (this.getSecurityService().getCurrentUser() != null) {
            String key = this.serializer.generateUniqueKey(leaderboardName, raceColumnName, fleetName);
            String privateTagsJson = this.getSecurityService().getPreference(this.getCurrentUsername(), key);
            List<TagDTO> privateTags = this.serializer.deserializeTags(privateTagsJson);
            result.addAll(privateTags);
        }
        return result;
    }
}

