/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.tagging;

import com.sap.sailing.domain.common.dto.TagDTO;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class TagDTODeSerializer {
    public static final String FIELD_TAG = "tag";
    public static final String FIELD_COMMENT = "comment";
    public static final String FIELD_HIDDEN_INFO = "hiddenInfo";
    public static final String FIELD_ORIGINAL_IMAGE_URL = "image";
    public static final String FIELD_RESIZED_IMAGE_URL = "resized_image";
    public static final String FIELD_USERNAME = "username";
    public static final String FIELD_VISIBLE_FOR_PUBLIC = "public";
    public static final String FIELD_RACE_TIMEPOINT = "raceTimepoint";
    public static final String FIELD_CREATED_AT = "createdAt";
    public static final String FIELD_REVOKED_AT = "revokedAt";
    private static final String UNIQUE_KEY_PREFIX = "sailing.tags.";
    private final JSONParser parser = new JSONParser();

    public JSONObject serialize(TagDTO tag) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_TAG, (Object)tag.getTag());
        if (tag.getComment() != null) {
            result.put((Object)FIELD_COMMENT, (Object)tag.getComment());
        }
        if (tag.getHiddenInfo() != null) {
            result.put((Object)FIELD_HIDDEN_INFO, (Object)tag.getHiddenInfo());
        }
        if (tag.getImageURL() != null) {
            result.put((Object)FIELD_ORIGINAL_IMAGE_URL, (Object)tag.getImageURL());
        }
        if (tag.getResizedImageURL() != null) {
            result.put((Object)FIELD_RESIZED_IMAGE_URL, (Object)tag.getResizedImageURL());
        }
        result.put((Object)FIELD_USERNAME, (Object)tag.getUsername());
        result.put((Object)FIELD_VISIBLE_FOR_PUBLIC, (Object)tag.isVisibleForPublic());
        result.put((Object)FIELD_RACE_TIMEPOINT, (Object)this.serializeTimePoint(tag.getRaceTimepoint()));
        result.put((Object)FIELD_CREATED_AT, (Object)this.serializeTimePoint(tag.getCreatedAt()));
        if (tag.getRevokedAt() != null) {
            result.put((Object)FIELD_REVOKED_AT, (Object)this.serializeTimePoint(tag.getRevokedAt()));
        }
        return result;
    }

    public JSONArray serialize(List<TagDTO> tags) {
        JSONArray result = new JSONArray();
        for (TagDTO tag : tags) {
            result.add((Object)this.serialize(tag));
        }
        return result;
    }

    public TagDTO deserialize(JSONObject jsonObject) {
        try {
            String tag = (String)jsonObject.get((Object)FIELD_TAG);
            String comment = jsonObject.get((Object)FIELD_COMMENT) == null ? "" : (String)jsonObject.get((Object)FIELD_COMMENT);
            String hiddenInfo = jsonObject.get((Object)FIELD_HIDDEN_INFO) == null ? "" : (String)jsonObject.get((Object)FIELD_HIDDEN_INFO);
            String imageURL = jsonObject.get((Object)FIELD_ORIGINAL_IMAGE_URL) == null ? "" : (String)jsonObject.get((Object)FIELD_ORIGINAL_IMAGE_URL);
            String resizedImageURL = jsonObject.get((Object)FIELD_RESIZED_IMAGE_URL) == null ? "" : (String)jsonObject.get((Object)FIELD_RESIZED_IMAGE_URL);
            String username = (String)jsonObject.get((Object)FIELD_USERNAME);
            boolean visibleForPublic = (Boolean)jsonObject.get((Object)FIELD_VISIBLE_FOR_PUBLIC);
            TimePoint raceTimePoint = this.deserializeTimePoint((Long)jsonObject.get((Object)FIELD_RACE_TIMEPOINT));
            TimePoint createdAt = this.deserializeTimePoint((Long)jsonObject.get((Object)FIELD_CREATED_AT));
            TimePoint revokedAt = jsonObject.get((Object)FIELD_REVOKED_AT) == null ? null : this.deserializeTimePoint((Long)jsonObject.get((Object)FIELD_REVOKED_AT));
            return new TagDTO(tag, comment, hiddenInfo, imageURL, resizedImageURL, visibleForPublic, username, raceTimePoint, createdAt, revokedAt);
        }
        catch (Exception e) {
            return null;
        }
    }

    public List<TagDTO> deserialize(JSONArray jsonArray) {
        return this.deserializeTags(jsonArray.toJSONString());
    }

    public String serializeTags(List<TagDTO> tags) {
        JSONArray jsonTags = new JSONArray();
        for (TagDTO tag : tags) {
            jsonTags.add((Object)this.serialize(tag));
        }
        return jsonTags.toJSONString();
    }

    public TagDTO deserializeTag(String jsonObject) {
        TagDTO result = null;
        if (jsonObject != null && !jsonObject.isEmpty()) {
            try {
                JSONObject jsonTag = (JSONObject)this.parser.parse(jsonObject);
                result = this.deserialize(jsonTag);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public List<TagDTO> deserializeTags(String jsonArray) {
        ArrayList<TagDTO> result = new ArrayList<TagDTO>();
        if (jsonArray != null && !jsonArray.isEmpty()) {
            try {
                JSONArray jsonTags = (JSONArray)this.parser.parse(jsonArray);
                int i = 0;
                while (i < jsonTags.size()) {
                    result.add(this.deserialize((JSONObject)jsonTags.get(i)));
                    ++i;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public long serializeTimePoint(TimePoint timepoint) {
        return timepoint == null ? 0L : timepoint.asMillis();
    }

    public TimePoint deserializeTimePoint(long timepoint) {
        return new MillisecondsTimePoint(timepoint);
    }

    public String generateUniqueKey(String leaderboardName, String raceColumnName, String fleetName) {
        return UNIQUE_KEY_PREFIX + this.escape(leaderboardName) + "+" + this.escape(raceColumnName) + "+" + this.escape(fleetName);
    }

    private String escape(String string) {
        return string.replaceAll("/", "//").replaceAll("\\+", "/p");
    }
}

