/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.statistics;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.statistics.Statistics;
import com.sap.sailing.domain.statistics.impl.StatisticsImpl;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;

public class StatisticsAggregator {
    private int competitors = 0;
    private int races = 0;
    private int trackedRaces = 0;
    private int regattas = 0;
    private long numberOfGPSFixes = 0L;
    private long numberOfWindFixes = 0L;
    private Distance distanceTraveled = Distance.NULL;
    private Util.Triple<Competitor, Speed, TimePoint> maxSpeed = null;

    public void addStatistics(Statistics remoteStatisticsForYear) {
        this.competitors += remoteStatisticsForYear.getNumberOfCompetitors();
        this.races += remoteStatisticsForYear.getNumberOfRaces();
        this.trackedRaces += remoteStatisticsForYear.getNumberOfTrackedRaces();
        this.regattas += remoteStatisticsForYear.getNumberOfRegattas();
        this.numberOfGPSFixes += remoteStatisticsForYear.getNumberOfGPSFixes();
        this.numberOfWindFixes += remoteStatisticsForYear.getNumberOfWindFixes();
        this.distanceTraveled = this.distanceTraveled.add(remoteStatisticsForYear.getDistanceTraveled());
        Util.Triple maxSpeedFromStatisticsToAdd = remoteStatisticsForYear.getMaxSpeed();
        if (maxSpeedFromStatisticsToAdd != null && (this.maxSpeed == null || ((Speed)maxSpeedFromStatisticsToAdd.getB()).compareTo((Object)((Speed)this.maxSpeed.getB())) > 0)) {
            this.maxSpeed = maxSpeedFromStatisticsToAdd;
        }
    }

    public Statistics getStatistics() {
        return new StatisticsImpl(this.competitors, this.regattas, this.races, this.trackedRaces, this.numberOfGPSFixes, this.numberOfWindFixes, this.distanceTraveled, this.maxSpeed);
    }
}

