/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.masterdata;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.impl.MasterDataImportInformation;
import com.sap.sailing.domain.base.impl.RegattaImpl;
import com.sap.sailing.domain.common.DataImportSubProgress;
import com.sap.sailing.domain.common.MasterDataImportObjectCreationCount;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.masterdataimport.TopLevelMasterData;
import com.sap.sailing.domain.persistence.MongoRaceLogStoreFactory;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.ImportMasterDataOperation;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.util.ObjectInputStreamResolvingAgainstCache;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;

public class MasterDataImporter {
    private static final Logger logger = Logger.getLogger(MasterDataImporter.class.getName());
    private final DomainFactory baseDomainFactory;
    private final RacingEventService racingEventService;
    private final User user;
    private final UserGroup tenant;

    public MasterDataImporter(DomainFactory baseDomainFactory, RacingEventService racingEventService, User user, UserGroup tenant) {
        this.baseDomainFactory = baseDomainFactory;
        this.racingEventService = racingEventService;
        this.user = user;
        this.tenant = tenant;
    }

    public Map<LeaderboardGroup, ? extends Iterable<Event>> importFromStream(InputStream inputStream, UUID importOperationId, boolean override) throws IOException, ClassNotFoundException {
        TopLevelMasterData topLevelMasterData;
        ObjectInputStreamResolvingAgainstCache objectInputStream = this.racingEventService.getBaseDomainFactory().createObjectInputStreamResolvingAgainstThisFactory(inputStream, new ObjectInputStreamResolvingAgainstCache.ResolveListener(){

            public void onNewObject(Object result) {
                if (result instanceof Boat || result instanceof Competitor) {
                    QualifiedObjectIdentifier id = ((WithQualifiedObjectIdentifier)result).getIdentifier();
                    logger.info("Adopting " + id + " from Masterdataimport to " + MasterDataImporter.this.user.getName() + " and group " + (MasterDataImporter.this.tenant == null ? "null" : MasterDataImporter.this.tenant.getName()));
                    MasterDataImporter.this.racingEventService.getSecurityService().setOwnershipIfNotSet(id, MasterDataImporter.this.user, MasterDataImporter.this.tenant);
                }
            }

            public void onResolvedObject(Object result) {
            }
        }, new HashMap());
        this.racingEventService.createOrUpdateDataImportProgressWithReplication(importOperationId, 0.03, DataImportSubProgress.TRANSFER_STARTED, 0.5);
        RaceLogStore raceLogStore = MongoRaceLogStoreFactory.INSTANCE.getMongoRaceLogStore(this.racingEventService.getMongoObjectFactory(), this.racingEventService.getDomainObjectFactory());
        RegattaImpl.setOngoingMasterDataImport((MasterDataImportInformation)new MasterDataImportInformation(raceLogStore));
        ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.racingEventService.getDeserializationClassLoader());
        try {
            List competitorIds = (List)objectInputStream.readObject();
            if (override) {
                this.setAllowCompetitorsDataToBeReset(competitorIds);
            }
            objectInputStream.readObject();
            topLevelMasterData = (TopLevelMasterData)objectInputStream.readObject();
        }
        finally {
            RegattaImpl.setOngoingMasterDataImport(null);
            Thread.currentThread().setContextClassLoader(oldContextClassLoader);
        }
        for (Regatta regatta : topLevelMasterData.getAllRegattas()) {
            RegattaImpl regattaImpl = (RegattaImpl)regatta;
            regattaImpl.initializeSeriesAfterDeserialize();
            if (regatta.getRegistrationLinkSecret() != null) continue;
            logger.info("Generated missing registrationLinkSecret for " + this + " while importing MasterData");
            regatta.setRegistrationLinkSecret(UUID.randomUUID().toString());
        }
        this.racingEventService.createOrUpdateDataImportProgressWithReplication(importOperationId, 0.3, DataImportSubProgress.TRANSFER_COMPLETED, 0.5);
        this.applyMasterDataImportOperation(topLevelMasterData, importOperationId, override);
        return topLevelMasterData.getEventForLeaderboardGroup();
    }

    private void setAllowCompetitorsDataToBeReset(List<Serializable> competitorIds) {
        CompetitorAndBoatStore store = this.baseDomainFactory.getCompetitorAndBoatStore();
        for (Serializable id : competitorIds) {
            Competitor competitor = this.baseDomainFactory.getExistingCompetitorById(id);
            if (competitor == null) continue;
            store.allowCompetitorResetToDefaults(competitor);
        }
    }

    private MasterDataImportObjectCreationCount applyMasterDataImportOperation(TopLevelMasterData topLevelMasterData, UUID importOperationId, boolean override) {
        ImportMasterDataOperation strippedOpForReplicas = new ImportMasterDataOperation(topLevelMasterData.copyAndStripOffDataNotNeededOnReplicas(), importOperationId, override, this.user, this.tenant);
        this.racingEventService.replicate((OperationWithResult)strippedOpForReplicas);
        ImportMasterDataOperation op = new ImportMasterDataOperation(topLevelMasterData, importOperationId, override, this.user, this.tenant);
        return (MasterDataImportObjectCreationCount)this.racingEventService.apply((OperationWithResult)op);
    }
}

