/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl.preferences.model;

import com.sap.sailing.server.impl.preferences.model.TrackedElementWithDeviceId;
import com.sap.sse.common.Util;
import com.sap.sse.common.settings.generic.AbstractGenericSerializableSettings;
import com.sap.sse.common.settings.generic.BooleanSetting;
import com.sap.sse.common.settings.generic.SettingsList;
import com.sap.sse.common.settings.generic.StringSetting;
import com.sap.sse.common.settings.generic.UUIDSetting;
import java.util.Set;
import java.util.UUID;

public class TrackedEventPreference
extends AbstractGenericSerializableSettings {
    private static final long serialVersionUID = 234711768869820003L;
    private transient UUIDSetting eventId;
    private transient StringSetting leaderboardName;
    private transient StringSetting baseUrl;
    private transient BooleanSetting isArchived;
    private transient StringSetting regattaSecret;
    private transient SettingsList<TrackedElementWithDeviceId> trackedElements;

    public TrackedEventPreference() {
    }

    public TrackedEventPreference(TrackedEventPreference other) {
        this(other.getEventId(), other.getLeaderboardName(), other.getTrackedElements(), other.getBaseUrl(), other.getIsArchived(), other.getRegattaSecret());
    }

    public TrackedEventPreference(TrackedEventPreference other, boolean isArchived) {
        this(other.getEventId(), other.getLeaderboardName(), other.getTrackedElements(), other.getBaseUrl(), isArchived, other.getRegattaSecret());
    }

    public TrackedEventPreference(TrackedEventPreference other, TrackedElementWithDeviceId trackedElement) {
        this(other.getEventId(), other.getLeaderboardName(), TrackedEventPreference.addTrackedElement(other.getTrackedElements(), trackedElement), other.getBaseUrl(), other.getIsArchived(), other.getRegattaSecret());
    }

    private static Iterable<TrackedElementWithDeviceId> addTrackedElement(Iterable<TrackedElementWithDeviceId> trackedElements, TrackedElementWithDeviceId trackedElement) {
        Set result = Util.asSet(trackedElements);
        result.add(trackedElement);
        return result;
    }

    public TrackedEventPreference(UUID eventId, String leaderboardName, Iterable<TrackedElementWithDeviceId> trackedElements, String baseUrl, boolean isArchived, String regattaSecret) {
        this();
        this.eventId.setValue((Object)eventId);
        this.leaderboardName.setValue((Object)leaderboardName);
        this.trackedElements.setValues(trackedElements);
        this.baseUrl.setValue((Object)baseUrl);
        this.isArchived.setValue((Object)isArchived);
        this.regattaSecret.setValue((Object)regattaSecret);
    }

    protected void addChildSettings() {
        this.eventId = new UUIDSetting("eventId", (AbstractGenericSerializableSettings)this);
        this.leaderboardName = new StringSetting("leaderboardName", (AbstractGenericSerializableSettings)this);
        this.trackedElements = new SettingsList("trackedElements", (AbstractGenericSerializableSettings)this, () -> new TrackedElementWithDeviceId());
        this.baseUrl = new StringSetting("baseUrl", (AbstractGenericSerializableSettings)this);
        this.isArchived = new BooleanSetting("isArchived", (AbstractGenericSerializableSettings)this);
        this.regattaSecret = new StringSetting("regattaSecret", (AbstractGenericSerializableSettings)this);
    }

    public UUID getEventId() {
        return (UUID)this.eventId.getValue();
    }

    public String getLeaderboardName() {
        return (String)this.leaderboardName.getValue();
    }

    public Iterable<TrackedElementWithDeviceId> getTrackedElements() {
        return this.trackedElements.getValues();
    }

    public String getBaseUrl() {
        return (String)this.baseUrl.getValue();
    }

    public boolean getIsArchived() {
        return (Boolean)this.isArchived.getValue();
    }

    public String getRegattaSecret() {
        return (String)this.regattaSecret.getValue();
    }
}

