/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.competitorimport.CompetitorProvider;
import com.sap.sailing.domain.abstractlog.AbstractLog;
import com.sap.sailing.domain.abstractlog.AbstractLogEvent;
import com.sap.sailing.domain.abstractlog.AbstractLogEventAuthor;
import com.sap.sailing.domain.abstractlog.impl.AllEventsOfTypeFinder;
import com.sap.sailing.domain.abstractlog.impl.LogEventAuthorImpl;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogEventVisitor;
import com.sap.sailing.domain.abstractlog.race.SimpleRaceLogIdentifier;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishedTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishingTimeFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.LastPublishedCourseDesignFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.RaceLogResolver;
import com.sap.sailing.domain.abstractlog.race.impl.RaceLogRaceStatusEventImpl;
import com.sap.sailing.domain.abstractlog.race.state.RaceState;
import com.sap.sailing.domain.abstractlog.race.state.ReadonlyRaceState;
import com.sap.sailing.domain.abstractlog.race.state.impl.RaceStateImpl;
import com.sap.sailing.domain.abstractlog.race.state.impl.ReadonlyRaceStateImpl;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLog;
import com.sap.sailing.domain.abstractlog.regatta.RegattaLogEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.RegattaLogDefineMarkEvent;
import com.sap.sailing.domain.abstractlog.regatta.events.impl.RegattaLogDefineMarkEventImpl;
import com.sap.sailing.domain.abstractlog.shared.analyzing.CompetitorsAndBoatsInLogAnalyzer;
import com.sap.sailing.domain.anniversary.DetailedRaceInfo;
import com.sap.sailing.domain.anniversary.SimpleRaceInfo;
import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.CompetitorAndBoatStore;
import com.sap.sailing.domain.base.CompetitorWithBoat;
import com.sap.sailing.domain.base.Course;
import com.sap.sailing.domain.base.CourseArea;
import com.sap.sailing.domain.base.CourseBase;
import com.sap.sailing.domain.base.CourseListener;
import com.sap.sailing.domain.base.DomainFactory;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.EventBase;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.LeaderboardSearchResult;
import com.sap.sailing.domain.base.LeaderboardSearchResultBase;
import com.sap.sailing.domain.base.Mark;
import com.sap.sailing.domain.base.Nationality;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.RaceColumnInSeries;
import com.sap.sailing.domain.base.RaceColumnListener;
import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.RegattaListener;
import com.sap.sailing.domain.base.RegattaRegistry;
import com.sap.sailing.domain.base.RemoteSailingServerReference;
import com.sap.sailing.domain.base.SailingServerConfiguration;
import com.sap.sailing.domain.base.Series;
import com.sap.sailing.domain.base.SharedDomainFactory;
import com.sap.sailing.domain.base.Sideline;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.base.configuration.DeviceConfiguration;
import com.sap.sailing.domain.base.configuration.RegattaConfiguration;
import com.sap.sailing.domain.base.impl.DynamicBoat;
import com.sap.sailing.domain.base.impl.DynamicCompetitor;
import com.sap.sailing.domain.base.impl.DynamicCompetitorWithBoat;
import com.sap.sailing.domain.base.impl.DynamicTeam;
import com.sap.sailing.domain.base.impl.EventImpl;
import com.sap.sailing.domain.base.impl.PersonImpl;
import com.sap.sailing.domain.base.impl.RegattaImpl;
import com.sap.sailing.domain.base.impl.RemoteSailingServerReferenceImpl;
import com.sap.sailing.domain.base.impl.TeamImpl;
import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sailing.domain.common.CompetitorDescriptor;
import com.sap.sailing.domain.common.CompetitorRegistrationType;
import com.sap.sailing.domain.common.DataImportProgress;
import com.sap.sailing.domain.common.DataImportSubProgress;
import com.sap.sailing.domain.common.DetailType;
import com.sap.sailing.domain.common.LeaderboardType;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.RaceIdentifier;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.RegattaFetcher;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.RegattaName;
import com.sap.sailing.domain.common.ScoreCorrectionProvider;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.TackType;
import com.sap.sailing.domain.common.TrackedRaceStatusEnum;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.dto.AnniversaryType;
import com.sap.sailing.domain.common.dto.EventType;
import com.sap.sailing.domain.common.dto.FleetDTO;
import com.sap.sailing.domain.common.dto.RegattaCreationParametersDTO;
import com.sap.sailing.domain.common.dto.SeriesCreationParametersDTO;
import com.sap.sailing.domain.common.impl.DataImportProgressImpl;
import com.sap.sailing.domain.common.impl.MasterDataImportObjectCreationCountImpl;
import com.sap.sailing.domain.common.media.MediaTrack;
import com.sap.sailing.domain.common.polars.NotEnoughDataHasBeenAddedException;
import com.sap.sailing.domain.common.racelog.RaceLogRaceStatus;
import com.sap.sailing.domain.common.racelog.RacingProcedureType;
import com.sap.sailing.domain.common.racelog.tracking.DoesNotHaveRegattaLogException;
import com.sap.sailing.domain.common.racelog.tracking.MarkAlreadyUsedInRaceException;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.SensorFix;
import com.sap.sailing.domain.leaderboard.EventResolver;
import com.sap.sailing.domain.leaderboard.FlexibleLeaderboard;
import com.sap.sailing.domain.leaderboard.FlexibleRaceColumn;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.LeaderboardGroupResolver;
import com.sap.sailing.domain.leaderboard.LeaderboardRegistry;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithEliminations;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboardWithOtherTieBreakingLeaderboard;
import com.sap.sailing.domain.leaderboard.ScoreCorrectionListener;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.ThresholdBasedResultDiscardingRule;
import com.sap.sailing.domain.leaderboard.impl.DelegatingRegattaLeaderboardWithCompetitorElimination;
import com.sap.sailing.domain.leaderboard.impl.FlexibleLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.LeaderboardGroupImpl;
import com.sap.sailing.domain.leaderboard.impl.RegattaLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.RegattaLeaderboardWithOtherTieBreakingLeaderboardImpl;
import com.sap.sailing.domain.leaderboard.impl.ThresholdBasedResultDiscardingRuleImpl;
import com.sap.sailing.domain.leaderboard.meta.LeaderboardGroupMetaLeaderboard;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprint;
import com.sap.sailing.domain.markpassinghash.MarkPassingRaceFingerprintRegistry;
import com.sap.sailing.domain.orc.ORCPerformanceCurveRankingMetric;
import com.sap.sailing.domain.persistence.DomainObjectFactory;
import com.sap.sailing.domain.persistence.MongoObjectFactory;
import com.sap.sailing.domain.persistence.MongoRaceLogStoreFactory;
import com.sap.sailing.domain.persistence.MongoRegattaLogStoreFactory;
import com.sap.sailing.domain.persistence.MongoWindStoreFactory;
import com.sap.sailing.domain.persistence.PersistenceFactory;
import com.sap.sailing.domain.persistence.media.MediaDB;
import com.sap.sailing.domain.persistence.media.MediaDBFactory;
import com.sap.sailing.domain.persistence.racelog.tracking.MongoSensorFixStoreFactory;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.racelog.RaceLogAndTrackedRaceResolver;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.domain.racelog.RaceLogStore;
import com.sap.sailing.domain.racelog.tracking.SensorFixStore;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.ranking.RankingMetricConstructor;
import com.sap.sailing.domain.regattalike.HasRegattaLike;
import com.sap.sailing.domain.regattalike.IsRegattaLike;
import com.sap.sailing.domain.regattalike.LeaderboardThatHasRegattaLike;
import com.sap.sailing.domain.regattalike.RegattaLikeListener;
import com.sap.sailing.domain.regattalog.RegattaLogStore;
import com.sap.sailing.domain.resultimport.ResultUrlProvider;
import com.sap.sailing.domain.shared.tracking.AddResult;
import com.sap.sailing.domain.shared.tracking.TrackingConnectorInfo;
import com.sap.sailing.domain.statistics.Statistics;
import com.sap.sailing.domain.tracking.BravoFixTrack;
import com.sap.sailing.domain.tracking.DynamicRaceDefinitionSet;
import com.sap.sailing.domain.tracking.DynamicSensorFixTrack;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.RaceChangeListener;
import com.sap.sailing.domain.tracking.RaceHandle;
import com.sap.sailing.domain.tracking.RaceListener;
import com.sap.sailing.domain.tracking.RaceTracker;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParameters;
import com.sap.sailing.domain.tracking.RaceTrackingConnectivityParametersHandler;
import com.sap.sailing.domain.tracking.RaceTrackingHandler;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.TrackedRaceStatus;
import com.sap.sailing.domain.tracking.TrackedRegatta;
import com.sap.sailing.domain.tracking.TrackedRegattaListener;
import com.sap.sailing.domain.tracking.TrackedRegattaRegistry;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.domain.tracking.WindPositionMode;
import com.sap.sailing.domain.tracking.WindStore;
import com.sap.sailing.domain.tracking.WindTracker;
import com.sap.sailing.domain.tracking.WindTrackerFactory;
import com.sap.sailing.domain.tracking.impl.AbstractRaceChangeListener;
import com.sap.sailing.domain.tracking.impl.DynamicTrackedRegattaImpl;
import com.sap.sailing.domain.tracking.impl.TrackedRaceImpl;
import com.sap.sailing.domain.windestimation.WindEstimationFactoryService;
import com.sap.sailing.expeditionconnector.ExpeditionDeviceConfiguration;
import com.sap.sailing.expeditionconnector.ExpeditionTrackerFactory;
import com.sap.sailing.resultimport.ResultUrlRegistry;
import com.sap.sailing.server.Replicator;
import com.sap.sailing.server.anniversary.AnniversaryRaceDeterminatorImpl;
import com.sap.sailing.server.anniversary.RaceChangeObserverForAnniversaryDetection;
import com.sap.sailing.server.anniversary.checker.QuarterChecker;
import com.sap.sailing.server.anniversary.checker.SameDigitChecker;
import com.sap.sailing.server.gateway.deserialization.impl.CourseAreaJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.EventBaseJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.LeaderboardGroupBaseJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.LeaderboardSearchResultBaseJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.TrackingConnectorInfoJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.VenueJsonDeserializer;
import com.sap.sailing.server.impl.CourseAndMarkConfigurationFactoryImpl;
import com.sap.sailing.server.impl.CourseChangeReplicator;
import com.sap.sailing.server.impl.EmptyTrackedRegattaListener;
import com.sap.sailing.server.impl.LeaderboardMXBeanImpl;
import com.sap.sailing.server.impl.LeaderboardSearchResultBaseRanker;
import com.sap.sailing.server.impl.MediaLibrary;
import com.sap.sailing.server.impl.PersistentCompetitorAndBoatStore;
import com.sap.sailing.server.impl.RaceLogReplicatorAndNotifier;
import com.sap.sailing.server.impl.RaceLogScoringReplicator;
import com.sap.sailing.server.impl.RegattaByKeywordSearchService;
import com.sap.sailing.server.impl.RegattaLogReplicator;
import com.sap.sailing.server.impl.RemoteSailingServerSet;
import com.sap.sailing.server.impl.TrackedRegattaListenerManager;
import com.sap.sailing.server.impl.preferences.model.CompetitorNotificationPreference;
import com.sap.sailing.server.interfaces.CourseAndMarkConfigurationFactory;
import com.sap.sailing.server.interfaces.DataImportLockWithProgress;
import com.sap.sailing.server.interfaces.KeywordQueryWithOptionalEventQualification;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.interfaces.RacingEventServiceOperation;
import com.sap.sailing.server.interfaces.SimulationService;
import com.sap.sailing.server.interfaces.TaggingService;
import com.sap.sailing.server.masterdata.MasterDataImporter;
import com.sap.sailing.server.notification.EmptySailingNotificationService;
import com.sap.sailing.server.notification.SailingNotificationService;
import com.sap.sailing.server.operationaltransformation.AddCourseAreas;
import com.sap.sailing.server.operationaltransformation.AddDefaultRegatta;
import com.sap.sailing.server.operationaltransformation.AddMediaTrackOperation;
import com.sap.sailing.server.operationaltransformation.AddRaceDefinition;
import com.sap.sailing.server.operationaltransformation.AddSpecificRegatta;
import com.sap.sailing.server.operationaltransformation.ConnectTrackedRaceToLeaderboardColumn;
import com.sap.sailing.server.operationaltransformation.CreateBoat;
import com.sap.sailing.server.operationaltransformation.CreateCompetitor;
import com.sap.sailing.server.operationaltransformation.CreateEvent;
import com.sap.sailing.server.operationaltransformation.CreateOrUpdateDataImportProgress;
import com.sap.sailing.server.operationaltransformation.CreateOrUpdateDeviceConfiguration;
import com.sap.sailing.server.operationaltransformation.CreateTrackedRace;
import com.sap.sailing.server.operationaltransformation.DataImportFailed;
import com.sap.sailing.server.operationaltransformation.RecordCompetitorGPSFix;
import com.sap.sailing.server.operationaltransformation.RecordCompetitorSensorFix;
import com.sap.sailing.server.operationaltransformation.RecordCompetitorSensorFixTrack;
import com.sap.sailing.server.operationaltransformation.RecordMarkGPSFixForExistingTrack;
import com.sap.sailing.server.operationaltransformation.RecordMarkGPSFixForNewMarkTrack;
import com.sap.sailing.server.operationaltransformation.RecordWindFix;
import com.sap.sailing.server.operationaltransformation.RemoveDeviceConfiguration;
import com.sap.sailing.server.operationaltransformation.RemoveLeaderboardGroupFromEvent;
import com.sap.sailing.server.operationaltransformation.RemoveMediaTrackOperation;
import com.sap.sailing.server.operationaltransformation.RemoveWindFix;
import com.sap.sailing.server.operationaltransformation.RenameEvent;
import com.sap.sailing.server.operationaltransformation.SetDataImportDeleteProgressFromMapTimer;
import com.sap.sailing.server.operationaltransformation.TrackRegatta;
import com.sap.sailing.server.operationaltransformation.UpdateBoat;
import com.sap.sailing.server.operationaltransformation.UpdateCompetitor;
import com.sap.sailing.server.operationaltransformation.UpdateEndOfTracking;
import com.sap.sailing.server.operationaltransformation.UpdateMarkPassings;
import com.sap.sailing.server.operationaltransformation.UpdateMediaTrackDurationOperation;
import com.sap.sailing.server.operationaltransformation.UpdateMediaTrackRacesOperation;
import com.sap.sailing.server.operationaltransformation.UpdateMediaTrackStartTimeOperation;
import com.sap.sailing.server.operationaltransformation.UpdateMediaTrackTitleOperation;
import com.sap.sailing.server.operationaltransformation.UpdateMediaTrackUrlOperation;
import com.sap.sailing.server.operationaltransformation.UpdateRaceDelayToLive;
import com.sap.sailing.server.operationaltransformation.UpdateStartOfTracking;
import com.sap.sailing.server.operationaltransformation.UpdateStartTimeReceived;
import com.sap.sailing.server.operationaltransformation.UpdateTrackedRaceStatus;
import com.sap.sailing.server.operationaltransformation.UpdateWindAveragingTime;
import com.sap.sailing.server.security.PermissionAwareRaceTrackingHandler;
import com.sap.sailing.server.simulation.SimulationServiceFactory;
import com.sap.sailing.server.statistics.StatisticsAggregator;
import com.sap.sailing.server.statistics.StatisticsCalculator;
import com.sap.sailing.server.statistics.TrackedRaceStatisticsCache;
import com.sap.sailing.server.tagging.TaggingServiceFactory;
import com.sap.sailing.server.util.EventUtil;
import com.sap.sailing.shared.server.SharedSailingData;
import com.sap.sse.ServerInfo;
import com.sap.sse.branding.BrandingConfigurationService;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.PairingListCreationException;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TypeBasedServiceFinder;
import com.sap.sse.common.TypeBasedServiceFinderFactory;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.search.Hit;
import com.sap.sse.common.search.Query;
import com.sap.sse.common.search.Result;
import com.sap.sse.common.search.ResultImpl;
import com.sap.sse.concurrent.LockUtil;
import com.sap.sse.concurrent.NamedReentrantReadWriteLock;
import com.sap.sse.filestorage.FileStorageManagementService;
import com.sap.sse.pairinglist.CompetitionFormat;
import com.sap.sse.pairinglist.PairingFrameProvider;
import com.sap.sse.pairinglist.PairingList;
import com.sap.sse.pairinglist.PairingListTemplate;
import com.sap.sse.pairinglist.PairingListTemplateFactory;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.replication.OperationWithResult;
import com.sap.sse.replication.ReplicationMasterDescriptor;
import com.sap.sse.replication.ReplicationService;
import com.sap.sse.replication.interfaces.impl.AbstractReplicableWithObjectInputStream;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.User;
import com.sap.sse.security.shared.impl.UserGroup;
import com.sap.sse.security.util.RemoteServerUtil;
import com.sap.sse.shared.classloading.ClassLoaderRegistry;
import com.sap.sse.shared.json.JsonDeserializer;
import com.sap.sse.shared.media.ImageDescriptor;
import com.sap.sse.shared.media.VideoDescriptor;
import com.sap.sse.util.ClearStateTestSupport;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sap.sse.util.ThreadLocalTransporter;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.BufferedReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.subject.Subject;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class RacingEventServiceImpl
extends AbstractReplicableWithObjectInputStream<RacingEventService, RacingEventServiceOperation<?>>
implements RacingEventService,
ClearStateTestSupport,
RegattaListener,
LeaderboardRegistry,
Replicator {
    private static final Logger logger = Logger.getLogger(RacingEventServiceImpl.class.getName());
    private static final ScheduledExecutorService scheduler = ThreadPoolUtil.INSTANCE.getDefaultForegroundTaskThreadPoolExecutor();
    private static final ScheduledExecutorService simulatorExecutor = ThreadPoolUtil.INSTANCE.createBackgroundTaskThreadPoolExecutor("Simulator Background Executor");
    private final DomainFactory baseDomainFactory;
    private final ConcurrentHashMap<Serializable, Event> eventsById;
    private final RemoteSailingServerSet remoteSailingServerSet;
    protected final ConcurrentHashMap<String, Regatta> regattasByName;
    private final NamedReentrantReadWriteLock regattasByNameLock;
    private final ConcurrentHashMap<RaceDefinition, CourseChangeReplicator> courseListeners;
    protected final ConcurrentHashMap<Regatta, Set<RaceTracker>> raceTrackersByRegatta;
    private final NamedReentrantReadWriteLock raceTrackersByRegattaLock;
    protected final ConcurrentHashMap<Object, RaceTracker> raceTrackersByID;
    private final ConcurrentHashMap<Object, NamedReentrantReadWriteLock> raceTrackersByIDLocks;
    private volatile transient ConcurrentHashMap<RegattaAndRaceIdentifier, Set<Consumer<RaceTracker>>> raceTrackerCallbacks;
    private final ConcurrentHashMap<String, Leaderboard> leaderboardsByName;
    private final NamedReentrantReadWriteLock leaderboardsByNameLock;
    private final ConcurrentHashMap<String, Set<LeaderboardGroup>> leaderboardGroupsByName;
    private final ConcurrentHashMap<UUID, LeaderboardGroup> leaderboardGroupsByID;
    private final ConcurrentHashMap<RaceIdentifier, MarkPassingRaceFingerprint> markPassingRaceFingerprints;
    private final NamedReentrantReadWriteLock leaderboardGroupsByNameLock;
    private final CompetitorAndBoatStore competitorAndBoatStore;
    private Set<DynamicTrackedRegatta> regattasObservedWithRaceAdditionListener = Collections.newSetFromMap(new ConcurrentHashMap());
    private final MongoObjectFactory mongoObjectFactory;
    private final DomainObjectFactory domainObjectFactory;
    private final ConcurrentHashMap<Regatta, DynamicTrackedRegatta> regattaTrackingCache;
    private final NamedReentrantReadWriteLock regattaTrackingCacheLock;
    private final ConcurrentHashMap<String, Regatta> persistentRegattasForRaceIDs;
    private final RaceLogReplicatorAndNotifier raceLogReplicator;
    private final RegattaLogReplicator regattaLogReplicator;
    private final RaceLogScoringReplicator raceLogScoringReplicator;
    private final MediaDB mediaDB;
    private final MediaLibrary mediaLibrary;
    private final Map<UUID, DeviceConfiguration> raceManagerDeviceConfigurationsById;
    private final Map<String, DeviceConfiguration> raceManagerDeviceConfigurationsByName;
    private final WindStore windStore;
    private final SensorFixStore sensorFixStore;
    private final AbstractLogEventAuthor raceLogEventAuthorForServer = new LogEventAuthorImpl(RacingEventService.class.getName(), 0);
    private PolarDataService polarDataService;
    private WindEstimationFactoryService windEstimationFactoryService;
    private final SimulationService simulationService;
    private final TaggingService taggingService;
    private transient SailingNotificationService notificationService;
    private final DataImportLockWithProgress dataImportLock;
    private BundleContext bundleContext;
    private TypeBasedServiceFinderFactory serviceFinderFactory;
    private final ClassLoaderRegistry masterDataClassLoaders = ClassLoaderRegistry.createInstance();
    private SailingServerConfiguration sailingServerConfiguration;
    private final TrackedRegattaListenerManager trackedRegattaListener;
    private long numberOfTrackedRacesToRestore;
    private final AtomicInteger numberOfTrackedRacesRestored;
    private final AtomicInteger numberOfTrackedRacesRestoredDoneLoading;
    private final AtomicInteger numberOfTrackedRacesStillLoading;
    private final ServiceTracker<ResultUrlRegistry, ResultUrlRegistry> resultUrlRegistryServiceTracker;
    private final ServiceTracker<ScoreCorrectionProvider, ScoreCorrectionProvider> scoreCorrectionProviderServiceTracker;
    private final ServiceTracker<CompetitorProvider, CompetitorProvider> competitorProviderServiceTracker;
    private final transient ConcurrentHashMap<Leaderboard, ScoreCorrectionListener> scoreCorrectionListenersByLeaderboard;
    private final transient ConcurrentHashMap<RaceDefinition, RaceTrackingConnectivityParameters> connectivityParametersByRace;
    private final TrackedRaceStatisticsCache trackedRaceStatisticsCache;
    private final AnniversaryRaceDeterminatorImpl anniversaryRaceDeterminator;
    private final RaceChangeObserverForAnniversaryDetection raceChangeObserverForAnniversaryDetection;
    private final PairingListTemplateFactory pairingListTemplateFactory = PairingListTemplateFactory.INSTANCE;
    private final FullyInitializedReplicableTracker<SecurityService> securityServiceTracker;
    private final CourseAndMarkConfigurationFactory courseAndMarkConfigurationFactory;

    public RacingEventServiceImpl() {
        this(true, null, null, false);
    }

    public RacingEventServiceImpl(WindStore windStore, SensorFixStore sensorFixStore, TypeBasedServiceFinderFactory serviceFinderFactory) {
        this(true, windStore, sensorFixStore, serviceFinderFactory, null, false);
    }

    void setBundleContext(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public RacingEventServiceImpl(boolean clearPersistentCompetitorAndBoatStore, SensorFixStore sensorFixStore, TypeBasedServiceFinderFactory serviceFinderFactory, boolean restoreTrackedRaces) {
        this(clearPersistentCompetitorAndBoatStore, sensorFixStore, serviceFinderFactory, null, null, null, restoreTrackedRaces, null, null, null, null, null, null, null);
    }

    public RacingEventServiceImpl(boolean clearPersistentCompetitorAndBoatStore, SensorFixStore sensorFixStore, TypeBasedServiceFinderFactory serviceFinderFactory, TrackedRegattaListenerManager trackedRegattaListener, SailingNotificationService sailingNotificationService, TrackedRaceStatisticsCache trackedRaceStatisticsCache, boolean restoreTrackedRaces, FullyInitializedReplicableTracker<SecurityService> securityServiceTracker, FullyInitializedReplicableTracker<SharedSailingData> sharedSailingDataTracker, ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker, ServiceTracker<ScoreCorrectionProvider, ScoreCorrectionProvider> scoreCorrectionProviderServiceTracker, ServiceTracker<CompetitorProvider, CompetitorProvider> competitorProviderServiceTracker, ServiceTracker<ResultUrlRegistry, ResultUrlRegistry> resultUrlRegistryServiceTracker, ServiceTracker<BrandingConfigurationService, BrandingConfigurationService> brandingConfigurationServiceTracker) {
        this(raceLogResolver -> new ConstructorParameters(serviceFinderFactory, clearPersistentCompetitorAndBoatStore, (RaceLogAndTrackedRaceResolver)raceLogResolver){
            private final MongoObjectFactory mongoObjectFactory;
            private final PersistentCompetitorAndBoatStore competitorStore;
            {
                this.mongoObjectFactory = PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory(typeBasedServiceFinderFactory);
                this.competitorStore = new PersistentCompetitorAndBoatStore(PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory(typeBasedServiceFinderFactory), bl, typeBasedServiceFinderFactory, raceLogAndTrackedRaceResolver);
            }

            @Override
            public DomainObjectFactory getDomainObjectFactory() {
                return this.competitorStore.getDomainObjectFactory();
            }

            @Override
            public MongoObjectFactory getMongoObjectFactory() {
                return this.mongoObjectFactory;
            }

            @Override
            public DomainFactory getBaseDomainFactory() {
                return this.competitorStore.getBaseDomainFactory();
            }

            @Override
            public CompetitorAndBoatStore getCompetitorAndBoatStore() {
                return this.competitorStore;
            }
        }, MediaDBFactory.INSTANCE.getDefaultMediaDB(), null, sensorFixStore, serviceFinderFactory, trackedRegattaListener, sailingNotificationService, trackedRaceStatisticsCache, restoreTrackedRaces, securityServiceTracker, sharedSailingDataTracker, null, scoreCorrectionProviderServiceTracker, competitorProviderServiceTracker, resultUrlRegistryServiceTracker);
    }

    private RacingEventServiceImpl(boolean clearPersistentCompetitorStore, WindStore windStore, SensorFixStore sensorFixStore, TypeBasedServiceFinderFactory serviceFinderFactory, SailingNotificationService sailingNotificationService, boolean restoreTrackedRaces) {
        this(raceLogResolver -> new ConstructorParameters(serviceFinderFactory, clearPersistentCompetitorStore, (RaceLogAndTrackedRaceResolver)raceLogResolver){
            private final MongoObjectFactory mongoObjectFactory;
            private final PersistentCompetitorAndBoatStore competitorStore;
            {
                this.mongoObjectFactory = PersistenceFactory.INSTANCE.getDefaultMongoObjectFactory(typeBasedServiceFinderFactory);
                this.competitorStore = new PersistentCompetitorAndBoatStore(this.mongoObjectFactory, bl, typeBasedServiceFinderFactory, raceLogAndTrackedRaceResolver);
            }

            @Override
            public DomainObjectFactory getDomainObjectFactory() {
                return this.competitorStore.getDomainObjectFactory();
            }

            @Override
            public MongoObjectFactory getMongoObjectFactory() {
                return this.mongoObjectFactory;
            }

            @Override
            public DomainFactory getBaseDomainFactory() {
                return this.competitorStore.getBaseDomainFactory();
            }

            @Override
            public CompetitorAndBoatStore getCompetitorAndBoatStore() {
                return this.competitorStore;
            }
        }, MediaDBFactory.INSTANCE.getDefaultMediaDB(), windStore, sensorFixStore, serviceFinderFactory, null, sailingNotificationService, null, restoreTrackedRaces, null, null, null, null, null, null);
    }

    public RacingEventServiceImpl(final DomainObjectFactory domainObjectFactory, final MongoObjectFactory mongoObjectFactory, MediaDB mediaDB, WindStore windStore, SensorFixStore sensorFixStore, boolean restoreTrackedRaces) {
        this(raceLogResolver -> new ConstructorParameters(){

            @Override
            public DomainObjectFactory getDomainObjectFactory() {
                return domainObjectFactory;
            }

            @Override
            public MongoObjectFactory getMongoObjectFactory() {
                return mongoObjectFactory;
            }

            @Override
            public DomainFactory getBaseDomainFactory() {
                return domainObjectFactory.getBaseDomainFactory();
            }

            @Override
            public CompetitorAndBoatStore getCompetitorAndBoatStore() {
                return this.getBaseDomainFactory().getCompetitorAndBoatStore();
            }
        }, mediaDB, windStore, sensorFixStore, null, null, null, null, restoreTrackedRaces, null, null, null, null, null, null);
    }

    public RacingEventServiceImpl(Function<RaceLogAndTrackedRaceResolver, ConstructorParameters> constructorParametersProvider, MediaDB mediaDb, WindStore windStore, SensorFixStore sensorFixStore, TypeBasedServiceFinderFactory serviceFinderFactory, TrackedRegattaListenerManager trackedRegattaListener, SailingNotificationService sailingNotificationService, TrackedRaceStatisticsCache trackedRaceStatisticsCache, boolean restoreTrackedRaces, FullyInitializedReplicableTracker<SecurityService> securityServiceTracker, FullyInitializedReplicableTracker<SharedSailingData> sharedSailingDataTracker, ServiceTracker<ReplicationService, ReplicationService> replicationServiceTracker, ServiceTracker<ScoreCorrectionProvider, ScoreCorrectionProvider> scoreCorrectionProviderServiceTracker, ServiceTracker<CompetitorProvider, CompetitorProvider> competitorProviderServiceTracker, ServiceTracker<ResultUrlRegistry, ResultUrlRegistry> resultUrlRegistryServiceTracker) {
        logger.info("Created " + this);
        this.securityServiceTracker = securityServiceTracker;
        this.numberOfTrackedRacesRestored = new AtomicInteger();
        this.numberOfTrackedRacesRestoredDoneLoading = new AtomicInteger();
        this.numberOfTrackedRacesStillLoading = new AtomicInteger();
        this.resultUrlRegistryServiceTracker = resultUrlRegistryServiceTracker;
        this.scoreCorrectionProviderServiceTracker = scoreCorrectionProviderServiceTracker;
        this.competitorProviderServiceTracker = competitorProviderServiceTracker;
        this.scoreCorrectionListenersByLeaderboard = new ConcurrentHashMap();
        this.connectivityParametersByRace = new ConcurrentHashMap();
        this.notificationService = sailingNotificationService;
        ConstructorParameters constructorParameters = constructorParametersProvider.apply((RaceLogAndTrackedRaceResolver)this);
        this.domainObjectFactory = constructorParameters.getDomainObjectFactory();
        this.masterDataClassLoaders.addClassLoader(this.getClass().getClassLoader());
        this.baseDomainFactory = constructorParameters.getBaseDomainFactory();
        this.populateBoatClasses(this.baseDomainFactory);
        this.mongoObjectFactory = constructorParameters.getMongoObjectFactory();
        this.mediaDB = mediaDb;
        this.competitorAndBoatStore = constructorParameters.getCompetitorAndBoatStore();
        try {
            this.windStore = windStore == null ? MongoWindStoreFactory.INSTANCE.getMongoWindStore(this.mongoObjectFactory, this.domainObjectFactory) : windStore;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.competitorAndBoatStore.addCompetitorUpdateListener(new CompetitorAndBoatStore.CompetitorUpdateListener(){

            public void competitorUpdated(Competitor competitor) {
                RacingEventServiceImpl.this.replicate((OperationWithResult)new UpdateCompetitor(competitor.getId().toString(), competitor.getName(), competitor.getShortName(), competitor.getColor(), competitor.getEmail(), competitor.getTeam().getNationality(), competitor.getTeam().getImage(), competitor.getFlagImage(), competitor.getTimeOnTimeFactor(), competitor.getTimeOnDistanceAllowancePerNauticalMile(), competitor.getSearchTag()));
            }

            public void competitorCreated(Competitor competitor) {
                RacingEventServiceImpl.this.replicate((OperationWithResult)new CreateCompetitor(competitor.getId(), competitor.getName(), competitor.getShortName(), competitor.getColor(), competitor.getEmail(), competitor.getFlagImage(), competitor.getTeam() == null ? null : competitor.getTeam().getNationality(), competitor.getTimeOnTimeFactor(), competitor.getTimeOnDistanceAllowancePerNauticalMile(), competitor.getSearchTag(), competitor.hasBoat() ? ((CompetitorWithBoat)competitor).getBoat().getId() : null));
            }
        });
        this.competitorAndBoatStore.addBoatUpdateListener(new CompetitorAndBoatStore.BoatUpdateListener(){

            public void boatUpdated(Boat boat) {
                RacingEventServiceImpl.this.replicate((OperationWithResult)new UpdateBoat(boat.getId().toString(), boat.getName(), boat.getColor(), boat.getSailID()));
            }

            public void boatCreated(Boat boat) {
                RacingEventServiceImpl.this.replicate((OperationWithResult)new CreateBoat(boat.getId(), boat.getName(), boat.getBoatClass() == null ? null : boat.getBoatClass().getName(), boat.getSailID(), boat.getColor()));
            }
        });
        this.dataImportLock = new DataImportLockWithProgress();
        this.remoteSailingServerSet = new RemoteSailingServerSet(scheduler, (SharedDomainFactory<?>)this.baseDomainFactory);
        this.regattasByName = new ConcurrentHashMap();
        this.regattasByNameLock = new NamedReentrantReadWriteLock("regattasByName for " + this, false);
        this.eventsById = new ConcurrentHashMap();
        this.regattaTrackingCache = new ConcurrentHashMap();
        this.regattaTrackingCacheLock = new NamedReentrantReadWriteLock("regattaTrackingCache for " + this, false);
        this.raceTrackersByRegatta = new ConcurrentHashMap();
        this.raceTrackersByRegattaLock = new NamedReentrantReadWriteLock("raceTrackersByRegatta for " + this, false);
        this.raceTrackersByID = new ConcurrentHashMap();
        this.raceTrackersByIDLocks = new ConcurrentHashMap();
        this.raceTrackerCallbacks = new ConcurrentHashMap();
        this.leaderboardGroupsByName = new ConcurrentHashMap();
        this.leaderboardGroupsByID = new ConcurrentHashMap();
        this.leaderboardGroupsByNameLock = new NamedReentrantReadWriteLock("leaderboardGroupsByName for " + this, false);
        this.leaderboardsByName = new ConcurrentHashMap();
        this.leaderboardsByNameLock = new NamedReentrantReadWriteLock("leaderboardsByName for " + this, false);
        this.markPassingRaceFingerprints = new ConcurrentHashMap();
        this.courseListeners = new ConcurrentHashMap();
        this.persistentRegattasForRaceIDs = new ConcurrentHashMap();
        this.simulationService = SimulationServiceFactory.INSTANCE.getService(simulatorExecutor, this);
        this.taggingService = TaggingServiceFactory.INSTANCE.getService(this);
        this.raceLogReplicator = new RaceLogReplicatorAndNotifier(this);
        this.regattaLogReplicator = new RegattaLogReplicator(this);
        this.raceLogScoringReplicator = new RaceLogScoringReplicator(this);
        this.mediaLibrary = new MediaLibrary();
        try {
            this.sensorFixStore = sensorFixStore == null ? MongoSensorFixStoreFactory.INSTANCE.getMongoGPSFixStore(this.mongoObjectFactory, this.domainObjectFactory, serviceFinderFactory) : sensorFixStore;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception trying to obtain MongoDB sensor fix store", e);
            throw new RuntimeException(e);
        }
        this.courseAndMarkConfigurationFactory = new CourseAndMarkConfigurationFactoryImpl(sharedSailingDataTracker, this.sensorFixStore, (RaceLogResolver)this, this.getBaseDomainFactory());
        this.raceManagerDeviceConfigurationsById = new HashMap<UUID, DeviceConfiguration>();
        this.raceManagerDeviceConfigurationsByName = new HashMap<String, DeviceConfiguration>();
        this.serviceFinderFactory = serviceFinderFactory;
        this.trackedRegattaListener = trackedRegattaListener == null ? EmptyTrackedRegattaListener.INSTANCE : trackedRegattaListener;
        this.sailingServerConfiguration = this.domainObjectFactory.loadServerConfiguration();
        Iterable<Util.Pair<Event, Boolean>> loadedEventsWithRequireStoreFlag = this.loadStoredEvents();
        this.loadStoredRegattas();
        this.loadRaceIDToRegattaAssociations();
        this.loadStoredLeaderboardsAndGroups();
        this.loadLinksFromEventsToLeaderboardGroups();
        this.loadMediaLibary();
        this.loadStoredDeviceConfigurations();
        this.loadAllRemoteSailingServersAndSchedulePeriodicEventCacheRefresh();
        this.loadMarkPassingRaceFingerprints();
        for (Util.Pair<Event, Boolean> eventAndRequireStoreFlag : loadedEventsWithRequireStoreFlag) {
            if (!((Boolean)eventAndRequireStoreFlag.getB()).booleanValue()) continue;
            this.mongoObjectFactory.storeEvent((Event)eventAndRequireStoreFlag.getA());
        }
        if (restoreTrackedRaces) {
            this.restoreTrackedRaces();
        } else {
            this.getMongoObjectFactory().removeAllConnectivityParametersForRacesToRestore();
        }
        this.trackedRaceStatisticsCache = trackedRaceStatisticsCache;
        this.anniversaryRaceDeterminator = new AnniversaryRaceDeterminatorImpl(this, this.remoteSailingServerSet, new QuarterChecker(), new SameDigitChecker());
        this.raceChangeObserverForAnniversaryDetection = new RaceChangeObserverForAnniversaryDetection(this.anniversaryRaceDeterminator);
        if (this.anniversaryRaceDeterminator.isEnabled()) {
            this.trackedRegattaListener.addListener((TrackedRegattaListener)this.raceChangeObserverForAnniversaryDetection);
        }
    }

    private void loadMarkPassingRaceFingerprints() {
        this.markPassingRaceFingerprints.putAll(this.domainObjectFactory.loadFingerprintsForMarkPassingHashes());
    }

    public void storeMarkPassings(RaceIdentifier raceIdentifier, MarkPassingRaceFingerprint fingerprint, Map<Competitor, Map<Waypoint, MarkPassing>> markPassings, Course course) {
        this.markPassingRaceFingerprints.put(raceIdentifier, fingerprint);
        this.mongoObjectFactory.storeMarkPassings(raceIdentifier, fingerprint, markPassings, course);
    }

    public MarkPassingRaceFingerprint getMarkPassingRaceFingerprint(RaceIdentifier raceIdentifier) {
        return this.markPassingRaceFingerprints.get(raceIdentifier);
    }

    public void removeStoredMarkPassings(RaceIdentifier raceIdentifier) {
        this.markPassingRaceFingerprints.remove(raceIdentifier);
        this.mongoObjectFactory.removeMarkPassings(raceIdentifier);
    }

    public Map<Competitor, Map<Waypoint, MarkPassing>> loadMarkPassings(RaceIdentifier raceIdentifier, Course course) {
        Map result = this.markPassingRaceFingerprints.containsKey(raceIdentifier) ? this.domainObjectFactory.loadMarkPassings(raceIdentifier, course) : null;
        return result;
    }

    public ClassLoaderRegistry getMasterDataClassLoaders() {
        return this.masterDataClassLoaders;
    }

    public void addTrackedRegattaListener(TrackedRegattaListener listener) {
        this.trackedRegattaListener.addListener(listener);
    }

    public void removeTrackedRegattaListener(TrackedRegattaListener listener) {
        this.trackedRegattaListener.removeListener(listener);
    }

    public void migrateCompetitorNotificationPreferencesWithCompetitorNames() {
        logger.log(Level.INFO, "Migrating Competitor names for CompetitorNotificationPreferences");
        SecurityService securityService = this.getSecurityService();
        Map competitorNotificationPreferencesByUser = securityService.getPreferenceObjectsByKey("sailing.notifications.competitors");
        competitorNotificationPreferencesByUser.forEach((user, preferences) -> {
            boolean missingCompetitorNameInSavedPreferences = false;
            Iterable<CompetitorNotificationPreference> competitors = preferences.getCompetitors();
            for (CompetitorNotificationPreference competitor : competitors) {
                DynamicCompetitor existingCompetitor;
                if (competitor.getCompetitorName() != null || (existingCompetitor = this.competitorAndBoatStore.getExistingCompetitorByIdAsString(competitor.getCompetitorIdAsString())) == null) continue;
                String competitorName = existingCompetitor.getName() == null ? existingCompetitor.getShortName() : existingCompetitor.getName();
                missingCompetitorNameInSavedPreferences = true;
                competitor.setCompetitorName(competitorName);
            }
            if (missingCompetitorNameInSavedPreferences) {
                securityService.setPreferenceObject(user, "sailing.notifications.competitors", (Object)preferences);
            }
        });
    }

    private void populateBoatClasses(DomainFactory baseDomainFactory) {
        for (String boatClassName : BoatClassMasterdata.getAllBoatClassNames((boolean)false)) {
            baseDomainFactory.getOrCreateBoatClass(boatClassName);
        }
    }

    private void restoreTrackedRaces() {
        this.numberOfTrackedRacesToRestore = this.getDomainObjectFactory().loadConnectivityParametersForRacesToRestore(params -> {
            try {
                RaceHandle handle = this.addRace(null, (RaceTrackingConnectivityParameters)params, -1L, (RaceTrackingHandler)new RaceTrackingHandler.DefaultRaceTrackingHandler(){

                    public DynamicTrackedRace createTrackedRace(TrackedRegatta trackedRegatta, RaceDefinition raceDefinition, Iterable<Sideline> sidelines, WindStore windStore, long delayToLiveInMillis, long millisecondsOverWhichToAverageWind, long millisecondsOverWhichToAverageSpeed, DynamicRaceDefinitionSet raceDefinitionSetToUpdate, boolean useMarkPassingCalculator, RaceLogAndTrackedRaceResolver raceLogResolver, Optional<ThreadLocalTransporter> threadLocalTransporter, TrackingConnectorInfo trackingConnectorInfo, MarkPassingRaceFingerprintRegistry markPassingRaceFingerprintRegistry) {
                        DynamicTrackedRace trackedRace = super.createTrackedRace(trackedRegatta, raceDefinition, sidelines, windStore, delayToLiveInMillis, millisecondsOverWhichToAverageWind, millisecondsOverWhichToAverageSpeed, raceDefinitionSetToUpdate, useMarkPassingCalculator, raceLogResolver, threadLocalTransporter, trackingConnectorInfo, markPassingRaceFingerprintRegistry);
                        RacingEventServiceImpl.this.getSecurityService().migrateOwnership((WithQualifiedObjectIdentifier)trackedRace);
                        trackedRace.runWhenDoneLoading(() -> {
                            int n = RacingEventServiceImpl.this.numberOfTrackedRacesRestoredDoneLoading.incrementAndGet();
                        });
                        return trackedRace;
                    }
                });
                RaceDefinition race = handle.getRace(60000L);
                if (race == null) {
                    logger.warning("Race for tracker " + handle.getRaceTracker() + " with ID " + handle.getRaceTracker().getID() + " didn't appear within " + 60000L + "ms. Maybe it will later...");
                } else {
                    logger.info("Race " + race + " showed up during restoring by tracker " + handle.getRaceTracker() + " with ID " + handle.getRaceTracker().getID());
                }
                int newNumberOfTrackedRacesRestored = this.numberOfTrackedRacesRestored.incrementAndGet();
                logger.info("Added race to restore #" + newNumberOfTrackedRacesRestored + "/" + this.numberOfTrackedRacesToRestore);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception trying to restore race " + params + ". Removing from the restore list. This server will no longer try to load this race automatically upon server restart.", e);
                try {
                    this.getMongoObjectFactory().removeConnectivityParametersForRaceToRestore(params);
                }
                catch (MalformedURLException e1) {
                    logger.log(Level.SEVERE, "Dang... even that failed. Couldn't remove connectivity params for " + params + " from restore list", e1);
                }
            }
        }).getNumberOfParametersToLoad();
    }

    public PolarDataService getPolarDataService() {
        return this.polarDataService;
    }

    public SimulationService getSimulationService() {
        return this.simulationService;
    }

    public TaggingService getTaggingService() {
        return this.taggingService;
    }

    public void clearState() throws Exception {
        for (UUID leaderboardGroupID : new ArrayList(this.leaderboardGroupsByID.keySet())) {
            this.removeLeaderboardGroup(leaderboardGroupID);
        }
        for (String leaderboardName : new ArrayList(this.leaderboardsByName.keySet())) {
            this.removeLeaderboard(leaderboardName);
        }
        for (Regatta regatta : new ArrayList<Regatta>(this.regattasByName.values())) {
            this.stopTracking(regatta, true);
            this.removeRegatta(regatta);
        }
        for (Event event : new ArrayList<Event>(this.eventsById.values())) {
            this.removeEvent(event.getId());
        }
        for (MediaTrack mediaTrack : this.mediaLibrary.allTracks()) {
            this.mediaTrackDeleted(mediaTrack);
        }
        for (WindTrackerFactory factory : this.getWindTrackerFactories()) {
            if (!(factory instanceof ExpeditionTrackerFactory)) continue;
            ((ExpeditionTrackerFactory)factory).clearState();
        }
        this.competitorAndBoatStore.clear();
        this.windStore.clear();
        this.raceManagerDeviceConfigurationsById.clear();
        this.raceManagerDeviceConfigurationsByName.clear();
        this.getRaceLogStore().clear();
        this.getRegattaLogStore().clear();
        this.anniversaryRaceDeterminator.clear();
        this.raceChangeObserverForAnniversaryDetection.clear();
    }

    public DomainFactory getBaseDomainFactory() {
        return this.baseDomainFactory;
    }

    public MongoObjectFactory getMongoObjectFactory() {
        return this.mongoObjectFactory;
    }

    public DomainObjectFactory getDomainObjectFactory() {
        return this.domainObjectFactory;
    }

    public void ensureOwnerships() {
        SecurityService securityService = this.getSecurityService();
        for (ResultUrlProvider resultUrlProvider : this.getAllUrlBasedScoreCorrectionProviders()) {
            for (URL resultImportUrl : resultUrlProvider.getAllUrls()) {
                QualifiedObjectIdentifier ident = SecuredDomainType.RESULT_IMPORT_URL.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{resultUrlProvider.getName(), resultImportUrl.toString()}));
                securityService.migrateOwnership(ident, ident.toString());
            }
        }
        securityService.assumeOwnershipMigrated(SecuredDomainType.RESULT_IMPORT_URL.getName());
        securityService.migrateOwnership(new WithQualifiedObjectIdentifier(){
            private static final long serialVersionUID = 1L;

            public String getName() {
                return "Simulator of server " + ServerInfo.getName();
            }

            public HasPermissions getPermissionType() {
                return SecuredDomainType.SIMULATOR;
            }

            public QualifiedObjectIdentifier getIdentifier() {
                return SecuredDomainType.SIMULATOR.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()}));
            }
        });
        securityService.assumeOwnershipMigrated(SecuredDomainType.SIMULATOR.getName());
        securityService.assumeOwnershipMigrated(SecuredDomainType.FILE_STORAGE.getName());
        for (DeviceConfiguration device : this.getAllDeviceConfigurations()) {
            securityService.migrateOwnership((WithQualifiedObjectIdentifier)device);
        }
        securityService.assumeOwnershipMigrated(SecuredDomainType.RACE_MANAGER_APP_DEVICE_CONFIGURATION.getName());
        for (Event event : this.getAllEvents()) {
            securityService.migrateOwnership((WithQualifiedObjectIdentifier)event);
        }
        securityService.assumeOwnershipMigrated(SecuredDomainType.EVENT.getName());
        for (Regatta regatta : this.getAllRegattas()) {
            securityService.migrateOwnership((WithQualifiedObjectIdentifier)regatta);
            DynamicTrackedRegatta trackedRegatta = this.getTrackedRegatta(regatta);
            if (trackedRegatta == null) continue;
            trackedRegatta.lockTrackedRacesForRead();
            try {
                for (DynamicTrackedRace trackedRace : trackedRegatta.getTrackedRaces()) {
                    securityService.migrateOwnership((WithQualifiedObjectIdentifier)trackedRace);
                }
            }
            finally {
                trackedRegatta.unlockTrackedRacesAfterRead();
            }
        }
        securityService.assumeOwnershipMigrated(SecuredDomainType.TRACKED_RACE.getName());
        securityService.assumeOwnershipMigrated(SecuredDomainType.REGATTA.getName());
        for (Leaderboard leaderboard : this.getLeaderboards().values()) {
            securityService.migrateOwnership((WithQualifiedObjectIdentifier)leaderboard);
        }
        securityService.assumeOwnershipMigrated(SecuredDomainType.LEADERBOARD.getName());
        for (LeaderboardGroup leaderboardGroup : this.getLeaderboardGroups().values()) {
            securityService.migrateOwnership((WithQualifiedObjectIdentifier)leaderboardGroup);
        }
        securityService.assumeOwnershipMigrated(SecuredDomainType.LEADERBOARD_GROUP.getName());
        for (MediaTrack mediaTrack : this.getAllMediaTracks()) {
            securityService.migrateOwnership((WithQualifiedObjectIdentifier)mediaTrack);
        }
        securityService.assumeOwnershipMigrated(SecuredDomainType.MEDIA_TRACK.getName());
        for (Competitor competitor : this.getCompetitorAndBoatStore().getAllCompetitors()) {
            securityService.migrateOwnership((WithQualifiedObjectIdentifier)competitor);
        }
        securityService.assumeOwnershipMigrated(SecuredDomainType.COMPETITOR.getName());
        for (Boat boat : this.getCompetitorAndBoatStore().getBoats()) {
            securityService.migrateOwnership((WithQualifiedObjectIdentifier)boat);
        }
        securityService.assumeOwnershipMigrated(SecuredDomainType.BOAT.getName());
        securityService.migrateOwnership(SecuredDomainType.WIND_ESTIMATION_MODELS.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})), "Wind estimation models for server " + ServerInfo.getName());
        securityService.checkMigration(SecuredDomainType.getAllInstances());
    }

    private void loadRaceIDToRegattaAssociations() {
        this.persistentRegattasForRaceIDs.putAll(this.domainObjectFactory.loadRaceIDToRegattaAssociations((RegattaRegistry)this));
    }

    private void loadStoredRegattas() {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
        try {
            for (Regatta regatta : this.domainObjectFactory.loadAllRegattas((TrackedRegattaRegistry)this)) {
                logger.info("putting regatta " + regatta.getName() + " (" + regatta.hashCode() + ") into regattasByName");
                this.regattasByName.put(regatta.getName(), regatta);
                regatta.addRegattaListener((RegattaListener)this);
                this.onRegattaLikeAdded((IsRegattaLike)regatta);
                regatta.addRaceColumnListener((RaceColumnListener)this.raceLogReplicator);
                regatta.addRaceColumnListener((RaceColumnListener)this.raceLogScoringReplicator);
            }
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
        }
    }

    private Iterable<Util.Pair<Event, Boolean>> loadStoredEvents() {
        Iterable loadedEventsWithRequireStoreFlag = this.domainObjectFactory.loadAllEvents();
        for (Util.Pair eventAndFlag : loadedEventsWithRequireStoreFlag) {
            Event event = (Event)eventAndFlag.getA();
            if (event.getId() == null) continue;
            this.eventsById.put(event.getId(), event);
        }
        return loadedEventsWithRequireStoreFlag;
    }

    private void loadLinksFromEventsToLeaderboardGroups() {
        this.domainObjectFactory.loadLeaderboardGroupLinksForEvents((EventResolver)this, (LeaderboardGroupResolver)this);
    }

    private void loadAllRemoteSailingServersAndSchedulePeriodicEventCacheRefresh() {
        for (RemoteSailingServerReference sailingServer : this.domainObjectFactory.loadAllRemoteSailingServerReferences()) {
            this.remoteSailingServerSet.add(sailingServer);
        }
    }

    private void loadMediaLibary() {
        List allDbMediaTracks = this.mediaDB.loadAllMediaTracks();
        this.mediaTracksAdded(allDbMediaTracks);
    }

    private void loadStoredDeviceConfigurations() {
        for (DeviceConfiguration config : this.domainObjectFactory.loadAllDeviceConfigurations()) {
            this.raceManagerDeviceConfigurationsById.put(config.getId(), config);
            if (this.raceManagerDeviceConfigurationsByName.put(config.getName(), config) == null) continue;
            logger.warning("DeviceConfiguration " + config.getId() + " with name " + config.getName() + " overwrote another config by that same name");
        }
    }

    public void addLeaderboard(Leaderboard leaderboard) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardsByNameLock);
        try {
            this.leaderboardsByName.put(leaderboard.getName(), leaderboard);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardsByNameLock);
        }
        if (leaderboard instanceof FlexibleLeaderboard) {
            this.onRegattaLikeAdded(((FlexibleLeaderboard)leaderboard).getRegattaLike());
            leaderboard.addRaceColumnListener((RaceColumnListener)this.raceLogReplicator);
            leaderboard.addRaceColumnListener((RaceColumnListener)this.raceLogScoringReplicator);
        }
        LeaderboardScoreCorrectionNotifier scoreCorrectionListener = new LeaderboardScoreCorrectionNotifier(leaderboard);
        this.scoreCorrectionListenersByLeaderboard.put(leaderboard, scoreCorrectionListener);
        leaderboard.addScoreCorrectionListener((ScoreCorrectionListener)scoreCorrectionListener);
        this.tryToRegisterMBeanForLeaderboard(leaderboard);
    }

    private void tryToRegisterMBeanForLeaderboard(Leaderboard leaderboard) {
        try {
            LeaderboardMXBeanImpl mbean = new LeaderboardMXBeanImpl(leaderboard);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mBeanName = mbean.getObjectName();
            mbs.registerMBean(mbean, mBeanName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            logger.log(Level.SEVERE, "Couldn't register MBean for leaderboard " + leaderboard.getName(), e);
        }
    }

    private void removeMBeanForLeaderboard(Leaderboard leaderboard) {
        try {
            LeaderboardMXBeanImpl mbean = new LeaderboardMXBeanImpl(leaderboard);
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            ObjectName mBeanName = mbean.getObjectName();
            mbs.unregisterMBean(mBeanName);
        }
        catch (InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException e) {
            logger.log(Level.SEVERE, "Couldn't unregister MBean for leaderboard " + leaderboard.getName(), e);
        }
    }

    private void loadStoredLeaderboardsAndGroups() {
        logger.info("loading stored leaderboards and groups");
        for (LeaderboardGroup leaderboardGroup : this.domainObjectFactory.getAllLeaderboardGroups((RegattaRegistry)this, (LeaderboardRegistry)this)) {
            logger.info("loaded leaderboard group " + leaderboardGroup.getName() + " into " + this);
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
            try {
                this.leaderboardGroupsByName.put(leaderboardGroup.getName(), Collections.singleton(leaderboardGroup));
                this.leaderboardGroupsByID.put(leaderboardGroup.getId(), leaderboardGroup);
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
            }
        }
        this.domainObjectFactory.getLeaderboardsNotInGroup((RegattaRegistry)this, (LeaderboardRegistry)this);
        logger.info("done with loading stored leaderboards and groups");
    }

    public FlexibleLeaderboard addFlexibleLeaderboard(String leaderboardName, String leaderboardDisplayName, int[] discardThresholds, ScoringScheme scoringScheme, Iterable<? extends Serializable> courseAreaIds) {
        logger.info("adding flexible leaderboard " + leaderboardName);
        FlexibleLeaderboardImpl result = new FlexibleLeaderboardImpl(this.getRaceLogStore(), this.getRegattaLogStore(), leaderboardName, (ThresholdBasedResultDiscardingRule)new ThresholdBasedResultDiscardingRuleImpl(discardThresholds), scoringScheme, Util.map(courseAreaIds, courseAreaId -> this.getBaseDomainFactory().getExistingCourseAreaById(courseAreaId)));
        result.setDisplayName(leaderboardDisplayName);
        if (this.getLeaderboardByName(leaderboardName) != null) {
            throw new IllegalArgumentException("Leaderboard with name " + leaderboardName + " already exists");
        }
        this.addLeaderboard((Leaderboard)result);
        this.mongoObjectFactory.storeLeaderboard((Leaderboard)result);
        return result;
    }

    public CourseArea getCourseArea(Serializable courseAreaId) {
        return this.getBaseDomainFactory().getExistingCourseAreaById(courseAreaId);
    }

    public RegattaLeaderboard addRegattaLeaderboard(RegattaIdentifier regattaIdentifier, String leaderboardDisplayName, int[] discardThresholds) {
        return this.addRegattaLeaderboard(regattaIdentifier, leaderboardDisplayName, discardThresholds, (regatta, thresholdBasedResultDiscardingRule) -> new RegattaLeaderboardImpl(regatta, (ThresholdBasedResultDiscardingRule)new ThresholdBasedResultDiscardingRuleImpl(discardThresholds)));
    }

    private <R extends RegattaLeaderboard> R addRegattaLeaderboard(RegattaIdentifier regattaIdentifier, String leaderboardDisplayName, int[] discardThresholds, BiFunction<Regatta, ThresholdBasedResultDiscardingRule, R> regattaConstructor) {
        Regatta regatta = this.getRegatta(regattaIdentifier);
        if (regatta == null) {
            throw new IllegalArgumentException("Cannot find regatta " + regattaIdentifier + ". Hence, cannot create regatta leaderboard for it.");
        }
        RegattaLeaderboard result = (RegattaLeaderboard)regattaConstructor.apply(regatta, (ThresholdBasedResultDiscardingRule)new ThresholdBasedResultDiscardingRuleImpl(discardThresholds));
        result.setDisplayName(leaderboardDisplayName);
        if (this.getLeaderboardByName(result.getName()) != null) {
            throw new IllegalArgumentException("Leaderboard with name " + result.getName() + " already exists in " + this);
        }
        logger.info("adding regatta leaderboard for regatta " + regatta.getName() + " (" + regatta.hashCode() + ")" + " to " + this);
        this.addLeaderboard((Leaderboard)result);
        this.mongoObjectFactory.storeLeaderboard((Leaderboard)result);
        return (R)result;
    }

    public RegattaLeaderboardWithEliminations addRegattaLeaderboardWithEliminations(String leaderboardName, String leaderboardDisplayName, RegattaLeaderboard fullRegattaLeaderboard) {
        if (fullRegattaLeaderboard == null) {
            throw new NullPointerException("Must provide a valid regatta leaderboard, not null");
        }
        if (this.getLeaderboardByName(leaderboardName) != null) {
            throw new IllegalArgumentException("Leaderboard with name " + leaderboardName + " already exists in " + this);
        }
        DelegatingRegattaLeaderboardWithCompetitorElimination result = new DelegatingRegattaLeaderboardWithCompetitorElimination(() -> fullRegattaLeaderboard, leaderboardName);
        result.setDisplayName(leaderboardDisplayName);
        logger.info("adding regatta leaderboard with eliminations for regatta leaderboard " + fullRegattaLeaderboard.getName() + " to " + this);
        this.addLeaderboard((Leaderboard)result);
        this.mongoObjectFactory.storeLeaderboard((Leaderboard)result);
        return result;
    }

    public RegattaLeaderboardWithOtherTieBreakingLeaderboard addRegattaLeaderboardWithOtherTieBreakingLeaderboard(RegattaIdentifier regattaIdentifier, String leaderboardDisplayName, int[] discardThresholds, RegattaLeaderboard otherTieBreakingLeaderboard) {
        return (RegattaLeaderboardWithOtherTieBreakingLeaderboard)this.addRegattaLeaderboard(regattaIdentifier, leaderboardDisplayName, discardThresholds, (regatta, thresholdBasedResultDiscardingRule) -> new RegattaLeaderboardWithOtherTieBreakingLeaderboardImpl(regatta, (ThresholdBasedResultDiscardingRule)new ThresholdBasedResultDiscardingRuleImpl(discardThresholds), () -> otherTieBreakingLeaderboard));
    }

    public RaceColumn addColumnToLeaderboard(String columnName, String leaderboardName, boolean medalRace) {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard != null) {
            if (leaderboard instanceof FlexibleLeaderboard) {
                FlexibleRaceColumn result = ((FlexibleLeaderboard)leaderboard).addRaceColumn(columnName, medalRace);
                this.updateStoredLeaderboard((Leaderboard)((FlexibleLeaderboard)leaderboard));
                return result;
            }
            throw new IllegalArgumentException("Leaderboard named " + leaderboardName + " is not a FlexibleLeaderboard");
        }
        throw new IllegalArgumentException("Leaderboard named " + leaderboardName + " not found");
    }

    public void moveLeaderboardColumnUp(String leaderboardName, String columnName) {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard == null || !(leaderboard instanceof FlexibleLeaderboard)) {
            throw new IllegalArgumentException("Leaderboard named " + leaderboardName + " not found");
        }
        ((FlexibleLeaderboard)leaderboard).moveRaceColumnUp(columnName);
        this.updateStoredLeaderboard((Leaderboard)((FlexibleLeaderboard)leaderboard));
    }

    public void moveLeaderboardColumnDown(String leaderboardName, String columnName) {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard == null || !(leaderboard instanceof FlexibleLeaderboard)) {
            throw new IllegalArgumentException("Leaderboard named " + leaderboardName + " not found");
        }
        ((FlexibleLeaderboard)leaderboard).moveRaceColumnDown(columnName);
        this.updateStoredLeaderboard((Leaderboard)((FlexibleLeaderboard)leaderboard));
    }

    public void removeLeaderboardColumn(String leaderboardName, String columnName) {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard == null) {
            throw new IllegalArgumentException("Leaderboard named " + leaderboardName + " not found");
        }
        if (!(leaderboard instanceof FlexibleLeaderboard)) {
            throw new IllegalArgumentException("Columns cannot be removed from Leaderboard named " + leaderboardName);
        }
        ((FlexibleLeaderboard)leaderboard).removeRaceColumn(columnName);
        this.updateStoredLeaderboard((Leaderboard)((FlexibleLeaderboard)leaderboard));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void renameLeaderboardColumn(String leaderboardName, String oldColumnName, String newColumnName) {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard == null) throw new IllegalArgumentException("Leaderboard named " + leaderboardName + " not found");
        RaceColumn raceColumn = leaderboard.getRaceColumnByName(oldColumnName);
        if (!(raceColumn instanceof FlexibleRaceColumn)) throw new IllegalArgumentException("Race column " + oldColumnName + " cannot be renamed");
        for (Fleet fleet : raceColumn.getFleets()) {
            this.getMongoObjectFactory().removeRaceLog(raceColumn.getRaceLogIdentifier(fleet));
        }
        ((FlexibleRaceColumn)raceColumn).setName(newColumnName);
        this.storeRaceLogs(raceColumn);
        this.updateStoredLeaderboard(leaderboard);
    }

    private void storeRaceLogs(RaceColumn raceColumn) {
        for (Fleet fleet : raceColumn.getFleets()) {
            RaceLogIdentifier identifier = raceColumn.getRaceLogIdentifier(fleet);
            RaceLogEventVisitor storeVisitor = MongoRaceLogStoreFactory.INSTANCE.getMongoRaceLogStoreVisitor(identifier, this.getMongoObjectFactory());
            RaceLog raceLog = raceColumn.getRaceLog(fleet);
            raceLog.lockForRead();
            try {
                for (RaceLogEvent e : raceLog.getRawFixes()) {
                    e.accept((Object)storeVisitor);
                }
            }
            finally {
                raceLog.unlockAfterRead();
            }
        }
    }

    public void updateLeaderboardColumnFactor(String leaderboardName, String columnName, Double factor) {
        RaceColumn raceColumn;
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard != null) {
            raceColumn = leaderboard.getRaceColumnByName(columnName);
            if (raceColumn == null) {
                throw new IllegalArgumentException("Race column " + columnName + " not found in leaderboard " + leaderboardName);
            }
        } else {
            throw new IllegalArgumentException("Leaderboard named " + leaderboardName + " not found");
        }
        raceColumn.setFactor(factor);
        this.updateStoredLeaderboard(leaderboard);
    }

    public void updateStoredLeaderboard(Leaderboard leaderboard) {
        this.getMongoObjectFactory().storeLeaderboard(leaderboard);
    }

    public void updateStoredRegatta(Regatta regatta) {
        if (regatta.isPersistent()) {
            this.mongoObjectFactory.storeRegatta(regatta);
        }
    }

    public void removeLeaderboard(String leaderboardName) {
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard != null) {
            HashSet<Leaderboard> leaderboardsToRemove = new HashSet<Leaderboard>();
            leaderboardsToRemove.add(leaderboard);
            if (leaderboard.getLeaderboardType() == LeaderboardType.RegattaLeaderboard) {
                Regatta regatta = ((RegattaLeaderboard)leaderboard).getRegatta();
                for (Leaderboard candidateForRemoval : this.getLeaderboards().values()) {
                    if (candidateForRemoval == leaderboard || !(candidateForRemoval instanceof RegattaLeaderboard)) continue;
                    Regatta candidatesRegatta = ((RegattaLeaderboard)candidateForRemoval).getRegatta();
                    if (candidatesRegatta == regatta) {
                        leaderboardsToRemove.add(candidateForRemoval);
                        continue;
                    }
                    if (!(candidateForRemoval instanceof RegattaLeaderboardWithOtherTieBreakingLeaderboard) || ((RegattaLeaderboardWithOtherTieBreakingLeaderboard)candidateForRemoval).getOtherTieBreakingLeaderboard().getRegatta() != regatta) continue;
                    leaderboardsToRemove.add(candidateForRemoval);
                }
            }
            for (Leaderboard toRemove : leaderboardsToRemove) {
                this.removeSingleLeaderboardInternal(toRemove);
            }
        }
    }

    private void removeSingleLeaderboardInternal(Leaderboard leaderboard) {
        this.removeLeaderboardFromLeaderboardsByName(leaderboard.getName());
        leaderboard.removeRaceColumnListener((RaceColumnListener)this.raceLogReplicator);
        leaderboard.removeRaceColumnListener((RaceColumnListener)this.raceLogScoringReplicator);
        ScoreCorrectionListener scoreCorrectionListener = this.scoreCorrectionListenersByLeaderboard.remove(leaderboard);
        if (scoreCorrectionListener != null) {
            leaderboard.getScoreCorrection().removeScoreCorrectionListener(scoreCorrectionListener);
        }
        this.mongoObjectFactory.removeLeaderboard(leaderboard.getName());
        this.syncGroupsAfterLeaderboardRemove(leaderboard.getName(), true);
        if (leaderboard instanceof FlexibleLeaderboard) {
            this.onRegattaLikeRemoved(((FlexibleLeaderboard)leaderboard).getRegattaLike());
        }
        leaderboard.destroy();
    }

    private Leaderboard removeLeaderboardFromLeaderboardsByName(String leaderboardName) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardsByNameLock);
        try {
            Leaderboard leaderboard = this.leaderboardsByName.get(leaderboardName);
            if (leaderboard != null) {
                this.removeMBeanForLeaderboard(leaderboard);
            }
            Leaderboard leaderboard2 = this.leaderboardsByName.remove(leaderboardName);
            return leaderboard2;
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardsByNameLock);
        }
    }

    private void syncGroupsAfterLeaderboardRemove(String removedLeaderboardName, boolean doDatabaseUpdate) {
        boolean groupNeedsUpdate = false;
        for (Set<LeaderboardGroup> leaderboardGroupsSet : this.leaderboardGroupsByName.values()) {
            for (LeaderboardGroup leaderboardGroup : leaderboardGroupsSet) {
                for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                    if (!leaderboard.getName().equals(removedLeaderboardName)) continue;
                    leaderboardGroup.removeLeaderboard(leaderboard);
                    groupNeedsUpdate = true;
                    break;
                }
                if (leaderboardGroup.getOverallLeaderboard() != null && leaderboardGroup.getOverallLeaderboard().getName().equals(removedLeaderboardName)) {
                    leaderboardGroup.setOverallLeaderboard(null);
                    groupNeedsUpdate = true;
                }
                if (doDatabaseUpdate && groupNeedsUpdate) {
                    this.mongoObjectFactory.storeLeaderboardGroup(leaderboardGroup);
                }
                groupNeedsUpdate = false;
            }
        }
    }

    public Leaderboard getLeaderboardByName(String name) {
        return this.leaderboardsByName.get(name);
    }

    public Position getMarkPosition(Mark mark, LeaderboardThatHasRegattaLike leaderboard, TimePoint timePoint) {
        GPSFixTrack track = null;
        GPSFix nonSpanningFallback = null;
        for (TrackedRace trackedRace : leaderboard.getTrackedRaces()) {
            GPSFixTrack trackCandidate = trackedRace.getTrack(mark);
            if (trackCandidate == null) continue;
            if (this.spansTimePoint((GPSFixTrack<Mark, GPSFix>)trackCandidate, timePoint)) {
                track = trackCandidate;
                break;
            }
            nonSpanningFallback = this.improveTimewiseClosestFix(nonSpanningFallback, (GPSFixTrack<Mark, GPSFix>)trackCandidate, timePoint);
        }
        Position result = track != null ? track.getEstimatedPosition(timePoint, false) : (nonSpanningFallback == null ? null : nonSpanningFallback.getPosition());
        return result;
    }

    private GPSFix improveTimewiseClosestFix(GPSFix nonSpanningFallback, GPSFixTrack<Mark, GPSFix> track, final TimePoint timePoint) {
        GPSFix lastAtOrBefore = (GPSFix)track.getLastFixAtOrBefore(timePoint);
        GPSFix firstAtOrAfter = (GPSFix)track.getFirstFixAtOrAfter(timePoint);
        List<GPSFix> list = Arrays.asList(nonSpanningFallback, lastAtOrBefore, firstAtOrAfter);
        list.sort(new Comparator<GPSFix>(){

            @Override
            public int compare(GPSFix o1, GPSFix o2) {
                int result = o1 == null ? (o2 == null ? 0 : 1) : (o2 == null ? -1 : Long.valueOf(Math.abs(o1.getTimePoint().until(timePoint).asMillis())).compareTo(Math.abs(o2.getTimePoint().until(timePoint).asMillis())));
                return result;
            }
        });
        return list.get(0);
    }

    private boolean spansTimePoint(GPSFixTrack<Mark, GPSFix> track, TimePoint timePoint) {
        return track.getLastFixAtOrBefore(timePoint) != null && track.getFirstFixAtOrAfter(timePoint) != null;
    }

    public Map<String, Leaderboard> getLeaderboards() {
        return Collections.unmodifiableMap(new HashMap<String, Leaderboard>(this.leaderboardsByName));
    }

    public SailingServerConfiguration getSailingServerConfiguration() {
        return this.sailingServerConfiguration;
    }

    public void updateServerConfiguration(SailingServerConfiguration serverConfiguration) {
        this.sailingServerConfiguration = serverConfiguration;
        this.mongoObjectFactory.storeServerConfiguration(serverConfiguration);
    }

    public Map<RemoteSailingServerReference, Util.Pair<Iterable<EventBase>, Exception>> getPublicEventsOfAllSailingServers() {
        return this.remoteSailingServerSet.getCachedEventsForRemoteSailingServers();
    }

    public RemoteSailingServerReference addRemoteSailingServerReference(String name, URL url, boolean include) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " requested addition of remote sailing server reference " + name);
        RemoteSailingServerReferenceImpl result = new RemoteSailingServerReferenceImpl(name, url, include, Collections.emptySet());
        this.remoteSailingServerSet.add((RemoteSailingServerReference)result);
        this.mongoObjectFactory.storeSailingServer((RemoteSailingServerReference)result);
        return result;
    }

    public RemoteSailingServerReference updateRemoteSailingServerReference(String name, boolean include, Set<UUID> selectedEventIds) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " requested update of remote sailing server reference " + name);
        RemoteSailingServerReference result = this.getRemoteServerReferenceByName(name);
        if (result != null) {
            result.updateSelectedEventIds(selectedEventIds);
            result.setInclude(include);
            this.mongoObjectFactory.storeSailingServer(result);
        }
        return result;
    }

    public Iterable<RemoteSailingServerReference> getLiveRemoteServerReferences() {
        return this.remoteSailingServerSet.getLiveRemoteServerReferences();
    }

    public Map<String, RemoteSailingServerReference> getAllRemoteServerReferences() {
        return this.remoteSailingServerSet.getAllRemoteServerReferences();
    }

    public RemoteSailingServerReference getRemoteServerReferenceByName(String remoteServerReferenceName) {
        return this.remoteSailingServerSet.getServerReferenceByName(remoteServerReferenceName);
    }

    public RemoteSailingServerReference getRemoteServerReferenceByUrl(URL remoteServerReferenceUrl) {
        return this.remoteSailingServerSet.getServerReferenceByUrl(remoteServerReferenceUrl);
    }

    public Util.Pair<Iterable<EventBase>, Exception> updateRemoteServerEventCacheSynchronously(RemoteSailingServerReference ref, boolean forceUpdate) {
        return this.remoteSailingServerSet.getEventsOrException(ref, forceUpdate);
    }

    public Util.Pair<Iterable<EventBase>, Exception> getCompleteRemoteServerReference(RemoteSailingServerReference ref) {
        return this.remoteSailingServerSet.getEventsComplete(ref);
    }

    public void removeRemoteSailingServerReference(String name) {
        logger.info("Subject " + SecurityUtils.getSubject().getPrincipal() + " requested removal of remote sailing server reference " + name);
        this.remoteSailingServerSet.remove(name);
        this.mongoObjectFactory.removeSailingServer(name);
    }

    public Iterable<Event> getAllEvents() {
        return Collections.unmodifiableCollection(new ArrayList<Event>(this.eventsById.values()));
    }

    public Iterable<Regatta> getRegattasSelectively(boolean include, Iterable<UUID> regattaIds) {
        Iterable<Object> regattas = regattaIds != null && !Util.isEmpty(regattaIds) ? Collections.unmodifiableCollection(Util.stream(this.getAllRegattas()).filter(element -> include ? Util.contains((Iterable)regattaIds, (Object)element.getId()) : !Util.contains((Iterable)regattaIds, (Object)element.getId())).collect(Collectors.toList())) : (include ? Collections.emptyList() : this.getAllRegattas());
        return regattas;
    }

    public Iterable<Event> getEventsSelectively(boolean include, Iterable<UUID> eventIds) {
        Iterable<Object> events = eventIds != null && !Util.isEmpty(eventIds) ? Collections.unmodifiableCollection(Util.stream(this.getAllEvents()).filter(element -> include ? Util.contains((Iterable)eventIds, (Object)element.getId()) : !Util.contains((Iterable)eventIds, (Object)element.getId())).collect(Collectors.toList())) : (include ? Collections.emptyList() : this.getAllEvents());
        return events;
    }

    public Event getEvent(Serializable id) {
        return id == null ? null : this.eventsById.get(id);
    }

    public Iterable<Regatta> getAllRegattas() {
        return Collections.unmodifiableCollection(new ArrayList<Regatta>(this.regattasByName.values()));
    }

    public boolean isRaceBeingTracked(Regatta regattaContext, RaceDefinition r) {
        Set<RaceTracker> trackers = this.raceTrackersByRegatta.get(regattaContext);
        if (trackers != null) {
            for (RaceTracker tracker : trackers) {
                RaceDefinition race = tracker.getRace();
                if (race != r) continue;
                return true;
            }
        }
        return false;
    }

    public Regatta getRegattaByName(String name) {
        return name == null ? null : this.regattasByName.get(name);
    }

    public Regatta getOrCreateDefaultRegatta(String name, String boatClassName, Serializable id) {
        Regatta result = this.regattasByName.get(name);
        if (result == null) {
            result = new RegattaImpl(this.getRaceLogStore(), this.getRegattaLogStore(), name, this.getBaseDomainFactory().getOrCreateBoatClass(boatClassName), false, CompetitorRegistrationType.CLOSED, null, null, (TrackedRegattaRegistry)this, this.getBaseDomainFactory().createScoringScheme(ScoringSchemeType.LOW_POINT), id, null, UUID.randomUUID().toString());
            logger.info("Created default regatta " + result.getName() + " (" + this.hashCode() + ") on " + this);
            this.onRegattaLikeAdded((IsRegattaLike)result);
            this.cacheAndReplicateDefaultRegatta(result);
        }
        return result;
    }

    private void onRegattaLikeAdded(IsRegattaLike isRegattaLike) {
        isRegattaLike.addListener((RegattaLikeListener)this.regattaLogReplicator);
    }

    private void onRegattaLikeRemoved(IsRegattaLike isRegattaLike) {
        isRegattaLike.removeListener((RegattaLikeListener)this.regattaLogReplicator);
        this.getRegattaLogStore().removeRegattaLog(isRegattaLike.getRegattaLikeIdentifier());
    }

    public Regatta createRegatta(String fullRegattaName, String boatClassName, boolean canBoatsOfCompetitorsChangePerRace, CompetitorRegistrationType competitorRegistrationType, String registrationLinkSecret, TimePoint startDate, TimePoint endDate, Serializable id, Iterable<? extends Series> series, boolean persistent, ScoringScheme scoringScheme, Iterable<? extends Serializable> courseAreaIds, Double buoyZoneRadiusInHullLengths, boolean useStartTimeInference, boolean controlTrackingFromStartAndFinishTimes, boolean autoRestartTrackingUponCompetitorSetChange, RankingMetricConstructor rankingMetricConstructor) {
        if (useStartTimeInference && controlTrackingFromStartAndFinishTimes) {
            throw new IllegalArgumentException("Cannot set both of useStartTimeInference and controlTrackingFromStartAndFinishTimes to true");
        }
        Util.Pair<Regatta, Boolean> regattaWithCreatedFlag = this.getOrCreateRegattaWithoutReplication(fullRegattaName, boatClassName, canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, registrationLinkSecret, startDate, endDate, id, series, persistent, scoringScheme, courseAreaIds, buoyZoneRadiusInHullLengths, useStartTimeInference, controlTrackingFromStartAndFinishTimes, autoRestartTrackingUponCompetitorSetChange, rankingMetricConstructor);
        Regatta regatta = (Regatta)regattaWithCreatedFlag.getA();
        if (((Boolean)regattaWithCreatedFlag.getB()).booleanValue()) {
            this.onRegattaLikeAdded((IsRegattaLike)regatta);
            this.replicateSpecificRegattaWithoutRaceColumns(regatta);
        }
        return regatta;
    }

    public void addRegattaWithoutReplication(Regatta regatta) {
        boolean wasAdded = this.addAndConnectRegatta(regatta.isPersistent(), regatta);
        if (!wasAdded) {
            logger.info("Regatta with name " + regatta.getName() + " already existed, so it hasn't been added.");
        }
    }

    private RaceLogStore getRaceLogStore() {
        return MongoRaceLogStoreFactory.INSTANCE.getMongoRaceLogStore(this.mongoObjectFactory, this.domainObjectFactory);
    }

    private RegattaLogStore getRegattaLogStore() {
        return MongoRegattaLogStoreFactory.INSTANCE.getMongoRegattaLogStore(this.mongoObjectFactory, this.domainObjectFactory);
    }

    public Util.Pair<Regatta, Boolean> getOrCreateRegattaWithoutReplication(String fullRegattaName, String boatClassName, boolean canBoatsOfCompetitorsChangePerRace, CompetitorRegistrationType competitorRegistrationType, String registrationLinkSecret, TimePoint startDate, TimePoint endDate, Serializable id, Iterable<? extends Series> series, boolean persistent, ScoringScheme scoringScheme, Iterable<? extends Serializable> courseAreaIds, Double buoyZoneRadiusInHullLengths, boolean useStartTimeInference, boolean controlTrackingFromStartAndFinishTimes, boolean autoRestartTrackingUponCompetitorSetChange, RankingMetricConstructor rankingMetricConstructor) {
        RegattaImpl regatta = new RegattaImpl(this.getRaceLogStore(), this.getRegattaLogStore(), fullRegattaName, this.getBaseDomainFactory().getOrCreateBoatClass(boatClassName), canBoatsOfCompetitorsChangePerRace, competitorRegistrationType, startDate, endDate, series, persistent, scoringScheme, id, Util.map(courseAreaIds, courseAreaId -> this.getBaseDomainFactory().getExistingCourseAreaById(courseAreaId)), buoyZoneRadiusInHullLengths, useStartTimeInference, controlTrackingFromStartAndFinishTimes, autoRestartTrackingUponCompetitorSetChange, rankingMetricConstructor, registrationLinkSecret);
        boolean wasCreated = this.addAndConnectRegatta(persistent, (Regatta)regatta);
        if (wasCreated) {
            logger.info("Created regatta " + regatta.getName() + " (" + this.hashCode() + ") on " + this);
        }
        return new Util.Pair((Object)regatta, (Object)wasCreated);
    }

    private boolean addAndConnectRegatta(boolean persistent, Regatta regatta) {
        boolean wasCreated = false;
        if (!this.regattasByName.containsKey(regatta.getName())) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
            try {
                if (!this.regattasByName.containsKey(regatta.getName())) {
                    wasCreated = true;
                    logger.info("putting regatta " + regatta.getName() + " (" + regatta.hashCode() + ") into regattasByName of " + this);
                    this.regattasByName.put(regatta.getName(), regatta);
                    regatta.addRegattaListener((RegattaListener)this);
                    regatta.addRaceColumnListener((RaceColumnListener)this.raceLogReplicator);
                    regatta.addRaceColumnListener((RaceColumnListener)this.raceLogScoringReplicator);
                }
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
            }
        }
        if (persistent) {
            this.updateStoredRegatta(regatta);
        }
        return wasCreated;
    }

    public void addRace(RegattaIdentifier addToRegatta, RaceDefinition raceDefinition) {
        Regatta regatta = this.getRegatta(addToRegatta);
        regatta.addRace(raceDefinition);
    }

    public void raceAdded(Regatta regatta, RaceDefinition raceDefinition) {
        if (regatta.isPersistent()) {
            this.setRegattaForRace(regatta, raceDefinition);
        }
        CourseChangeReplicator listener = new CourseChangeReplicator(this, regatta, raceDefinition);
        this.courseListeners.put(raceDefinition, listener);
        raceDefinition.getCourse().addCourseListener((CourseListener)listener);
        this.replicate((OperationWithResult)new AddRaceDefinition(regatta.getRegattaIdentifier(), raceDefinition));
    }

    public void raceRemoved(Regatta regatta, RaceDefinition raceDefinition) {
        raceDefinition.getCourse().removeCourseListener((CourseListener)this.courseListeners.remove(raceDefinition));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamedReentrantReadWriteLock lockRaceTrackersById(Object trackerId) {
        NamedReentrantReadWriteLock lock;
        ConcurrentHashMap<Object, NamedReentrantReadWriteLock> concurrentHashMap = this.raceTrackersByIDLocks;
        synchronized (concurrentHashMap) {
            lock = this.raceTrackersByIDLocks.computeIfAbsent(trackerId, tid -> new NamedReentrantReadWriteLock("raceTrackersByIDLock for " + tid, false));
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)lock);
        return lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlockRaceTrackersById(Object trackerId, NamedReentrantReadWriteLock lock) {
        LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)lock);
        ConcurrentHashMap<Object, NamedReentrantReadWriteLock> concurrentHashMap = this.raceTrackersByIDLocks;
        synchronized (concurrentHashMap) {
            this.raceTrackersByIDLocks.remove(trackerId);
        }
    }

    public RaceHandle addRace(RegattaIdentifier regattaToAddTo, RaceTrackingConnectivityParameters params, long timeoutInMilliseconds) throws Exception {
        return this.addRace(regattaToAddTo, params, timeoutInMilliseconds, this.getPermissionAwareRaceTrackingHandler());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RaceHandle addRace(RegattaIdentifier regattaToAddTo, RaceTrackingConnectivityParameters params, long timeoutInMilliseconds, RaceTrackingHandler raceTrackingHandler) throws Exception {
        Object trackerID = params.getTrackerID();
        NamedReentrantReadWriteLock raceTrackersByIdLock = this.lockRaceTrackersById(trackerID);
        try {
            RaceTracker tracker = this.raceTrackersByID.get(trackerID);
            if (tracker == null) {
                Regatta regatta;
                Regatta regatta2 = regatta = regattaToAddTo == null ? null : this.getRegatta(regattaToAddTo);
                if (regatta == null) {
                    tracker = params.createRaceTracker((TrackedRegattaRegistry)this, this.windStore, (RaceLogAndTrackedRaceResolver)this, (LeaderboardGroupResolver)this, timeoutInMilliseconds, raceTrackingHandler, (MarkPassingRaceFingerprintRegistry)this);
                } else {
                    tracker = params.createRaceTracker(regatta, (TrackedRegattaRegistry)this, this.windStore, (RaceLogAndTrackedRaceResolver)this, (LeaderboardGroupResolver)this, timeoutInMilliseconds, raceTrackingHandler, (MarkPassingRaceFingerprintRegistry)this);
                    assert (tracker.getRegatta() == regatta);
                }
                LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
                try {
                    this.raceTrackersByID.put(tracker.getID(), tracker);
                    Set trackers = this.raceTrackersByRegatta.computeIfAbsent(tracker.getRegatta(), r -> Collections.newSetFromMap(new ConcurrentHashMap()));
                    trackers.add(tracker);
                    this.notifyListenersForNewRaceTracker(tracker);
                }
                finally {
                    LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
                }
                String regattaName = tracker.getRegatta().getName();
                Regatta regattaWithName = this.regattasByName.get(regattaName);
                if (regattaWithName != null) {
                    if (regattaWithName != tracker.getRegatta()) {
                        if (!Util.isEmpty((Iterable)regattaWithName.getAllRaces())) throw new RuntimeException("Internal error. Two regatta objects with equal name " + regattaName);
                        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
                        try {
                            this.regattasByName.remove(regattaName);
                            this.cacheAndReplicateDefaultRegatta(tracker.getRegatta());
                        }
                        finally {
                            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
                        }
                    }
                } else {
                    this.cacheAndReplicateDefaultRegatta(tracker.getRegatta());
                }
                this.getMongoObjectFactory().addConnectivityParametersForRaceToRestore(params);
                tracker.add(t -> this.rememberConnectivityParametersForRace(t));
                if (params.isTrackWind()) {
                    Subject currentSubject = SecurityUtils.getSubject();
                    tracker.add(t -> new Thread(currentSubject.associateWith(() -> this.startTrackingWind(regattaWithName, t.getRace(), params.isCorrectWindDirectionByMagneticDeclination())), "Starting wind trackers for race " + t.getRace()).start());
                }
            } else {
                logger.warning("Race tracker with ID " + trackerID + " already found; not tracking twice to avoid race duplication");
                WindStore existingTrackersWindStore = tracker.getWindStore();
                if (!existingTrackersWindStore.equals(this.windStore)) {
                    logger.warning("Wind store mismatch. Requested wind store: " + this.windStore + ". Wind store in use by existing tracker: " + existingTrackersWindStore);
                }
            }
            if (timeoutInMilliseconds != -1L) {
                this.scheduleAbortTrackerAfterInitialTimeout(tracker, timeoutInMilliseconds);
            }
            RaceHandle raceHandle = tracker.getRaceHandle();
            return raceHandle;
        }
        finally {
            this.unlockRaceTrackersById(trackerID, raceTrackersByIdLock);
        }
    }

    private void rememberConnectivityParametersForRace(RaceTracker tracker) {
        RaceDefinition race = tracker.getRace();
        assert (race != null);
        RaceTrackingConnectivityParameters connectivityParams = tracker.getConnectivityParams();
        this.connectivityParametersByRace.put(race, connectivityParams);
    }

    private void replicateSpecificRegattaWithoutRaceColumns(Regatta regatta) {
        this.replicate((OperationWithResult)new AddSpecificRegatta(regatta.getName(), regatta.getBoatClass() == null ? null : regatta.getBoatClass().getName(), regatta.canBoatsOfCompetitorsChangePerRace(), regatta.getCompetitorRegistrationType(), regatta.getRegistrationLinkSecret(), regatta.getStartDate(), regatta.getEndDate(), regatta.getId(), this.getSeriesWithoutRaceColumnsConstructionParametersAsMap(regatta), regatta.isPersistent(), regatta.getScoringScheme(), (Iterable)Util.mapToArrayList((Iterable)regatta.getCourseAreas(), CourseArea::getId), regatta.getBuoyZoneRadiusInHullLengths(), regatta.useStartTimeInference(), regatta.isControlTrackingFromStartAndFinishTimes(), regatta.isAutoRestartTrackingUponCompetitorSetChange(), regatta.getRankingMetricType()));
        RegattaIdentifier regattaIdentifier = regatta.getRegattaIdentifier();
        for (RaceDefinition race : regatta.getAllRaces()) {
            this.replicate((OperationWithResult)new AddRaceDefinition(regattaIdentifier, race));
        }
    }

    private RegattaCreationParametersDTO getSeriesWithoutRaceColumnsConstructionParametersAsMap(Regatta regatta) {
        LinkedHashMap<String, SeriesCreationParametersDTO> result = new LinkedHashMap<String, SeriesCreationParametersDTO>();
        for (Series s : regatta.getSeries()) {
            assert (Util.isEmpty((Iterable)s.getRaceColumns()));
            ArrayList<FleetDTO> fleetNamesAndOrdering = new ArrayList<FleetDTO>();
            for (Fleet f : s.getFleets()) {
                fleetNamesAndOrdering.add(this.getBaseDomainFactory().convertToFleetDTO(f));
            }
            result.put(s.getName(), new SeriesCreationParametersDTO(fleetNamesAndOrdering, s.isMedal(), s.isFleetsCanRunInParallel(), s.isStartsWithZeroScore(), s.isFirstColumnNonDiscardableCarryForward(), s.getResultDiscardingRule() == null ? null : s.getResultDiscardingRule().getDiscardIndexResultsStartingWithHowManyRaces(), s.hasSplitFleetContiguousScoring(), s.hasCrossFleetMergedRanking(), s.getMaximumNumberOfDiscards(), s.isOneAlwaysStaysOne()));
        }
        return new RegattaCreationParametersDTO(result);
    }

    private void cacheAndReplicateDefaultRegatta(Regatta regatta) {
        if (!this.regattasByName.containsKey(regatta.getName())) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
            try {
                if (!this.regattasByName.containsKey(regatta.getName())) {
                    logger.info("putting regatta " + regatta.getName() + " (" + regatta.hashCode() + ") into regattasByName of " + this);
                    this.regattasByName.put(regatta.getName(), regatta);
                    regatta.addRegattaListener((RegattaListener)this);
                    regatta.addRaceColumnListener((RaceColumnListener)this.raceLogReplicator);
                    regatta.addRaceColumnListener((RaceColumnListener)this.raceLogScoringReplicator);
                    this.replicate((OperationWithResult)new AddDefaultRegatta(regatta.getName(), regatta.getBoatClass() == null ? null : regatta.getBoatClass().getName(), regatta.getStartDate(), regatta.getEndDate(), regatta.getId()));
                    RegattaIdentifier regattaIdentifier = regatta.getRegattaIdentifier();
                    for (RaceDefinition race : regatta.getAllRaces()) {
                        this.replicate((OperationWithResult)new AddRaceDefinition(regattaIdentifier, race));
                    }
                }
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
            }
        }
    }

    public DynamicTrackedRace createTrackedRace(RegattaAndRaceIdentifier raceIdentifier, WindStore windStore, long delayToLiveInMillis, long millisecondsOverWhichToAverageWind, long millisecondsOverWhichToAverageSpeed, boolean useMarkPassingCalculator, TrackingConnectorInfo trackingConnectorInfo) {
        DynamicTrackedRegatta trackedRegatta = this.getOrCreateTrackedRegatta(this.getRegatta((RegattaIdentifier)raceIdentifier));
        RaceDefinition race = this.getRace(raceIdentifier);
        return trackedRegatta.createTrackedRace(race, Collections.emptyList(), windStore, delayToLiveInMillis, millisecondsOverWhichToAverageWind, millisecondsOverWhichToAverageSpeed, null, useMarkPassingCalculator, (RaceLogAndTrackedRaceResolver)this, Optional.of(this.getThreadLocalTransporterForCurrentlyFillingFromInitialLoadOrApplyingOperationReceivedFromMaster()), trackingConnectorInfo, (MarkPassingRaceFingerprintRegistry)this);
    }

    private void ensureRegattaHasRaceAdditionListener(DynamicTrackedRegatta trackedRegatta) {
        if (this.regattasObservedWithRaceAdditionListener.add(trackedRegatta)) {
            trackedRegatta.addRaceListener((RaceListener)new RaceAdditionListener(), Optional.empty(), true);
        }
    }

    private void stopObservingRegattaWithRaceAdditionListener(DynamicTrackedRegatta trackedRegatta) {
        this.regattasObservedWithRaceAdditionListener.remove(trackedRegatta);
    }

    private void linkRaceToConfiguredLeaderboardColumns(TrackedRace trackedRace) {
        RegattaAndRaceIdentifier trackedRaceIdentifier = trackedRace.getRaceIdentifier();
        for (Leaderboard leaderboard : this.getLeaderboards().values()) {
            for (RaceColumn column : leaderboard.getRaceColumns()) {
                for (Fleet fleet : column.getFleets()) {
                    if (!trackedRaceIdentifier.equals(column.getRaceIdentifier(fleet)) || column.getTrackedRace(fleet) != null) continue;
                    column.setTrackedRace(fleet, trackedRace);
                    this.replicate((OperationWithResult)new ConnectTrackedRaceToLeaderboardColumn(leaderboard.getName(), column.getName(), fleet.getName(), trackedRaceIdentifier));
                }
            }
        }
    }

    public void stopTracking(Regatta regatta, boolean willBeRemoved) throws MalformedURLException, IOException, InterruptedException {
        Set<RaceTracker> trackersForRegatta;
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
        try {
            trackersForRegatta = this.raceTrackersByRegatta.remove(regatta);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
        }
        if (trackersForRegatta != null) {
            for (RaceTracker raceTracker : trackersForRegatta) {
                RaceDefinition race = raceTracker.getRace();
                if (race != null) {
                    this.stopTrackingWind(regatta, race);
                }
                raceTracker.stop(false, willBeRemoved);
                Object trackerId = raceTracker.getID();
                NamedReentrantReadWriteLock lock = this.lockRaceTrackersById(trackerId);
                try {
                    this.raceTrackersByID.remove(trackerId);
                }
                finally {
                    this.unlockRaceTrackersById(trackerId, lock);
                }
            }
        }
    }

    public void stopTrackingAndRemove(Regatta regatta) throws MalformedURLException, IOException, InterruptedException {
        if (regatta != null) {
            this.stopTracking(regatta, true);
            if (regatta.getName() != null) {
                logger.info("Removing regatta " + regatta.getName() + " (" + regatta.hashCode() + ") from " + this);
                LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
                try {
                    this.regattasByName.remove(regatta.getName());
                }
                finally {
                    LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
                }
                LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattaTrackingCacheLock);
                try {
                    this.regattaTrackingCache.remove(regatta);
                }
                finally {
                    LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattaTrackingCacheLock);
                }
                regatta.removeRegattaListener((RegattaListener)this);
                regatta.removeRaceColumnListener((RaceColumnListener)this.raceLogReplicator);
                regatta.removeRaceColumnListener((RaceColumnListener)this.raceLogScoringReplicator);
            }
        }
    }

    private ScheduledFuture<?> scheduleAbortTrackerAfterInitialTimeout(final RaceTracker tracker, final long timeoutInMilliseconds) {
        ScheduledFuture<?> task = this.getScheduler().schedule(new Runnable(){

            @Override
            public void run() {
                if (tracker.getRace() == null) {
                    try {
                        logger.log(Level.SEVERE, "RaceDefinition for a race in regatta " + tracker.getRegatta().getName() + " not obtained within " + timeoutInMilliseconds + "ms. Aborting tracker for this race.");
                        RacingEventServiceImpl.this.stopTracking(tracker.getRegatta(), raceTracker2 -> raceTracker2 == tracker, true, true);
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "scheduleAbortTrackerAfterInitialTimeout", e);
                    }
                }
            }
        }, timeoutInMilliseconds, TimeUnit.MILLISECONDS);
        return task;
    }

    public void stopTracking(Regatta regatta, RaceDefinition race) throws MalformedURLException, IOException, InterruptedException {
        logger.info("Stopping tracking for " + race + "...");
        this.stopTracking(regatta, (RaceTracker raceTracker) -> raceTracker.getRace() == race);
        try {
            this.stopTrackingWind(regatta, race);
            RaceTrackingConnectivityParameters connectivityParams = this.connectivityParametersByRace.get(race);
            if (connectivityParams != null) {
                if (connectivityParams.isTrackWind()) {
                    connectivityParams.setTrackWind(false);
                    this.getMongoObjectFactory().addConnectivityParametersForRaceToRestore(connectivityParams);
                }
            } else {
                logger.warning("Would have expected to find connectivity params for race " + race + " but didn't");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void stopTracker(Regatta regatta, RaceTracker tracker) throws MalformedURLException, IOException, InterruptedException {
        this.stopTracking(regatta, (RaceTracker raceTracker2) -> raceTracker2 == tracker);
    }

    private void stopTracking(Regatta regatta, Predicate<RaceTracker> matcher) throws MalformedURLException, IOException, InterruptedException {
        this.stopTracking(regatta, matcher, false, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RaceTracker getAndRemoveRaceTracker(Regatta regatta, Predicate<RaceTracker> matcher) {
        Optional<Object> raceTracker;
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
        try {
            Set<RaceTracker> trackerSet = this.raceTrackersByRegatta.get(regatta);
            raceTracker = trackerSet != null ? trackerSet.stream().filter(matcher).findAny() : Optional.empty();
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
        }
        if (raceTracker.isPresent()) {
            RaceTracker tracker = (RaceTracker)raceTracker.get();
            logger.info("Found tracker with ID " + tracker.getID() + " for race " + tracker.getRace());
            Object trackerId = tracker.getID();
            NamedReentrantReadWriteLock lock = this.lockRaceTrackersById(trackerId);
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
            try {
                RaceTracker result;
                RaceTracker raceTrackerByID = this.raceTrackersByID.get(trackerId);
                if (raceTrackerByID == tracker) {
                    logger.info("Removing tracker for race " + tracker.getRace() + " from raceTrackersByID");
                    result = this.raceTrackersByID.remove(trackerId);
                } else {
                    logger.warning("Was expecting to find race tracker " + tracker + " with ID " + trackerId + " but found " + raceTrackerByID);
                    result = null;
                }
                Set<RaceTracker> trackerSet = this.raceTrackersByRegatta.get(regatta);
                boolean removedFromRaceTrackersByRegatta = false;
                if (trackerSet != null) {
                    Iterator<RaceTracker> trackerIter = trackerSet.iterator();
                    while (trackerIter.hasNext()) {
                        if (trackerIter.next() != tracker) continue;
                        logger.info("Removing tracker for race " + tracker.getRace() + " from raceTrackersByRegatta");
                        if (result == null) {
                            logger.warning("This is surprising because we did not find " + tracker + " in raceTrackersByID");
                        }
                        trackerIter.remove();
                        removedFromRaceTrackersByRegatta = true;
                        if (!trackerSet.isEmpty()) break;
                        this.raceTrackersByRegatta.remove(regatta);
                        break;
                    }
                }
                if (removedFromRaceTrackersByRegatta) return result;
                logger.warning("Did not find race tracker " + tracker + " in raceTrackersByRegatta anymore");
                if (result == null) return result;
                logger.warning("This is surprising because we did find " + tracker + " in raceTrackersByID and removed it there.");
                return result;
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
                this.unlockRaceTrackersById(trackerId, lock);
            }
        } else {
            logger.warning("Didn't find any trackers for regatta " + regatta);
            return null;
        }
    }

    private void stopTracking(Regatta regatta, Predicate<RaceTracker> matcher, boolean stopTrackerPreemtively, boolean trackerWillBeRemoved) throws MalformedURLException, IOException, InterruptedException {
        RaceTracker raceTracker = this.getAndRemoveRaceTracker(regatta, matcher);
        if (raceTracker != null) {
            logger.info("Found tracker to stop for races " + raceTracker.getRace());
            raceTracker.stop(stopTrackerPreemtively, trackerWillBeRemoved);
        } else {
            logger.warning("Didn't find the tracker looked for in regatta " + regatta);
        }
    }

    public void removeRegatta(Regatta regatta) throws MalformedURLException, IOException, InterruptedException {
        String regattaLeaderboardName = RegattaLeaderboardImpl.getLeaderboardNameForRegatta((Regatta)regatta);
        if (this.getLeaderboardByName(regattaLeaderboardName) != null) {
            this.removeLeaderboard(regattaLeaderboardName);
        }
        HashSet racesToRemove = new HashSet();
        Util.addAll((Iterable)regatta.getAllRaces(), racesToRemove);
        for (RaceDefinition race : racesToRemove) {
            this.removeRace(regatta, race);
            this.mongoObjectFactory.removeRegattaForRaceID(race.getName(), regatta);
            this.persistentRegattasForRaceIDs.remove(race.getId().toString());
        }
        if (regatta.isPersistent()) {
            this.mongoObjectFactory.removeRegatta(regatta);
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
        try {
            this.regattasByName.remove(regatta.getName());
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
        }
        regatta.removeRegattaListener((RegattaListener)this);
        regatta.removeRaceColumnListener((RaceColumnListener)this.raceLogReplicator);
        regatta.removeRaceColumnListener((RaceColumnListener)this.raceLogScoringReplicator);
        this.onRegattaLikeRemoved((IsRegattaLike)regatta);
    }

    public void removeSeries(Series series) throws MalformedURLException, IOException, InterruptedException {
        Regatta regatta = series.getRegatta();
        regatta.removeSeries(series);
        if (regatta.isPersistent()) {
            this.mongoObjectFactory.storeRegatta(regatta);
        }
    }

    public Regatta updateRegatta(RegattaIdentifier regattaIdentifier, TimePoint startDate, TimePoint endDate, Iterable<? extends Serializable> newCourseAreaIds, RegattaConfiguration newRegattaConfiguration, Iterable<? extends Series> series, Double buoyZoneRadiusInHullLengths, boolean useStartTimeInference, boolean controlTrackingFromStartAndFinishTimes, boolean autoRestartTrackingUponCompetitorSetChange, String registrationLinkSecret, CompetitorRegistrationType registrationType) {
        if (useStartTimeInference && controlTrackingFromStartAndFinishTimes) {
            throw new IllegalArgumentException("Cannot set both of useStartTimeInference and controlTrackingFromStartAndFinishTimes to true");
        }
        Regatta regatta = this.getRegatta(regattaIdentifier);
        regatta.setCourseAreas(Util.map(newCourseAreaIds, this::getCourseArea));
        regatta.setStartDate(startDate);
        regatta.setEndDate(endDate);
        regatta.setBuoyZoneRadiusInHullLengths(buoyZoneRadiusInHullLengths);
        regatta.setControlTrackingFromStartAndFinishTimes(controlTrackingFromStartAndFinishTimes);
        regatta.setAutoRestartTrackingUponCompetitorSetChange(autoRestartTrackingUponCompetitorSetChange);
        regatta.setRegistrationLinkSecret(registrationLinkSecret);
        regatta.setCompetitorRegistrationType(registrationType);
        if (regatta.useStartTimeInference() != useStartTimeInference) {
            regatta.setUseStartTimeInference(useStartTimeInference);
            DynamicTrackedRegatta dynamicTrackedRegatta = this.getTrackedRegatta(regatta);
            if (dynamicTrackedRegatta != null) {
                dynamicTrackedRegatta.lockTrackedRacesForRead();
                try {
                    for (DynamicTrackedRace trackedRace : dynamicTrackedRegatta.getTrackedRaces()) {
                        trackedRace.invalidateStartTime();
                    }
                }
                finally {
                    dynamicTrackedRegatta.unlockTrackedRacesAfterRead();
                }
            }
        }
        regatta.setRegattaConfiguration(newRegattaConfiguration);
        if (series != null) {
            for (Series series2 : series) {
                regatta.addSeries(series2);
            }
        }
        if (regatta.isPersistent()) {
            this.mongoObjectFactory.storeRegatta(regatta);
        }
        return regatta;
    }

    public RaceHandle updateRaceCompetitors(Regatta regatta, RaceDefinition race) throws Exception {
        RaceHandle result;
        if (regatta.isAutoRestartTrackingUponCompetitorSetChange()) {
            RaceTrackingConnectivityParameters connectivityParams = this.connectivityParametersByRace.get(race);
            if (connectivityParams != null) {
                this.removeRace(regatta, race);
                result = this.addRace(regatta.getRegattaIdentifier(), connectivityParams, 60000L, (RaceTrackingHandler)new RaceTrackingHandler.DefaultRaceTrackingHandler());
            } else {
                result = null;
                logger.warning("Unable to update race competitors for race " + race + " in regatta " + regatta + " because no connectivity params were found that we could use to start tracking again for that race.");
            }
        } else {
            result = null;
        }
        return result;
    }

    public void removeRace(Regatta regatta, RaceDefinition race) throws MalformedURLException, IOException, InterruptedException {
        logger.info("Removing the race " + race + "...");
        RaceTrackingConnectivityParameters connectivityParams = this.connectivityParametersByRace.remove(race);
        if (connectivityParams != null) {
            this.getMongoObjectFactory().removeConnectivityParametersForRaceToRestore(connectivityParams);
        }
        this.stopAllTrackersForWhichRaceIsLastReachable(regatta, race);
        this.stopTrackingWind(regatta, race);
        DynamicTrackedRace trackedRace = this.getExistingTrackedRace(regatta, race);
        if (trackedRace != null) {
            boolean isTrackedRacesBecameEmpty;
            this.removeStoredMarkPassings((RaceIdentifier)trackedRace.getRaceIdentifier());
            DynamicTrackedRegatta trackedRegatta = this.getTrackedRegatta(regatta);
            if (trackedRegatta != null) {
                trackedRegatta.lockTrackedRacesForWrite();
                boolean oldTrackedRacesIsEmpty = Util.isEmpty((Iterable)trackedRegatta.getTrackedRaces());
                try {
                    trackedRegatta.removeTrackedRace((TrackedRace)trackedRace, Optional.of(this.getThreadLocalTransporterForCurrentlyFillingFromInitialLoadOrApplyingOperationReceivedFromMaster()));
                    boolean newTrackedRacesIsEmpty = Util.isEmpty((Iterable)trackedRegatta.getTrackedRaces());
                    isTrackedRacesBecameEmpty = !oldTrackedRacesIsEmpty && newTrackedRacesIsEmpty;
                }
                finally {
                    trackedRegatta.unlockTrackedRacesAfterWrite();
                }
            } else {
                isTrackedRacesBecameEmpty = false;
            }
            if (isTrackedRacesBecameEmpty) {
                this.removeTrackedRegatta(regatta);
            }
            for (Series series : regatta.getSeries()) {
                for (RaceColumnInSeries raceColumn : series.getRaceColumns()) {
                    for (Fleet fleet : series.getFleets()) {
                        if (raceColumn.getTrackedRace(fleet) != trackedRace) continue;
                        raceColumn.releaseTrackedRace(fleet);
                    }
                }
            }
            for (Leaderboard leaderboard : this.getLeaderboards().values()) {
                if (!(leaderboard instanceof FlexibleLeaderboard)) continue;
                for (RaceColumnInSeries raceColumn : leaderboard.getRaceColumns()) {
                    for (Fleet fleet : raceColumn.getFleets()) {
                        if (raceColumn.getTrackedRace(fleet) != trackedRace) continue;
                        raceColumn.releaseTrackedRace(fleet);
                    }
                }
            }
        }
        regatta.removeRace(race);
        if (!regatta.isPersistent() && Util.isEmpty((Iterable)regatta.getAllRaces())) {
            logger.info("Removing regatta " + regatta.getName() + " (" + regatta.hashCode() + ") from service " + this);
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
            try {
                this.regattasByName.remove(regatta.getName());
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
            }
            regatta.removeRegattaListener((RegattaListener)this);
            regatta.removeRaceColumnListener((RaceColumnListener)this.raceLogReplicator);
            regatta.removeRaceColumnListener((RaceColumnListener)this.raceLogScoringReplicator);
        }
    }

    private void stopAllTrackersForWhichRaceIsLastReachable(Regatta regatta, RaceDefinition race) throws MalformedURLException, IOException, InterruptedException {
        this.stopTracking(regatta, tracker -> tracker.getRace() == race, true, true);
    }

    public void startTrackingWind(Regatta regatta, RaceDefinition race, boolean correctByDeclination) {
        for (WindTrackerFactory windTrackerFactory : this.getWindTrackerFactories()) {
            try {
                windTrackerFactory.createWindTracker(this.getOrCreateTrackedRegatta(regatta), race, correctByDeclination, this.getSecurityService());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error trying to track wind using wind tracker factory " + windTrackerFactory, e);
            }
        }
    }

    public void stopTrackingWind(Regatta regatta, RaceDefinition race) throws SocketException, IOException {
        for (WindTrackerFactory windTrackerFactory : this.getWindTrackerFactories()) {
            WindTracker windTracker = windTrackerFactory.getExistingWindTracker(race);
            if (windTracker == null) continue;
            windTracker.stop();
        }
    }

    public Iterable<Util.Triple<Regatta, RaceDefinition, String>> getWindTrackedRaces() {
        ArrayList<Util.Triple<Regatta, RaceDefinition, String>> result = new ArrayList<Util.Triple<Regatta, RaceDefinition, String>>();
        for (Regatta regatta : this.getAllRegattas()) {
            for (RaceDefinition race : regatta.getAllRaces()) {
                for (WindTrackerFactory windTrackerFactory : this.getWindTrackerFactories()) {
                    WindTracker windTracker = windTrackerFactory.getExistingWindTracker(race);
                    if (windTracker == null) continue;
                    result.add((Util.Triple<Regatta, RaceDefinition, String>)new Util.Triple((Object)regatta, (Object)race, (Object)windTracker.toString()));
                }
            }
        }
        return result;
    }

    public DynamicTrackedRace getTrackedRace(Regatta regatta, RaceDefinition race) {
        return this.getOrCreateTrackedRegatta(regatta).getExistingTrackedRace(race);
    }

    private DynamicTrackedRace getExistingTrackedRace(Regatta regatta, RaceDefinition race) {
        return this.getOrCreateTrackedRegatta(regatta).getExistingTrackedRace(race);
    }

    public DynamicTrackedRegatta getOrCreateTrackedRegatta(Regatta regatta) {
        this.cacheAndReplicateDefaultRegatta(regatta);
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattaTrackingCacheLock);
        try {
            DynamicTrackedRegatta result = this.regattaTrackingCache.get(regatta);
            if (result == null) {
                logger.info("Creating DynamicTrackedRegattaImpl for regatta " + regatta.getName() + " with hashCode " + regatta.hashCode());
                result = new DynamicTrackedRegattaImpl(regatta);
                this.replicate((OperationWithResult)new TrackRegatta(regatta.getRegattaIdentifier()));
                this.regattaTrackingCache.put(regatta, result);
                this.ensureRegattaHasRaceAdditionListener(result);
                this.trackedRegattaListener.regattaAdded((TrackedRegatta)result);
            }
            DynamicTrackedRegatta dynamicTrackedRegatta = result;
            return dynamicTrackedRegatta;
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattaTrackingCacheLock);
        }
    }

    public DynamicTrackedRegatta getTrackedRegatta(Regatta regatta) {
        return this.regattaTrackingCache.get(regatta);
    }

    public void removeTrackedRegatta(Regatta regatta) {
        DynamicTrackedRegatta trackedRegatta;
        logger.info("Removing regatta " + regatta.getName() + " from regattaTrackingCache");
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattaTrackingCacheLock);
        try {
            trackedRegatta = this.regattaTrackingCache.remove(regatta);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattaTrackingCacheLock);
        }
        this.stopObservingRegattaWithRaceAdditionListener(trackedRegatta);
        this.trackedRegattaListener.regattaRemoved((TrackedRegatta)trackedRegatta);
    }

    public Regatta getRegatta(RegattaName regattaName) {
        return this.regattasByName.get(regattaName.getRegattaName());
    }

    public Regatta getRegatta(RegattaIdentifier regattaIdentifier) {
        return (Regatta)regattaIdentifier.getRegatta((RegattaFetcher)this);
    }

    public DynamicTrackedRace getTrackedRace(RegattaAndRaceIdentifier raceIdentifier) {
        RaceDefinition race;
        DynamicTrackedRegatta trackedRegatta;
        DynamicTrackedRace result = null;
        Regatta regatta = this.regattasByName.get(raceIdentifier.getRegattaName());
        if (regatta != null && (trackedRegatta = this.regattaTrackingCache.get(regatta)) != null && (race = regatta.getRaceByName(raceIdentifier.getRaceName())) != null) {
            result = trackedRegatta.getExistingTrackedRace(race);
        }
        return result;
    }

    public DynamicTrackedRace getExistingTrackedRace(RegattaAndRaceIdentifier raceIdentifier) {
        Regatta regatta = this.getRegattaByName(raceIdentifier.getRegattaName());
        DynamicTrackedRace trackedRace = null;
        if (regatta != null) {
            RaceDefinition race = regatta.getRaceByName(raceIdentifier.getRaceName());
            trackedRace = this.getOrCreateTrackedRegatta(regatta).getExistingTrackedRace(race);
        }
        return trackedRace;
    }

    public RaceDefinition getRace(RegattaAndRaceIdentifier regattaNameAndRaceName) {
        RaceDefinition result = null;
        Regatta regatta = this.getRegatta((RegattaIdentifier)regattaNameAndRaceName);
        if (regatta != null) {
            result = regatta.getRaceByName(regattaNameAndRaceName.getRaceName());
        }
        return result;
    }

    public Map<UUID, LeaderboardGroup> getLeaderboardGroups() {
        return Collections.unmodifiableMap(new HashMap<UUID, LeaderboardGroup>(this.leaderboardGroupsByID));
    }

    public LeaderboardGroup getLeaderboardGroupByName(String groupName) {
        Set<LeaderboardGroup> leaderboardGroups = this.leaderboardGroupsByName.get(groupName);
        if (leaderboardGroups != null) {
            return leaderboardGroups.stream().findFirst().orElse(null);
        }
        return null;
    }

    public LeaderboardGroup getLeaderboardGroupByID(UUID leaderboardGroupID) {
        LeaderboardGroup result = leaderboardGroupID != null ? this.leaderboardGroupsByID.get(leaderboardGroupID) : null;
        return result;
    }

    public LeaderboardGroup resolveLeaderboardGroupByRegattaName(String regattaName) {
        for (LeaderboardGroup leaderboardGroup : this.getLeaderboardGroups().values()) {
            for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                if (!leaderboard.getName().equals(regattaName)) continue;
                return leaderboardGroup;
            }
        }
        return null;
    }

    public LeaderboardGroup addLeaderboardGroup(UUID leaderboardGroupId, String groupName, String description, String displayName, boolean displayGroupsInReverseOrder, List<String> leaderboardNames, int[] overallLeaderboardDiscardThresholds, ScoringSchemeType overallLeaderboardScoringSchemeType) {
        ArrayList<Leaderboard> leaderboards = new ArrayList<Leaderboard>();
        for (String leaderboardName : leaderboardNames) {
            Leaderboard leaderboard = this.leaderboardsByName.get(leaderboardName);
            if (leaderboard == null) {
                throw new IllegalArgumentException("No leaderboard with name " + leaderboardName + " found");
            }
            leaderboards.add(leaderboard);
        }
        LeaderboardGroupImpl result = new LeaderboardGroupImpl(leaderboardGroupId, groupName, description, displayName, displayGroupsInReverseOrder, leaderboards);
        if (overallLeaderboardScoringSchemeType != null) {
            this.addOverallLeaderboardToLeaderboardGroup((LeaderboardGroup)result, this.getBaseDomainFactory().createScoringScheme(overallLeaderboardScoringSchemeType), overallLeaderboardDiscardThresholds);
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
        try {
            if (this.leaderboardGroupsByName.containsKey(groupName)) {
                throw new IllegalArgumentException("Leaderboard group with name " + groupName + " already exists");
            }
            this.leaderboardGroupsByName.put(groupName, Collections.singleton(result));
            this.leaderboardGroupsByID.put(result.getId(), (LeaderboardGroup)result);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
        }
        this.mongoObjectFactory.storeLeaderboardGroup((LeaderboardGroup)result);
        return result;
    }

    public void addLeaderboardGroupWithoutReplication(LeaderboardGroup leaderboardGroup) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
        try {
            if (this.leaderboardGroupsByID.containsKey(leaderboardGroup.getId())) {
                throw new IllegalArgumentException("Leaderboard group with ID " + leaderboardGroup.getId() + " already exists");
            }
            this.leaderboardGroupsByName.put(leaderboardGroup.getName(), Collections.singleton(leaderboardGroup));
            this.leaderboardGroupsByID.put(leaderboardGroup.getId(), leaderboardGroup);
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
        }
        if (leaderboardGroup.hasOverallLeaderboard()) {
            this.addLeaderboard(leaderboardGroup.getOverallLeaderboard());
        }
        this.mongoObjectFactory.storeLeaderboardGroup(leaderboardGroup);
    }

    public void removeLeaderboardGroup(UUID leaderboardGroupId) {
        LeaderboardGroup leaderboardGroup = this.leaderboardGroupsByID.get(leaderboardGroupId);
        if (leaderboardGroup != null) {
            LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
            try {
                this.leaderboardGroupsByName.remove(leaderboardGroup.getName());
                for (Event event : this.eventsById.values()) {
                    if (!Util.contains((Iterable)event.getLeaderboardGroups(), (Object)leaderboardGroup)) continue;
                    new RemoveLeaderboardGroupFromEvent(event.getId(), new UUID[]{leaderboardGroup.getId()}).internalApplyTo((RacingEventService)this);
                }
                this.leaderboardGroupsByID.remove(leaderboardGroupId);
            }
            finally {
                LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
            }
        }
        this.mongoObjectFactory.removeLeaderboardGroup(leaderboardGroupId);
    }

    private void renameLeaderboardGroup(UUID leaderboardGroupId, String newName) {
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
        try {
            LeaderboardGroup toRename = this.leaderboardGroupsByID.get(leaderboardGroupId);
            if (toRename == null) {
                throw new IllegalArgumentException("No leaderboard group with ID " + leaderboardGroupId + " found");
            }
            if (this.leaderboardGroupsByName.containsKey(newName)) {
                throw new IllegalArgumentException("Leaderboard group with name " + newName + " already exists");
            }
            this.leaderboardGroupsByName.remove(toRename.getName());
            toRename.setName(newName);
            this.leaderboardGroupsByName.put(newName, Collections.singleton(toRename));
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
        }
        this.mongoObjectFactory.renameLeaderboardGroup(leaderboardGroupId, newName);
    }

    public void updateLeaderboardGroup(UUID leaderboardGroupId, String newName, String description, String displayName, List<String> leaderboardNames, int[] overallLeaderboardDiscardThresholds, ScoringSchemeType overallLeaderboardScoringSchemeType) {
        LeaderboardGroup group = this.getLeaderboardGroupByID(leaderboardGroupId);
        if (group == null) {
            throw new IllegalArgumentException("LeaderboardGroup with ID " + leaderboardGroupId + " not found");
        }
        if (!group.getName().equals(newName)) {
            this.renameLeaderboardGroup(leaderboardGroupId, newName);
        }
        if (!description.equals(group.getDescription())) {
            group.setDescriptiom(description);
        }
        if (!Util.equalsWithNull((Object)displayName, (Object)group.getDisplayName())) {
            group.setDisplayName(displayName);
        }
        group.clearLeaderboards();
        for (String leaderboardName : leaderboardNames) {
            Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
            if (leaderboard == null) continue;
            group.addLeaderboard(leaderboard);
        }
        Leaderboard overallLeaderboard = group.getOverallLeaderboard();
        if (overallLeaderboard != null) {
            if (overallLeaderboardScoringSchemeType == null) {
                group.setOverallLeaderboard(null);
                this.removeLeaderboard(overallLeaderboard.getName());
            } else {
                overallLeaderboard.setCrossLeaderboardResultDiscardingRule((ThresholdBasedResultDiscardingRule)new ThresholdBasedResultDiscardingRuleImpl(overallLeaderboardDiscardThresholds));
                this.updateStoredLeaderboard(overallLeaderboard);
            }
        } else if (overallLeaderboard == null && overallLeaderboardScoringSchemeType != null) {
            this.addOverallLeaderboardToLeaderboardGroup(group, this.getBaseDomainFactory().createScoringScheme(overallLeaderboardScoringSchemeType), overallLeaderboardDiscardThresholds);
        }
        this.updateStoredLeaderboardGroup(group);
    }

    private void addOverallLeaderboardToLeaderboardGroup(LeaderboardGroup leaderboardGroup, ScoringScheme scoringScheme, int[] discardThresholds) {
        LeaderboardGroupMetaLeaderboard overallLeaderboard = new LeaderboardGroupMetaLeaderboard(leaderboardGroup, scoringScheme, (ThresholdBasedResultDiscardingRule)new ThresholdBasedResultDiscardingRuleImpl(discardThresholds));
        leaderboardGroup.setOverallLeaderboard((Leaderboard)overallLeaderboard);
        this.addLeaderboard((Leaderboard)overallLeaderboard);
        this.updateStoredLeaderboard((Leaderboard)overallLeaderboard);
    }

    public void updateStoredLeaderboardGroup(LeaderboardGroup leaderboardGroup) {
        this.mongoObjectFactory.storeLeaderboardGroup(leaderboardGroup);
    }

    private ScheduledExecutorService getScheduler() {
        return scheduler;
    }

    public ObjectInputStream createObjectInputStreamResolvingAgainstCache(InputStream is, Map<String, Class<?>> classLoaderCache) throws IOException {
        return this.getBaseDomainFactory().createObjectInputStreamResolvingAgainstThisFactory(is, null, classLoaderCache);
    }

    public ClassLoader getDeserializationClassLoader() {
        return this.masterDataClassLoaders.getCombinedMasterDataClassLoader();
    }

    public void serializeForInitialReplicationInternal(ObjectOutputStream oos) throws IOException {
        StringBuffer logoutput = new StringBuffer();
        logger.info("Serializing regattas...");
        oos.writeObject(this.regattasByName);
        logoutput.append("Serialized " + this.regattasByName.size() + " regattas\n");
        for (Regatta regatta : this.regattasByName.values()) {
            logoutput.append(String.format("%3s\n", regatta.toString()));
        }
        logger.info("Serializing events...");
        oos.writeObject(this.eventsById);
        logoutput.append("\nSerialized " + this.eventsById.size() + " events\n");
        for (Event event : this.eventsById.values()) {
            logoutput.append(String.format("%3s\n", event.toString()));
        }
        logger.info("Serializing regattas observed...");
        oos.writeObject(this.regattasObservedWithRaceAdditionListener);
        logger.info("Serializing regatta tracking cache...");
        oos.writeObject(this.regattaTrackingCache);
        logger.info("Serializing leaderboard groups...");
        oos.writeObject(this.leaderboardGroupsByName);
        logoutput.append("Serialized " + this.leaderboardGroupsByName.size() + " leaderboard groups\n");
        this.leaderboardGroupsByName.values().forEach(leaderboardGroupsSet -> leaderboardGroupsSet.stream().findFirst().ifPresent(lg -> {
            StringBuffer stringBuffer2 = logoutput.append(String.format("%3s\n", lg.toString()));
        }));
        logger.info("Serializing leaderboards...");
        oos.writeObject(this.leaderboardsByName);
        logoutput.append("Serialized " + this.leaderboardsByName.size() + " leaderboards\n");
        for (Leaderboard leaderboard : this.leaderboardsByName.values()) {
            logoutput.append(String.format("%3s\n", leaderboard.toString()));
        }
        logger.info("Serializing media library...");
        this.mediaLibrary.serialize(oos);
        logoutput.append("Serialized " + this.mediaLibrary.allTracks().size() + " media tracks\n");
        for (MediaTrack mediaTrack : this.mediaLibrary.allTracks()) {
            logoutput.append(String.format("%3s\n", mediaTrack.toString()));
        }
        logger.info("Serializing persisted competitors...");
        oos.writeObject(this.competitorAndBoatStore);
        logoutput.append("Serialized " + this.competitorAndBoatStore.getCompetitorsCount() + " persisted competitors\n");
        logger.info("Serializing configuration map...");
        oos.writeObject(this.raceManagerDeviceConfigurationsById);
        logoutput.append("Serialized " + this.raceManagerDeviceConfigurationsById.size() + " device configuration entries\n");
        for (DeviceConfiguration deviceConfiguration : this.raceManagerDeviceConfigurationsById.values()) {
            logoutput.append(String.format("%3s\n", deviceConfiguration.getName()));
        }
        logger.info("Serializing anniversary races...");
        Map<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> map = this.anniversaryRaceDeterminator.getKnownAnniversaries();
        oos.writeObject(map);
        logoutput.append("Serialized " + map.size() + " anniversary races\n");
        logger.info("Serializing next anniversary...");
        Util.Pair<Integer, AnniversaryType> nextAnniversary = this.anniversaryRaceDeterminator.getNextAnniversary();
        oos.writeObject(nextAnniversary);
        logoutput.append("Serialized next anniversary " + nextAnniversary + "\n");
        logger.info("Serializing race count for anniversaries...");
        int currentRaceCount = this.anniversaryRaceDeterminator.getCurrentRaceCount();
        oos.writeInt(currentRaceCount);
        logoutput.append("Serialized race count for anniversaries " + currentRaceCount + "\n");
        logger.info("Serializing remote sailing server references...");
        ArrayList<RemoteSailingServerReference> remoteServerReferences = new ArrayList<RemoteSailingServerReference>(this.remoteSailingServerSet.getCachedEventsForRemoteSailingServers().keySet());
        oos.writeObject(remoteServerReferences);
        logoutput.append("Serialized " + remoteServerReferences.size() + " remote sailing server references\n");
        logger.info("Serializing server configuration (e.g., \"local server\" state)...");
        oos.writeObject(this.sailingServerConfiguration);
        logger.info(logoutput.toString());
    }

    public void initiallyFillFromInternal(ObjectInputStream ois) throws IOException, ClassNotFoundException, InterruptedException {
        logger.info("Performing initial replication load on " + this);
        StringBuffer logoutput = new StringBuffer();
        logger.info("Reading all regattas...");
        this.regattasByName.putAll((Map)ois.readObject());
        logoutput.append("Received " + this.regattasByName.size() + " NEW regattas\n");
        for (Regatta regatta : this.regattasByName.values()) {
            regatta.addRegattaListener((RegattaListener)this);
            logoutput.append(String.format("%3s\n", regatta.toString()));
        }
        logger.info("Reading all events...");
        this.eventsById.putAll((Map)ois.readObject());
        logoutput.append("\nReceived " + this.eventsById.size() + " NEW events\n");
        for (Event event : this.eventsById.values()) {
            logoutput.append(String.format("%3s\n", event.toString()));
        }
        logger.info("Reading all dynamic tracked regattas...");
        for (DynamicTrackedRegatta trackedRegattaToObserve : (Set)ois.readObject()) {
            this.ensureRegattaHasRaceAdditionListener(trackedRegattaToObserve);
        }
        logger.info("Reading all of the regatta tracking cache...");
        this.regattaTrackingCache.putAll((Map)ois.readObject());
        logoutput.append("Received " + this.regattaTrackingCache.size() + " NEW regatta tracking cache entries\n");
        logger.info("Reading leaderboard groups...");
        this.leaderboardGroupsByName.putAll((Map)ois.readObject());
        logoutput.append("Received " + this.leaderboardGroupsByName.size() + " NEW leaderboard groups\n");
        this.leaderboardGroupsByName.values().forEach(leaderboardGroupsSet -> leaderboardGroupsSet.stream().findFirst().ifPresent(lg -> {
            this.leaderboardGroupsByID.put(lg.getId(), (LeaderboardGroup)lg);
            logoutput.append(String.format("%3s\n", lg.toString()));
        }));
        logger.info("Reading leaderboards by name...");
        this.leaderboardsByName.putAll((Map)ois.readObject());
        for (Leaderboard leaderboard : this.leaderboardsByName.values()) {
            this.tryToRegisterMBeanForLeaderboard(leaderboard);
        }
        logoutput.append("Received " + this.leaderboardsByName.size() + " NEW leaderboards\n");
        for (Leaderboard leaderboard : this.leaderboardsByName.values()) {
            logoutput.append(String.format("%3s\n", leaderboard.toString()));
        }
        for (Leaderboard leaderboard : this.leaderboardsByName.values()) {
            if (leaderboard instanceof LeaderboardGroupMetaLeaderboard) {
                ((LeaderboardGroupMetaLeaderboard)leaderboard).registerAsScoreCorrectionChangeForwarderAndRaceColumnListenerOnAllLeaderboards();
                continue;
            }
            if (!(leaderboard instanceof FlexibleLeaderboard)) continue;
            leaderboard.addRaceColumnListener((RaceColumnListener)this.raceLogReplicator);
        }
        logger.info("Reading media library...");
        this.mediaLibrary.deserialize(ois);
        logoutput.append("Received " + this.mediaLibrary.allTracks().size() + " NEW media tracks\n");
        for (MediaTrack mediatrack : this.mediaLibrary.allTracks()) {
            logoutput.append(String.format("%3s\n", mediatrack.toString()));
        }
        logger.info("Reading competitors...");
        for (Competitor competitor : ((CompetitorAndBoatStore)ois.readObject()).getAllCompetitors()) {
            DynamicCompetitor dynamicCompetitor = (DynamicCompetitor)competitor;
            if (dynamicCompetitor.hasBoat()) {
                this.competitorAndBoatStore.getOrCreateCompetitorWithBoat(dynamicCompetitor.getId(), dynamicCompetitor.getName(), dynamicCompetitor.getShortName(), dynamicCompetitor.getColor(), dynamicCompetitor.getEmail(), dynamicCompetitor.getFlagImage(), dynamicCompetitor.getTeam(), dynamicCompetitor.getTimeOnTimeFactor(), dynamicCompetitor.getTimeOnDistanceAllowancePerNauticalMile(), dynamicCompetitor.getSearchTag(), ((DynamicCompetitorWithBoat)dynamicCompetitor).getBoat(), true);
                continue;
            }
            this.competitorAndBoatStore.getOrCreateCompetitor(dynamicCompetitor.getId(), dynamicCompetitor.getName(), dynamicCompetitor.getShortName(), dynamicCompetitor.getColor(), dynamicCompetitor.getEmail(), dynamicCompetitor.getFlagImage(), dynamicCompetitor.getTeam(), dynamicCompetitor.getTimeOnTimeFactor(), dynamicCompetitor.getTimeOnDistanceAllowancePerNauticalMile(), dynamicCompetitor.getSearchTag(), true);
        }
        logoutput.append("Received " + this.competitorAndBoatStore.getCompetitorsCount() + " NEW competitors\n");
        logger.info("Reading device configurations...");
        this.raceManagerDeviceConfigurationsById.putAll((Map)ois.readObject());
        logoutput.append("Received " + this.raceManagerDeviceConfigurationsById.size() + " NEW configuration entries\n");
        for (DeviceConfiguration config : this.raceManagerDeviceConfigurationsById.values()) {
            this.raceManagerDeviceConfigurationsByName.put(config.getName(), config);
            logoutput.append(String.format("%3s\n", config.getName()));
        }
        logger.info("Reading anniversary races...");
        Map knownAnniversaries = (Map)ois.readObject();
        this.anniversaryRaceDeterminator.setKnownAnniversaries(knownAnniversaries);
        logoutput.append("Received " + knownAnniversaries.size() + " anniversary races\n");
        logger.info("Reading next anniversary...");
        Util.Pair nextAnniversary = (Util.Pair)ois.readObject();
        this.anniversaryRaceDeterminator.setNextAnniversary((Util.Pair<Integer, AnniversaryType>)nextAnniversary);
        logoutput.append("Received next anniversary " + nextAnniversary + "\n");
        logger.info("Reading race count for anniversaries...");
        int currentRaceCount = ois.readInt();
        this.anniversaryRaceDeterminator.setRaceCount(currentRaceCount);
        logoutput.append("Received race count for anniversaries " + currentRaceCount + "\n");
        logger.info("Reading remote sailing server references...");
        for (RemoteSailingServerReference remoteSailingServerReference : (Iterable)ois.readObject()) {
            this.remoteSailingServerSet.add(remoteSailingServerReference);
            logoutput.append("Received remote sailing server reference " + remoteSailingServerReference);
        }
        logger.info("Reading sailing server configuration (e.g., \"local server\" state)...");
        this.sailingServerConfiguration = (SailingServerConfiguration)ois.readObject();
        for (Regatta regatta : this.regattasByName.values()) {
            RegattaImpl regattaImpl = (RegattaImpl)regatta;
            regattaImpl.initializeSeriesAfterDeserialize();
            regattaImpl.addRaceColumnListener((RaceColumnListener)this.raceLogReplicator);
        }
        for (DynamicTrackedRegatta trackedRegatta : this.regattaTrackingCache.values()) {
            trackedRegatta.lockTrackedRacesForRead();
            try {
                for (TrackedRace trackedRace : trackedRegatta.getTrackedRaces()) {
                    ((TrackedRaceImpl)trackedRace).setRaceLogResolver((RaceLogAndTrackedRaceResolver)this);
                    ((TrackedRaceImpl)trackedRace).registerRegattaListener();
                    trackedRace.initializeAfterDeserialization();
                }
            }
            finally {
                trackedRegatta.unlockTrackedRacesAfterRead();
            }
        }
        this.regattaTrackingCache.values().forEach(arg_0 -> ((TrackedRegattaListenerManager)this.trackedRegattaListener).regattaAdded(arg_0));
        logger.info(logoutput.toString());
    }

    public void clearReplicaState() throws MalformedURLException, IOException, InterruptedException {
        logger.info("Clearing all data structures...");
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
        try {
            this.regattasByName.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattasByNameLock);
        }
        this.regattasObservedWithRaceAdditionListener.clear();
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
        try {
            if (this.raceTrackersByRegatta != null && !this.raceTrackersByRegatta.isEmpty()) {
                for (DynamicTrackedRegatta regatta : this.regattaTrackingCache.values()) {
                    Set<RaceTracker> trackers = this.raceTrackersByRegatta.get(regatta.getRegatta());
                    if (trackers == null) continue;
                    for (RaceTracker tracker : trackers) {
                        tracker.stop(true);
                    }
                }
            }
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.regattaTrackingCacheLock);
        try {
            this.regattaTrackingCache.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.regattaTrackingCacheLock);
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
        try {
            this.raceTrackersByRegatta.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
        try {
            this.leaderboardGroupsByName.clear();
            this.leaderboardGroupsByID.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardGroupsByNameLock);
        }
        LockUtil.lockForWrite((NamedReentrantReadWriteLock)this.leaderboardsByNameLock);
        try {
            for (Leaderboard leaderboardToClear : this.leaderboardsByName.values()) {
                this.removeMBeanForLeaderboard(leaderboardToClear);
            }
            this.leaderboardsByName.clear();
            this.scoreCorrectionListenersByLeaderboard.clear();
        }
        finally {
            LockUtil.unlockAfterWrite((NamedReentrantReadWriteLock)this.leaderboardsByNameLock);
        }
        this.connectivityParametersByRace.clear();
        this.eventsById.clear();
        this.mediaLibrary.clear();
        this.raceManagerDeviceConfigurationsById.clear();
        this.raceManagerDeviceConfigurationsByName.clear();
        this.competitorAndBoatStore.clearCompetitors();
        this.remoteSailingServerSet.clear();
        if (this.notificationService != null) {
            this.notificationService.stop();
            this.notificationService = new EmptySailingNotificationService();
        }
        this.anniversaryRaceDeterminator.clearAndStop();
        this.remoteSailingServerSet.setRetrieveRemoteRaceResult(false);
        this.trackedRegattaListener.removeListener((TrackedRegattaListener)this.raceChangeObserverForAnniversaryDetection);
        this.raceChangeObserverForAnniversaryDetection.stop();
    }

    public Event addEvent(String eventName, String eventDescription, TimePoint startDate, TimePoint endDate, String venue, boolean isPublic, UUID id) {
        Event result = this.createEventWithoutReplication(eventName, eventDescription, startDate, endDate, venue, isPublic, id, null, null, null, Collections.emptyList(), Collections.emptyList());
        this.replicate((OperationWithResult)new CreateEvent(eventName, eventDescription, startDate, endDate, venue, isPublic, id, null, null, null, Collections.emptyList(), Collections.emptyList(), Collections.emptyList()));
        return result;
    }

    public void addEventWithoutReplication(Event event) {
        this.addEvent(event);
    }

    public Event createEventWithoutReplication(String eventName, String eventDescription, TimePoint startDate, TimePoint endDate, String venue, boolean isPublic, UUID id, URL officialWebsiteURL, URL baseURL, Map<Locale, URL> sailorsInfoWebsiteURLs, Iterable<ImageDescriptor> images, Iterable<VideoDescriptor> videos) {
        EventImpl result = new EventImpl(eventName, startDate, endDate, venue, isPublic, id);
        this.addEvent((Event)result);
        result.setDescription(eventDescription);
        result.setOfficialWebsiteURL(officialWebsiteURL);
        result.setBaseURL(baseURL);
        result.setSailorsInfoWebsiteURLs(sailorsInfoWebsiteURLs);
        result.setImages(images);
        result.setVideos(videos);
        return result;
    }

    private void addEvent(Event result) {
        if (this.eventsById.containsKey(result.getId())) {
            throw new IllegalArgumentException("Event with ID " + result.getId() + " already exists which is pretty surprising...");
        }
        this.eventsById.put(result.getId(), result);
        this.mongoObjectFactory.storeEvent(result);
    }

    public void updateEvent(UUID id, String eventName, String eventDescription, TimePoint startDate, TimePoint endDate, String venueName, boolean isPublic, Iterable<UUID> leaderboardGroupIds, URL officialWebsiteURL, URL baseURL, Map<Locale, URL> sailorsInfoWebsiteURLs, Iterable<ImageDescriptor> images, Iterable<VideoDescriptor> videos, Iterable<String> windFinderReviewedSpotCollectionIds) {
        Event event = this.eventsById.get(id);
        if (event == null) {
            throw new IllegalArgumentException("Sailing event with ID " + id + " does not exist.");
        }
        event.setName(eventName);
        event.setDescription(eventDescription);
        event.setStartAndEndDate(startDate, endDate);
        event.setPublic(isPublic);
        event.getVenue().setName(venueName);
        ArrayList<LeaderboardGroup> leaderboardGroups = new ArrayList<LeaderboardGroup>();
        for (UUID lgid : leaderboardGroupIds) {
            LeaderboardGroup lg = this.getLeaderboardGroupByID(lgid);
            if (lg != null) {
                leaderboardGroups.add(lg);
                continue;
            }
            logger.info("Couldn't find leaderboard group with ID " + lgid + " while updating event " + event.getName());
        }
        event.setLeaderboardGroups(leaderboardGroups);
        event.setOfficialWebsiteURL(officialWebsiteURL);
        event.setBaseURL(baseURL);
        event.setSailorsInfoWebsiteURLs(sailorsInfoWebsiteURLs);
        event.setImages(images);
        event.setVideos(videos);
        event.setWindFinderReviewedSpotsCollection(windFinderReviewedSpotCollectionIds);
        this.mongoObjectFactory.storeEvent(event);
    }

    public void renameEvent(UUID id, String newName) {
        Event toRename = this.eventsById.get(id);
        if (toRename == null) {
            throw new IllegalArgumentException("No sailing event with ID " + id + " found.");
        }
        toRename.setName(newName);
        this.mongoObjectFactory.renameEvent((Serializable)id, newName);
        this.replicate((OperationWithResult)new RenameEvent(id, newName));
    }

    public void removeEvent(UUID id) {
        this.removeEventFromEventsById(id);
        this.mongoObjectFactory.removeEvent((Serializable)id);
    }

    protected void removeEventFromEventsById(Serializable id) {
        this.eventsById.remove(id);
    }

    public Regatta getRememberedRegattaForRace(Serializable raceID) {
        return this.persistentRegattasForRaceIDs.get(raceID.toString());
    }

    private void setRegattaForRace(Regatta regatta, RaceDefinition race) {
        this.setRegattaForRace(regatta, race.getId().toString());
    }

    public void setRegattaForRace(Regatta regatta, String raceIdAsString) {
        Regatta oldRegatta = this.persistentRegattasForRaceIDs.put(raceIdAsString, regatta);
        if (oldRegatta != regatta) {
            this.mongoObjectFactory.storeRegattaForRaceID(raceIdAsString, regatta);
        }
    }

    public CourseArea[] addCourseAreas(UUID eventId, String[] courseAreaNames, UUID[] courseAreaIds, Position[] centerPositions, Distance[] radiuses) {
        CourseArea[] courseAreas = this.addCourseAreasWithoutReplication(eventId, courseAreaIds, courseAreaNames, centerPositions, radiuses);
        this.replicate((OperationWithResult)new AddCourseAreas(eventId, courseAreaNames, courseAreaIds, centerPositions, radiuses));
        return courseAreas;
    }

    public CourseArea[] addCourseAreasWithoutReplication(UUID eventId, UUID[] courseAreaIds, String[] courseAreaNames, Position[] centerPositions, Distance[] radiuses) {
        CourseArea[] result = new CourseArea[courseAreaNames.length];
        int i = 0;
        while (i < courseAreaIds.length) {
            CourseArea courseArea = this.getBaseDomainFactory().getOrCreateCourseArea(courseAreaIds[i], courseAreaNames[i], centerPositions[i], radiuses[i]);
            Event event = this.eventsById.get(eventId);
            if (event == null) {
                throw new IllegalArgumentException("No sailing event with ID " + eventId + " found.");
            }
            event.getVenue().addCourseArea(courseArea);
            this.mongoObjectFactory.storeEvent(event);
            result[i] = courseArea;
            ++i;
        }
        return result;
    }

    public CourseArea[] removeCourseAreaWithoutReplication(UUID eventId, UUID[] courseAreaIds) {
        Event event = this.eventsById.get(eventId);
        if (event == null) {
            throw new IllegalArgumentException("No sailing event with ID " + eventId + " found.");
        }
        CourseArea[] courseAreasRemoved = new CourseArea[courseAreaIds.length];
        int i = 0;
        UUID[] uUIDArray = courseAreaIds;
        int n = courseAreaIds.length;
        int n2 = 0;
        while (n2 < n) {
            UUID courseAreaId = uUIDArray[n2];
            CourseArea courseArea = this.getBaseDomainFactory().getExistingCourseAreaById((Serializable)courseAreaId);
            if (courseArea == null) {
                throw new IllegalArgumentException("No course area with ID " + courseAreaId + " found.");
            }
            courseAreasRemoved[i++] = courseArea;
            event.getVenue().removeCourseArea(courseArea);
            this.mongoObjectFactory.storeEvent(event);
            ++n2;
        }
        return courseAreasRemoved;
    }

    public void mediaTrackAdded(MediaTrack mediaTrack) {
        if (mediaTrack.dbId == null) {
            mediaTrack.dbId = this.mediaDB.insertMediaTrack(mediaTrack.title, mediaTrack.url, mediaTrack.startTime, mediaTrack.duration, mediaTrack.mimeType, mediaTrack.assignedRaces);
        }
        this.mediaLibrary.addMediaTrack(mediaTrack);
        this.replicate((OperationWithResult)new AddMediaTrackOperation(mediaTrack));
    }

    public void mediaTracksAdded(Iterable<MediaTrack> mediaTracks) {
        this.mediaLibrary.addMediaTracks(mediaTracks);
    }

    public void mediaTrackTitleChanged(MediaTrack mediaTrack) {
        this.mediaDB.updateTitle(mediaTrack.dbId, mediaTrack.title);
        this.mediaLibrary.titleChanged(mediaTrack);
        this.replicate((OperationWithResult)new UpdateMediaTrackTitleOperation(mediaTrack));
    }

    public void mediaTrackUrlChanged(MediaTrack mediaTrack) {
        this.mediaDB.updateUrl(mediaTrack.dbId, mediaTrack.url);
        this.mediaLibrary.urlChanged(mediaTrack);
        this.replicate((OperationWithResult)new UpdateMediaTrackUrlOperation(mediaTrack));
    }

    public void mediaTrackStartTimeChanged(MediaTrack mediaTrack) {
        this.mediaDB.updateStartTime(mediaTrack.dbId, mediaTrack.startTime);
        this.mediaLibrary.startTimeChanged(mediaTrack);
        this.replicate((OperationWithResult)new UpdateMediaTrackStartTimeOperation(mediaTrack));
    }

    public void mediaTrackDurationChanged(MediaTrack mediaTrack) {
        this.mediaDB.updateDuration(mediaTrack.dbId, mediaTrack.duration);
        this.mediaLibrary.durationChanged(mediaTrack);
        this.replicate((OperationWithResult)new UpdateMediaTrackDurationOperation(mediaTrack));
    }

    public void mediaTrackAssignedRacesChanged(MediaTrack mediaTrack) {
        this.mediaDB.updateRace(mediaTrack.dbId, mediaTrack.assignedRaces);
        this.mediaLibrary.assignedRacesChanged(mediaTrack);
        this.replicate((OperationWithResult)new UpdateMediaTrackRacesOperation(mediaTrack));
    }

    public void mediaTrackDeleted(MediaTrack mediaTrack) {
        this.mediaDB.deleteMediaTrack(mediaTrack.dbId);
        this.mediaLibrary.deleteMediaTrack(mediaTrack);
        this.replicate((OperationWithResult)new RemoveMediaTrackOperation(mediaTrack));
    }

    public void mediaTracksImported(Iterable<MediaTrack> mediaTracksToImport, MasterDataImportObjectCreationCountImpl creationCount, boolean override) throws Exception {
        Exception firstException = null;
        for (MediaTrack trackToImport : mediaTracksToImport) {
            try {
                MediaTrack existingTrack = this.mediaLibrary.lookupMediaTrack(trackToImport);
                if (existingTrack == null) {
                    this.mediaDB.insertMediaTrackWithId(trackToImport.dbId, trackToImport.title, trackToImport.url, trackToImport.startTime, trackToImport.duration, trackToImport.mimeType, trackToImport.assignedRaces);
                    this.mediaTrackAdded(trackToImport);
                } else if (override) {
                    if (!Util.equalsWithNull((Object)existingTrack.title, (Object)trackToImport.title)) {
                        this.mediaTrackTitleChanged(trackToImport);
                    }
                    if (!Util.equalsWithNull((Object)existingTrack.url, (Object)trackToImport.url)) {
                        this.mediaTrackUrlChanged(trackToImport);
                    }
                    if (!Util.equalsWithNull((Object)existingTrack.startTime, (Object)trackToImport.startTime)) {
                        this.mediaTrackStartTimeChanged(trackToImport);
                    }
                    if (!Util.equalsWithNull((Object)existingTrack.duration, (Object)trackToImport.duration)) {
                        this.mediaTrackDurationChanged(trackToImport);
                    }
                    if (!Util.equalsWithNull((Object)existingTrack.assignedRaces, (Object)trackToImport.assignedRaces)) {
                        this.mediaTrackAssignedRacesChanged(trackToImport);
                    }
                }
                creationCount.addOneMediaTrack();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Problem importing media track " + trackToImport + "; continuing with other media tracks.", e);
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public Iterable<MediaTrack> getMediaTracksForRace(RegattaAndRaceIdentifier regattaAndRaceIdentifier) {
        return this.mediaLibrary.findMediaTracksForRace(regattaAndRaceIdentifier);
    }

    public Iterable<MediaTrack> getMediaTracksInTimeRange(RegattaAndRaceIdentifier regattaAndRaceIdentifier) {
        DynamicTrackedRace trackedRace = this.getExistingTrackedRace(regattaAndRaceIdentifier);
        if (trackedRace != null) {
            if (trackedRace.isLive(MillisecondsTimePoint.now())) {
                return this.mediaLibrary.findLiveMediaTracks();
            }
            TimePoint raceStart = trackedRace.getStartOfRace() == null ? trackedRace.getStartOfTracking() : trackedRace.getStartOfRace();
            TimePoint raceEnd = trackedRace.getEndOfRace() == null ? trackedRace.getEndOfTracking() : trackedRace.getEndOfRace();
            return this.mediaLibrary.findMediaTracksInTimeRange(raceStart, raceEnd);
        }
        return Collections.emptyList();
    }

    public Iterable<MediaTrack> getAllMediaTracks() {
        return this.mediaLibrary.allTracks();
    }

    public Iterable<URL> getResultImportUrls(String resultProviderName) throws UnauthorizedException {
        Optional<ResultUrlProvider> resultUrlProvider = this.getUrlBasedScoreCorrectionProvider(resultProviderName);
        Optional<ResultUrlRegistry> resultUrlRegistry = this.getResultUrlRegistry();
        if (resultUrlProvider.isPresent() && resultUrlRegistry.isPresent()) {
            return resultUrlRegistry.get().getReadableResultUrls(resultUrlProvider.get().getName());
        }
        return null;
    }

    public void removeResultImportURLs(String resultProviderName, Set<URL> toRemove) throws UnauthorizedException, Exception {
        this.getUrlBasedScoreCorrectionProvider(resultProviderName).ifPresent(resultUrlProvider -> this.getResultUrlRegistry().ifPresent(resultUrlRegistry -> {
            for (URL urlToRemove : toRemove) {
                this.getSecurityService().checkPermissionAndDeleteOwnershipForObjectRemoval(SecuredDomainType.RESULT_IMPORT_URL.getQualifiedObjectIdentifier(new TypeRelativeObjectIdentifier(new String[]{resultUrlProvider.getName(), urlToRemove.toString()})), () -> resultUrlRegistry.unregisterResultUrl(resultProviderName, urlToRemove));
            }
        }));
    }

    public void addResultImportUrl(String resultProviderName, URL url) throws UnauthorizedException, Exception {
        this.getUrlBasedScoreCorrectionProvider(resultProviderName).ifPresent(resultUrlProvider -> this.getResultUrlRegistry().ifPresent(resultUrlRegistry -> this.getSecurityService().setOwnershipCheckPermissionForObjectCreationAndRevertOnError(SecuredDomainType.RESULT_IMPORT_URL, new TypeRelativeObjectIdentifier(new String[]{resultUrlProvider.getName(), url.toString()}), url.toString(), () -> resultUrlRegistry.registerResultUrl(resultProviderName, url))));
    }

    private Optional<ResultUrlRegistry> getResultUrlRegistry() {
        if (this.resultUrlRegistryServiceTracker == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((ResultUrlRegistry)this.resultUrlRegistryServiceTracker.getService());
    }

    public Optional<ResultUrlProvider> getUrlBasedScoreCorrectionProvider(String resultProviderName) {
        for (ResultUrlProvider resultUrlProvider : this.getAllUrlBasedScoreCorrectionProviders()) {
            if (!resultUrlProvider.getName().equals(resultProviderName)) continue;
            return Optional.of(resultUrlProvider);
        }
        return Optional.empty();
    }

    private Iterable<ResultUrlProvider> getAllUrlBasedScoreCorrectionProviders() {
        HashSet<ResultUrlProvider> result = new HashSet<ResultUrlProvider>();
        for (ScoreCorrectionProvider scp : this.getAllScoreCorrectionProviders()) {
            if (!(scp instanceof ResultUrlProvider)) continue;
            result.add((ResultUrlProvider)scp);
        }
        for (CompetitorProvider cp : this.getAllCompetitorProviders()) {
            if (!(cp instanceof ResultUrlProvider)) continue;
            result.add((ResultUrlProvider)cp);
        }
        return result;
    }

    public Iterable<CompetitorProvider> getAllCompetitorProviders() {
        CompetitorProvider[] services = (CompetitorProvider[])this.competitorProviderServiceTracker.getServices((Object[])new CompetitorProvider[0]);
        ArrayList<CompetitorProvider> result = new ArrayList<CompetitorProvider>();
        if (services != null) {
            CompetitorProvider[] competitorProviderArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                CompetitorProvider service = competitorProviderArray[n2];
                result.add(service);
                ++n2;
            }
        }
        return result;
    }

    private Iterable<ScoreCorrectionProvider> getAllScoreCorrectionProviders() {
        ScoreCorrectionProvider[] services = (ScoreCorrectionProvider[])this.scoreCorrectionProviderServiceTracker.getServices((Object[])new ScoreCorrectionProvider[0]);
        ArrayList<ScoreCorrectionProvider> result = new ArrayList<ScoreCorrectionProvider>();
        if (services != null) {
            ScoreCorrectionProvider[] scoreCorrectionProviderArray = services;
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                ScoreCorrectionProvider service = scoreCorrectionProviderArray[n2];
                result.add(service);
                ++n2;
            }
        }
        return result;
    }

    public String toString() {
        return "RacingEventService: " + this.hashCode() + " Build: " + ServerInfo.getBuildVersion();
    }

    public void reloadRaceLog(String leaderboardName, String raceColumnName, String fleetName) {
        Fleet fleetImpl;
        RaceLog racelog;
        RaceColumn raceColumn;
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard != null && (raceColumn = leaderboard.getRaceColumnByName(raceColumnName)) != null && (racelog = raceColumn.getRaceLog(fleetImpl = raceColumn.getFleetByName(fleetName))) != null) {
            raceColumn.reloadRaceLog(fleetImpl);
            logger.info("Reloaded race log for fleet " + fleetImpl + " for race column " + raceColumn.getName() + " for leaderboard " + leaderboard.getName());
        }
    }

    public ConcurrentHashMap<String, Regatta> getPersistentRegattasForRaceIDs() {
        return this.persistentRegattasForRaceIDs;
    }

    public WindStore getWindStore() {
        return this.windStore;
    }

    public DeviceConfiguration getDeviceConfigurationById(UUID id) {
        return this.raceManagerDeviceConfigurationsById.get(id);
    }

    public DeviceConfiguration getDeviceConfigurationByName(String deviceConfigurationName) {
        return this.raceManagerDeviceConfigurationsByName.get(deviceConfigurationName);
    }

    public void createOrUpdateDeviceConfiguration(DeviceConfiguration configuration) {
        this.raceManagerDeviceConfigurationsById.put(configuration.getId(), configuration);
        this.raceManagerDeviceConfigurationsByName.put(configuration.getName(), configuration);
        this.mongoObjectFactory.storeDeviceConfiguration(configuration);
        this.replicate((OperationWithResult)new CreateOrUpdateDeviceConfiguration(configuration));
    }

    public void removeDeviceConfiguration(UUID id) {
        DeviceConfiguration removedConfig = this.raceManagerDeviceConfigurationsById.remove(id);
        if (removedConfig != null) {
            this.raceManagerDeviceConfigurationsByName.remove(removedConfig.getName());
        }
        this.mongoObjectFactory.removeDeviceConfiguration(id);
        this.replicate((OperationWithResult)new RemoveDeviceConfiguration(id));
    }

    public Iterable<DeviceConfiguration> getAllDeviceConfigurations() {
        return this.raceManagerDeviceConfigurationsById.values();
    }

    public TimePoint setStartTimeAndProcedure(String leaderboardName, String raceColumnName, String fleetName, String authorName, int authorPriority, int passId, TimePoint logicalTimePoint, TimePoint startTime, RacingProcedureType racingProcedure, UUID courseAreaId) {
        TimePoint result;
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard instanceof HasRegattaLike && raceLog != null) {
            RaceState state = RaceStateImpl.create((RaceLogResolver)this, (RaceLog)raceLog, (AbstractLogEventAuthor)new LogEventAuthorImpl(authorName, authorPriority));
            if (passId > raceLog.getCurrentPassId()) {
                state.setAdvancePass(logicalTimePoint);
            }
            state.setRacingProcedure(logicalTimePoint, racingProcedure);
            state.forceNewStartTime(logicalTimePoint, startTime, courseAreaId);
            result = state.getStartTime();
        } else {
            result = null;
        }
        return result;
    }

    public TimePoint setEndTime(String leaderboardName, String raceColumnName, String fleetName, String authorName, int authorPriority, int passId, TimePoint logicalTimePoint) {
        TimePoint result;
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard instanceof HasRegattaLike && raceLog != null) {
            LogEventAuthorImpl author = new LogEventAuthorImpl(authorName, authorPriority);
            raceLog.add((AbstractLogEvent)new RaceLogRaceStatusEventImpl(logicalTimePoint, (AbstractLogEventAuthor)author, raceLog.getCurrentPassId(), RaceLogRaceStatus.FINISHED));
            result = (TimePoint)new FinishedTimeFinder(raceLog).analyze();
        } else {
            result = null;
        }
        return result;
    }

    public TimePoint setFinishingTime(String leaderboardName, String raceColumnName, String fleetName, String authorName, Integer authorPriority, int passId, MillisecondsTimePoint logicalTimePoint) {
        TimePoint result;
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard instanceof HasRegattaLike && raceLog != null) {
            LogEventAuthorImpl author = new LogEventAuthorImpl(authorName, authorPriority.intValue());
            raceLog.add((AbstractLogEvent)new RaceLogRaceStatusEventImpl((TimePoint)logicalTimePoint, (AbstractLogEventAuthor)author, raceLog.getCurrentPassId(), RaceLogRaceStatus.FINISHING));
            result = (TimePoint)new FinishingTimeFinder(raceLog).analyze();
        } else {
            result = null;
        }
        return result;
    }

    public RaceLog getRaceLog(String leaderboardName, String raceColumnName, String fleetName) {
        RaceColumn raceColumn;
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard != null && (raceColumn = leaderboard.getRaceColumnByName(raceColumnName)) != null) {
            Fleet fleetImpl = raceColumn.getFleetByName(fleetName);
            return raceColumn.getRaceLog(fleetImpl);
        }
        return null;
    }

    public Map<Competitor, Boat> getCompetitorToBoatMappingsForRace(String leaderboardName, String raceColumnName, String fleetName) {
        HashMap<Competitor, Boat> result = new HashMap<Competitor, Boat>();
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard != null) {
            RaceColumn raceColumn = leaderboard.getRaceColumnByName(raceColumnName);
            Fleet fleet = leaderboard.getFleet(fleetName);
            if (raceColumn != null && fleet != null) {
                TrackedRace trackedRace;
                RaceLog raceLog = raceColumn.getRaceLog(fleet);
                if (raceLog != null) {
                    Map competitorAndBoatsInRacelog = (Map)new CompetitorsAndBoatsInLogAnalyzer((AbstractLog)raceLog).analyze();
                    result.putAll(competitorAndBoatsInRacelog);
                }
                if ((trackedRace = raceColumn.getTrackedRace(fleet)) != null) {
                    Map competitorsAndBoatsFromRaceDef = trackedRace.getRace().getCompetitorsAndTheirBoats();
                    for (Competitor competitor : competitorsAndBoatsFromRaceDef.keySet()) {
                        if (result.containsKey(competitor)) continue;
                        result.put(competitor, (Boat)competitorsAndBoatsFromRaceDef.get(competitor));
                    }
                }
            }
        }
        return result;
    }

    public Util.Triple<TimePoint, Integer, RacingProcedureType> getStartTimeAndProcedure(String leaderboardName, String raceColumnName, String fleetName) {
        Util.Triple result;
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard instanceof HasRegattaLike && raceLog != null) {
            ReadonlyRaceState state = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this, (RaceLog)raceLog);
            result = new Util.Triple((Object)state.getStartTime(), (Object)raceLog.getCurrentPassId(), (Object)state.getRacingProcedure().getType());
        } else {
            result = null;
        }
        return result;
    }

    public Util.Triple<TimePoint, TimePoint, Integer> getFinishingAndFinishTime(String leaderboardName, String raceColumnName, String fleetName) {
        Util.Triple result;
        RaceLog raceLog = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        if (leaderboard instanceof HasRegattaLike && raceLog != null) {
            ReadonlyRaceState state = ReadonlyRaceStateImpl.getOrCreate((RaceLogResolver)this, (RaceLog)raceLog);
            result = new Util.Triple((Object)state.getFinishingTime(), (Object)state.getFinishedTime(), (Object)raceLog.getCurrentPassId());
        } else {
            result = null;
        }
        return result;
    }

    private Iterable<WindTrackerFactory> getWindTrackerFactories() {
        Set<ExpeditionTrackerFactory> result;
        if (this.bundleContext == null) {
            result = Collections.singleton(ExpeditionTrackerFactory.getInstance());
        } else {
            ServiceTracker tracker = new ServiceTracker(this.bundleContext, WindTrackerFactory.class, null);
            tracker.open();
            result = new HashSet<ExpeditionTrackerFactory>();
            WindTrackerFactory[] windTrackerFactoryArray = (WindTrackerFactory[])tracker.getServices((Object[])new WindTrackerFactory[0]);
            int n = windTrackerFactoryArray.length;
            int n2 = 0;
            while (n2 < n) {
                WindTrackerFactory factory = windTrackerFactoryArray[n2];
                result.add((ExpeditionTrackerFactory)factory);
                ++n2;
            }
            tracker.close();
        }
        return result;
    }

    public void addOrReplaceExpeditionDeviceConfiguration(UUID deviceConfigurationId, String name, Integer expeditionBoatId) {
        ServiceTracker tracker = new ServiceTracker(this.bundleContext, ExpeditionTrackerFactory.class, null);
        tracker.open();
        ExpeditionTrackerFactory expeditionTrackerFactory = (ExpeditionTrackerFactory)tracker.getService();
        if (expeditionTrackerFactory != null) {
            expeditionTrackerFactory.addOrReplaceDeviceConfiguration(new ExpeditionDeviceConfiguration(name, deviceConfigurationId, expeditionBoatId));
        } else {
            logger.severe("Addition or update of Expedition device configuration " + deviceConfigurationId + " was requested, " + "but no Expedition connector was found. Request not fulfilled.");
        }
        tracker.close();
    }

    public void removeExpeditionDeviceConfiguration(UUID deviceUuid) {
        ServiceTracker tracker = new ServiceTracker(this.bundleContext, ExpeditionTrackerFactory.class, null);
        tracker.open();
        ExpeditionTrackerFactory expeditionTrackerFactory = (ExpeditionTrackerFactory)tracker.getService();
        if (expeditionTrackerFactory != null) {
            expeditionTrackerFactory.removeDeviceConfiguration(deviceUuid);
        } else {
            logger.severe("Addition or update of Expedition device configuration " + deviceUuid + " was requested, " + "but no Expedition connector was found. Request not fulfilled.");
        }
        tracker.close();
    }

    public SensorFixStore getSensorFixStore() {
        return this.sensorFixStore;
    }

    public RaceTracker getRaceTrackerById(Object id) {
        return this.raceTrackersByID.get(id);
    }

    public AbstractLogEventAuthor getServerAuthor() {
        Subject subject = null;
        try {
            subject = SecurityUtils.getSubject();
        }
        catch (Exception e) {
            logger.info("Couldn't access security manager's subject; using default server author: " + e.getMessage());
        }
        Object result = subject != null && subject.getPrincipal() != null ? new LogEventAuthorImpl(subject.getPrincipal().toString(), 0) : this.raceLogEventAuthorForServer;
        return result;
    }

    public CompetitorAndBoatStore getCompetitorAndBoatStore() {
        return this.competitorAndBoatStore;
    }

    public TypeBasedServiceFinderFactory getTypeBasedServiceFinderFactory() {
        return this.serviceFinderFactory;
    }

    public DataImportLockWithProgress getDataImportLock() {
        return this.dataImportLock;
    }

    public DataImportProgress createOrUpdateDataImportProgressWithReplication(UUID importOperationId, double overallProgressPct, DataImportSubProgress subProgress, double subProgressPct) {
        DataImportProgress progress = this.createOrUpdateDataImportProgressWithoutReplication(importOperationId, overallProgressPct, subProgress, subProgressPct);
        this.replicate((OperationWithResult)new CreateOrUpdateDataImportProgress(importOperationId, overallProgressPct, subProgress, subProgressPct));
        return progress;
    }

    public DataImportProgress createOrUpdateDataImportProgressWithoutReplication(UUID importOperationId, double overallProgressPct, DataImportSubProgress subProgress, double subProgressPct) {
        DataImportProgress progress = this.dataImportLock.getProgress(importOperationId);
        boolean newObject = false;
        if (progress == null) {
            progress = new DataImportProgressImpl(importOperationId);
            newObject = true;
        }
        progress.setOverAllProgressPct(overallProgressPct);
        progress.setCurrentSubProgress(subProgress);
        progress.setCurrentSubProgressPct(subProgressPct);
        if (newObject) {
            this.dataImportLock.addProgress(importOperationId, progress);
        }
        return progress;
    }

    public void setDataImportFailedWithoutReplication(UUID importOperationId, String errorMessage) {
        DataImportProgress progress = this.dataImportLock.getProgress(importOperationId);
        if (progress != null) {
            progress.setFailed();
            progress.setErrorMessage(errorMessage);
        }
    }

    public void setDataImportFailedWithReplication(UUID importOperationId, String errorMessage) {
        this.setDataImportFailedWithoutReplication(importOperationId, errorMessage);
        this.replicate((OperationWithResult)new DataImportFailed(importOperationId, errorMessage));
    }

    public void setDataImportDeleteProgressFromMapTimerWithReplication(UUID importOperationId) {
        this.setDataImportDeleteProgressFromMapTimerWithoutReplication(importOperationId);
        this.replicate((OperationWithResult)new SetDataImportDeleteProgressFromMapTimer(importOperationId));
    }

    public void setDataImportDeleteProgressFromMapTimerWithoutReplication(UUID importOperationId) {
        this.dataImportLock.setDeleteFromMapTimer(importOperationId);
    }

    public Result<LeaderboardSearchResult> search(KeywordQueryWithOptionalEventQualification query) {
        long start = System.currentTimeMillis();
        logger.info("Searching local server for " + query);
        Result<LeaderboardSearchResult> result = new RegattaByKeywordSearchService().search(this, query);
        logger.fine("Search for " + query + " took " + (System.currentTimeMillis() - start) + "ms");
        return result;
    }

    public Result<LeaderboardSearchResultBase> searchRemotely(String remoteServerReferenceName, KeywordQueryWithOptionalEventQualification query) {
        long start = System.currentTimeMillis();
        ResultImpl result = null;
        RemoteSailingServerReference remoteRef = this.remoteSailingServerSet.getServerReferenceByName(remoteServerReferenceName);
        if (remoteRef == null) {
            result = null;
        } else {
            BufferedReader bufferedReader = null;
            try {
                try {
                    String basePath = "/sailingserver/api/v1/search";
                    boolean include = remoteRef.isInclude();
                    Set selectedEventIds = remoteRef.getSelectedEventIds();
                    StringBuilder eventsEndpointName = new StringBuilder("/sailingserver/api/v1/search");
                    eventsEndpointName.append("?q=").append(URLEncoder.encode(query.toString(), "UTF-8"));
                    eventsEndpointName.append("&include=").append(include);
                    if (selectedEventIds != null) {
                        for (UUID selectedEventId : selectedEventIds) {
                            eventsEndpointName.append("&eventId=").append(selectedEventId.toString());
                        }
                    }
                    URL eventsURL = new URL(remoteRef.getURL(), eventsEndpointName.toString());
                    logger.info("Searching remote server " + remoteRef + " for " + query);
                    URLConnection urlConnection = HttpUrlConnectionHelper.redirectConnection((URL)eventsURL);
                    bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "UTF-8"));
                    JSONParser parser = new JSONParser();
                    Object eventsAsObject = parser.parse((Reader)bufferedReader);
                    LeaderboardGroupBaseJsonDeserializer leaderboardGroupBaseJsonDeserializer = new LeaderboardGroupBaseJsonDeserializer();
                    CourseAreaJsonDeserializer courseAreaDeserializer = new CourseAreaJsonDeserializer((SharedDomainFactory)DomainFactory.INSTANCE);
                    LeaderboardSearchResultBaseJsonDeserializer deserializer = new LeaderboardSearchResultBaseJsonDeserializer(new EventBaseJsonDeserializer((JsonDeserializer)new VenueJsonDeserializer((JsonDeserializer)courseAreaDeserializer), (JsonDeserializer)leaderboardGroupBaseJsonDeserializer, (JsonDeserializer)new TrackingConnectorInfoJsonDeserializer()), leaderboardGroupBaseJsonDeserializer);
                    result = new ResultImpl((Query)query, new LeaderboardSearchResultBaseRanker());
                    JSONArray hitsAsJsonArray = (JSONArray)eventsAsObject;
                    for (Object hitAsObject : hitsAsJsonArray) {
                        JSONObject hitAsJson = (JSONObject)hitAsObject;
                        LeaderboardSearchResultBase hit = deserializer.deserialize(hitAsJson);
                        result.addHit((Hit)hit);
                    }
                }
                finally {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
            }
            catch (IOException | ParseException e) {
                logger.log(Level.INFO, "Exception trying to fetch events from remote server " + remoteRef + ": " + e.getMessage(), e);
            }
        }
        logger.fine("Remote search on " + remoteRef + " for " + query + " took " + (System.currentTimeMillis() - start) + "ms");
        return result;
    }

    public void stoppedReplicatingFrom(ReplicationMasterDescriptor master) {
        super.stoppedReplicatingFrom(master);
        this.anniversaryRaceDeterminator.start();
        this.remoteSailingServerSet.setRetrieveRemoteRaceResult(true);
    }

    public FileStorageManagementService getFileStorageManagementService() {
        ServiceReference ref = this.bundleContext.getServiceReference(FileStorageManagementService.class);
        if (ref == null) {
            logger.warning("No file storage management service registered");
            return null;
        }
        return (FileStorageManagementService)this.bundleContext.getService(ref);
    }

    public void setPolarDataService(PolarDataService service) {
        if (this.polarDataService == null && service != null) {
            this.polarDataService = service;
            this.polarDataService.registerDomainFactory(this.baseDomainFactory);
            this.setPolarDataServiceOnAllTrackedRaces(service);
        }
    }

    public void setWindEstimationFactoryService(WindEstimationFactoryService service) {
        if (this.windEstimationFactoryService != null || service != null) {
            this.windEstimationFactoryService = service;
            this.setWindEstimationOnAllTrackedRaces(service);
        }
    }

    private void setWindEstimationOnAllTrackedRaces(WindEstimationFactoryService service) {
        Iterable<Regatta> allRegattas = this.getAllRegattas();
        for (Regatta regatta : allRegattas) {
            DynamicTrackedRegatta trackedRegatta = this.getTrackedRegatta(regatta);
            if (trackedRegatta == null) continue;
            trackedRegatta.lockTrackedRacesForRead();
            try {
                try {
                    Iterable trackedRaces = trackedRegatta.getTrackedRaces();
                    for (TrackedRace trackedRace : trackedRaces) {
                        trackedRace.setWindEstimation(service == null ? null : service.createIncrementalWindEstimationTrack(trackedRace));
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Error reconstructing the wind estimation models for tracked races", e);
                    trackedRegatta.unlockTrackedRacesAfterRead();
                    continue;
                }
            }
            catch (Throwable throwable) {
                trackedRegatta.unlockTrackedRacesAfterRead();
                throw throwable;
            }
            trackedRegatta.unlockTrackedRacesAfterRead();
        }
    }

    private void setPolarDataServiceOnAllTrackedRaces(PolarDataService service) {
        Iterable<Regatta> allRegattas = this.getAllRegattas();
        for (Regatta regatta : allRegattas) {
            DynamicTrackedRegatta trackedRegatta = this.getTrackedRegatta(regatta);
            if (trackedRegatta == null) continue;
            trackedRegatta.lockTrackedRacesForRead();
            try {
                try {
                    Iterable trackedRaces = trackedRegatta.getTrackedRaces();
                    for (TrackedRace trackedRace : trackedRaces) {
                        trackedRace.setPolarDataService(service);
                        if (service == null) continue;
                        service.insertExistingFixes(trackedRace);
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Error reconstructing the polars for tracked races", e);
                    trackedRegatta.unlockTrackedRacesAfterRead();
                    continue;
                }
            }
            catch (Throwable throwable) {
                trackedRegatta.unlockTrackedRacesAfterRead();
                throw throwable;
            }
            trackedRegatta.unlockTrackedRacesAfterRead();
        }
    }

    public void unsetPolarDataService(PolarDataService service) {
        if (this.polarDataService == service) {
            this.polarDataService = null;
            this.setPolarDataServiceOnAllTrackedRaces(null);
        }
    }

    public RaceLog resolve(SimpleRaceLogIdentifier identifier) {
        return this.resolveFromSimpleRaceLogIdentifier(identifier, (raceColumn, fleet) -> raceColumn.getRaceLog(fleet));
    }

    private <T> T resolveFromSimpleRaceLogIdentifier(SimpleRaceLogIdentifier identifier, BiFunction<RaceColumn, Fleet, T> innerResolver) {
        T result;
        RaceColumn raceColumn = this.getRaceColumn(identifier);
        if (raceColumn != null) {
            Fleet fleet = raceColumn.getFleetByName(identifier.getFleetName());
            if (fleet != null) {
                result = innerResolver.apply(raceColumn, fleet);
                if (result == null) {
                    logger.log(Level.WARNING, "Failed to resolve " + identifier + " because innerResolver couldn't find fleet " + fleet.getName() + " in race column " + raceColumn.getName() + " which has fleets " + Util.join((String)", ", (Iterable)raceColumn.getFleets()) + " by race log resolver " + this);
                }
            } else {
                result = null;
                logger.log(Level.WARNING, "Failed to resolve " + identifier + " because fleet wasn't found in race column " + raceColumn.getName() + " which has fleets " + Util.join((String)", ", (Iterable)raceColumn.getFleets()) + " by race log resolver " + this);
            }
        } else {
            result = null;
            logger.log(Level.WARNING, "Failed to resolve " + identifier + " because race column " + identifier.getRaceColumnName() + " wasn't found by race log resolver " + this);
        }
        return result;
    }

    public TrackedRace resolveTrackedRace(SimpleRaceLogIdentifier identifier) {
        return this.resolveFromSimpleRaceLogIdentifier(identifier, (raceColumn, fleet) -> raceColumn.getTrackedRace(fleet));
    }

    private RaceColumn getRaceColumn(SimpleRaceLogIdentifier identifier) {
        RaceColumn raceColumn;
        Regatta regattaLike;
        Regatta regatta = this.regattasByName.get(identifier.getRegattaLikeParentName());
        if (regatta != null) {
            regattaLike = regatta;
        } else {
            Leaderboard leaderboard = this.leaderboardsByName.get(identifier.getRegattaLikeParentName());
            if (leaderboard != null && leaderboard instanceof FlexibleLeaderboard) {
                regattaLike = (FlexibleLeaderboard)leaderboard;
            } else {
                regattaLike = null;
                logger.log(Level.WARNING, "Couldn't find race column " + identifier.getRaceColumnName() + " in " + this + " because regatta was not found and leaderboard " + identifier.getRegattaLikeParentName() + (leaderboard == null ? " not found" : " not a flexible leaderboard"));
            }
        }
        if (regattaLike != null) {
            raceColumn = regattaLike.getRaceColumnByName(identifier.getRaceColumnName());
            if (raceColumn == null) {
                logger.log(Level.WARNING, "Couldn't find race column " + identifier.getRaceColumnName() + " in regatta " + regattaLike);
            }
        } else {
            raceColumn = null;
        }
        return raceColumn;
    }

    public void getRaceTrackerByRegattaAndRaceIdentifier(RegattaAndRaceIdentifier raceIdentifier, Consumer<RaceTracker> callback) {
        Regatta regatta;
        LockUtil.lockForRead((NamedReentrantReadWriteLock)this.regattasByNameLock);
        try {
            regatta = this.regattasByName.get(raceIdentifier.getRegattaName());
        }
        finally {
            LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.regattasByNameLock);
        }
        if (regatta != null) {
            LockUtil.lockForRead((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
            try {
                Set<RaceTracker> raceTrackersForRegatta = this.raceTrackersByRegatta.get(regatta);
                if (raceTrackersForRegatta != null) {
                    for (RaceTracker raceTracker : raceTrackersForRegatta) {
                        if (!Util.equalsWithNull((Object)raceTracker.getRaceIdentifier(), (Object)raceIdentifier)) continue;
                        callback.accept(raceTracker);
                        return;
                    }
                }
                Util.addToValueSet(this.getRaceTrackerCallbacks(), (Object)raceIdentifier, callback);
            }
            finally {
                LockUtil.unlockAfterRead((NamedReentrantReadWriteLock)this.raceTrackersByRegattaLock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentHashMap<RegattaAndRaceIdentifier, Set<Consumer<RaceTracker>>> getRaceTrackerCallbacks() {
        if (this.raceTrackerCallbacks == null) {
            RacingEventServiceImpl racingEventServiceImpl = this;
            synchronized (racingEventServiceImpl) {
                if (this.raceTrackerCallbacks == null) {
                    this.raceTrackerCallbacks = new ConcurrentHashMap();
                }
            }
        }
        return this.raceTrackerCallbacks;
    }

    private void notifyListenersForNewRaceTracker(RaceTracker tracker) {
        Set<Consumer<RaceTracker>> callbacks;
        RegattaAndRaceIdentifier raceIdentifier = tracker.getRaceIdentifier();
        if (raceIdentifier != null && (callbacks = this.getRaceTrackerCallbacks().remove(raceIdentifier)) != null) {
            callbacks.forEach(callback -> callback.accept(tracker));
        }
    }

    public long getNumberOfTrackedRacesToRestore() {
        return this.numberOfTrackedRacesToRestore;
    }

    public int getNumberOfTrackedRacesRestored() {
        return this.numberOfTrackedRacesRestored.get();
    }

    public Map<Integer, Statistics> getLocalStatisticsByYear() {
        HashMap<Integer, StatisticsCalculator> calculators = new HashMap<Integer, StatisticsCalculator>();
        this.getAllEvents().forEach(event -> {
            Integer eventYear;
            if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)event) && event.isPublic() && (eventYear = EventUtil.getYearOfEvent((EventBase)event)) != null) {
                StatisticsCalculator calculator;
                if (calculators.containsKey(eventYear)) {
                    calculator = (StatisticsCalculator)calculators.get(eventYear);
                } else {
                    calculator = new StatisticsCalculator(this.trackedRaceStatisticsCache);
                    calculators.put(eventYear, calculator);
                }
                event.getLeaderboardGroups().forEach(lg -> {
                    if (this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)lg)) {
                        for (Leaderboard t : lg.getLeaderboards()) {
                            if (t instanceof RegattaLeaderboard && !this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)((RegattaLeaderboard)t).getRegatta()) || !this.getSecurityService().hasCurrentUserReadPermission((WithQualifiedObjectIdentifier)t)) continue;
                            calculator.addLeaderboard(t);
                        }
                    }
                });
            }
        });
        HashMap<Integer, Statistics> result = new HashMap<Integer, Statistics>();
        calculators.forEach((year, calculator) -> result.put((Integer)year, calculator.getStatistics()));
        return result;
    }

    public Map<Integer, Statistics> getOverallStatisticsByYear() {
        HashMap<Integer, StatisticsAggregator> statisticsAggregators = new HashMap<Integer, StatisticsAggregator>();
        BiConsumer<Integer, Statistics> statisticsConsumer = (year, statistics) -> {
            StatisticsAggregator statisticsAggregator;
            if (statisticsAggregators.containsKey(year)) {
                statisticsAggregator = (StatisticsAggregator)statisticsAggregators.get(year);
            } else {
                statisticsAggregator = new StatisticsAggregator();
                statisticsAggregators.put((Integer)year, statisticsAggregator);
            }
            statisticsAggregator.addStatistics((Statistics)statistics);
        };
        Map<Integer, Statistics> localStatistics = this.getLocalStatisticsByYear();
        localStatistics.forEach(statisticsConsumer);
        Map<RemoteSailingServerReference, Util.Pair<Map<Integer, Statistics>, Exception>> remoteStatistics = this.remoteSailingServerSet.getCachedStatisticsForRemoteSailingServers();
        remoteStatistics.forEach((ref, statisticsOrError) -> {
            Map remoteStatisticsOrNull = (Map)statisticsOrError.getA();
            if (remoteStatisticsOrNull != null) {
                remoteStatisticsOrNull.forEach(statisticsConsumer);
            }
        });
        HashMap<Integer, Statistics> result = new HashMap<Integer, Statistics>();
        statisticsAggregators.forEach((year, aggregator) -> {
            Statistics statistics = result.put((Integer)year, aggregator.getStatistics());
        });
        return result;
    }

    public Map<RegattaAndRaceIdentifier, Set<SimpleRaceInfo>> getRemoteRaceList(Predicate<UUID> eventListFilter) {
        HashMap<RegattaAndRaceIdentifier, Set<SimpleRaceInfo>> store = new HashMap<RegattaAndRaceIdentifier, Set<SimpleRaceInfo>>();
        for (Map.Entry<RemoteSailingServerReference, Util.Pair<Iterable<SimpleRaceInfo>, Exception>> remoteServerRaces : this.remoteSailingServerSet.getCachedRaceList().entrySet()) {
            if (remoteServerRaces.getValue().getB() != null) {
                throw new RuntimeException("Some remoteserver did not respond " + remoteServerRaces.getKey());
            }
            RacingEventServiceImpl.stream((Iterable)remoteServerRaces.getValue().getA()).filter(race -> eventListFilter.test(race.getEventID())).forEach(race -> Util.addToValueSet((Map)store, (Object)race.getIdentifier(), (Object)race));
        }
        return store;
    }

    private static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public Map<RegattaAndRaceIdentifier, Set<SimpleRaceInfo>> getLocalRaceList(Predicate<UUID> eventListFilter) {
        HashMap<RegattaAndRaceIdentifier, Set<SimpleRaceInfo>> store = new HashMap<RegattaAndRaceIdentifier, Set<SimpleRaceInfo>>();
        RacingEventServiceImpl.stream(this.getAllEvents()).filter(event -> eventListFilter.test(event.getId())).forEach(event -> RacingEventServiceImpl.stream(event.getLeaderboardGroups()).flatMap(group -> RacingEventServiceImpl.stream(group.getLeaderboards())).flatMap(leaderBoard -> RacingEventServiceImpl.stream(leaderBoard.getRaceColumns())).flatMap(race -> RacingEventServiceImpl.stream(race.getFleets()).flatMap(fleet -> Stream.of(race.getTrackedRace(fleet)))).filter(trackedRace -> trackedRace != null && trackedRace.hasGPSData()).forEach(trackedRace -> {
            RegattaAndRaceIdentifier raceIdentifier = trackedRace.getRaceIdentifier();
            TimePoint startOfRace = trackedRace.getStartOfRace();
            if (startOfRace != null) {
                Util.addToValueSet((Map)store, (Object)raceIdentifier, (Object)new SimpleRaceInfo(raceIdentifier, startOfRace, null, event.getId()));
            }
        }));
        return store;
    }

    public DetailedRaceInfo getFullDetailsForRaceLocal(RegattaAndRaceIdentifier raceIdentifier) {
        Event eventMatchingAtLeastOneCourseArea;
        TrackedRace trackedRace;
        DetailedRaceInfo bestMatch = null;
        boolean matchesName = false;
        boolean matchesCourseArea = false;
        Leaderboard leaderboardByRegattaName = this.getLeaderboardByName(raceIdentifier.getRegattaName());
        if (leaderboardByRegattaName != null && (trackedRace = (TrackedRace)Util.first((Iterable)Util.filter((Iterable)leaderboardByRegattaName.getTrackedRaces(), tr -> tr.getRaceIdentifier().equals(raceIdentifier)))) != null && leaderboardByRegattaName != null && !Util.isEmpty((Iterable)leaderboardByRegattaName.getCourseAreas()) && (eventMatchingAtLeastOneCourseArea = this.findEventContainingLeaderboardAndMatchingAtLeastOneCourseArea(leaderboardByRegattaName)) != null) {
            bestMatch = new DetailedRaceInfo(raceIdentifier, leaderboardByRegattaName.getName(), leaderboardByRegattaName.getDisplayName(), trackedRace.getStartOfRace(), eventMatchingAtLeastOneCourseArea.getId(), eventMatchingAtLeastOneCourseArea.getName(), EventUtil.getEventType(eventMatchingAtLeastOneCourseArea), null);
        }
        if (bestMatch == null) {
            for (Event event : this.getAllEvents()) {
                EventType eventType = EventUtil.getEventType(event);
                for (LeaderboardGroup group : event.getLeaderboardGroups()) {
                    for (Leaderboard leaderboard : group.getLeaderboards()) {
                        for (RaceColumn race : leaderboard.getRaceColumns()) {
                            for (Fleet fleet : race.getFleets()) {
                                RegattaAndRaceIdentifier trackedRaceIdentifier;
                                TrackedRace trackedRace2 = race.getTrackedRace(fleet);
                                if (trackedRace2 == null || !(trackedRaceIdentifier = trackedRace2.getRaceIdentifier()).equals(raceIdentifier) || trackedRace2.getStartOfRace() == null) continue;
                                boolean leaderboardLinkedToEventThroughCourseArea = Util.containsAny((Iterable)event.getVenue().getCourseAreas(), (Iterable)leaderboard.getCourseAreas());
                                boolean nameOfRegattaAndLeaderboardMatch = leaderboard.getName().equals(trackedRaceIdentifier.getRegattaName());
                                if (bestMatch != null && (!leaderboardLinkedToEventThroughCourseArea || matchesCourseArea) && (leaderboardLinkedToEventThroughCourseArea != matchesCourseArea || !nameOfRegattaAndLeaderboardMatch || matchesName)) continue;
                                bestMatch = new DetailedRaceInfo(trackedRaceIdentifier, leaderboard.getName(), leaderboard.getDisplayName(), trackedRace2.getStartOfRace(), event.getId(), event.getName(), eventType, null);
                                matchesName = nameOfRegattaAndLeaderboardMatch;
                                matchesCourseArea = leaderboardLinkedToEventThroughCourseArea;
                                if (!matchesName || !matchesCourseArea) continue;
                                return bestMatch;
                            }
                        }
                    }
                }
            }
        }
        return bestMatch;
    }

    public Event findEventContainingLeaderboardAndMatchingAtLeastOneCourseArea(Leaderboard leaderboard) {
        Set<Event> events = this.findEventsContainingLeaderboardAndMatchingAtLeastOneCourseArea(leaderboard, this.getAllEvents());
        if (!events.isEmpty()) {
            return (Event)Util.get(events, (int)0);
        }
        return null;
    }

    public Set<Event> findEventsContainingLeaderboardAndMatchingAtLeastOneCourseArea(Leaderboard leaderboard, Iterable<Event> events) {
        HashSet<Event> foundEvents = new HashSet<Event>();
        if (!Util.isEmpty((Iterable)leaderboard.getCourseAreas())) {
            for (Event event : events) {
                if (!Util.containsAny((Iterable)event.getVenue().getCourseAreas(), (Iterable)leaderboard.getCourseAreas())) continue;
                for (LeaderboardGroup leaderboardGroup : event.getLeaderboardGroups()) {
                    if (leaderboardGroup.getIndexOf(leaderboard) < 0) continue;
                    foundEvents.add(event);
                }
            }
        }
        return foundEvents;
    }

    public DetailedRaceInfo getFullDetailsForRaceCascading(RegattaAndRaceIdentifier raceIdentifier) {
        DetailedRaceInfo bestMatch = this.getFullDetailsForRaceLocal(raceIdentifier);
        if (bestMatch == null) {
            Map<RemoteSailingServerReference, Util.Pair<Iterable<SimpleRaceInfo>, Exception>> races = this.remoteSailingServerSet.getCachedRaceList();
            block0: for (Map.Entry<RemoteSailingServerReference, Util.Pair<Iterable<SimpleRaceInfo>, Exception>> cachedInfo : races.entrySet()) {
                Iterable raceList = (Iterable)cachedInfo.getValue().getA();
                if (raceList == null) continue;
                for (SimpleRaceInfo race : raceList) {
                    if (!race.getIdentifier().equals(raceIdentifier)) continue;
                    bestMatch = this.remoteSailingServerSet.getDetailedInfoBlocking(race);
                    continue block0;
                }
            }
        }
        return bestMatch;
    }

    public Util.Pair<Integer, AnniversaryType> getNextAnniversary() {
        return this.anniversaryRaceDeterminator.getNextAnniversary();
    }

    public int getCurrentRaceCount() {
        return this.anniversaryRaceDeterminator.getCurrentRaceCount();
    }

    public Map<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> getKnownAnniversaries() {
        return this.anniversaryRaceDeterminator.getKnownAnniversaries();
    }

    public AnniversaryRaceDeterminatorImpl getAnniversaryRaceDeterminator() {
        return this.anniversaryRaceDeterminator;
    }

    public PairingListTemplate createPairingListTemplate(final int flightsCount, final int groupsCount, final int competitorsCount, int flightMultiplier, int boatChangeFactor) {
        PairingListTemplate template = this.pairingListTemplateFactory.createPairingListTemplate(new PairingFrameProvider(){

            public int getGroupsCount() {
                return groupsCount;
            }

            public int getFlightsCount() {
                return flightsCount;
            }

            public int getCompetitorsCount() {
                return competitorsCount;
            }
        }, flightMultiplier, boatChangeFactor);
        return template;
    }

    public PairingList<RaceColumn, Fleet, Competitor, Boat> getPairingListFromTemplate(PairingListTemplate pairingListTemplate, String leaderboardName, final Iterable<RaceColumn> selectedRaceColumns) throws PairingListCreationException {
        final Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        final List competitors = Util.asList((Iterable)leaderboard.getAllCompetitors());
        Collections.shuffle(competitors);
        PairingList pairingList = pairingListTemplate.createPairingList((CompetitionFormat)new CompetitionFormat<RaceColumn, Fleet, Competitor, Boat>(){

            public Iterable<RaceColumn> getFlights() {
                return selectedRaceColumns;
            }

            public Iterable<Competitor> getCompetitors() {
                return competitors;
            }

            public Iterable<? extends Fleet> getGroups(RaceColumn flight) {
                return leaderboard.getRaceColumnByName(flight.getName()).getFleets();
            }

            public int getGroupsCount() {
                return Util.size((Iterable)((RaceColumn)Util.get((Iterable)leaderboard.getRaceColumns(), (int)0)).getFleets());
            }

            public Iterable<Boat> getCompetitorAllocation() {
                return leaderboard.getAllBoats();
            }
        });
        return pairingList;
    }

    public Iterable<String> getAllWindFinderReviewedSpotsCollectionIds() {
        HashSet<String> result = new HashSet<String>();
        for (Event event : this.getAllEvents()) {
            Util.addAll((Iterable)event.getWindFinderReviewedSpotsCollectionIds(), result);
        }
        return result;
    }

    public Iterable<String> getWindFinderReviewedSpotsCollectionIdsByRegatta(RegattaIdentifier regattaIdentifier) {
        Event event;
        HashSet<String> result = new HashSet<String>();
        Regatta regatta = this.getRegatta(regattaIdentifier);
        if (regatta == null) {
            throw new IllegalArgumentException("The regatta identified by " + regattaIdentifier + " was not found.");
        }
        Leaderboard regattaLeaderboard = this.getLeaderboardByName(regatta.getName());
        if (regattaLeaderboard != null && (event = this.findEventContainingLeaderboardAndMatchingAtLeastOneCourseArea(regattaLeaderboard)) != null) {
            Util.addAll((Iterable)event.getWindFinderReviewedSpotsCollectionIds(), result);
        }
        logger.info("Using WindFinder spot collections " + result + " for regatta " + regattaIdentifier);
        return result;
    }

    public DynamicCompetitorWithBoat convertCompetitorDescriptorToCompetitorWithBoat(CompetitorDescriptor competitorDescriptor, String searchTag) {
        Nationality nationality = competitorDescriptor.getCountryCode() == null || competitorDescriptor.getCountryCode().getThreeLetterIOCCode() == null || competitorDescriptor.getCountryCode().getThreeLetterIOCCode().isEmpty() ? null : this.getBaseDomainFactory().getOrCreateNationality(competitorDescriptor.getCountryCode().getThreeLetterIOCCode());
        Serializable competitorId = competitorDescriptor.getCompetitorId() != null ? competitorDescriptor.getCompetitorId() : UUID.randomUUID();
        Serializable boatId = competitorDescriptor.getBoatId() != null ? competitorDescriptor.getBoatId() : UUID.randomUUID();
        PersonImpl sailor = new PersonImpl(competitorDescriptor.getName(), nationality, null, null);
        TeamImpl team = new TeamImpl(competitorDescriptor.getName(), Collections.singleton(sailor), null);
        BoatClass boatClass = this.getBaseDomainFactory().getOrCreateBoatClass(competitorDescriptor.getBoatClassName());
        DynamicBoat boat = this.getCompetitorAndBoatStore().getOrCreateBoat(boatId, competitorDescriptor.getBoatName(), boatClass, competitorDescriptor.getSailNumber(), null, true);
        DynamicCompetitorWithBoat competitorWithBoat = this.getCompetitorAndBoatStore().getOrCreateCompetitorWithBoat(competitorId, competitorDescriptor.getName(), competitorDescriptor.getShortName(), null, null, null, (DynamicTeam)team, competitorDescriptor.getTimeOnTimeFactor(), competitorDescriptor.getTimeOnDistanceAllowancePerNauticalMile(), searchTag, boat, true);
        return competitorWithBoat;
    }

    public SecurityService getSecurityService() {
        try {
            return (SecurityService)this.securityServiceTracker.getInitializedService(0L);
        }
        catch (InterruptedException e) {
            logger.severe("Interrupted while waiting for security service; returning null");
            return null;
        }
    }

    public CourseAndMarkConfigurationFactory getCourseAndMarkConfigurationFactory() {
        return this.courseAndMarkConfigurationFactory;
    }

    public RaceTrackingConnectivityParameters getConnectivityParametersByRace(RaceDefinition raceDefiniton) {
        return this.connectivityParametersByRace.get(raceDefiniton);
    }

    public RaceTrackingHandler getPermissionAwareRaceTrackingHandler() {
        return new PermissionAwareRaceTrackingHandler(this.getSecurityService());
    }

    public TypeBasedServiceFinder<RaceTrackingConnectivityParametersHandler> getRaceTrackingConnectivityParamsServiceFinder() {
        return this.domainObjectFactory.getRaceTrackingConnectivityParamsServiceFinder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<LeaderboardGroup, ? extends Iterable<Event>> importMasterData(String urlAsString, UUID[] leaderboardGroupIds, boolean override, boolean compress, boolean exportWind, boolean exportDeviceConfigurations, String targetServerUsername, String targetServerPassword, String targetServerBearerToken, boolean exportTrackedRacesAndStartTracking, UUID importOperationId) throws IllegalArgumentException {
        Map<LeaderboardGroup, ? extends Iterable<Event>> map;
        InputStream inputStream;
        URLConnection connection;
        long startTime;
        block25: {
            String query;
            if (this.dataImportLock.getProgress(importOperationId) != null) {
                IllegalArgumentException e = new IllegalArgumentException("The UUID for the importOperationId already exists.");
                logger.log(Level.SEVERE, e.getMessage(), e);
                throw e;
            }
            User user = this.getSecurityService().getCurrentUser();
            logger.info("Importing master data from " + urlAsString + " for leaderboard groups " + Arrays.toString(leaderboardGroupIds) + " for user " + user.getName() + " with import operation ID " + importOperationId);
            String token = this.getSecurityService().getOrCreateTargetServerBearerToken(urlAsString, targetServerUsername, targetServerPassword, targetServerBearerToken);
            this.createOrUpdateDataImportProgressWithReplication(importOperationId, 0.0, DataImportSubProgress.INIT, 0.0);
            UserGroup tenant = this.getSecurityService().getDefaultTenantForCurrentUser();
            startTime = System.currentTimeMillis();
            this.createOrUpdateDataImportProgressWithReplication(importOperationId, 0.01, DataImportSubProgress.CONNECTION_SETUP, 0.5);
            try {
                query = this.createLeaderboardGroupQuery(leaderboardGroupIds, compress, exportWind, exportDeviceConfigurations, exportTrackedRacesAndStartTracking);
            }
            catch (UnsupportedEncodingException e1) {
                throw new RuntimeException(e1);
            }
            connection = null;
            URL serverAddress = null;
            inputStream = null;
            try {
                String masterDataPath = "/sailingserver/spi/v1/masterdata/leaderboardgroups";
                URL base = RemoteServerUtil.createBaseUrl((String)urlAsString);
                serverAddress = RemoteServerUtil.createRemoteServerUrl((URL)base, (String)"/sailingserver/spi/v1/masterdata/leaderboardgroups", (String)query);
                connection = HttpUrlConnectionHelper.redirectConnectionWithBearerToken((URL)serverAddress, (Duration)Duration.ONE_HOUR.times(2L), (String)"POST", (String)token);
                this.createOrUpdateDataImportProgressWithReplication(importOperationId, 0.02, DataImportSubProgress.CONNECTION_ESTABLISH, 0.5);
                if (compress) {
                    TimeoutExtendingInputStream timeoutExtendingInputStream = new TimeoutExtendingInputStream(connection.getInputStream(), connection);
                    inputStream = new GZIPInputStream(timeoutExtendingInputStream);
                } else {
                    inputStream = new TimeoutExtendingInputStream(connection.getInputStream(), connection);
                }
                MasterDataImporter importer = new MasterDataImporter(this.baseDomainFactory, this, user, tenant);
                map = importer.importFromStream(inputStream, importOperationId, override);
                this.setDataImportDeleteProgressFromMapTimerWithReplication(importOperationId);
                if (connection == null) break block25;
            }
            catch (Throwable e) {
                try {
                    String message = e.getMessage();
                    if (connection instanceof HttpURLConnection) {
                        try {
                            Throwable throwable = null;
                            Object var24_35 = null;
                            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(((HttpURLConnection)connection).getErrorStream(), HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)connection, (String)"UTF-8")));){
                                message = bufferedReader.readLine();
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                    throw throwable;
                                }
                                if (throwable == throwable2) throw throwable;
                                throwable.addSuppressed(throwable2);
                                throw throwable;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    logger.log(Level.SEVERE, message, e);
                    this.setDataImportFailedWithReplication(importOperationId, String.valueOf(message) + "\n\nHave you checked if the" + " versions (commit-wise) of the importing and exporting servers are compatible with each other? " + "If the error still occurs, when both servers are running the same version, please report the problem.");
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    this.setDataImportDeleteProgressFromMapTimerWithReplication(importOperationId);
                    if (connection != null && connection instanceof HttpURLConnection) {
                        ((HttpURLConnection)connection).disconnect();
                    }
                    connection = null;
                    long timeToImport = System.currentTimeMillis() - startTime;
                    logger.info(String.format("Took %s ms overall to import master data.", timeToImport));
                    try {
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    catch (IOException e2) {
                        logger.log(Level.INFO, "Couldn't close input stream", e2);
                    }
                    throw throwable;
                }
            }
            if (connection instanceof HttpURLConnection) {
                ((HttpURLConnection)connection).disconnect();
            }
        }
        connection = null;
        long timeToImport = System.currentTimeMillis() - startTime;
        logger.info(String.format("Took %s ms overall to import master data.", timeToImport));
        try {
            if (inputStream == null) return map;
            inputStream.close();
            return map;
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Couldn't close input stream", e);
        }
        return map;
    }

    private String createLeaderboardGroupQuery(UUID[] leaderboardGroupIds, boolean compress, boolean exportWind, boolean exportDeviceConfigurations, boolean exportTrackedRacesAndStartTracking) throws UnsupportedEncodingException {
        StringBuilder queryStringBuilder = new StringBuilder();
        UUID[] uUIDArray = leaderboardGroupIds;
        int n = leaderboardGroupIds.length;
        int n2 = 0;
        while (n2 < n) {
            UUID uuid = uUIDArray[n2];
            queryStringBuilder.append("uuids[]");
            queryStringBuilder.append('=');
            queryStringBuilder.append(uuid);
            queryStringBuilder.append('&');
            ++n2;
        }
        queryStringBuilder.append(String.format("compress=%s&exportWind=%s&exportDeviceConfigs=%s&exportTrackedRacesAndStartTracking=%s", compress, exportWind, exportDeviceConfigurations, exportTrackedRacesAndStartTracking));
        return queryStringBuilder.toString();
    }

    public int getNumberOfTrackedRacesStillLoading() {
        return this.numberOfTrackedRacesStillLoading.get();
    }

    public int getNumberOfTrackedRacesRestoredDoneLoading() {
        return this.numberOfTrackedRacesRestoredDoneLoading.get();
    }

    private RegattaLog getRegattaLogInternal(String leaderboardName) throws DoesNotHaveRegattaLogException {
        Leaderboard l = this.getLeaderboardByName(leaderboardName);
        if (!(l instanceof HasRegattaLike)) {
            throw new DoesNotHaveRegattaLogException();
        }
        return ((HasRegattaLike)l).getRegattaLike().getRegattaLog();
    }

    public void addMarkToRegattaLog(String leaderboardName, Mark mark) throws DoesNotHaveRegattaLogException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        RegattaLog regattaLog = this.getRegattaLogInternal(leaderboardName);
        RegattaLogDefineMarkEventImpl event = new RegattaLogDefineMarkEventImpl(MillisecondsTimePoint.now(), this.getServerAuthor(), MillisecondsTimePoint.now(), (Serializable)UUID.randomUUID(), mark);
        regattaLog.add((AbstractLogEvent)event);
    }

    public void revokeMarkDefinitionEventInRegattaLog(String leaderboardName, String raceColumnName, String fleetName, String markId) throws DoesNotHaveRegattaLogException, MarkAlreadyUsedInRaceException {
        this.getSecurityService().checkCurrentUserUpdatePermission((WithQualifiedObjectIdentifier)this.getLeaderboardByName(leaderboardName));
        Util.Pair<Boolean, String> markAlreadyUsed = this.checkIfMarksAreUsedInOtherRaceLogs(leaderboardName, raceColumnName, fleetName, Collections.singleton(markId));
        if (((Boolean)markAlreadyUsed.getA()).booleanValue()) {
            throw new MarkAlreadyUsedInRaceException("Cannot revoke mark. Mark is used already in another race.", (String)markAlreadyUsed.getB());
        }
        RegattaLog regattaLog = this.getRegattaLogInternal(leaderboardName);
        List regattaLogDefineMarkEvents = (List)new AllEventsOfTypeFinder((AbstractLog)regattaLog, true, RegattaLogDefineMarkEvent.class).analyze();
        RegattaLogDefineMarkEvent eventToRevoke = null;
        for (RegattaLogEvent event : regattaLogDefineMarkEvents) {
            RegattaLogDefineMarkEvent defineMarkEvent = (RegattaLogDefineMarkEvent)event;
            if (!defineMarkEvent.getMark().getId().toString().equals(markId)) continue;
            eventToRevoke = defineMarkEvent;
            break;
        }
        regattaLog.revokeDefineMarkEventAndRelatedDeviceMappings(eventToRevoke, this.getServerAuthor(), logger);
    }

    public Util.Pair<Boolean, String> checkIfMarksAreUsedInOtherRaceLogs(String leaderboardName, String raceColumnName, String fleetName, Set<String> markIds) {
        RaceLog raceLogToIgnore = this.getRaceLog(leaderboardName, raceColumnName, fleetName);
        HashSet<String> racesContainingMarksToDeleteInCourse = new HashSet<String>();
        boolean marksAreUsedInOtherRaceLogs = false;
        Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
        for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
            for (Fleet fleet : raceColumn.getFleets()) {
                LastPublishedCourseDesignFinder finder;
                CourseBase course;
                RaceLog raceLog = raceColumn.getRaceLog(fleet);
                if (raceLog == raceLogToIgnore || (course = (CourseBase)(finder = new LastPublishedCourseDesignFinder(raceLog, true)).analyze()) == null) continue;
                for (Waypoint waypoint : course.getWaypoints()) {
                    for (Mark mark : waypoint.getMarks()) {
                        if (!markIds.contains(mark.getId().toString())) continue;
                        racesContainingMarksToDeleteInCourse.add(String.valueOf(raceColumn.getName()) + "/" + fleet.getName());
                        marksAreUsedInOtherRaceLogs = true;
                    }
                }
            }
        }
        StringBuilder racesInCollision = new StringBuilder();
        for (String raceName : racesContainingMarksToDeleteInCourse) {
            racesInCollision.append(String.valueOf(raceName) + ", ");
        }
        return new Util.Pair((Object)marksAreUsedInOtherRaceLogs, (Object)racesInCollision.substring(0, Math.max(0, racesInCollision.length() - 2)));
    }

    public Iterable<TrackedRace> getAllTrackedRacesForEventTrackingAt(Event event, TimePoint at) {
        HashSet<TrackedRace> result = new HashSet<TrackedRace>();
        for (Leaderboard leaderboard : event.getLeaderboards()) {
            for (TrackedRace trackedRace : leaderboard.getTrackedRaces()) {
                if (trackedRace.getStartOfTracking() == null || trackedRace.getStartOfTracking().after(at) || trackedRace.getEndOfTracking() != null && trackedRace.getEndOfTracking().before(at)) continue;
                result.add(trackedRace);
            }
        }
        return result;
    }

    public Double getCompetitorRaceDataEntry(DetailType dataType, TrackedRace trackedRace, Competitor competitor, TimePoint timePoint, LeaderboardGroup leaderboardGroup, String leaderboardName, WindLegTypeAndLegBearingAndORCPerformanceCurveCache cache) throws NoWindException, NotEnoughDataHasBeenAddedException, MaxIterationsExceededException, FunctionEvaluationException {
        Double result = null;
        Course course = trackedRace.getRace().getCourse();
        course.lockForRead();
        trackedRace.lockForRead((Iterable)trackedRace.getMarkPassings(competitor));
        try {
            TrackedLegOfCompetitor trackedLeg = trackedRace.getTrackedLeg(competitor, timePoint);
            switch (dataType) {
                case LEG_TACKTYPE_LONGTACK_SHORTTACK: {
                    TackType tackType;
                    if (trackedLeg != null && (tackType = trackedLeg.getTackType(timePoint, cache)) != null) {
                        result = tackType == TackType.LONGTACK ? 1.0 : -1.0;
                        break;
                    }
                    result = 0.0;
                    break;
                }
                case RACE_CURRENT_SPEED_OVER_GROUND_IN_KNOTS: {
                    GPSFixTrack sogTrack = trackedRace.getTrack(competitor);
                    if (sogTrack == null) break;
                    SpeedWithBearing speedOverGround = sogTrack.getEstimatedSpeed(timePoint);
                    result = speedOverGround == null ? null : Double.valueOf(speedOverGround.getKnots());
                    break;
                }
                case RACE_CURRENT_COURSE_OVER_GROUND_IN_TRUE_DEGREES: 
                case CHART_COURSE_OVER_GROUND_TRUE_DEGREES: {
                    GPSFixTrack cogTrack = trackedRace.getTrack(competitor);
                    if (cogTrack == null) break;
                    SpeedWithBearing speedOverGround = cogTrack.getEstimatedSpeed(timePoint);
                    result = speedOverGround == null ? null : Double.valueOf(speedOverGround.getBearing().getDegrees());
                    break;
                }
                case RACE_CURRENT_POSITION_LAT_DEG: {
                    GPSFixTrack latTrack = trackedRace.getTrack(competitor);
                    if (latTrack == null) break;
                    Position position = latTrack.getEstimatedPosition(timePoint, true);
                    result = position == null ? null : Double.valueOf(position.getLatDeg());
                    break;
                }
                case RACE_CURRENT_POSITION_LNG_DEG: {
                    GPSFixTrack lngTrack = trackedRace.getTrack(competitor);
                    if (lngTrack == null) break;
                    Position position = lngTrack.getEstimatedPosition(timePoint, true);
                    result = position == null ? null : Double.valueOf(position.getLngDeg());
                    break;
                }
                case LEG_VELOCITY_MADE_GOOD_IN_KNOTS: {
                    SpeedWithBearing velocityMadeGood = trackedLeg != null ? trackedLeg.getVelocityMadeGood(timePoint, WindPositionMode.EXACT, cache) : trackedRace.getVelocityMadeGood(competitor, timePoint, cache);
                    result = velocityMadeGood == null ? null : Double.valueOf(velocityMadeGood.getKnots());
                    break;
                }
                case LEG_DISTANCE_TRAVELED: {
                    if (trackedLeg == null) break;
                    Distance distanceTraveled = trackedRace.getDistanceTraveled(competitor, timePoint);
                    result = distanceTraveled == null ? null : Double.valueOf(distanceTraveled.getMeters());
                    break;
                }
                case LEG_DISTANCE_TRAVELED_INCLUDING_GATE_START: {
                    if (trackedLeg == null) break;
                    Distance distanceTraveledConsideringGateStart = trackedRace.getDistanceTraveledIncludingGateStart(competitor, timePoint);
                    result = distanceTraveledConsideringGateStart == null ? null : Double.valueOf(distanceTraveledConsideringGateStart.getMeters());
                    break;
                }
                case LEG_GAP_TO_LEADER_IN_SECONDS: {
                    if (trackedLeg == null) break;
                    RankingMetric.RankingInfo rankingInfo = trackedRace.getRankingMetric().getRankingInfo(timePoint, cache);
                    Duration gapToLeaderInOwnTime = trackedLeg.getTrackedLeg().getTrackedRace().getRankingMetric().getGapToLeaderInOwnTime(rankingInfo, competitor, cache);
                    result = gapToLeaderInOwnTime == null ? null : Double.valueOf(gapToLeaderInOwnTime.asSeconds());
                    break;
                }
                case LEG_GAP_TO_LEADER_IN_SECONDS_CHANGE: {
                    result = null;
                    if (trackedLeg == null) break;
                    int count = 0;
                    Duration gapDifferenceSum = Duration.NULL;
                    Duration gapToLeaderInOwnTime = null;
                    TimePoint tp = timePoint;
                    Duration samplingRate = trackedRace.getTrack(competitor).getAverageIntervalBetweenRawFixes();
                    int i = 0;
                    while (i < 5) {
                        RankingMetric.RankingInfo rankingInfo = trackedRace.getRankingMetric().getRankingInfo(tp, cache);
                        Duration nextGapToLeaderInOwnTime = trackedLeg.getTrackedLeg().getTrackedRace().getRankingMetric().getGapToLeaderInOwnTime(rankingInfo, competitor, cache);
                        if (gapToLeaderInOwnTime != null && nextGapToLeaderInOwnTime != null) {
                            gapDifferenceSum = gapDifferenceSum.plus(gapToLeaderInOwnTime.minus(nextGapToLeaderInOwnTime));
                            ++count;
                        }
                        gapToLeaderInOwnTime = nextGapToLeaderInOwnTime;
                        tp = tp.minus(samplingRate);
                        ++i;
                    }
                    result = count == 0 ? null : Double.valueOf(gapDifferenceSum.times(1.0 / (double)count).asSeconds() / samplingRate.times(5L).asSeconds());
                    break;
                }
                case CHART_WINDWARD_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD: {
                    if (trackedLeg == null) break;
                    RankingMetric.RankingInfo rankingInfo = trackedRace.getRankingMetric().getRankingInfo(timePoint, cache);
                    Distance distanceToLeader = trackedLeg.getWindwardDistanceToCompetitorFarthestAhead(timePoint, WindPositionMode.LEG_MIDDLE, rankingInfo, cache);
                    result = distanceToLeader == null ? null : Double.valueOf(distanceToLeader.getMeters());
                    break;
                }
                case CHART_WINDWARD_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD_CHANGE: {
                    result = null;
                    if (trackedLeg == null) break;
                    int count = 0;
                    Distance.NullDistance distanceDifferenceSum = Distance.NULL;
                    Distance distanceToLeader = null;
                    TimePoint tp = timePoint;
                    Duration samplingRate = trackedRace.getTrack(competitor).getAverageIntervalBetweenRawFixes();
                    int i = 0;
                    while (i < 5) {
                        RankingMetric.RankingInfo rankingInfo = trackedRace.getRankingMetric().getRankingInfo(tp, cache);
                        Distance nextDistanceToLeader = trackedLeg.getWindwardDistanceToCompetitorFarthestAhead(tp, WindPositionMode.LEG_MIDDLE, rankingInfo, cache);
                        if (distanceToLeader != null && nextDistanceToLeader != null) {
                            distanceDifferenceSum = distanceDifferenceSum.add(distanceToLeader.add(nextDistanceToLeader.scale(-1.0)));
                            ++count;
                        }
                        distanceToLeader = nextDistanceToLeader;
                        tp = tp.minus(samplingRate);
                        ++i;
                    }
                    result = count == 0 ? null : Double.valueOf(distanceDifferenceSum.scale(1.0 / (double)count).getMeters() / samplingRate.times(5L).asSeconds());
                    break;
                }
                case RACE_IMPLIED_WIND: {
                    RankingMetric rankingMetric = trackedRace.getRankingMetric();
                    if (!(rankingMetric instanceof ORCPerformanceCurveRankingMetric)) break;
                    ORCPerformanceCurveRankingMetric orcPcsRankingMetric = (ORCPerformanceCurveRankingMetric)rankingMetric;
                    try {
                        Speed impliedWind = orcPcsRankingMetric.getImpliedWind(competitor, timePoint, cache);
                        result = impliedWind == null ? null : Double.valueOf(impliedWind.getKnots());
                    }
                    catch (FunctionEvaluationException | MaxIterationsExceededException e) {
                        logger.log(Level.WARNING, "Problem computing implied wind", e);
                        result = null;
                    }
                    break;
                }
                case RACE_RANK: {
                    if (trackedLeg == null) break;
                    result = trackedLeg.getRank(timePoint, cache);
                    break;
                }
                case REGATTA_RANK: {
                    if (leaderboardName == null || leaderboardName.isEmpty()) break;
                    Leaderboard leaderboard = this.getLeaderboardByName(leaderboardName);
                    result = leaderboard == null ? null : Double.valueOf(leaderboard.getTotalRankOfCompetitor(competitor, timePoint));
                    break;
                }
                case OVERALL_RANK: {
                    if (leaderboardGroup == null) break;
                    Leaderboard overall = leaderboardGroup.getOverallLeaderboard();
                    result = overall == null ? null : Double.valueOf(overall.getTotalRankOfCompetitor(competitor, timePoint));
                    break;
                }
                case CHART_DISTANCE_TO_START_LINE: {
                    TimePoint startOfRace = trackedRace.getStartOfRace();
                    if (startOfRace != null && !timePoint.before(startOfRace) && !timePoint.equals(startOfRace)) break;
                    Distance distanceToStartLine = trackedRace.getDistanceToStartLine(competitor, timePoint);
                    result = distanceToStartLine == null ? null : Double.valueOf(distanceToStartLine.getMeters());
                    break;
                }
                case CHART_BEAT_ANGLE: 
                case CHART_ABS_TWA: {
                    Bearing twa = trackedRace.getTWA(competitor, timePoint, cache);
                    Double d = result = twa == null ? null : Double.valueOf(twa.getDegrees());
                    if (result == null || dataType != DetailType.CHART_ABS_TWA) break;
                    result = Math.abs(result);
                    break;
                }
                case BRAVO_LEG_CURRENT_HEEL_IN_DEGREES: 
                case BRAVO_RACE_HEEL_IN_DEGREES: {
                    result = this.getBravoBearingInDegrees(BravoFixTrack::getHeel, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVO_LEG_CURRENT_PITCH_IN_DEGREES: 
                case BRAVO_RACE_PITCH_IN_DEGREES: {
                    result = this.getBravoBearingInDegrees(BravoFixTrack::getPitch, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVO_RACE_CURRENT_RIDE_HEIGHT_IN_METERS: {
                    result = this.getBravoDistanceInMeters(BravoFixTrack::getRideHeight, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_PORT_DAGGERBOARD_RAKE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getPortDaggerboardRakeIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_STBD_DAGGERBOARD_RAKE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getStbdDaggerboardRakeStbdIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_PORT_RUDDER_RAKE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getPortRudderRakeIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_STBD_RUDDER_RAKE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getStbdRudderRakeIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_MAST_ROTATION_IN_DEGREES: {
                    result = this.getBravoBearingInDegrees(BravoFixTrack::getMastRotationIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_LEEWAY_IN_DEGREES: {
                    result = this.getBravoBearingInDegrees(BravoFixTrack::getLeewayIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_SET: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getSetIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_DRIFT_IN_DEGREES: {
                    result = this.getBravoBearingInDegrees(BravoFixTrack::getDriftIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_DEPTH_IN_METERS: {
                    result = this.getBravoDistanceInMeters(BravoFixTrack::getDepthIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_RUDDER_IN_DEGREES: {
                    result = this.getBravoBearingInDegrees(BravoFixTrack::getRudderIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_TACK_ANGLE_IN_DEGREES: {
                    result = this.getBravoBearingInDegrees(BravoFixTrack::getTackAngleIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_DEFLECTOR_PERCENTAGE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getDeflectorPercentageIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_DEFLECTOR_IN_MILLIMETERS: {
                    Double deflectorInMeters = this.getBravoDistanceInMeters(BravoFixTrack::getDeflectorIfAvailable, trackedRace, competitor, timePoint);
                    result = deflectorInMeters == null ? null : Double.valueOf(deflectorInMeters * 1000.0);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_RAKE_IN_DEGREES: {
                    result = this.getBravoBearingInDegrees(BravoFixTrack::getRakeIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_TARGET_HEEL_ANGLE_IN_DEGREES: {
                    result = this.getBravoBearingInDegrees(BravoFixTrack::getTargetHeelIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_FORESTAY_LOAD: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getForestayLoadIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_FORESTAY_PRESSURE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getForestayPressureIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case BRAVOEXTENDED_RACE_CURRENT_TARGET_BOATSPEED_PERCENTAGE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getTargetBoatspeedPIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_AWA: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionAWAIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_AWS: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionAWSIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_BARO: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionBaroIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_BOAT_SPEED: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionBoatSpeedIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_COG: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionCOGIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_COURSE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionCourseDetailIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_DIST_TO_PORT_LAYLINE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionDistToPortLaylineIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_DIST_TO_STB_LAYLINE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionDistToStbLaylineIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_DISTANCE_BELOW_LINE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionDistanceBelowLineInMetersIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_DISTANCE_TO_COMMITTEE_BOAT: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionDistanceToCommitteeBoatIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_DISTANCE_TO_PIN: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionDistanceToPinDetailIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_FORESTAY_LOAD: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionForestayLoadIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_HEADING: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionHeadingIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_JIB_CAR_PORT: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionJibCarPortIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_JIB_CAR_STBD: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionJibCarStbdIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_LINE_SQUARE_FOR_WIND_DIRECTION: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionLineSquareForWindIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_LOAD_P: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionLoadPIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_LOAD_S: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionLoadSIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_MAST_BUTT: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionMastButtIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_RAKE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionRakeIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_RATE_OF_TURN: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionRateOfTurnIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_RUDDER_ANGLE: {
                    result = this.getBravoBearingInDegrees(BravoFixTrack::getRudderIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_SOG: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionSOGIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TARG_BOAT_SPEED: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTargBoatSpeedIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TARG_TWA: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTargTWAIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TARGET_HEEL: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTargetHeelIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TIME_TO_BURN_TO_COMMITTEE_BOAT: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTimeToBurnToCommitteeBoatIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TIME_TO_BURN_TO_LINE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTimeToBurnToLineInSecondsIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TIME_TO_BURN_TO_PIN: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTimeToBurnToPinIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TIME_TO_COMMITTEE_BOAT: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTimeToCommitteeBoatIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TIME_TO_GUN: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTimeToGunInSecondsIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TIME_TO_PIN: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTimeToPinIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TIME_TO_PORT_LAYLINE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTimeToPortLaylineIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TIME_TO_STB_LAYLINE: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTimeToStbLaylineIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TWA: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTWAIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TWD: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTWDIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_TWS: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionTWSIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_VMG: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionVMGIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_VMG_TARG_VMG_DELTA: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionVMGTargVMGDeltaIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case EXPEDITION_RACE_KICKER_TENSION: {
                    result = this.getBravoDoubleValue(BravoFixTrack::getExpeditionKickerTensionIfAvailable, trackedRace, competitor, timePoint);
                    break;
                }
                case PERCENT_TARGET_BOAT_SPEED: {
                    result = trackedRace.getPercentTargetBoatSpeed(competitor, timePoint, cache);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("There is currently no support for the enum value '" + dataType + "' in this method.");
                }
            }
            Double d = result;
            return d;
        }
        finally {
            trackedRace.unlockAfterRead((Iterable)trackedRace.getMarkPassings(competitor));
            course.unlockAfterRead();
        }
    }

    private Double getBravoDoubleValue(BiFunction<BravoFixTrack<Competitor>, TimePoint, Double> valueGetter, TrackedRace trackedRace, Competitor competitor, TimePoint timePoint) {
        return this.getBravoValue(valueGetter, Function.identity(), trackedRace, competitor, timePoint);
    }

    private Double getBravoBearingInDegrees(BiFunction<BravoFixTrack<Competitor>, TimePoint, Bearing> valueGetter, TrackedRace trackedRace, Competitor competitor, TimePoint timePoint) {
        return this.getBravoValue(valueGetter, Bearing::getDegrees, trackedRace, competitor, timePoint);
    }

    private Double getBravoDistanceInMeters(BiFunction<BravoFixTrack<Competitor>, TimePoint, Distance> valueGetter, TrackedRace trackedRace, Competitor competitor, TimePoint timePoint) {
        return this.getBravoValue(valueGetter, Distance::getMeters, trackedRace, competitor, timePoint);
    }

    private <T> Double getBravoValue(BiFunction<BravoFixTrack<Competitor>, TimePoint, T> valueGetter, Function<T, Double> mapperToDouble, TrackedRace trackedRace, Competitor competitor, TimePoint timePoint) {
        T t;
        BravoFixTrack bravoFixTrack = (BravoFixTrack)trackedRace.getSensorTrack(competitor, "BravoFixTrack");
        Double result = bravoFixTrack != null ? ((t = valueGetter.apply((BravoFixTrack<Competitor>)bravoFixTrack, timePoint)) == null ? null : mapperToDouble.apply(t)) : null;
        return result;
    }

    public static interface ConstructorParameters {
        public DomainObjectFactory getDomainObjectFactory();

        public MongoObjectFactory getMongoObjectFactory();

        public DomainFactory getBaseDomainFactory();

        public CompetitorAndBoatStore getCompetitorAndBoatStore();
    }

    private class LeaderboardScoreCorrectionNotifier
    implements ScoreCorrectionListener {
        private final Duration HOW_LONG_BETWEEN_TWO_NOTIFICATIONS_FOR_SIMILAR_EVENT = Duration.ONE_MINUTE.times(5L);
        private TimePoint lastNotificationForLeaderboard;
        private final ConcurrentHashMap<Competitor, TimePoint> lastNotificationForCompetitor;
        private final Leaderboard leaderboard;

        public LeaderboardScoreCorrectionNotifier(Leaderboard leaderboard) {
            this.leaderboard = leaderboard;
            this.lastNotificationForCompetitor = new ConcurrentHashMap();
        }

        public void correctedScoreChanged(Competitor competitor, RaceColumn raceColumn, Double oldCorrectedScore, Double newCorrectedScore) {
            this.notifyForCompetitorScoreCorrectionUpdateIfNotAlreadyNotifiedRecently(competitor, raceColumn);
        }

        public void incrementalScoreCorrectionChanged(Competitor competitor, RaceColumn raceColumn, Double oldScoreOffsetInPoints, Double newScoreOffsetInPoints) {
            this.notifyForCompetitorScoreCorrectionUpdateIfNotAlreadyNotifiedRecently(competitor, raceColumn);
        }

        public void maxPointsReasonChanged(Competitor competitor, RaceColumn raceColumn, MaxPointsReason oldMaxPointsReason, MaxPointsReason newMaxPointsReason) {
            this.notifyForCompetitorScoreCorrectionUpdateIfNotAlreadyNotifiedRecently(competitor, raceColumn);
        }

        public void carriedPointsChanged(Competitor competitor, Double oldCarriedPoints, Double newCarriedPoints) {
            this.notifyForCompetitorScoreCorrectionUpdateIfNotAlreadyNotifiedRecently(competitor, null);
        }

        public void isSuppressedChanged(Competitor competitor, boolean newIsSuppressed) {
        }

        public void timePointOfLastCorrectionsValidityChanged(TimePoint oldTimePointOfLastCorrectionsValidity, TimePoint newTimePointOfLastCorrectionsValidity) {
            this.notifyForLeaderboardIfNotAlreadyNotifiedRecently();
        }

        public void commentChanged(String oldComment, String newComment) {
            this.notifyForLeaderboardIfNotAlreadyNotifiedRecently();
        }

        private void notifyForLeaderboardIfNotAlreadyNotifiedRecently() {
            TimePoint now = MillisecondsTimePoint.now();
            if (RacingEventServiceImpl.this.notificationService != null && (this.lastNotificationForLeaderboard == null || this.lastNotificationForLeaderboard.until(now).compareTo((Object)this.HOW_LONG_BETWEEN_TWO_NOTIFICATIONS_FOR_SIMILAR_EVENT) >= 0)) {
                scheduler.execute(() -> RacingEventServiceImpl.this.notificationService.notifyUserOnBoatClassWhenScoreCorrectionsAreAvailable(this.leaderboard.getBoatClass(), this.leaderboard));
                this.lastNotificationForLeaderboard = now;
            }
        }

        private void notifyForCompetitorScoreCorrectionUpdateIfNotAlreadyNotifiedRecently(Competitor competitor, RaceColumn raceColumn) {
            TimePoint now = MillisecondsTimePoint.now();
            if (!(RacingEventServiceImpl.this.notificationService == null || this.lastNotificationForCompetitor.containsKey(competitor) && this.lastNotificationForCompetitor.get(competitor).until(now).compareTo((Object)this.HOW_LONG_BETWEEN_TWO_NOTIFICATIONS_FOR_SIMILAR_EVENT) < 0)) {
                scheduler.execute(() -> RacingEventServiceImpl.this.notificationService.notifyUserOnCompetitorScoreCorrections(competitor, this.leaderboard));
                this.lastNotificationForCompetitor.put(competitor, now);
            }
            this.notifyForLeaderboardIfNotAlreadyNotifiedRecently();
        }
    }

    private class PolarFixCacheUpdater
    extends AbstractRaceChangeListener {
        private final TrackedRace race;

        public PolarFixCacheUpdater(TrackedRace race) {
            this.race = race;
        }

        public void competitorPositionChanged(GPSFixMoving fix, Competitor item, AddResult addedOrReplaced) {
            if (RacingEventServiceImpl.this.polarDataService != null) {
                RacingEventServiceImpl.this.polarDataService.competitorPositionChanged(fix, item, this.race);
            }
        }

        public void statusChanged(TrackedRaceStatus newStatus, TrackedRaceStatus oldStatus) {
            if (oldStatus.getStatus() == TrackedRaceStatusEnum.LOADING && newStatus.getStatus() != TrackedRaceStatusEnum.LOADING && newStatus.getStatus() != TrackedRaceStatusEnum.REMOVED && RacingEventServiceImpl.this.polarDataService != null) {
                RacingEventServiceImpl.this.polarDataService.raceFinishedLoading(this.race);
            }
        }
    }

    private class RaceAdditionListener
    implements RaceListener,
    Serializable {
        private static final long serialVersionUID = 1036955460477000265L;
        private final Map<TrackedRace, TrackedRaceReplicatorAndNotifier> trackedRaceReplicators = new HashMap<TrackedRace, TrackedRaceReplicatorAndNotifier>();
        private final Map<TrackedRace, PolarFixCacheUpdater> polarFixCacheUpdaters = new HashMap<TrackedRace, PolarFixCacheUpdater>();

        public void raceRemoved(TrackedRace trackedRace) {
            PolarFixCacheUpdater polarFixCacheUpdater;
            TrackedRaceReplicatorAndNotifier trackedRaceReplicator = this.trackedRaceReplicators.remove(trackedRace);
            if (trackedRaceReplicator != null) {
                trackedRace.removeListener((RaceChangeListener)trackedRaceReplicator);
            }
            if ((polarFixCacheUpdater = this.polarFixCacheUpdaters.remove(trackedRace)) != null) {
                trackedRace.removeListener((RaceChangeListener)polarFixCacheUpdater);
            }
            trackedRace.runSynchronizedOnStatus(() -> {
                if (!trackedRace.hasFinishedLoading()) {
                    RacingEventServiceImpl.this.numberOfTrackedRacesStillLoading.decrementAndGet();
                }
            });
        }

        public void raceAdded(TrackedRace trackedRace) {
            CreateTrackedRace op = new CreateTrackedRace(trackedRace.getRaceIdentifier(), trackedRace.getWindStore(), trackedRace.getDelayToLiveInMillis(), trackedRace.getMillisecondsOverWhichToAverageWind(), trackedRace.getMillisecondsOverWhichToAverageSpeed(), trackedRace.getTrackingConnectorInfo());
            RacingEventServiceImpl.this.replicate((OperationWithResult)op);
            RacingEventServiceImpl.this.linkRaceToConfiguredLeaderboardColumns(trackedRace);
            TrackedRaceReplicatorAndNotifier trackedRaceReplicator = new TrackedRaceReplicatorAndNotifier(trackedRace);
            this.trackedRaceReplicators.put(trackedRace, trackedRaceReplicator);
            trackedRace.addListener((RaceChangeListener)trackedRaceReplicator, true, true);
            PolarFixCacheUpdater polarFixCacheUpdater = new PolarFixCacheUpdater(trackedRace);
            this.polarFixCacheUpdaters.put(trackedRace, polarFixCacheUpdater);
            trackedRace.addListener((RaceChangeListener)polarFixCacheUpdater);
            if (RacingEventServiceImpl.this.polarDataService != null) {
                trackedRace.setPolarDataService(RacingEventServiceImpl.this.polarDataService);
            }
            if (RacingEventServiceImpl.this.windEstimationFactoryService != null) {
                trackedRace.setWindEstimation(RacingEventServiceImpl.this.windEstimationFactoryService.createIncrementalWindEstimationTrack(trackedRace));
            }
            RacingEventServiceImpl.this.numberOfTrackedRacesStillLoading.incrementAndGet();
            trackedRace.runWhenDoneLoading(() -> {
                int n = RacingEventServiceImpl.this.numberOfTrackedRacesStillLoading.decrementAndGet();
            });
        }
    }

    private class TimeoutExtendingInputStream
    extends FilterInputStream {
        private static final int DEFAULT_TIMEOUT_IN_SECONDS = 7200;
        private final URLConnection connection;

        protected TimeoutExtendingInputStream(InputStream in, URLConnection connection) {
            super(in);
            this.connection = connection;
        }

        @Override
        public int read() throws IOException {
            this.connection.setReadTimeout(0x6DDD00);
            return super.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            this.connection.setReadTimeout(0x6DDD00);
            return super.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.connection.setReadTimeout(0x6DDD00);
            return super.read(b, off, len);
        }
    }

    private class TrackedRaceReplicatorAndNotifier
    implements RaceChangeListener {
        private final TrackedRace trackedRace;

        public TrackedRaceReplicatorAndNotifier(TrackedRace trackedRace) {
            this.trackedRace = trackedRace;
        }

        public void windSourcesToExcludeChanged(Iterable<? extends WindSource> windSourcesToExclude) {
        }

        public void startOfTrackingChanged(TimePoint oldStartOfTracking, TimePoint newStartOfTracking) {
            RacingEventServiceImpl.this.replicate((OperationWithResult)new UpdateStartOfTracking(this.getRaceIdentifier(), newStartOfTracking));
        }

        public void endOfTrackingChanged(TimePoint oldEndOfTracking, TimePoint newEndOfTracking) {
            RacingEventServiceImpl.this.replicate((OperationWithResult)new UpdateEndOfTracking(this.getRaceIdentifier(), newEndOfTracking));
        }

        public void startTimeReceivedChanged(TimePoint startTimeReceived) {
            RacingEventServiceImpl.this.replicate((OperationWithResult)new UpdateStartTimeReceived(this.getRaceIdentifier(), startTimeReceived));
        }

        public void startOfRaceChanged(TimePoint oldStartOfRace, TimePoint newStartOfRace) {
            if (newStartOfRace != null && newStartOfRace.after(MillisecondsTimePoint.now())) {
                scheduler.execute(() -> RacingEventServiceImpl.this.notificationService.notifyUserOnBoatClassUpcomingRace(this.trackedRace.getRace().getBoatClass(), this.getMostAppropriateLeaderboard(), this.getMostAppropriateRaceColumn(), this.getMostAppropriateFleet(), newStartOfRace));
            }
        }

        public void finishingTimeChanged(TimePoint oldFinishingTime, TimePoint newFinishingTime) {
        }

        public void finishedTimeChanged(TimePoint oldFinishedTime, TimePoint newFinishedTime) {
            if (newFinishedTime != null && newFinishedTime.after(MillisecondsTimePoint.now().minus(Duration.ONE_HOUR))) {
                scheduler.execute(() -> RacingEventServiceImpl.this.notificationService.notifyUserOnBoatClassRaceChangesStateToFinished(this.trackedRace.getRace().getBoatClass(), this.trackedRace, this.getMostAppropriateLeaderboard(), this.getMostAppropriateRaceColumn(), this.getMostAppropriateFleet()));
            }
        }

        public void waypointAdded(int zeroBasedIndex, Waypoint waypointThatGotAdded) {
        }

        public void waypointRemoved(int zeroBasedIndex, Waypoint waypointThatGotRemoved) {
        }

        public void delayToLiveChanged(long delayToLiveInMillis) {
            RacingEventServiceImpl.this.replicate((OperationWithResult)new UpdateRaceDelayToLive(this.getRaceIdentifier(), delayToLiveInMillis));
        }

        public void windDataReceived(Wind wind, WindSource windSource) {
            if (windSource.getType() != WindSourceType.MANEUVER_BASED_ESTIMATION) {
                RacingEventServiceImpl.this.replicate((OperationWithResult)new RecordWindFix(this.getRaceIdentifier(), windSource, wind));
            }
        }

        public void windDataRemoved(Wind wind, WindSource windSource) {
            if (windSource.getType() != WindSourceType.MANEUVER_BASED_ESTIMATION) {
                RacingEventServiceImpl.this.replicate((OperationWithResult)new RemoveWindFix(this.getRaceIdentifier(), windSource, wind));
            }
        }

        public void windAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
            RacingEventServiceImpl.this.replicate((OperationWithResult)new UpdateWindAveragingTime(this.getRaceIdentifier(), newMillisecondsOverWhichToAverage));
        }

        public void competitorPositionChanged(GPSFixMoving fix, Competitor competitor, AddResult addedOrReplaced) {
            RacingEventServiceImpl.this.replicate((OperationWithResult)new RecordCompetitorGPSFix(this.getRaceIdentifier(), competitor, fix));
        }

        public void statusChanged(TrackedRaceStatus newStatus, TrackedRaceStatus oldStatus) {
            RacingEventServiceImpl.this.replicate((OperationWithResult)new UpdateTrackedRaceStatus(this.getRaceIdentifier(), newStatus));
        }

        public void markPositionChanged(GPSFix fix, Mark mark, boolean firstInTrack, AddResult addedOrReplaced) {
            Object operation = firstInTrack ? new RecordMarkGPSFixForNewMarkTrack(this.getRaceIdentifier(), mark, fix) : new RecordMarkGPSFixForExistingTrack(this.getRaceIdentifier(), mark, fix);
            RacingEventServiceImpl.this.replicate((OperationWithResult)operation);
        }

        public void markPassingReceived(Competitor competitor, Map<Waypoint, MarkPassing> oldMarkPassings, Iterable<MarkPassing> markPassings) {
            RacingEventServiceImpl.this.replicate((OperationWithResult)new UpdateMarkPassings(this.getRaceIdentifier(), competitor, markPassings));
            MarkPassing last = (MarkPassing)Util.last(markPassings);
            if (last != null && last.getWaypoint() == this.trackedRace.getRace().getCourse().getLastWaypoint() && this.trackedRace.getStatus().getStatus() != TrackedRaceStatusEnum.LOADING && last.getTimePoint().after(MillisecondsTimePoint.now().minus(Duration.ONE_HOUR))) {
                scheduler.execute(() -> RacingEventServiceImpl.this.notificationService.notifyUserOnCompetitorPassesFinish(competitor, this.trackedRace, this.getMostAppropriateLeaderboard(), this.getMostAppropriateRaceColumn(), this.getMostAppropriateFleet()));
            }
        }

        public void speedAveragingChanged(long oldMillisecondsOverWhichToAverage, long newMillisecondsOverWhichToAverage) {
            RacingEventServiceImpl.this.replicate((OperationWithResult)new UpdateWindAveragingTime(this.getRaceIdentifier(), newMillisecondsOverWhichToAverage));
        }

        public void competitorSensorTrackAdded(DynamicSensorFixTrack<Competitor, ?> track) {
            RacingEventServiceImpl.this.replicate((OperationWithResult)new RecordCompetitorSensorFixTrack(this.getRaceIdentifier(), track));
        }

        public void competitorSensorFixAdded(Competitor competitor, String trackName, SensorFix fix, AddResult addedOrReplaced) {
            RacingEventServiceImpl.this.replicate((OperationWithResult)new RecordCompetitorSensorFix(this.getRaceIdentifier(), competitor, trackName, fix));
        }

        private RegattaAndRaceIdentifier getRaceIdentifier() {
            return this.trackedRace.getRaceIdentifier();
        }

        public void regattaLogAttached(RegattaLog regattaLog) {
        }

        public void raceLogAttached(RaceLog regattaLog) {
        }

        public void raceLogDetached(RaceLog raceLog) {
        }

        private Leaderboard getMostAppropriateLeaderboard() {
            Util.Triple<Leaderboard, RaceColumn, Fleet> slot = this.findMostAppropriateLeaderboardSlot();
            return slot == null ? null : (Leaderboard)slot.getA();
        }

        private RaceColumn getMostAppropriateRaceColumn() {
            Util.Triple<Leaderboard, RaceColumn, Fleet> slot = this.findMostAppropriateLeaderboardSlot();
            return slot == null ? null : (RaceColumn)slot.getB();
        }

        private Fleet getMostAppropriateFleet() {
            Util.Triple<Leaderboard, RaceColumn, Fleet> slot = this.findMostAppropriateLeaderboardSlot();
            return slot == null ? null : (Fleet)slot.getC();
        }

        private Util.Triple<Leaderboard, RaceColumn, Fleet> findMostAppropriateLeaderboardSlot() {
            Regatta regatta = this.trackedRace.getTrackedRegatta().getRegatta();
            String regattaLeaderboardName = RegattaLeaderboardImpl.getLeaderboardNameForRegatta((Regatta)regatta);
            Leaderboard regattaLeaderboard = RacingEventServiceImpl.this.getLeaderboardByName(regattaLeaderboardName);
            Leaderboard leaderboard = null;
            Util.Pair raceColumnAndFleet = null;
            if (regattaLeaderboard != null) {
                leaderboard = regattaLeaderboard;
                raceColumnAndFleet = regattaLeaderboard.getRaceColumnAndFleet(this.trackedRace);
            } else {
                for (Leaderboard l : RacingEventServiceImpl.this.getLeaderboards().values()) {
                    Util.Pair rcaf = l.getRaceColumnAndFleet(this.trackedRace);
                    if (rcaf == null) continue;
                    leaderboard = l;
                    raceColumnAndFleet = rcaf;
                    break;
                }
            }
            Util.Triple result = leaderboard != null && raceColumnAndFleet != null ? new Util.Triple((Object)leaderboard, (Object)((RaceColumn)raceColumnAndFleet.getA()), (Object)((Fleet)raceColumnAndFleet.getB())) : null;
            return result;
        }

        public void firstGPSFixReceived() {
        }
    }
}

