/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.impl;

import com.sap.sailing.domain.abstractlog.race.CompetitorResult;
import com.sap.sailing.domain.abstractlog.race.CompetitorResults;
import com.sap.sailing.domain.abstractlog.race.RaceLog;
import com.sap.sailing.domain.abstractlog.race.RaceLogEvent;
import com.sap.sailing.domain.abstractlog.race.RaceLogFinishPositioningConfirmedEvent;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.AbstractFinishPositioningListFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.ConfirmedFinishPositioningListFinder;
import com.sap.sailing.domain.abstractlog.race.analyzing.impl.FinishPositioningListFinder;
import com.sap.sailing.domain.abstractlog.race.impl.BaseRaceLogEventVisitor;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.impl.RaceColumnListenerWithDefaultAction;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.RankingMetrics;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.racelog.RaceLogIdentifier;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardMaxPointsReason;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardScoreCorrection;
import com.sap.sailing.server.operationaltransformation.UpdateLeaderboardScoreCorrectionMetadata;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.replication.OperationWithResult;
import java.util.logging.Logger;

public class RaceLogScoringReplicator
implements RaceColumnListenerWithDefaultAction {
    private static final Logger logger = Logger.getLogger(RaceLogScoringReplicator.class.getName());
    private static final long serialVersionUID = -5958519195756937338L;
    private final RacingEventService service;
    private static final String COMMENT_TEXT_ON_SCORE_CORRECTION_SINGLE_FLEET = "Results of race %s have been updated.";
    private static final String COMMENT_TEXT_ON_SCORE_CORRECTION_MULTI_FLEET = "Results of race %s, %s have been updated.";

    public RaceLogScoringReplicator(RacingEventService service) {
        this.service = service;
    }

    public void raceLogEventAdded(final RaceColumn raceColumn, final RaceLogIdentifier raceLogIdentifier, RaceLogEvent event) {
        event.accept((Object)new BaseRaceLogEventVisitor(){

            public void visit(RaceLogFinishPositioningConfirmedEvent event) {
                RaceLogScoringReplicator.this.handleFinishPositioningList(raceColumn, raceLogIdentifier, event);
            }
        });
    }

    private void handleFinishPositioningList(RaceColumn raceColumn, RaceLogIdentifier raceLogIdentifier, RaceLogFinishPositioningConfirmedEvent event) {
        Leaderboard leaderboard = this.service.getLeaderboardByName(raceLogIdentifier.getRegattaLikeParent().getName());
        if (leaderboard != null) {
            Fleet fleet = raceColumn.getFleetByName(raceLogIdentifier.getFleetName());
            RaceLog raceLog = raceColumn.getRaceLog(fleet);
            this.checkNeedForScoreCorrectionByResultsOfRaceCommittee(leaderboard, raceColumn, fleet, raceLog, event.getCreatedAt(), event);
        }
    }

    public boolean isTransient() {
        return true;
    }

    private void checkNeedForScoreCorrectionByResultsOfRaceCommittee(Leaderboard leaderboard, RaceColumn raceColumn, Fleet fleet, RaceLog raceLog, TimePoint timePoint, RaceLogFinishPositioningConfirmedEvent event) {
        int numberOfCompetitorsInLeaderboard = Util.size((Iterable)leaderboard.getCompetitors());
        int numberOfCompetitorsInRace = this.getNumberOfCompetitorsInRace(raceColumn, fleet, numberOfCompetitorsInLeaderboard);
        ConfirmedFinishPositioningListFinder confirmedPositioningListFinder = new ConfirmedFinishPositioningListFinder(raceLog);
        CompetitorResults positioningList = ((AbstractFinishPositioningListFinder.CompetitorResultsAndTheirCreationTimePoints)confirmedPositioningListFinder.analyze()).getCompetitorResults();
        if (positioningList == null) {
            FinishPositioningListFinder positioningListFinder = new FinishPositioningListFinder(raceLog);
            positioningList = ((AbstractFinishPositioningListFinder.CompetitorResultsAndTheirCreationTimePoints)positioningListFinder.analyze()).getCompetitorResults();
        }
        if (positioningList != null) {
            boolean metadataUpdateRequired = false;
            for (CompetitorResult positionedCompetitor : positioningList) {
                Competitor competitor = this.service.getBaseDomainFactory().getExistingCompetitorById(positionedCompetitor.getCompetitorId());
                int rankByRaceCommittee = this.getRankInPositioningListByRaceCommittee(positionedCompetitor);
                Double preChangeTotalPoints = leaderboard.getTotalPoints(competitor, raceColumn, timePoint);
                MaxPointsReason preChangeMaxPointsReason = leaderboard.getMaxPointsReason(competitor, raceColumn, timePoint);
                this.correctScoreInLeaderboardIfNecessary(leaderboard, raceColumn, timePoint, numberOfCompetitorsInRace, competitor, rankByRaceCommittee, positionedCompetitor.getScore(), positionedCompetitor.getMaxPointsReason());
                this.setMaxPointsReasonInLeaderboardIfNecessary(leaderboard, raceColumn, timePoint, positionedCompetitor.getMaxPointsReason(), competitor);
                Double postChangeTotalPoints = leaderboard.getTotalPoints(competitor, raceColumn, timePoint);
                MaxPointsReason postChangeMaxPointsReason = leaderboard.getMaxPointsReason(competitor, raceColumn, timePoint);
                if (metadataUpdateRequired || Util.equalsWithNull((Object)postChangeTotalPoints, (Object)preChangeTotalPoints) && Util.equalsWithNull((Object)preChangeMaxPointsReason, (Object)postChangeMaxPointsReason)) continue;
                logger.info("Found at least one score correction change in leaderboard " + leaderboard.getName() + " for competitor " + competitor.getName() + " in race column " + raceColumn.getName() + ". Updating comment and time of last correction.");
                metadataUpdateRequired = true;
            }
            if (metadataUpdateRequired && (leaderboard.getScoreCorrection().getTimePointOfLastCorrectionsValidity() == null || timePoint != null && leaderboard.getScoreCorrection().getTimePointOfLastCorrectionsValidity().before(timePoint))) {
                String comment = "Default".equals(fleet.getName()) ? String.format(COMMENT_TEXT_ON_SCORE_CORRECTION_SINGLE_FLEET, raceColumn.getName()) : String.format(COMMENT_TEXT_ON_SCORE_CORRECTION_MULTI_FLEET, raceColumn.getName(), fleet.getName());
                this.applyMetadataUpdate(leaderboard, timePoint, comment);
            }
        }
    }

    private void setMaxPointsReasonInLeaderboardIfNecessary(Leaderboard leaderboard, RaceColumn raceColumn, TimePoint timePoint, MaxPointsReason maxPointsReason, Competitor competitor) {
        MaxPointsReason maxPointsReasonByRaceCommittee = maxPointsReason;
        MaxPointsReason oldMaxPointsReason = leaderboard.getMaxPointsReason(competitor, raceColumn, timePoint);
        if (!Util.equalsWithNull((Object)maxPointsReasonByRaceCommittee, (Object)oldMaxPointsReason)) {
            this.applyMaxPointsReasonOperation(leaderboard, raceColumn, competitor, maxPointsReasonByRaceCommittee, timePoint);
        }
    }

    private void correctScoreInLeaderboardIfNecessary(Leaderboard leaderboard, RaceColumn raceColumn, TimePoint timePoint, int numberOfCompetitorsInRace, Competitor competitor, int rankByRaceCommittee, Double optionalExplicitScore, MaxPointsReason maxPointsReason) {
        Double scoreByRaceCommittee;
        Double d = scoreByRaceCommittee = optionalExplicitScore == null && maxPointsReason != null && maxPointsReason != MaxPointsReason.NONE ? null : this.getScoreFromRaceCommittee(leaderboard, raceColumn, timePoint, numberOfCompetitorsInRace, competitor, rankByRaceCommittee, optionalExplicitScore, maxPointsReason);
        if (!Util.equalsWithNull((Object)leaderboard.getScoreCorrection().getExplicitScoreCorrection(competitor, raceColumn), (Object)scoreByRaceCommittee)) {
            this.applyScoreCorrectionOperation(leaderboard, raceColumn, competitor, scoreByRaceCommittee, timePoint);
        }
    }

    private Double getScoreFromRaceCommittee(Leaderboard leaderboard, RaceColumn raceColumn, TimePoint timePoint, int numberOfCompetitorsInRace, Competitor competitor, int oneBasedRankByRaceCommittee, Double optionalExplicitScore, MaxPointsReason maxPointsReason) {
        Object scoreByRaceCommittee = optionalExplicitScore == null ? (maxPointsReason != null && maxPointsReason != MaxPointsReason.NONE ? null : (leaderboard instanceof RegattaLeaderboard && ((RegattaLeaderboard)leaderboard).getRegatta().getRankingMetricType() != RankingMetrics.ONE_DESIGN ? null : leaderboard.getScoringScheme().getScoreForRank(leaderboard, raceColumn, competitor, oneBasedRankByRaceCommittee, () -> numberOfCompetitorsInRace, leaderboard.getNumberOfCompetitorsInLeaderboardFetcher(), timePoint))) : optionalExplicitScore;
        return scoreByRaceCommittee;
    }

    private void applyScoreCorrectionOperation(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, Double correctedScore, TimePoint timePoint) {
        UpdateLeaderboardScoreCorrection operation = new UpdateLeaderboardScoreCorrection(leaderboard.getName(), raceColumn.getName(), competitor.getId().toString(), correctedScore, timePoint);
        this.service.apply((OperationWithResult)operation);
    }

    private void applyMaxPointsReasonOperation(Leaderboard leaderboard, RaceColumn raceColumn, Competitor competitor, MaxPointsReason reason, TimePoint timePoint) {
        UpdateLeaderboardMaxPointsReason operation = new UpdateLeaderboardMaxPointsReason(leaderboard.getName(), raceColumn.getName(), competitor.getId().toString(), reason, timePoint);
        this.service.apply((OperationWithResult)operation);
    }

    private void applyMetadataUpdate(Leaderboard leaderboard, TimePoint timePointOfLastCorrectionValidity, String comment) {
        UpdateLeaderboardScoreCorrectionMetadata operation = new UpdateLeaderboardScoreCorrectionMetadata(leaderboard.getName(), timePointOfLastCorrectionValidity, comment);
        this.service.apply((OperationWithResult)operation);
    }

    private int getRankInPositioningListByRaceCommittee(CompetitorResult positionedCompetitor) {
        return positionedCompetitor.getOneBasedRank();
    }

    private int getNumberOfCompetitorsInRace(RaceColumn raceColumn, Fleet fleet, int numberOfCompetitorsInLeaderboard) {
        int numberOfCompetitorsInRace = raceColumn.getRaceDefinition(fleet) != null ? Util.size((Iterable)raceColumn.getRaceDefinition(fleet).getCompetitors()) : numberOfCompetitorsInLeaderboard;
        return numberOfCompetitorsInRace;
    }

    public void defaultAction() {
    }
}

