/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.anniversary;

import com.sap.sailing.domain.anniversary.DetailedRaceInfo;
import com.sap.sailing.domain.anniversary.SimpleRaceInfo;
import com.sap.sailing.domain.common.RegattaAndRaceIdentifier;
import com.sap.sailing.domain.common.dto.AnniversaryType;
import com.sap.sailing.server.anniversary.AddAnniversaryOperation;
import com.sap.sailing.server.anniversary.UpdateNextAnniversaryOperation;
import com.sap.sailing.server.anniversary.UpdateRaceCountOperation;
import com.sap.sailing.server.impl.RemoteSailingServerSet;
import com.sap.sailing.server.interfaces.AnniversaryRaceDeterminator;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.replication.OperationWithResult;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class AnniversaryRaceDeterminatorImpl
implements AnniversaryRaceDeterminator {
    private static final Logger logger = Logger.getLogger(AnniversaryRaceDeterminatorImpl.class.getName());
    private final ConcurrentHashMap<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> knownAnniversaries;
    private final CopyOnWriteArrayList<AnniversaryRaceDeterminator.AnniversaryChecker> checkers;
    private final RacingEventService racingEventService;
    private final RemoteSailingServerSet remoteSailingServerSet;
    private final Runnable raceChangedListener;
    private final AtomicBoolean isStarted;
    private volatile Util.Pair<Integer, AnniversaryType> nextAnniversary;
    private volatile int currentRaceCount;
    private final boolean enabled;

    public AnniversaryRaceDeterminatorImpl(RacingEventService racingEventService, RemoteSailingServerSet remoteSailingServerSet, AnniversaryRaceDeterminator.AnniversaryChecker ... checkerToUse) {
        this.racingEventService = racingEventService;
        this.remoteSailingServerSet = remoteSailingServerSet;
        this.knownAnniversaries = new ConcurrentHashMap();
        this.isStarted = new AtomicBoolean(false);
        try {
            this.knownAnniversaries.putAll(racingEventService.getDomainObjectFactory().getAnniversaryData());
        }
        catch (MalformedURLException e) {
            logger.warning("Could not load anniversaries from MongoDb");
        }
        this.checkers = new CopyOnWriteArrayList();
        AnniversaryRaceDeterminator.AnniversaryChecker[] anniversaryCheckerArray = checkerToUse;
        int n = checkerToUse.length;
        int n2 = 0;
        while (n2 < n) {
            AnniversaryRaceDeterminator.AnniversaryChecker toAdd = anniversaryCheckerArray[n2];
            this.checkers.add(toAdd);
            ++n2;
        }
        this.raceChangedListener = this::update;
        this.enabled = Boolean.parseBoolean(System.getProperty("AnniversaryRaceDeterminator.enabled", "false"));
        this.start();
    }

    void update() {
        if (this.isStarted.get()) {
            HashMap<RegattaAndRaceIdentifier, SimpleRaceInfo> allRaces = new HashMap<RegattaAndRaceIdentifier, SimpleRaceInfo>();
            this.remoteSailingServerSet.getCachedRaceList().forEach((remoteServer, result) -> {
                if (result.getB() != null) {
                    logger.warning("Could not update anniversary determinator, because remote server " + remoteServer.getURL() + " returned error " + result.getB());
                } else {
                    ((Iterable)result.getA()).forEach(race -> {
                        SimpleRaceInfo simpleRaceInfo = allRaces.put(race.getIdentifier(), (SimpleRaceInfo)race);
                    });
                }
            });
            this.racingEventService.getLocalRaceList(uuid -> true).values().stream().flatMap(Collection::stream).forEach(race -> {
                SimpleRaceInfo simpleRaceInfo = allRaces.put(race.getIdentifier(), (SimpleRaceInfo)race);
            });
            if (allRaces.size() != this.currentRaceCount) {
                this.checkForNewAnniversaries(allRaces);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForNewAnniversaries(Map<RegattaAndRaceIdentifier, SimpleRaceInfo> races) {
        if (this.isStarted.get()) {
            ArrayList<SimpleRaceInfo> allRaces = new ArrayList<SimpleRaceInfo>(races.values());
            TimePoint now = MillisecondsTimePoint.now();
            allRaces.removeIf(race -> now.before(race.getStartOfRace()));
            Collections.sort(allRaces, new Comparator<SimpleRaceInfo>(){

                @Override
                public int compare(SimpleRaceInfo o1, SimpleRaceInfo o2) {
                    return o1.getStartOfRace().compareTo((Object)o2.getStartOfRace());
                }
            });
            HashMap<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> anniversariesToAdd = new HashMap<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>>();
            Integer nearestNext = null;
            AnniversaryType nearestType = null;
            for (AnniversaryRaceDeterminator.AnniversaryChecker checker : this.checkers) {
                checker.update(allRaces.size());
                for (Integer n : checker.getAnniversaries()) {
                    Util.Pair<DetailedRaceInfo, AnniversaryType> anniversaryData;
                    if (this.knownAnniversaries.containsKey(n) || (anniversaryData = this.resolveAnniversaryData(n, allRaces.get(n - 1), checker.getType())) == null) continue;
                    anniversariesToAdd.put(n, anniversaryData);
                }
                Integer n = checker.getNextAnniversary();
                if (n == null || nearestNext != null && n >= nearestNext) continue;
                nearestNext = n;
                nearestType = checker.getType();
            }
            AnniversaryRaceDeterminatorImpl anniversaryRaceDeterminatorImpl = this;
            synchronized (anniversaryRaceDeterminatorImpl) {
                if (nearestNext != null && (this.nextAnniversary == null || nearestNext > (Integer)this.nextAnniversary.getA())) {
                    this.racingEventService.apply((OperationWithResult)new UpdateNextAnniversaryOperation((Util.Pair<Integer, AnniversaryType>)new Util.Pair((Object)nearestNext, nearestType)));
                }
                boolean requiresPersist = false;
                for (Map.Entry entry : anniversariesToAdd.entrySet()) {
                    Integer anniversary = (Integer)entry.getKey();
                    if (this.knownAnniversaries.containsKey(anniversary)) continue;
                    this.racingEventService.apply((OperationWithResult)new AddAnniversaryOperation(anniversary, (Util.Pair<DetailedRaceInfo, AnniversaryType>)((Util.Pair)entry.getValue())));
                    requiresPersist = true;
                }
                this.racingEventService.apply((OperationWithResult)new UpdateRaceCountOperation(allRaces.size()));
                if (requiresPersist) {
                    this.racingEventService.getMongoObjectFactory().storeAnniversaryData(this.knownAnniversaries);
                }
            }
        }
    }

    private Util.Pair<DetailedRaceInfo, AnniversaryType> resolveAnniversaryData(Integer anniversary, SimpleRaceInfo simpleRaceInfo, AnniversaryType anniversaryType) {
        DetailedRaceInfo fullData = this.racingEventService.getFullDetailsForRaceCascading(simpleRaceInfo.getIdentifier());
        logger.info("Determined new Anniversary! " + anniversary + " - " + simpleRaceInfo + " - " + anniversaryType + " - " + fullData);
        if (fullData == null) {
            logger.severe("Detailed data for anniversary " + anniversary + " - " + simpleRaceInfo + " could not be resolved");
            return null;
        }
        return new Util.Pair((Object)fullData, (Object)anniversaryType);
    }

    public synchronized void addAnniversary(int anniversaryToCheck, Util.Pair<DetailedRaceInfo, AnniversaryType> anniversaryData) {
        this.knownAnniversaries.put(anniversaryToCheck, anniversaryData);
    }

    public synchronized void setNextAnniversary(Util.Pair<Integer, AnniversaryType> nextAnniversary) {
        this.nextAnniversary = nextAnniversary;
    }

    public synchronized void setRaceCount(int raceCount) {
        this.currentRaceCount = raceCount;
    }

    public Util.Pair<Integer, AnniversaryType> getNextAnniversary() {
        return this.nextAnniversary;
    }

    public Map<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> getKnownAnniversaries() {
        return new HashMap<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>>(this.knownAnniversaries);
    }

    public synchronized void setKnownAnniversaries(Map<Integer, Util.Pair<DetailedRaceInfo, AnniversaryType>> anniversaries) {
        this.knownAnniversaries.clear();
        if (anniversaries != null) {
            this.knownAnniversaries.putAll(anniversaries);
        }
    }

    public int getCurrentRaceCount() {
        return this.currentRaceCount;
    }

    public void start() {
        logger.config("system property AnniversaryRaceDeterminator.enabled is " + this.enabled);
        this.isStarted.set(this.enabled);
        if (this.enabled) {
            this.remoteSailingServerSet.addRemoteRaceResultReceivedCallback(this.raceChangedListener);
        }
    }

    public synchronized void clearAndStop() {
        this.isStarted.set(false);
        this.remoteSailingServerSet.removeRemoteRaceResultReceivedCallback(this.raceChangedListener);
        this.clear();
    }

    public synchronized void clear() {
        this.knownAnniversaries.clear();
        this.nextAnniversary = null;
        this.currentRaceCount = 0;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

