/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.windfinderadapter.impl;

import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceWithAdditionalID;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.domain.tracking.WindTracker;
import com.sap.sailing.domain.windfinder.ReviewedSpotsCollection;
import com.sap.sailing.domain.windfinder.Spot;
import com.sap.sailing.domain.windfinder.WindFinderSpotListener;
import com.sap.sailing.domain.windfinderadapter.impl.WindFinderTrackerFactoryImpl;
import com.sap.sse.common.TimePoint;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutionException;
import org.json.simple.parser.ParseException;

public class WindFinderWindTracker
implements WindTracker,
WindFinderSpotListener {
    private final DynamicTrackedRace trackedRace;
    private final WindFinderTrackerFactoryImpl factory;
    private WeakHashMap<Spot, TimePoint> timePointOfLastMeasurement;
    private final Iterable<Spot> spots;

    public WindFinderWindTracker(DynamicTrackedRace trackedRace, WindFinderTrackerFactoryImpl factory) throws InterruptedException, ExecutionException, MalformedURLException, IOException, ParseException {
        this.trackedRace = trackedRace;
        this.factory = factory;
        this.timePointOfLastMeasurement = new WeakHashMap();
        this.spots = this.subscribeToUsefulSpots();
    }

    public void windDataReceived(Iterable<Wind> windFixes, Spot spot) {
        WindSourceWithAdditionalID windSource = new WindSourceWithAdditionalID(WindSourceType.WINDFINDER, spot.getId());
        WindTrack windTrack = this.trackedRace.getOrCreateWindTrack((WindSource)windSource);
        for (Wind wind : windFixes) {
            Wind existingFix;
            Wind wind2 = existingFix = windTrack == null ? null : (Wind)windTrack.getFirstRawFixAtOrAfter(wind.getTimePoint());
            if (existingFix != null && existingFix.getTimePoint().equals(wind.getTimePoint())) continue;
            this.trackedRace.recordWind(wind, (WindSource)windSource);
            if (this.timePointOfLastMeasurement.containsKey(spot) && !wind.getTimePoint().after(this.timePointOfLastMeasurement.get(spot))) continue;
            this.timePointOfLastMeasurement.put(spot, wind.getTimePoint());
        }
    }

    public Iterable<Spot> subscribeToUsefulSpots() throws MalformedURLException, IOException, ParseException, InterruptedException, ExecutionException {
        HashSet<Spot> result = new HashSet<Spot>();
        for (ReviewedSpotsCollection spotCollection : this.factory.getReviewedSpotsCollections(this.trackedRace.getTrackedRegatta().getRegatta().getRegattaIdentifier())) {
            for (Spot spot : spotCollection.getSpots(true)) {
                result.add(spot);
                spot.addListener((WindFinderSpotListener)this);
            }
        }
        return result;
    }

    public void stop() {
        for (Spot spot : this.spots) {
            spot.removeListener((WindFinderSpotListener)this);
        }
        this.factory.trackerStopped(this.trackedRace.getRace());
    }
}

