/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.windfinderadapter.impl;

import com.sap.sailing.domain.base.RaceDefinition;
import com.sap.sailing.domain.common.RegattaIdentifier;
import com.sap.sailing.domain.common.WindFinderReviewedSpotsCollectionIdProvider;
import com.sap.sailing.domain.tracking.DynamicTrackedRace;
import com.sap.sailing.domain.tracking.DynamicTrackedRegatta;
import com.sap.sailing.domain.tracking.WindTracker;
import com.sap.sailing.domain.windfinder.ReviewedSpotsCollection;
import com.sap.sailing.domain.windfinder.Spot;
import com.sap.sailing.domain.windfinder.WindFinderTrackerFactory;
import com.sap.sailing.domain.windfinderadapter.impl.Activator;
import com.sap.sailing.domain.windfinderadapter.impl.ReviewedSpotsCollectionImpl;
import com.sap.sailing.domain.windfinderadapter.impl.WindFinderWindTracker;
import com.sap.sse.common.Util;
import com.sap.sse.security.SecurityService;
import com.sap.sse.util.ServiceTrackerFactory;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.parser.ParseException;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;

public class WindFinderTrackerFactoryImpl
implements WindFinderTrackerFactory {
    private static final Logger logger = Logger.getLogger(WindFinderTrackerFactoryImpl.class.getName());
    private final Map<RaceDefinition, WindTracker> windTrackerPerRace = new HashMap<RaceDefinition, WindTracker>();
    private final Future<ConcurrentMap<String, ReviewedSpotsCollection>> reviewedSpotsCollectionsByIdCache;
    private Set<ReviewedSpotsCollection> reviewedSpotsCollections;
    private final ServiceTracker<WindFinderReviewedSpotsCollectionIdProvider, WindFinderReviewedSpotsCollectionIdProvider> reviewedSpotsCollectionIdProvider;
    private final ScheduledExecutorService executor = ThreadPoolUtil.INSTANCE.getDefaultBackgroundTaskThreadPoolExecutor();

    public WindFinderTrackerFactoryImpl() {
        this.reviewedSpotsCollections = Collections.synchronizedSet(new HashSet());
        if (Activator.getContext() != null) {
            this.reviewedSpotsCollectionIdProvider = ServiceTrackerFactory.createAndOpen((BundleContext)Activator.getContext(), WindFinderReviewedSpotsCollectionIdProvider.class);
            this.reviewedSpotsCollectionsByIdCache = this.executor.schedule(() -> {
                ConcurrentHashMap<String, ReviewedSpotsCollection> result = new ConcurrentHashMap<String, ReviewedSpotsCollection>();
                try {
                    for (ReviewedSpotsCollection c : this.loadAllSpotCollectionsFromProvider(false)) {
                        result.put(c.getId(), c);
                    }
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Problem loading WindFinder spot collections", e);
                }
                return result;
            }, 0L, TimeUnit.MILLISECONDS);
        } else {
            this.reviewedSpotsCollectionIdProvider = null;
            final ConcurrentHashMap cache = new ConcurrentHashMap();
            this.reviewedSpotsCollectionsByIdCache = new Future<ConcurrentMap<String, ReviewedSpotsCollection>>(){

                @Override
                public boolean cancel(boolean mayInterruptIfRunning) {
                    return true;
                }

                @Override
                public boolean isCancelled() {
                    return false;
                }

                @Override
                public boolean isDone() {
                    return true;
                }

                @Override
                public ConcurrentMap<String, ReviewedSpotsCollection> get() {
                    return cache;
                }

                @Override
                public ConcurrentMap<String, ReviewedSpotsCollection> get(long timeout, TimeUnit unit) {
                    return cache;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindTracker createWindTracker(DynamicTrackedRegatta trackedRegatta, RaceDefinition race, boolean correctByDeclination, SecurityService optionalSecurityService) throws Exception {
        WindTracker result;
        DynamicTrackedRace trackedRace = trackedRegatta.getTrackedRace(race);
        Map<RaceDefinition, WindTracker> map = this.windTrackerPerRace;
        synchronized (map) {
            WindTracker existingWindTrackerForRace = this.getExistingWindTracker(race);
            if (existingWindTrackerForRace == null) {
                result = new WindFinderWindTracker(trackedRace, this);
                this.windTrackerPerRace.put(race, result);
            } else {
                result = existingWindTrackerForRace;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WindTracker getExistingWindTracker(RaceDefinition race) {
        Map<RaceDefinition, WindTracker> map = this.windTrackerPerRace;
        synchronized (map) {
            return this.windTrackerPerRace.get(race);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void trackerStopped(RaceDefinition race) {
        Map<RaceDefinition, WindTracker> map = this.windTrackerPerRace;
        synchronized (map) {
            this.windTrackerPerRace.remove(race);
        }
    }

    public Iterable<ReviewedSpotsCollection> getReviewedSpotsCollections(RegattaIdentifier regattaIdentifier) throws InterruptedException, ExecutionException {
        WindFinderReviewedSpotsCollectionIdProvider provider;
        HashSet<ReviewedSpotsCollection> result = new HashSet<ReviewedSpotsCollection>();
        result.addAll(this.reviewedSpotsCollections);
        if (this.reviewedSpotsCollectionIdProvider != null && (provider = (WindFinderReviewedSpotsCollectionIdProvider)this.reviewedSpotsCollectionIdProvider.getService()) != null) {
            for (String id : provider.getWindFinderReviewedSpotsCollectionIdsByRegatta(regattaIdentifier)) {
                result.add(this.getReviewedSpotsCollectionById(id, true));
            }
        }
        return result;
    }

    public Iterable<ReviewedSpotsCollection> getAllReviewedSpotsCollections(boolean cached) throws InterruptedException, ExecutionException {
        HashSet<ReviewedSpotsCollection> result = new HashSet<ReviewedSpotsCollection>();
        if (cached) {
            result.addAll(this.reviewedSpotsCollectionsByIdCache.get().values());
        } else {
            result.addAll(this.reviewedSpotsCollections);
            Util.addAll(this.loadAllSpotCollectionsFromProvider(true), result);
            for (ReviewedSpotsCollection c : result) {
                this.reviewedSpotsCollectionsByIdCache.get().putIfAbsent(c.getId(), c);
            }
        }
        return result;
    }

    private Iterable<ReviewedSpotsCollection> loadAllSpotCollectionsFromProvider(boolean lookupInCache) throws InterruptedException, ExecutionException {
        WindFinderReviewedSpotsCollectionIdProvider provider;
        HashSet<ReviewedSpotsCollection> result = new HashSet<ReviewedSpotsCollection>();
        if (this.reviewedSpotsCollectionIdProvider != null && (provider = (WindFinderReviewedSpotsCollectionIdProvider)this.reviewedSpotsCollectionIdProvider.getService()) != null) {
            for (String id : provider.getAllWindFinderReviewedSpotsCollectionIds()) {
                result.add(this.getReviewedSpotsCollectionById(id, lookupInCache));
            }
        }
        return result;
    }

    public ReviewedSpotsCollection getReviewedSpotsCollectionById(String spotsCollectionId, boolean lookupInCache) throws InterruptedException, ExecutionException {
        ReviewedSpotsCollectionImpl result;
        if (!lookupInCache || (result = (ReviewedSpotsCollection)this.reviewedSpotsCollectionsByIdCache.get().get(spotsCollectionId)) == null) {
            ReviewedSpotsCollectionImpl finalResult;
            result = finalResult = new ReviewedSpotsCollectionImpl(spotsCollectionId);
            this.executor.schedule(() -> this.reviewedSpotsCollectionsByIdCache.get().put(spotsCollectionId, finalResult), 0L, TimeUnit.MILLISECONDS);
        }
        return result;
    }

    public Spot getSpotById(String spotId, boolean cached) throws MalformedURLException, IOException, ParseException, InterruptedException, ExecutionException {
        Spot result = null;
        block0: for (ReviewedSpotsCollection coll : this.getAllReviewedSpotsCollections(cached)) {
            for (Spot spot : coll.getSpots(cached)) {
                if (!Util.equalsWithNull((Object)spot.getId(), (Object)spotId)) continue;
                result = spot;
                continue block0;
            }
        }
        return result;
    }

    public void addReviewedSpotCollection(ReviewedSpotsCollection collection) throws InterruptedException, ExecutionException {
        this.reviewedSpotsCollections.add(collection);
        this.reviewedSpotsCollectionsByIdCache.get().put(collection.getId(), collection);
    }

    public void removeReviewedSpotCollection(ReviewedSpotsCollection collection) throws InterruptedException, ExecutionException {
        this.reviewedSpotsCollections.remove(collection);
        this.reviewedSpotsCollectionsByIdCache.get().remove(collection.getId());
    }
}

