/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.windfinderadapter.impl;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.windfinder.ReviewedSpotsCollection;
import com.sap.sailing.domain.windfinder.Spot;
import com.sap.sailing.domain.windfinderadapter.impl.SpotImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class WindFinderReportParser {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssX");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Wind parse(Position position, JSONObject jsonOfSingleMeasurement) throws NumberFormatException, ParseException {
        WindImpl result;
        if (jsonOfSingleMeasurement.get((Object)"dtl") != null && jsonOfSingleMeasurement.get((Object)"ws") != null && jsonOfSingleMeasurement.get((Object)"wd") != null) {
            Date date;
            DateFormat dateFormat = this.dateFormat;
            synchronized (dateFormat) {
                date = this.dateFormat.parse(jsonOfSingleMeasurement.get((Object)"dtl").toString());
            }
            result = new WindImpl(position, (TimePoint)new MillisecondsTimePoint(date), (SpeedWithBearing)new KnotSpeedWithBearingImpl(Double.parseDouble(jsonOfSingleMeasurement.get((Object)"ws").toString()), new DegreeBearingImpl(Double.parseDouble(jsonOfSingleMeasurement.get((Object)"wd").toString())).reverse()));
        } else {
            result = null;
        }
        return result;
    }

    Iterable<Wind> parse(Position position, JSONArray jsonOfSeveralMeasurements) throws NumberFormatException, ParseException {
        ArrayList<Wind> result = new ArrayList<Wind>();
        for (Object jsonOfSingleMeasurement : jsonOfSeveralMeasurements) {
            Wind wind = this.parse(position, (JSONObject)jsonOfSingleMeasurement);
            if (wind == null) continue;
            result.add(wind);
        }
        return result;
    }

    Spot parseSpot(JSONObject jsonOfSingleSpot, ReviewedSpotsCollection reviewedSpotsCollection) {
        return new SpotImpl(jsonOfSingleSpot.get((Object)"n").toString(), jsonOfSingleSpot.get((Object)"id").toString(), jsonOfSingleSpot.get((Object)"kw").toString(), jsonOfSingleSpot.get((Object)"c") == null ? null : jsonOfSingleSpot.get((Object)"c").toString(), (Position)new DegreePosition(((Number)jsonOfSingleSpot.get((Object)"lat")).doubleValue(), ((Number)jsonOfSingleSpot.get((Object)"lon")).doubleValue()), this, reviewedSpotsCollection);
    }

    Iterable<Spot> parseSpots(JSONArray jsonOfMultipleSpots, ReviewedSpotsCollection reviewedSpotsCollection) {
        return Util.map((Iterable)jsonOfMultipleSpots, jsonOfSingleSpot -> this.parseSpot((JSONObject)jsonOfSingleSpot, reviewedSpotsCollection));
    }
}

