/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.windfinderadapter.impl;

import com.sap.sailing.domain.windfinder.ReviewedSpotsCollection;
import com.sap.sailing.domain.windfinder.Spot;
import com.sap.sailing.domain.windfinderadapter.impl.WindFinderReportParser;
import com.sap.sse.common.Duration;
import com.sap.sse.common.util.BackoffTracker;
import com.sap.sse.util.HttpUrlConnectionHelper;
import com.sap.sse.util.ThreadPoolUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ReviewedSpotsCollectionImpl
implements ReviewedSpotsCollection {
    private static final Logger logger = Logger.getLogger(ReviewedSpotsCollectionImpl.class.getName());
    private static final String SPOT_LIST_DOCUMENT_SUFFIX = "_nearby.json";
    private final String id;
    private final WindFinderReportParser parser;
    private Future<ConcurrentMap<String, Spot>> spotsByIdCache;
    private BackoffTracker backoffTracker;

    public ReviewedSpotsCollectionImpl(String id) {
        this.id = id;
        this.parser = new WindFinderReportParser();
        this.backoffTracker = new BackoffTracker(Duration.ONE_SECOND.times(5L), 2);
        this.spotsByIdCache = ThreadPoolUtil.INSTANCE.getDefaultForegroundTaskThreadPoolExecutor().schedule(() -> {
            ConcurrentHashMap<String, Spot> result = new ConcurrentHashMap<String, Spot>();
            for (Spot spot : this.loadSpots()) {
                result.put(spot.getId(), spot);
            }
            return result;
        }, 0L, TimeUnit.MILLISECONDS);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReviewedSpotsCollectionImpl other = (ReviewedSpotsCollectionImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String getId() {
        return this.id;
    }

    public Iterable<Spot> getSpots(boolean cached) throws MalformedURLException, IOException, ParseException, InterruptedException, ExecutionException {
        Iterable<Spot> result;
        if (cached && !this.spotsByIdCache.get().isEmpty()) {
            result = new HashSet(this.spotsByIdCache.get().values());
        } else {
            result = this.loadSpots();
            for (Spot spot : result) {
                this.spotsByIdCache.get().put(spot.getId(), spot);
            }
        }
        return result;
    }

    private Iterable<Spot> loadSpots() {
        Iterable<Spot> result = Collections.emptySet();
        if (!this.backoffTracker.backOff()) {
            try {
                URLConnection connection = HttpUrlConnectionHelper.redirectConnection((URL)new URL("http://external.windfinder.com/sap/" + this.getId() + SPOT_LIST_DOCUMENT_SUFFIX), (Duration)Duration.ONE_SECOND.times(10L), null);
                Charset charset = HttpUrlConnectionHelper.getCharsetFromConnectionOrDefault((URLConnection)connection, (String)"UTF-8");
                try {
                    Throwable throwable = null;
                    Object var5_8 = null;
                    try (InputStreamReader in = new InputStreamReader((InputStream)connection.getContent(), charset);){
                        JSONArray spotsAsJson = (JSONArray)new JSONParser().parse((Reader)in);
                        result = this.parser.parseSpots(spotsAsJson, this);
                        this.backoffTracker.clear();
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | ParseException e) {
                    logger.log(Level.SEVERE, "Problem loading spots for spot collection " + this.id, e);
                    this.backoffTracker.logFailure();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Problem loading spots for spot collection " + this.id, e);
                this.backoffTracker.logFailure();
            }
        }
        return result;
    }

    public String toString() {
        return "WindFinder Reviewed Spots Collection [id=" + this.id + "]";
    }
}

