/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.branding.impl;

import com.sap.sse.branding.BrandingConfigurationService;
import com.sap.sse.branding.shared.BrandingConfiguration;
import com.sap.sse.common.Util;
import com.sap.sse.util.ServiceTrackerFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Logger;
import org.json.simple.JSONObject;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class BrandingConfigurationServiceImpl
implements BrandingConfigurationService,
ServiceTrackerCustomizer<BrandingConfiguration, BrandingConfiguration> {
    private static final Logger logger = Logger.getLogger(BrandingConfigurationServiceImpl.class.getName());
    private final ServiceTracker<BrandingConfiguration, BrandingConfiguration> brandingConfigurationTracker;
    private final BundleContext bundleContext;
    private final ConcurrentMap<Util.Pair<String, String>, Map<String, Object>> brandingConfigurationsByIdAndLocale;
    private BrandingConfiguration activeBrandingConfiguration;
    private Filter filterForActiveBrandingConfigurationId;

    public BrandingConfigurationServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.brandingConfigurationTracker = ServiceTrackerFactory.createAndOpen((BundleContext)bundleContext, BrandingConfiguration.class, (ServiceTrackerCustomizer)this);
        this.brandingConfigurationsByIdAndLocale = new ConcurrentHashMap<Util.Pair<String, String>, Map<String, Object>>();
    }

    BrandingConfigurationServiceImpl(BundleContext bundleContext, ServiceTracker<BrandingConfiguration, BrandingConfiguration> brandingConfigurationTracker) {
        this.bundleContext = bundleContext;
        this.brandingConfigurationTracker = brandingConfigurationTracker;
        this.brandingConfigurationsByIdAndLocale = new ConcurrentHashMap<Util.Pair<String, String>, Map<String, Object>>();
    }

    @Override
    public boolean isBrandingActive() {
        return this.activeBrandingConfiguration != null;
    }

    @Override
    public BrandingConfiguration setActiveBrandingConfigurationById(String brandingConfigurationId) {
        this.filterForActiveBrandingConfigurationId = this.createFilterForBrandingConfigurationId(brandingConfigurationId);
        BrandingConfiguration brandingConfiguration = this.filterForActiveBrandingConfigurationId == null ? null : (this.activeBrandingConfiguration = this.brandingConfigurationTracker.getServiceReferences() == null ? null : (BrandingConfiguration)Arrays.asList(this.brandingConfigurationTracker.getServiceReferences()).stream().filter(ref -> this.filterForActiveBrandingConfigurationId.match(ref.getProperties())).findFirst().map(ref -> (BrandingConfiguration)this.brandingConfigurationTracker.getService(ref)).orElse(null));
        if (this.activeBrandingConfiguration == null) {
            logger.warning("Couldn't find a branding configuration with ID " + brandingConfigurationId + " in the OSGi service registry. Branding is effectively deactivated.");
        } else {
            logger.info("Found active branding configuration: " + this.activeBrandingConfiguration.getId() + " with object ID " + System.identityHashCode(this.activeBrandingConfiguration));
        }
        return this.activeBrandingConfiguration;
    }

    private Filter createFilterForBrandingConfigurationId(String brandingConfigurationId) {
        try {
            return brandingConfigurationId == null ? null : this.bundleContext.createFilter(String.format("(&(%s=%s)(%s=%s))", "com.sap.sse.branding", brandingConfigurationId, "objectClass", BrandingConfiguration.class.getName()));
        }
        catch (InvalidSyntaxException e) {
            throw new RuntimeException("Internal error: Invalid filter syntax for BrandingConfigurationService", e);
        }
    }

    @Override
    public BrandingConfiguration getActiveBrandingConfiguration() {
        return this.activeBrandingConfiguration;
    }

    @Override
    public Map<BrandingConfigurationService.BrandingConfigurationProperty, Object> getBrandingConfigurationProperties(Optional<String> locale) {
        String whitelabeled;
        String title;
        BrandingConfiguration brandingConfiguration = this.getActiveBrandingConfiguration();
        HashMap<BrandingConfigurationService.BrandingConfigurationProperty, Object> map = new HashMap<BrandingConfigurationService.BrandingConfigurationProperty, Object>();
        if (brandingConfiguration != null) {
            title = String.valueOf(brandingConfiguration.getBrandTitle(locale)) + " ";
            whitelabeled = "";
        } else {
            title = "";
            whitelabeled = "-whitelabeled";
        }
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.BRAND_TITLE_WITH_TRAILING_SPACE_JSP_PROPERTY_NAME, title);
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SOLUTIONS_IN_SAILING_IMAGE_URL, brandingConfiguration == null ? "" : brandingConfiguration.getSolutionsInSailingImageURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SOLUTIONS_IN_SAILING_TRIMMED_IMAGE_URL, brandingConfiguration == null ? "" : brandingConfiguration.getSoutionsInSailingTrimmedImageURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SAILING_RACE_MANAGER_APP_TRIMMED_IMAGE_URL, brandingConfiguration == null ? "" : brandingConfiguration.getSailingRaceManagerAppTrimmedImageURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SAILING_RACE_MANAGER_APP_IMAGE_URL, brandingConfiguration == null ? "" : brandingConfiguration.getSailingRaceManagerAppImageURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SAIL_IN_SIGHT_APP_IMAGE_URL, brandingConfiguration == null ? "" : brandingConfiguration.getSailInSightAppImageURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SAILING_SIMULATOR_IMAGE_URL, brandingConfiguration == null ? "" : brandingConfiguration.getSailingSimulatorImageURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SAILING_SIMULATOR_TRIMMED_IMAGE_URL, brandingConfiguration == null ? "" : brandingConfiguration.getSailingSimulatorTrimmedImageURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SAIL_IN_SIGHT_APP_IMAGE_URL, brandingConfiguration == null ? "" : brandingConfiguration.getSailInSightAppImageURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.BUOY_PINGER_APP_IMAGE_URL, brandingConfiguration == null ? "" : brandingConfiguration.getBuoyPingerAppImageURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SAILING_ANALYTICS_IMAGE_URL, brandingConfiguration == null ? "" : brandingConfiguration.getSailingAnalyticsImageURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.FOOTER_COPYRIGHT, brandingConfiguration == null ? "" : brandingConfiguration.getFooterCopyright());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.FOOTER_PRIVACY_LINK, brandingConfiguration == null ? "" : brandingConfiguration.getFooterPrivacyLink());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.FOOTER_JOBS_LINK, brandingConfiguration == null ? "" : brandingConfiguration.getFooterJobsLink());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.FOOTER_SUPPORT_LINK, brandingConfiguration == null ? "" : brandingConfiguration.getFooterSupportLink());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.MORE_LOGIN_INFORMATION_SIMULATOR_URL, brandingConfiguration == null ? "" : brandingConfiguration.getMoreLoginInformationSimulatorURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.MORE_LOGIN_INFORMATION_SAILOR_PROFILES_URL, brandingConfiguration == null ? "" : brandingConfiguration.getMoreLoginInformationSailorProfilesURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.MORE_LOGIN_INFORMATION_SETTINGS_URL, brandingConfiguration == null ? "" : brandingConfiguration.getMoreLoginInformationSettingsURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.MORE_LOGIN_INFORMATION_NOTIFICATIONS_URL, brandingConfiguration == null ? "" : brandingConfiguration.getMoreLoginInformationNotificationsURL());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SAILING_ANALYTICS_READ_MORE_TEXT, brandingConfiguration == null ? "" : brandingConfiguration.getSailingAnalyticsReadMoreText(locale));
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SPORTS_ON, brandingConfiguration == null ? "" : brandingConfiguration.getSportsOn(locale));
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.FOLLOW_SPORTS, brandingConfiguration == null ? "" : brandingConfiguration.getFollowSports(locale));
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.X_LINK, brandingConfiguration == null ? "" : brandingConfiguration.getxLink());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.FACEBOOK_LINK, brandingConfiguration == null ? "" : brandingConfiguration.getFacebookLink());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.INSTAGRAM_LINK, brandingConfiguration == null ? "" : brandingConfiguration.getInstagramLink());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SAILING_ANALYTICS_SAILING, brandingConfiguration == null ? "" : brandingConfiguration.getSailingAnalyticsSailing(locale));
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.WELCOME_TO_SAILING_ANALYTICS, brandingConfiguration == null ? "" : brandingConfiguration.getWelcomeToSailingAnalytics(locale));
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.WELCOME_TO_SAILING_ANALYTICS_BODY, brandingConfiguration == null ? "" : brandingConfiguration.getWelcomeToSailingAnalyticsBody(locale));
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.FOLLOW_GITHUB, brandingConfiguration == null ? "" : brandingConfiguration.getFollowGitHub(locale));
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.GITHUB_LINK, brandingConfiguration == null ? "" : brandingConfiguration.getGitHubLink());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.DEBRANDING_ACTIVE_JSP_PROPERTY_NAME, !this.isBrandingActive());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.BRANDING_ACTIVE_JSP_PROPERTY_NAME, this.isBrandingActive());
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.DASH_WHITELABELED_JSP_PROPERTY_NAME, whitelabeled);
        map.put(BrandingConfigurationService.BrandingConfigurationProperty.SCRIPT_FOR_CLIENT_CONFIGURATION_CONTEXT_TO_DOCUMENT_JSP_PROPERTY_NAME, this.generateScriptForClientConfigurationContext(map));
        return map;
    }

    @Override
    public Map<String, Object> getBrandingConfigurationPropertiesForJspContext(Optional<String> locale) {
        return this.brandingConfigurationsByIdAndLocale.computeIfAbsent((Util.Pair<String, String>)new Util.Pair((Object)locale.orElse(null), this.isBrandingActive() ? this.getActiveBrandingConfiguration().getId() : null), key -> this.computeBrandingConfigurationProperties(locale));
    }

    private Map<String, Object> computeBrandingConfigurationProperties(Optional<String> requestLocale) {
        HashMap<String, Object> brandingProperties = new HashMap<String, Object>();
        this.getBrandingConfigurationProperties(requestLocale).forEach((k, v) -> brandingProperties.put(k.getPropertyName(), v));
        return brandingProperties;
    }

    private Object generateScriptForClientConfigurationContext(Map<BrandingConfigurationService.BrandingConfigurationProperty, Object> map) {
        StringBuilder scriptBuilder = new StringBuilder();
        scriptBuilder.append("document.clientConfigurationContext=");
        JSONObject jsonObject = new JSONObject();
        for (Map.Entry<BrandingConfigurationService.BrandingConfigurationProperty, Object> brandingConfigurationPropertyAndValue : map.entrySet()) {
            jsonObject.put((Object)brandingConfigurationPropertyAndValue.getKey().getPropertyName(), brandingConfigurationPropertyAndValue.getValue());
        }
        scriptBuilder.append(jsonObject.toJSONString());
        scriptBuilder.append(";");
        return scriptBuilder.toString();
    }

    public BrandingConfiguration addingService(ServiceReference<BrandingConfiguration> reference) {
        BrandingConfiguration service = this.evictCachedPropertiesForBrandingServiceReference(reference);
        logger.info("Adding branding configuration service with ID: " + reference.getProperty("com.sap.sse.branding") + " and object ID " + System.identityHashCode(service));
        if (service != null && this.filterForActiveBrandingConfigurationId != null && this.filterForActiveBrandingConfigurationId.match(reference)) {
            logger.info("Added branding configuration service with ID " + reference.getProperty("com.sap.sse.branding") + " is selected as the active one.");
            this.activeBrandingConfiguration = service;
        }
        return service;
    }

    private BrandingConfiguration evictCachedPropertiesForBrandingServiceReference(ServiceReference<BrandingConfiguration> reference) {
        String brandingId = (String)reference.getProperty("com.sap.sse.branding");
        BrandingConfiguration service = (BrandingConfiguration)this.bundleContext.getService(reference);
        Iterator i = this.brandingConfigurationsByIdAndLocale.keySet().iterator();
        while (i.hasNext()) {
            Util.Pair cachedProperties = (Util.Pair)i.next();
            if (!Util.equalsWithNull((Object)cachedProperties.getB(), (Object)brandingId)) continue;
            logger.info("Removing cached branding properties from service with ID: " + brandingId + " and object ID " + System.identityHashCode(service));
            i.remove();
        }
        return service;
    }

    public void modifiedService(ServiceReference<BrandingConfiguration> reference, BrandingConfiguration service) {
        this.evictCachedPropertiesForBrandingServiceReference(reference);
        logger.info("Modified branding configuration service with ID: " + reference.getProperty("com.sap.sse.branding") + " and object ID " + System.identityHashCode(service));
        if (service != null && this.filterForActiveBrandingConfigurationId != null && this.filterForActiveBrandingConfigurationId.match(reference)) {
            logger.info("Modified branding configuration service with ID " + reference.getProperty("com.sap.sse.branding") + ", updating active branding configuration.");
            this.activeBrandingConfiguration = service;
        }
    }

    public void removedService(ServiceReference<BrandingConfiguration> reference, BrandingConfiguration service) {
        this.evictCachedPropertiesForBrandingServiceReference(reference);
        logger.info("Removed branding configuration service with ID: " + reference.getProperty("com.sap.sse.branding") + " and object ID " + System.identityHashCode(service));
        if (service == this.activeBrandingConfiguration) {
            logger.info("The active branding configuration service with ID " + reference.getProperty("com.sap.sse.branding") + " was removed, setting active branding configuration to null.");
            this.activeBrandingConfiguration = null;
        }
    }
}

