/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.common.impl.WindSourceImpl;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindTrack;
import com.sap.sailing.server.gateway.serialization.impl.WindTrackJsonSerializer;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class TrackedRaceJsonSerializer
implements JsonSerializer<TrackedRace> {
    public static final String FIELD_ID = "id";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_REGATTA = "regatta";
    public static final String FIELD_WINDSOURCES = "windSources";
    public static final String ALL_WINDSOURCES = "ALL";
    private final String windSourceToSerialize;
    private final String windSourceIdToSerialize;
    private final Function<WindSource, WindTrackJsonSerializer> windTrackSerializerProducer;

    public TrackedRaceJsonSerializer(Function<WindSource, WindTrackJsonSerializer> windTrackSerializer, String windSourceToSerialize, String windSourceIdToSerialize) {
        this.windTrackSerializerProducer = windTrackSerializer;
        this.windSourceToSerialize = windSourceToSerialize;
        this.windSourceIdToSerialize = windSourceIdToSerialize;
        windSourceToSerialize = WindSourceType.COMBINED.name();
    }

    public JSONObject serialize(TrackedRace trackedRace) {
        JSONObject jsonRace = new JSONObject();
        jsonRace.put((Object)FIELD_NAME, (Object)trackedRace.getRace().getName());
        jsonRace.put((Object)FIELD_REGATTA, (Object)trackedRace.getRaceIdentifier().getRegattaName());
        if (this.windTrackSerializerProducer != null) {
            JSONArray windTracks = new JSONArray();
            List<WindSource> windSources = this.getAvailableWindSources(trackedRace);
            JSONArray jsonWindSourcesDisplayed = new JSONArray();
            for (WindSource windSource : windSources) {
                JSONObject windSourceInformation = new JSONObject();
                windSourceInformation.put((Object)"typeName", (Object)windSource.getType().name());
                windSourceInformation.put((Object)FIELD_ID, (Object)(windSource.getId() != null ? windSource.getId().toString() : ""));
                jsonWindSourcesDisplayed.add((Object)windSourceInformation);
            }
            jsonRace.put((Object)"availableWindSources", (Object)jsonWindSourcesDisplayed);
            for (WindSource windSource : windSources) {
                if (!ALL_WINDSOURCES.equals(this.windSourceToSerialize) && !windSource.getType().name().equalsIgnoreCase(this.windSourceToSerialize) || this.windSourceIdToSerialize != null && windSource.getId() != null && !windSource.getId().toString().equalsIgnoreCase(this.windSourceIdToSerialize)) continue;
                WindTrack windTrack = trackedRace.getOrCreateWindTrack(windSource);
                JSONObject jsonWindTrack = this.windTrackSerializerProducer.apply(windSource).serialize(windTrack);
                windTracks.add((Object)jsonWindTrack);
            }
            jsonRace.put((Object)FIELD_WINDSOURCES, (Object)windTracks);
        }
        return jsonRace;
    }

    private List<WindSource> getAvailableWindSources(TrackedRace trackedRace) {
        ArrayList<WindSource> windSources = new ArrayList<WindSource>();
        for (WindSource windSource : trackedRace.getWindSources()) {
            windSources.add(windSource);
        }
        for (WindSource windSourceToExclude : trackedRace.getWindSourcesToExclude()) {
            windSources.remove(windSourceToExclude);
        }
        windSources.add((WindSource)new WindSourceImpl(WindSourceType.COMBINED));
        for (WindSource trackedLegMiddleWindSource : trackedRace.getWindSources(WindSourceType.LEG_MIDDLE)) {
            windSources.add(trackedLegMiddleWindSource);
        }
        return windSources;
    }
}

