/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.Boat;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Series;
import com.sap.sse.common.Util;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.Collection;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class RegattaJsonSerializer
implements JsonSerializer<Regatta> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_BOATCLASS = "boatclass";
    public static final String FIELD_START_DATE = "startDate";
    public static final String FIELD_END_DATE = "endDate";
    public static final String FIELD_SCORINGSYSTEM = "scoringSystem";
    public static final String FIELD_RANKINGMETRIC = "rankingMetric";
    public static final String FIELD_SERIES = "series";
    public static final String FIELD_COMPETITORS = "competitors";
    public static final String FIELD_BOATS = "boats";
    public static final String FIELD_TRACKED_RACES = "trackedRaces";
    public static final String FIELD_COURSE_AREA_IDS = "courseAreaIds";
    public static final String FIELD_CAN_BOATS_OF_COMPETITORS_CHANGE_PER_RACE = "canBoatsOfCompetitorsChangePerRace";
    public static final String FIELD_COMPETITOR_REGISTRATION_TYPE = "competitorRegistrationType";
    public static final String FIELD_USE_START_TIME_INFERENCE = "useStartTimeInference";
    public static final String FIELD_CONTROL_TRACKING_FROM_START_AND_FINISH_TIMES = "controlTrackingFromStartAndFinishTimes";
    public static final String FIELD_AUTO_RESTART_TRACKING_UPON_COMPETITOR_SET_CHANGE = "autoRestartTrackingUponCompetitorSetChange";
    private final JsonSerializer<Series> seriesSerializer;
    private final JsonSerializer<Competitor> competitorSerializer;
    private final JsonSerializer<Boat> boatSerializer;
    private final SecurityService securityService;

    public RegattaJsonSerializer(SecurityService securityService) {
        this(null, null, null, securityService);
    }

    public RegattaJsonSerializer(JsonSerializer<Series> seriesSerializer, JsonSerializer<Competitor> competitorSerializer, JsonSerializer<Boat> boatSerializer, SecurityService securityService) {
        this.seriesSerializer = seriesSerializer;
        this.competitorSerializer = competitorSerializer;
        this.boatSerializer = boatSerializer;
        this.securityService = securityService;
    }

    public JSONObject serialize(Regatta regatta) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_NAME, (Object)regatta.getName());
        result.put((Object)FIELD_START_DATE, regatta.getStartDate() != null ? Long.valueOf(regatta.getStartDate().asMillis()) : null);
        result.put((Object)FIELD_END_DATE, regatta.getEndDate() != null ? Long.valueOf(regatta.getEndDate().asMillis()) : null);
        result.put((Object)FIELD_SCORINGSYSTEM, (Object)regatta.getScoringScheme().getType().name());
        result.put((Object)FIELD_RANKINGMETRIC, (Object)regatta.getRankingMetricType().name());
        result.put((Object)FIELD_BOATCLASS, regatta.getBoatClass() != null ? regatta.getBoatClass().getName() : null);
        JSONArray courseAreaIds = new JSONArray();
        Util.addAll((Iterable)Util.map((Iterable)regatta.getCourseAreas(), ca -> ca.getId().toString()), (Collection)courseAreaIds);
        result.put((Object)FIELD_COURSE_AREA_IDS, (Object)courseAreaIds);
        result.put((Object)FIELD_CAN_BOATS_OF_COMPETITORS_CHANGE_PER_RACE, (Object)regatta.canBoatsOfCompetitorsChangePerRace());
        result.put((Object)FIELD_COMPETITOR_REGISTRATION_TYPE, (Object)regatta.getCompetitorRegistrationType().name());
        result.put((Object)FIELD_USE_START_TIME_INFERENCE, (Object)regatta.useStartTimeInference());
        result.put((Object)FIELD_CONTROL_TRACKING_FROM_START_AND_FINISH_TIMES, (Object)regatta.isControlTrackingFromStartAndFinishTimes());
        result.put((Object)FIELD_AUTO_RESTART_TRACKING_UPON_COMPETITOR_SET_CHANGE, (Object)regatta.isAutoRestartTrackingUponCompetitorSetChange());
        if (this.seriesSerializer != null) {
            JSONArray seriesJson = new JSONArray();
            for (Series series : regatta.getSeries()) {
                seriesJson.add((Object)this.seriesSerializer.serialize((Object)series));
            }
            result.put((Object)FIELD_SERIES, (Object)seriesJson);
        }
        if (this.competitorSerializer != null) {
            JSONArray competitorsJson = new JSONArray();
            for (Competitor competitor : regatta.getAllCompetitors()) {
                if (!this.securityService.hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS)) continue;
                competitorsJson.add((Object)this.competitorSerializer.serialize((Object)competitor));
            }
            result.put((Object)FIELD_COMPETITORS, (Object)competitorsJson);
        }
        if (regatta.canBoatsOfCompetitorsChangePerRace() && this.boatSerializer != null) {
            JSONArray boatsJson = new JSONArray();
            for (Boat boat : regatta.getAllBoats()) {
                if (!this.securityService.hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)boat, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS)) continue;
                boatsJson.add((Object)this.boatSerializer.serialize((Object)boat));
            }
            result.put((Object)FIELD_BOATS, (Object)boatsJson);
        }
        return result;
    }
}

