/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.coursetemplate.CommonMarkProperties;
import com.sap.sailing.domain.coursetemplate.ControlPointWithMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.CourseConfiguration;
import com.sap.sailing.domain.coursetemplate.FreestyleMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.FreestyleMarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationResponseAnnotation;
import com.sap.sailing.domain.coursetemplate.MarkConfigurationVisitor;
import com.sap.sailing.domain.coursetemplate.MarkPairWithConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkPropertiesBasedMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.MarkRole;
import com.sap.sailing.domain.coursetemplate.MarkTemplateBasedMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.RegattaMarkConfiguration;
import com.sap.sailing.domain.coursetemplate.WaypointWithMarkConfiguration;
import com.sap.sailing.server.gateway.serialization.impl.CommonMarkPropertiesJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.FreestyleMarkPropertiesJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.GPSFixJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.HashedStringUtil;
import com.sap.sailing.server.gateway.serialization.impl.RepeatablePartJsonSerializer;
import com.sap.sse.common.RepeatablePart;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import com.sap.sse.shared.json.JsonSerializer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CourseConfigurationJsonSerializer
implements JsonSerializer<CourseConfiguration<MarkConfigurationResponseAnnotation>> {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_SHORT_NAME = "shortName";
    public static final String FIELD_OPTIONAL_IMAGE_URL = "optionalImageUrl";
    public static final String FIELD_OPTIONAL_COURSE_TEMPLATE_UUID = "courseTemplateId";
    public static final String FIELD_MARK_CONFIGURATIONS = "markConfigurations";
    public static final String FIELD_MARK_CONFIGURATION_MARK_TEMPLATE_ID = "markTemplateId";
    public static final String FIELD_MARK_CONFIGURATION_MARK_PROPERTIES_ID = "markPropertiesId";
    public static final String FIELD_MARK_CONFIGURATION_MARK_ID = "markId";
    public static final String FIELD_MARK_CONFIGURATION_EFFECTIVE_PROPERTIES = "effectiveProperties";
    public static final String FIELD_MARK_CONFIGURATION_FREESTYLE_PROPERTIES = "freestyleProperties";
    public static final String FIELD_MARK_CONFIGURATION_ASSOCIATED_ROLE_NAME = "associatedRole";
    public static final String FIELD_MARK_CONFIGURATION_ASSOCIATED_ROLE_SHORT_NAME = "associatedRoleShortName";
    public static final String FIELD_MARK_CONFIGURATION_ASSOCIATED_ROLE_ID = "associatedRoleId";
    public static final String FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_MAPPINGS = "trackingDevices";
    public static final String FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_TYPE = "trackingDeviceType";
    public static final String FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_HASH = "trackingDeviceHash";
    public static final String FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_LAST_KNOWN_POSITION = "trackingDeviceLastKnownPosition";
    public static final String FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_MAPPED_FROM = "trackingDeviceMappedFromMillis";
    public static final String FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_MAPPED_TO = "trackingDeviceMappedToMillis";
    public static final String FIELD_MARK_CONFIGURATION_LAST_KNOWN_POSITION = "lastKnownPosition";
    public static final String FIELD_MARK_CONFIGURATION_POSITIONING = "positioning";
    public static final String FIELD_MARK_CONFIGURATION_STORE_TO_INVENTORY = "storeToInventory";
    public static final String FIELD_WAYPOINTS = "waypoints";
    public static final String FIELD_WAYPOINT_CONTROL_POINT_NAME = "controlPointName";
    public static final String FIELD_WAYPOINT_CONTROL_POINT_SHORT_NAME = "controlPointShortName";
    public static final String FIELD_WAYPOINT_PASSING_INSTRUCTION = "passingInstruction";
    public static final String FIELD_WAYPOINT_MARK_CONFIGURATION_IDS = "markConfigurationIds";
    public static final String FIELD_OPTIONAL_REPEATABLE_PART = "optionalRepeatablePart";
    public static final String FIELD_NUMBER_OF_LAPS = "numberOfLaps";
    public static final String FIELD_MARK_CONFIGURATION_ID = "id";
    private final JsonSerializer<RepeatablePart> repeatablePartJsonSerializer = new RepeatablePartJsonSerializer();
    private final JsonSerializer<CommonMarkProperties> commonMarkPropertiesJsonSerializer = new CommonMarkPropertiesJsonSerializer();
    private final JsonSerializer<FreestyleMarkProperties> commonMarkPropertiesWithTagsJsonSerializer = new FreestyleMarkPropertiesJsonSerializer();
    private final JsonSerializer<GPSFix> gpsFixJsonSerializer = new GPSFixJsonSerializer();

    public JSONObject serialize(CourseConfiguration<MarkConfigurationResponseAnnotation> courseConfiguration) {
        JSONObject result = new JSONObject();
        result.put((Object)FIELD_NAME, (Object)courseConfiguration.getName());
        result.put((Object)FIELD_SHORT_NAME, (Object)courseConfiguration.getShortName());
        if (courseConfiguration.getOptionalCourseTemplate() != null) {
            result.put((Object)FIELD_OPTIONAL_COURSE_TEMPLATE_UUID, (Object)courseConfiguration.getOptionalCourseTemplate().getId().toString());
        }
        if (courseConfiguration.getOptionalImageURL() != null) {
            result.put((Object)FIELD_OPTIONAL_IMAGE_URL, (Object)courseConfiguration.getOptionalImageURL().toString());
        }
        HashMap<MarkConfiguration, UUID> markConfigurationsToTempIdMap = new HashMap<MarkConfiguration, UUID>();
        JSONArray markConfigurationsJSON = new JSONArray();
        for (Map.Entry markWithOptionalRole : courseConfiguration.getAllMarksWithOptionalRoles().entrySet()) {
            MarkRole associatedRole;
            MarkConfiguration markConfiguration = (MarkConfiguration)markWithOptionalRole.getKey();
            final JSONObject markConfigurationsEntry = new JSONObject();
            UUID markConfigurationId = UUID.randomUUID();
            markConfigurationsEntry.put((Object)FIELD_MARK_CONFIGURATION_ID, (Object)markConfigurationId.toString());
            if (markConfiguration.getOptionalMarkTemplate() != null) {
                markConfigurationsEntry.put((Object)FIELD_MARK_CONFIGURATION_MARK_TEMPLATE_ID, (Object)markConfiguration.getOptionalMarkTemplate().getId().toString());
            }
            if ((associatedRole = (MarkRole)markWithOptionalRole.getValue()) != null) {
                markConfigurationsEntry.put((Object)FIELD_MARK_CONFIGURATION_ASSOCIATED_ROLE_NAME, (Object)associatedRole.getName());
                markConfigurationsEntry.put((Object)FIELD_MARK_CONFIGURATION_ASSOCIATED_ROLE_SHORT_NAME, (Object)associatedRole.getShortName());
                if (associatedRole instanceof MarkRole) {
                    markConfigurationsEntry.put((Object)FIELD_MARK_CONFIGURATION_ASSOCIATED_ROLE_ID, (Object)associatedRole.getId().toString());
                }
            }
            markConfiguration.accept((MarkConfigurationVisitor)new MarkConfigurationVisitor<Void, MarkConfigurationResponseAnnotation>(){

                public Void visit(FreestyleMarkConfiguration<MarkConfigurationResponseAnnotation> freeStyleMarkConfiguration) {
                    if (freeStyleMarkConfiguration.getOptionalMarkProperties() != null) {
                        markConfigurationsEntry.put((Object)CourseConfigurationJsonSerializer.FIELD_MARK_CONFIGURATION_MARK_PROPERTIES_ID, (Object)freeStyleMarkConfiguration.getOptionalMarkProperties().getId().toString());
                    }
                    markConfigurationsEntry.put((Object)CourseConfigurationJsonSerializer.FIELD_MARK_CONFIGURATION_FREESTYLE_PROPERTIES, (Object)CourseConfigurationJsonSerializer.this.commonMarkPropertiesWithTagsJsonSerializer.serialize((Object)freeStyleMarkConfiguration.getFreestyleProperties()));
                    return null;
                }

                public Void visit(MarkPropertiesBasedMarkConfiguration<MarkConfigurationResponseAnnotation> markPropertiesBasedMarkConfiguration) {
                    markConfigurationsEntry.put((Object)CourseConfigurationJsonSerializer.FIELD_MARK_CONFIGURATION_MARK_PROPERTIES_ID, (Object)markPropertiesBasedMarkConfiguration.getOptionalMarkProperties().getId().toString());
                    return null;
                }

                public Void visit(MarkTemplateBasedMarkConfiguration<MarkConfigurationResponseAnnotation> markConfiguration) {
                    return null;
                }

                public Void visit(RegattaMarkConfiguration<MarkConfigurationResponseAnnotation> regattaMarkConfiguration) {
                    if (regattaMarkConfiguration.getOptionalMarkProperties() != null) {
                        markConfigurationsEntry.put((Object)CourseConfigurationJsonSerializer.FIELD_MARK_CONFIGURATION_MARK_PROPERTIES_ID, (Object)regattaMarkConfiguration.getOptionalMarkProperties().getId().toString());
                    }
                    markConfigurationsEntry.put((Object)CourseConfigurationJsonSerializer.FIELD_MARK_CONFIGURATION_MARK_ID, (Object)regattaMarkConfiguration.getMark().getId().toString());
                    return null;
                }
            });
            markConfigurationsEntry.put((Object)FIELD_MARK_CONFIGURATION_EFFECTIVE_PROPERTIES, (Object)this.commonMarkPropertiesJsonSerializer.serialize((Object)markConfiguration.getEffectiveProperties()));
            if (markConfiguration.getAnnotationInfo() != null) {
                JSONArray deviceMappings = new JSONArray();
                markConfigurationsEntry.put((Object)FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_MAPPINGS, (Object)deviceMappings);
                for (Util.Triple deviceMapping : ((MarkConfigurationResponseAnnotation)markConfiguration.getAnnotationInfo()).getDeviceMappings()) {
                    GPSFix lastKnownPosition;
                    JSONObject deviceMappingObject = new JSONObject();
                    DeviceIdentifier deviceIdentifier = (DeviceIdentifier)deviceMapping.getA();
                    deviceMappingObject.put((Object)FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_TYPE, (Object)deviceIdentifier.getIdentifierType());
                    deviceMappingObject.put((Object)FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_HASH, (Object)HashedStringUtil.toHashedString(deviceIdentifier.getStringRepresentation()));
                    TimeRange mappedTimeRange = (TimeRange)deviceMapping.getB();
                    if (!mappedTimeRange.hasOpenBeginning()) {
                        deviceMappingObject.put((Object)FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_MAPPED_FROM, (Object)mappedTimeRange.from().asMillis());
                    }
                    if (!mappedTimeRange.hasOpenEnd()) {
                        deviceMappingObject.put((Object)FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_MAPPED_TO, (Object)mappedTimeRange.to().asMillis());
                    }
                    if ((lastKnownPosition = (GPSFix)deviceMapping.getC()) != null) {
                        deviceMappingObject.put((Object)FIELD_MARK_CONFIGURATION_TRACKING_DEVICE_LAST_KNOWN_POSITION, (Object)this.gpsFixJsonSerializer.serialize((Object)lastKnownPosition));
                    }
                    deviceMappings.add((Object)deviceMappingObject);
                }
                if (((MarkConfigurationResponseAnnotation)markConfiguration.getAnnotationInfo()).getLastKnownPosition() != null) {
                    markConfigurationsEntry.put((Object)FIELD_MARK_CONFIGURATION_LAST_KNOWN_POSITION, (Object)this.gpsFixJsonSerializer.serialize((Object)((MarkConfigurationResponseAnnotation)markConfiguration.getAnnotationInfo()).getLastKnownPosition()));
                }
            }
            markConfigurationsToTempIdMap.put(markConfiguration, markConfigurationId);
            markConfigurationsJSON.add((Object)markConfigurationsEntry);
        }
        result.put((Object)FIELD_MARK_CONFIGURATIONS, (Object)markConfigurationsJSON);
        JSONArray waypoints = new JSONArray();
        for (WaypointWithMarkConfiguration waypoint : courseConfiguration.getNumberOfLaps() != null && courseConfiguration.getNumberOfLaps() > 1 ? courseConfiguration.getWaypoints(courseConfiguration.getNumberOfLaps().intValue()) : courseConfiguration.getWaypoints()) {
            JSONObject waypointEntry = new JSONObject();
            waypointEntry.put((Object)FIELD_WAYPOINT_PASSING_INSTRUCTION, (Object)waypoint.getPassingInstruction().name());
            JSONArray markConfigurationIDs = new JSONArray();
            ControlPointWithMarkConfiguration controlPoint = waypoint.getControlPoint();
            controlPoint.getMarkConfigurations().forEach(mc -> {
                boolean bl = markConfigurationIDs.add((Object)((UUID)markConfigurationsToTempIdMap.get(mc)).toString());
            });
            waypointEntry.put((Object)FIELD_WAYPOINT_MARK_CONFIGURATION_IDS, (Object)markConfigurationIDs);
            if (controlPoint instanceof MarkPairWithConfiguration) {
                MarkPairWithConfiguration markPairWithConfiguration = (MarkPairWithConfiguration)controlPoint;
                waypointEntry.put((Object)FIELD_WAYPOINT_CONTROL_POINT_NAME, (Object)markPairWithConfiguration.getName());
                waypointEntry.put((Object)FIELD_WAYPOINT_CONTROL_POINT_SHORT_NAME, (Object)markPairWithConfiguration.getShortName());
            }
            waypoints.add((Object)waypointEntry);
        }
        result.put((Object)FIELD_WAYPOINTS, (Object)waypoints);
        if (courseConfiguration.hasRepeatablePart()) {
            result.put((Object)FIELD_OPTIONAL_REPEATABLE_PART, (Object)this.repeatablePartJsonSerializer.serialize((Object)courseConfiguration.getRepeatablePart()));
        }
        result.put((Object)FIELD_NUMBER_OF_LAPS, (Object)courseConfiguration.getNumberOfLaps());
        return result;
    }
}

