/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.serialization.impl;

import com.sap.sailing.domain.base.BoatClass;
import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.WindSourceType;
import com.sap.sailing.domain.maneuverdetection.TrackTimeInfo;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverDetectorImpl;
import com.sap.sailing.domain.polars.PolarDataService;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.gateway.serialization.impl.AbstractTrackedRaceDataJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.BoatClassJsonSerializer;
import com.sap.sailing.server.gateway.serialization.impl.CompetitorTrackElementsJsonSerializer;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.util.NavigableSet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class CompetitorTrackWithEstimationDataJsonSerializer
extends AbstractTrackedRaceDataJsonSerializer {
    public static final String ELEMENTS = "elements";
    public static final String BOAT_CLASS = "boatClass";
    public static final String COMPETITOR_NAME = "competitorName";
    public static final String AVG_INTERVAL_BETWEEN_FIXES_IN_SECONDS = "avgIntervalBetweenFixesInSeconds";
    public static final String DISTANCE_TRAVELLED_IN_METERS = "distanceTravelledInMeters";
    public static final String START_TIME_POINT = "startUnixTime";
    public static final String END_TIME_POINT = "endUnixTime";
    public static final String FIXES_COUNT_FOR_POLARS = "fixesCountForPolars";
    public static final String MARK_PASSINGS_COUNT = "markPassingsCount";
    public static final String WAYPOINTS_COUNT = "waypointsCount";
    public static final String WIND_QUALITY = "windQuality";
    private final BoatClassJsonSerializer boatClassJsonSerializer;
    private final CompetitorTrackElementsJsonSerializer elementsJsonSerializer;
    private final PolarDataService polarDataService;
    private final SecurityService securityService;
    private final Integer startBeforeStartLineInSeconds;
    private final Integer endBeforeStartLineInSeconds;
    private final Integer startAfterFinishLineInSeconds;
    private final Integer endAfterFinishLineInSeconds;

    public CompetitorTrackWithEstimationDataJsonSerializer(PolarDataService polarDataService, SecurityService securityService, BoatClassJsonSerializer boatClassJsonSerializer, CompetitorTrackElementsJsonSerializer elementsJsonSerializer, Integer startBeforeStartLineInSeconds, Integer endBeforeStartLineInSeconds, Integer startAfterFinishLineInSeconds, Integer endAfterFinishLineInSeconds) {
        this.polarDataService = polarDataService;
        this.boatClassJsonSerializer = boatClassJsonSerializer;
        this.elementsJsonSerializer = elementsJsonSerializer;
        this.startBeforeStartLineInSeconds = startBeforeStartLineInSeconds;
        this.endBeforeStartLineInSeconds = endBeforeStartLineInSeconds;
        this.startAfterFinishLineInSeconds = startAfterFinishLineInSeconds;
        this.endAfterFinishLineInSeconds = endAfterFinishLineInSeconds;
        this.securityService = securityService;
    }

    public JSONObject serialize(TrackedRace trackedRace) {
        JSONObject result = new JSONObject();
        JSONArray byCompetitorJson = new JSONArray();
        int windQuality = 0;
        for (WindSource windSource : trackedRace.getWindSources()) {
            if (windSource.getType() == WindSourceType.EXPEDITION) {
                windQuality = 2;
                break;
            }
            if (windSource.getType() != WindSourceType.RACECOMMITTEE) continue;
            windQuality = 1;
        }
        result.put((Object)WIND_QUALITY, (Object)windQuality);
        result.put((Object)"bycompetitor", (Object)byCompetitorJson);
        for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
            ManeuverDetectorImpl maneuverDetector;
            TrackTimeInfo trackTimeInfo;
            if (!this.securityService.hasCurrentUserOneOfExplicitPermissions((WithQualifiedObjectIdentifier)competitor, SecuredSecurityTypes.PublicReadableActions.READ_AND_READ_PUBLIC_ACTIONS) || (trackTimeInfo = (maneuverDetector = new ManeuverDetectorImpl(trackedRace, competitor)).getTrackTimeInfo()) == null) continue;
            TimePoint from = null;
            TimePoint to = null;
            from = this.startBeforeStartLineInSeconds != null ? trackTimeInfo.getTrackStartTimePoint().minus((Duration)new MillisecondsDurationImpl((long)this.startBeforeStartLineInSeconds.intValue() * 1000L)) : (this.startAfterFinishLineInSeconds != null ? trackTimeInfo.getTrackEndTimePoint().plus((Duration)new MillisecondsDurationImpl((long)this.startAfterFinishLineInSeconds.intValue() * 1000L)) : trackTimeInfo.getTrackStartTimePoint());
            to = this.endAfterFinishLineInSeconds != null ? trackTimeInfo.getTrackEndTimePoint().plus((Duration)new MillisecondsDurationImpl((long)this.endAfterFinishLineInSeconds.intValue() * 1000L)) : (this.endBeforeStartLineInSeconds != null ? trackTimeInfo.getTrackStartTimePoint().minus((Duration)new MillisecondsDurationImpl((long)this.endBeforeStartLineInSeconds.intValue() * 1000L)) : trackTimeInfo.getTrackEndTimePoint());
            JSONObject forCompetitorJson = new JSONObject();
            byCompetitorJson.add((Object)forCompetitorJson);
            forCompetitorJson.put((Object)COMPETITOR_NAME, (Object)competitor.getName());
            forCompetitorJson.put((Object)BOAT_CLASS, (Object)this.boatClassJsonSerializer.serialize(trackedRace.getRace().getBoatOfCompetitor(competitor).getBoatClass()));
            forCompetitorJson.put((Object)FIXES_COUNT_FOR_POLARS, (Object)this.getFixesCountForPolars(trackedRace, competitor));
            Duration averageIntervalBetweenFixes = trackedRace.getTrack(competitor).getAverageIntervalBetweenFixes();
            forCompetitorJson.put((Object)AVG_INTERVAL_BETWEEN_FIXES_IN_SECONDS, (Object)(averageIntervalBetweenFixes == null ? 0.0 : averageIntervalBetweenFixes.asSeconds()));
            GPSFixTrack track = trackedRace.getTrack(competitor);
            Double distanceTravelledInMeters = null;
            if (trackTimeInfo.getTrackStartTimePoint() != null && trackTimeInfo.getTrackEndTimePoint() != null) {
                distanceTravelledInMeters = track.getDistanceTraveled(trackTimeInfo.getTrackStartTimePoint(), trackTimeInfo.getTrackEndTimePoint()).getMeters();
            }
            forCompetitorJson.put((Object)DISTANCE_TRAVELLED_IN_METERS, distanceTravelledInMeters);
            forCompetitorJson.put((Object)START_TIME_POINT, trackTimeInfo.getTrackStartTimePoint() == null ? null : Long.valueOf(trackTimeInfo.getTrackStartTimePoint().asMillis()));
            forCompetitorJson.put((Object)END_TIME_POINT, trackTimeInfo.getTrackEndTimePoint() == null ? null : Long.valueOf(trackTimeInfo.getTrackEndTimePoint().asMillis()));
            forCompetitorJson.put((Object)MARK_PASSINGS_COUNT, (Object)this.getMarkPassingsCount(trackedRace, competitor));
            forCompetitorJson.put((Object)WAYPOINTS_COUNT, (Object)this.getWaypointsCount(trackedRace));
            forCompetitorJson.put((Object)ELEMENTS, (Object)this.elementsJsonSerializer.serialize(trackedRace, competitor, from, to, trackTimeInfo));
        }
        return result;
    }

    private int getMarkPassingsCount(TrackedRace trackedRace, Competitor competitor) {
        int markPassingsCount = 0;
        NavigableSet markPassings = trackedRace.getMarkPassings(competitor, false);
        trackedRace.lockForRead((Iterable)markPassings);
        try {
            markPassingsCount = Util.size((Iterable)markPassings);
        }
        finally {
            trackedRace.unlockAfterRead((Iterable)markPassings);
        }
        return markPassingsCount;
    }

    private long getFixesCountForPolars(TrackedRace trackedRace, Competitor competitor) {
        BoatClass boatClass = trackedRace.getRace().getBoatOfCompetitor(competitor).getBoatClass();
        Long fixesCountForBoatPolars = (Long)this.polarDataService.getFixCountPerBoatClass().get(boatClass);
        return fixesCountForBoatPolars == null ? 0L : fixesCountForBoatPolars;
    }

    private int getWaypointsCount(TrackedRace trackedRace) {
        Iterable waypoints = trackedRace.getRace().getCourse().getWaypoints();
        return Util.size((Iterable)waypoints);
    }
}

