/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.common.DeviceIdentifier;
import com.sap.sailing.domain.coursetemplate.Positioning;
import com.sap.sailing.domain.coursetemplate.impl.FixedPositioningImpl;
import com.sap.sailing.domain.coursetemplate.impl.TrackingDeviceBasedPositioningImpl;
import com.sap.sailing.server.gateway.deserialization.impl.DeviceIdentifierJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.PositionJsonDeserializer;
import com.sap.sse.shared.json.JsonDeserializationException;
import com.sap.sse.shared.json.JsonDeserializer;
import java.util.logging.Logger;
import org.json.simple.JSONObject;

public class PositioningJsonDeserializer
implements JsonDeserializer<Positioning> {
    private static final Logger logger = Logger.getLogger(PositioningJsonDeserializer.class.getName());
    private final PositionJsonDeserializer positionDeserializer = new PositionJsonDeserializer();
    private final DeviceIdentifierJsonDeserializer deviceIdentifierDeserializer;

    public PositioningJsonDeserializer(DeviceIdentifierJsonDeserializer deviceIdentifierDeserializer) {
        this.deviceIdentifierDeserializer = deviceIdentifierDeserializer;
    }

    public Positioning deserialize(JSONObject object) throws JsonDeserializationException {
        FixedPositioningImpl result;
        if (object.containsKey((Object)"position")) {
            result = new FixedPositioningImpl(this.positionDeserializer.deserialize((JSONObject)object.get((Object)"position")));
        } else if (object.containsKey((Object)"device_identifier")) {
            DeviceIdentifier deviceIdentifier = this.deviceIdentifierDeserializer.deserialize((JSONObject)object.get((Object)"device_identifier"));
            result = new TrackingDeviceBasedPositioningImpl(deviceIdentifier);
        } else {
            logger.warning("Unknown Positioning object type: " + object);
            result = null;
        }
        return result;
    }
}

