/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.maneuverdetection.ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData;
import com.sap.sailing.domain.maneuverdetection.impl.ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataImpl;
import com.sap.sailing.domain.tracking.ManeuverCurveBoundaries;
import com.sap.sailing.server.gateway.deserialization.impl.CompleteManeuverCurveWithEstimationDataJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.ManeuverCurveBoundariesJsonDeserializer;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.shared.json.JsonDeserializationException;
import org.json.simple.JSONObject;

public class ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataJsonDeserializer
extends ManeuverCurveBoundariesJsonDeserializer {
    public ManeuverCurveWithUnstableCourseAndSpeedWithEstimationData deserialize(JSONObject object) throws JsonDeserializationException {
        ManeuverCurveBoundaries boundaries = super.deserialize(object);
        Double avgSpeedBeforeInKnots = (Double)object.get((Object)"averageSpeedBeforeInKnots");
        Double avgCogBefore = (Double)object.get((Object)"averageCourseBeforeInDegrees");
        Double secondsBefore = (Double)object.get((Object)"durationFromPreviousManeuverInSeconds");
        Double avgSpeedAfterInKnots = (Double)object.get((Object)"averageSpeedAfterInKnots");
        Double avgCogAfter = (Double)object.get((Object)"averageCourseAfterInDegrees");
        Double secondsAfter = (Double)object.get((Object)"durationToNextManeuverInSeconds");
        Integer gpsFixesCountBefore = CompleteManeuverCurveWithEstimationDataJsonDeserializer.getInteger(object.get((Object)"gpsFixesCountFromPreviousManeuver"));
        Integer gpsFixesCountAfter = CompleteManeuverCurveWithEstimationDataJsonDeserializer.getInteger(object.get((Object)"gpsFixesCountToNextManeuver"));
        Integer gpsFixesCount = CompleteManeuverCurveWithEstimationDataJsonDeserializer.getInteger(object.get((Object)"gpsFixesCount"));
        Double longestIntervalBetweenTwoFixes = (Double)object.get((Object)"longestIntervalBetweenTwoFixesInSeconds");
        Double intervalBetweenLastFixOfCurveAndNextFix = (Double)object.get((Object)"intervalBetweenLastFixOfCurveAndNextFixInSeconds");
        Double intervalBetweenFirstFixOfCurveAndPreviousFix = (Double)object.get((Object)"intervalBetweenFirstFixOfCurveAndPreviousFixInSeconds");
        return new ManeuverCurveWithUnstableCourseAndSpeedWithEstimationDataImpl(boundaries.getTimePointBefore(), boundaries.getTimePointAfter(), boundaries.getSpeedWithBearingBefore(), boundaries.getSpeedWithBearingAfter(), boundaries.getDirectionChangeInDegrees(), boundaries.getLowestSpeed(), boundaries.getHighestSpeed(), this.convertSpeedWithBearing(avgSpeedBeforeInKnots, avgCogBefore), this.convertDuration(secondsBefore), gpsFixesCountBefore.intValue(), this.convertSpeedWithBearing(avgSpeedAfterInKnots, avgCogAfter), this.convertDuration(secondsAfter), gpsFixesCountAfter.intValue(), gpsFixesCount.intValue(), this.convertDuration(longestIntervalBetweenTwoFixes), this.convertDuration(intervalBetweenLastFixOfCurveAndNextFix), this.convertDuration(intervalBetweenFirstFixOfCurveAndPreviousFix));
    }

    private SpeedWithBearing convertSpeedWithBearing(Double speedInKnots, Double cog) {
        return speedInKnots == null || cog == null ? null : new KnotSpeedWithBearingImpl(speedInKnots.doubleValue(), (Bearing)new DegreeBearingImpl(cog.doubleValue()));
    }

    private Duration convertDuration(Double seconds) {
        return seconds == null ? null : new MillisecondsDurationImpl((long)(seconds * 1000.0));
    }
}

