/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.gateway.deserialization.impl;

import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.server.gateway.deserialization.TypeBasedJsonDeserializer;
import com.sap.sailing.server.gateway.deserialization.impl.GPSFixJsonDeserializer;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sap.sse.shared.json.JsonDeserializationException;
import org.json.simple.JSONObject;

public class GPSFixMovingJsonDeserializer
extends TypeBasedJsonDeserializer<GPSFixMoving> {
    public static final String TYPE = "GPSFixMoving";
    public static final String FIELD_BEARING_DEG = "bearing_deg";
    public static final String FIELD_SPEED_KNOTS = "speed_knots";
    public static final Object FIELD_TRUE_HEADING_DEG = "true_heading_deg";

    protected GPSFixMoving deserializeAfterCheckingType(JSONObject object) throws JsonDeserializationException {
        double bearingDeg = (Double)object.get((Object)FIELD_BEARING_DEG);
        double speedKnots = (Double)object.get((Object)FIELD_SPEED_KNOTS);
        JSONObject clone = (JSONObject)object.clone();
        clone.put((Object)"type", (Object)"GPSFix");
        GPSFix baseFix = (GPSFix)new GPSFixJsonDeserializer().deserialize(clone);
        DegreeBearingImpl bearing = new DegreeBearingImpl(bearingDeg);
        KnotSpeedWithBearingImpl speed = new KnotSpeedWithBearingImpl(speedKnots, (Bearing)bearing);
        DegreeBearingImpl optionalTrueHeading = object.containsKey(FIELD_TRUE_HEADING_DEG) ? new DegreeBearingImpl(((Double)object.get(FIELD_TRUE_HEADING_DEG)).doubleValue()) : null;
        GPSFixMovingImpl fix = new GPSFixMovingImpl(baseFix.getPosition(), baseFix.getTimePoint(), (SpeedWithBearing)speed, (Bearing)optionalTrueHeading);
        return fix;
    }

    protected String getType() {
        return TYPE;
    }
}

