/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.persistence.impl;

import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.sap.sse.security.persistence.MongoObjectFactory;
import com.sap.sse.security.persistence.impl.CollectionNames;
import com.sap.sse.security.persistence.impl.FieldNames;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.bson.Document;
import org.bson.conversions.Bson;

public class MongoObjectFactoryImpl
implements MongoObjectFactory {
    private static final Logger logger = Logger.getLogger(MongoObjectFactoryImpl.class.getName());
    private final MongoCollection<Document> sessionCollection;
    private final MongoCollection<Document> corsFilterConfigurationsCollection;

    public MongoObjectFactoryImpl(MongoDatabase mongoDatabase) {
        this.sessionCollection = mongoDatabase.getCollection(CollectionNames.SESSIONS.name());
        this.sessionCollection.createIndex((Bson)new Document().append(FieldNames.CACHE_NAME.name(), (Object)1).append(FieldNames.SESSION_ID.name(), (Object)1), new IndexOptions().name("cachenameandsessionid").background(false));
        this.corsFilterConfigurationsCollection = mongoDatabase.getCollection(CollectionNames.CORS_FILTER_CONFIGURATIONS.name());
        this.corsFilterConfigurationsCollection.createIndex((Bson)new Document().append(FieldNames.CORS_FILTER_CONFIGURATION_SERVER_NAME.name(), (Object)1), new IndexOptions().name("servername").background(false));
    }

    private Document getKey(String cacheName, Session session) {
        return MongoObjectFactoryImpl.getKey(cacheName, session.getId());
    }

    static Document getKey(String cacheName, Serializable sessionId) {
        return new Document().append(FieldNames.CACHE_NAME.name(), (Object)cacheName).append(FieldNames.SESSION_ID.name(), (Object)sessionId);
    }

    @Override
    public void storeSession(String cacheName, Session session) {
        Document sessionAsDocument = this.getKey(cacheName, session).append(FieldNames.SESSION_HOST.name(), (Object)session.getHost()).append(FieldNames.SESSION_LAST_ACCESS_TIME.name(), (Object)session.getLastAccessTime()).append(FieldNames.SESSION_START_TIMESTAMP.name(), (Object)session.getStartTimestamp()).append(FieldNames.SESSION_TIMEOUT.name(), (Object)session.getTimeout());
        ArrayList<Document> sessionAttributes = new ArrayList<Document>();
        for (Object attributeKey : session.getAttributeKeys()) {
            if (attributeKey instanceof String) {
                Object attributeValue = session.getAttribute(attributeKey);
                if (attributeValue instanceof PrincipalCollection) {
                    sessionAttributes.add(new Document().append(FieldNames.SESSION_ATTRIBUTE_NAME.name(), attributeKey).append(FieldNames.SESSION_ATTRIBUTE_VALUE.name(), this.storePrincipalCollection((PrincipalCollection)attributeValue)));
                    continue;
                }
                if (attributeValue instanceof String || attributeValue instanceof Number || attributeValue instanceof Boolean || attributeValue instanceof Character) {
                    sessionAttributes.add(new Document().append(FieldNames.SESSION_ATTRIBUTE_NAME.name(), attributeKey).append(FieldNames.SESSION_ATTRIBUTE_VALUE.name(), attributeValue));
                    continue;
                }
                logger.fine("Ignoring session attribute " + attributeKey + " with value " + attributeValue + "of type " + attributeValue.getClass().getName() + " because values of this type cannot be stored");
                continue;
            }
            logger.warning("Attribute key " + attributeKey + " of session " + session + " is not of type String but of type " + attributeKey.getClass().getName() + " and cannot be stored");
        }
        sessionAsDocument.append(FieldNames.SESSION_ATTRIBUTES.name(), sessionAttributes);
        Document key = this.getKey(cacheName, session);
        this.sessionCollection.replaceOne((Bson)key, (Object)sessionAsDocument, new ReplaceOptions().upsert(true));
    }

    private List<Document> storePrincipalCollection(PrincipalCollection principalCollection) {
        ArrayList<Document> result = new ArrayList<Document>();
        for (String realmName : principalCollection.getRealmNames()) {
            ArrayList<String> principalNames = new ArrayList<String>();
            for (Object o : principalCollection.fromRealm(realmName)) {
                principalNames.add(o.toString());
            }
            Document realmDocument = new Document().append(FieldNames.SESSION_PRINCIPAL_REALM_NAME.name(), (Object)realmName).append(FieldNames.SESSION_PRINCIPAL_REALM_VALUE.name(), principalNames);
            result.add(realmDocument);
        }
        return result;
    }

    @Override
    public void removeAllSessions(String cacheName) {
        this.sessionCollection.deleteMany((Bson)new Document(FieldNames.CACHE_NAME.name(), (Object)cacheName));
    }

    @Override
    public void removeSession(String cacheName, Session session) {
        this.sessionCollection.deleteOne((Bson)this.getKey(cacheName, session));
    }

    @Override
    public void storeCORSFilterConfigurationIsWildcard(String serverName) {
        Document filter = new Document().append(FieldNames.CORS_FILTER_CONFIGURATION_SERVER_NAME.name(), (Object)serverName);
        Document d = new Document().append(FieldNames.CORS_FILTER_CONFIGURATION_SERVER_NAME.name(), (Object)serverName).append(FieldNames.CORS_FILTER_CONFIGURATION_IS_WILDCARD.name(), (Object)true).append(FieldNames.CORS_FILTER_CONFIGURATION_ALLOWED_ORIGINS.name(), Collections.emptyList());
        this.corsFilterConfigurationsCollection.replaceOne((Bson)filter, (Object)d, new ReplaceOptions().upsert(true));
    }

    @Override
    public void storeCORSFilterConfigurationAllowedOrigins(String serverName, String ... allowedOrigins) {
        Document filter = new Document().append(FieldNames.CORS_FILTER_CONFIGURATION_SERVER_NAME.name(), (Object)serverName);
        Document d = new Document().append(FieldNames.CORS_FILTER_CONFIGURATION_SERVER_NAME.name(), (Object)serverName).append(FieldNames.CORS_FILTER_CONFIGURATION_IS_WILDCARD.name(), (Object)false).append(FieldNames.CORS_FILTER_CONFIGURATION_ALLOWED_ORIGINS.name(), allowedOrigins == null ? Collections.emptyList() : Arrays.asList(allowedOrigins));
        this.corsFilterConfigurationsCollection.replaceOne((Bson)filter, (Object)d, new ReplaceOptions().upsert(true));
    }
}

