/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl.doublefix;

import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sailing.domain.common.tracking.impl.DoubleVectorFixImpl;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackimport.BaseDoubleVectorFixImporter;
import com.sap.sailing.server.trackfiles.impl.doublefix.DoubleFixProcessor;
import com.sap.sailing.server.trackfiles.impl.doublefix.DoubleVectorFixData;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.util.ArrayList;

public final class LearningBatchProcessor
implements DoubleFixProcessor {
    private final int batchSize;
    private final ArrayList<DoubleVectorFixData> learnedFixes;
    private final ArrayList<DoubleVectorFix> collectedFixes;
    private final BaseDoubleVectorFixImporter.Callback callback;
    private final TrackFileImportDeviceIdentifier deviceIdentifier;
    private boolean isLearning = true;
    private long fixesToLearn;

    public LearningBatchProcessor(int batchSize, int fixesToLearn, BaseDoubleVectorFixImporter.Callback callback, TrackFileImportDeviceIdentifier deviceIdentifier) {
        this.batchSize = batchSize;
        this.fixesToLearn = fixesToLearn;
        this.collectedFixes = new ArrayList(batchSize);
        this.learnedFixes = new ArrayList(fixesToLearn);
        this.callback = callback;
        this.deviceIdentifier = deviceIdentifier;
    }

    @Override
    public void accept(DoubleVectorFixData fix) {
        if (this.isLearning) {
            this.learnFix(fix);
        } else {
            this.processFix(fix);
        }
    }

    private void learnFix(DoubleVectorFixData fix) {
        this.learnedFixes.add(fix);
        if ((long)this.learnedFixes.size() >= this.fixesToLearn) {
            this.finishLearning();
        }
    }

    private void finishLearning() {
        this.isLearning = false;
        for (DoubleVectorFixData doubleVectorFix : this.learnedFixes) {
            this.processFix(doubleVectorFix);
        }
    }

    private void processFix(DoubleVectorFixData fix) {
        this.collectedFixes.add((DoubleVectorFix)new DoubleVectorFixImpl((TimePoint)new MillisecondsTimePoint(fix.getTimepointInMs()), fix.getFix()));
        int currentlyCollectedFixes = this.collectedFixes.size();
        if (currentlyCollectedFixes >= this.batchSize) {
            this.pushCollectedFixes();
        }
    }

    @Override
    public void finish() {
        if (this.isLearning) {
            this.finishLearning();
        }
        this.pushCollectedFixes();
    }

    private void pushCollectedFixes() {
        this.callback.addFixes(this.collectedFixes, this.deviceIdentifier);
        this.collectedFixes.clear();
    }
}

