/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.server.trackfiles.impl;

import com.sap.sailing.domain.common.trackfiles.TrackFilesDataSource;
import com.sap.sailing.domain.common.trackfiles.TrackFilesFormat;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.server.trackfiles.impl.BouyDataRetriever;
import com.sap.sailing.server.trackfiles.impl.CompetitorDataRetriever;
import com.sap.sailing.server.trackfiles.impl.DataRetriever;
import com.sap.sailing.server.trackfiles.impl.ManueverDataRetriever;
import com.sap.sailing.server.trackfiles.impl.MetaDataRetriever;
import com.sap.sailing.server.trackfiles.impl.WindDataRetriever;
import com.sap.sailing.server.trackfiles.impl.WriteZipCallback;
import java.util.concurrent.Callable;
import java.util.zip.ZipEntry;

class WriteRaceDataCallable
implements Callable<Void> {
    private final TrackedRace race;
    private final TrackFilesDataSource data;
    private final TrackFilesFormat format;
    private final boolean dataBeforeAfter;
    private final boolean rawFixes;
    private final WriteZipCallback callback;

    public WriteRaceDataCallable(TrackedRace race, TrackFilesDataSource data, TrackFilesFormat format, boolean dataBeforeAfter, boolean rawFixes, WriteZipCallback callback) {
        this.race = race;
        this.data = data;
        this.format = format;
        this.dataBeforeAfter = dataBeforeAfter;
        this.rawFixes = rawFixes;
        this.callback = callback;
    }

    private DataRetriever getDataRetriever() {
        switch (this.data) {
            case BUOYS: {
                return new BouyDataRetriever();
            }
            case COMPETITORS: {
                return new CompetitorDataRetriever();
            }
            case WIND: {
                return new WindDataRetriever();
            }
            case MANEUVERS: {
                return new ManueverDataRetriever();
            }
            case METADATA: {
                return new MetaDataRetriever();
            }
        }
        return null;
    }

    @Override
    public Void call() throws Exception {
        DataRetriever dataRetriever = this.getDataRetriever();
        byte[] result = dataRetriever.getData(this.format, this.race, this.dataBeforeAfter, this.rawFixes);
        String suffix = this.data == TrackFilesDataSource.METADATA ? "txt" : this.format.suffix;
        ZipEntry entry = new ZipEntry(String.valueOf(this.race.getRaceIdentifier().getRegattaName()) + "/" + this.race.getRaceIdentifier().getRaceName() + " - " + this.data.toString() + "." + suffix);
        this.callback.write(entry, result);
        return null;
    }
}

