/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util.security;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.ConnectionProperty;
import com.sap.db.jdbc.ConnectionSapDB;
import com.sap.db.jdbc.Session;
import com.sap.db.jdbc.SessionFactory;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.jdbc.packet.HAuthenticationPart;
import com.sap.db.jdbc.packet.HReplyPacket;
import com.sap.db.jdbc.packet.HRequestPacket;
import com.sap.db.jdbc.trace.Tracer;
import com.sap.db.util.security.AuthenticationMethodType;
import java.sql.SQLException;
import java.util.Set;

@Immutable
public abstract class AbstractAuthenticationManager {
    public abstract Session authenticate(SessionFactory var1, ConnectionSapDB var2, Session var3, String var4, String var5, String var6, Set<AuthenticationMethodType> var7) throws RTEException, SQLException;

    public abstract void setClientProofPart(HAuthenticationPart var1, String var2, String var3, String var4) throws SQLException;

    public abstract String getMethodName();

    public abstract byte[] evaluateConnectReply(Tracer var1, HAuthenticationPart var2) throws SQLException;

    public void connect(ConnectionSapDB connection, Session session, String userName, String passwd, String x509) throws SQLException {
        String userNameFromServer = this.getUserNameFromServer();
        HRequestPacket requestPacket = connection.initConnect(session, this, userName, passwd, x509, userNameFromServer);
        HReplyPacket replyPacket = connection.exchange(session, requestPacket, null, new ConnectionSapDB.ExchangeFlag[0]);
        HAuthenticationPart authenticationPart = replyPacket.findAuthenticationPart(0);
        if (authenticationPart == null || !authenticationPart.nextField()) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
        String methodName = this.getMethodName();
        if (!methodName.equals("NATIVE") && !methodName.equals(authenticationPart.getValueAsString())) {
            throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
        }
        authenticationPart.nextField();
        byte[] cookie = this.evaluateConnectReply(connection.getTracer(), authenticationPart);
        if (cookie != null) {
            if (userNameFromServer == null) {
                throw SQLExceptionSapDB.newInstance("error.connection.wrongserverchallengereceived", new String[0]);
            }
            connection.setCookie(cookie);
            connection.setConnectionProperty(ConnectionProperty.USER, userNameFromServer);
        }
        this.onAuthenticationCompleted();
    }

    String getUserNameFromServer() {
        return null;
    }

    void onAuthenticationCompleted() {
    }
}

