/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.RteReturnCode;
import com.sap.db.jdbc.exceptions.RTEException;
import com.sap.db.jdbc.trace.Tracer;

@Immutable
public final class NetworkAddress {
    private final String _host;
    private final Integer _port;

    public static NetworkAddress newInstance(Tracer tracer, String address) throws RTEException {
        int idx;
        if (address == null || address.isEmpty()) {
            NetworkAddress networkAddress = new NetworkAddress(null, null);
            return networkAddress;
        }
        String hostName = address;
        String portString = null;
        if (address.charAt(0) == '[') {
            if (address.lastIndexOf(91) != 0) {
                throw RTEException.newInstance(tracer, "Invalid host: " + address, RteReturnCode.SQLNOTOK, -708);
            }
            idx = address.lastIndexOf(93);
            if (idx != address.indexOf(93)) {
                throw RTEException.newInstance(tracer, "Invalid host: " + address, RteReturnCode.SQLNOTOK, -708);
            }
            int colonIdx = address.indexOf(58, idx + 1);
            if (colonIdx != -1) {
                hostName = address.substring(0, colonIdx);
                portString = address.substring(colonIdx + 1);
                if (portString.isEmpty()) {
                    throw RTEException.newInstance(tracer, "Invalid host, missing port number: " + address, RteReturnCode.SQLNOTOK, -708);
                }
            }
        } else {
            idx = address.lastIndexOf(58);
            if (idx != -1 && idx == address.indexOf(58)) {
                hostName = address.substring(0, idx);
                portString = address.substring(idx + 1);
            }
        }
        Integer portNumber = null;
        if (portString != null && !portString.isEmpty()) {
            try {
                portNumber = Integer.parseInt(portString);
            }
            catch (NumberFormatException ex) {
                throw RTEException.newInstance(tracer, "Invalid port number: " + portString, RteReturnCode.SQLNOTOK, -708, ex);
            }
            if (portNumber < 0 || portNumber > 65535) {
                throw RTEException.newInstance(tracer, "Invalid port number: " + portString, RteReturnCode.SQLNOTOK, -708);
            }
        }
        NetworkAddress networkAddress = new NetworkAddress(hostName, portNumber);
        return networkAddress;
    }

    private NetworkAddress(String host, Integer port) {
        this._host = host;
        this._port = port;
    }

    public String getHost() {
        return this._host;
    }

    public Integer getPort() {
        return this._port;
    }
}

