/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.Immutable;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.AesCbc;
import com.sap.db.util.AriaCbc;
import com.sap.db.util.CSEBlockCipher;
import com.sap.db.util.CSECipher;
import com.sap.db.util.CSEStreamCipher;
import com.sap.db.util.RsaOaep;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;
import javax.crypto.NoSuchPaddingException;

@Immutable
public final class CSECipherFactory {
    private static final Map<String, String> CIPHER_ALGORITHM_NAMES_TO_HANA_ALGORITHM_NAMES;
    private static final Map<String, ThreadLocal<CSECipher>> HANA_ALGORITHM_NAMES_TO_JAVA_CIPHERS;
    private static final ThreadLocal<CSECipher> CIPHER_AES_CBC_PKCS5;
    private static final ThreadLocal<CSECipher> CIPHER_RSA_ECB_OAEP;
    private static final ThreadLocal<CSECipher> CIPHER_ARIA_CBC_PKCS7;

    public static CSEBlockCipher getBlockCipher(String algorithmName) throws SQLException {
        try {
            ThreadLocal<CSECipher> cipher = HANA_ALGORITHM_NAMES_TO_JAVA_CIPHERS.get(algorithmName);
            if (cipher != null) {
                return (CSEBlockCipher)cipher.get();
            }
            throw SQLExceptionSapDB.newInstance(String.format("Unknown algorithm specified: '%s'", algorithmName), new String[0]);
        }
        catch (ClassCastException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, String.format("'%s' is not a Block Cipher", algorithmName), new String[0]);
        }
    }

    public static CSEStreamCipher getStreamCipher(String algorithmName) throws SQLException {
        try {
            ThreadLocal<CSECipher> cipher = HANA_ALGORITHM_NAMES_TO_JAVA_CIPHERS.get(algorithmName);
            if (cipher != null) {
                return (CSEStreamCipher)cipher.get();
            }
            throw SQLExceptionSapDB.newInstance(String.format("Unknown algorithm specified: '%s'", algorithmName), new String[0]);
        }
        catch (ClassCastException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, String.format("'%s' is not a Stream Cipher", algorithmName), new String[0]);
        }
    }

    public static CSEStreamCipher getStreamCipher(Key key) throws SQLException {
        String algorithmName = key.getAlgorithm();
        try {
            String hanaAlgorithmName = CIPHER_ALGORITHM_NAMES_TO_HANA_ALGORITHM_NAMES.get(algorithmName);
            if (hanaAlgorithmName != null) {
                return (CSEStreamCipher)HANA_ALGORITHM_NAMES_TO_JAVA_CIPHERS.get(hanaAlgorithmName).get();
            }
            throw SQLExceptionSapDB.newInstance(String.format("Unknown algorithm specified: '%s'", algorithmName), new String[0]);
        }
        catch (ClassCastException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, String.format("'%s' is not a Stream Cipher", algorithmName), new String[0]);
        }
    }

    private CSECipherFactory() {
        throw new AssertionError((Object)"Non-instantiable class");
    }

    static {
        CIPHER_AES_CBC_PKCS5 = ThreadLocal.withInitial(() -> {
            try {
                return new AesCbc(256);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new RuntimeException("error.crypto.extension.not_installed", e);
            }
        });
        CIPHER_RSA_ECB_OAEP = ThreadLocal.withInitial(() -> {
            try {
                return new RsaOaep(2048);
            }
            catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new RuntimeException("error.crypto.extension.not_installed", e);
            }
        });
        CIPHER_ARIA_CBC_PKCS7 = ThreadLocal.withInitial(() -> {
            try {
                return new AriaCbc(256);
            }
            catch (InvalidKeyException | NoSuchAlgorithmException e) {
                throw new RuntimeException("error.crypto.extension.not_installed", e);
            }
        });
        CIPHER_ALGORITHM_NAMES_TO_HANA_ALGORITHM_NAMES = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        CIPHER_ALGORITHM_NAMES_TO_HANA_ALGORITHM_NAMES.put("AES", "AES-256-CBC");
        CIPHER_ALGORITHM_NAMES_TO_HANA_ALGORITHM_NAMES.put("RSA", "RSA-OAEP-2048");
        CIPHER_ALGORITHM_NAMES_TO_HANA_ALGORITHM_NAMES.put("SAP_HANA_ARIA", "ARIA-256-CBC");
        HANA_ALGORITHM_NAMES_TO_JAVA_CIPHERS = new TreeMap<String, ThreadLocal<CSECipher>>(String.CASE_INSENSITIVE_ORDER);
        HANA_ALGORITHM_NAMES_TO_JAVA_CIPHERS.put("AES-256-CBC", CIPHER_AES_CBC_PKCS5);
        HANA_ALGORITHM_NAMES_TO_JAVA_CIPHERS.put("RSA-OAEP-2048", CIPHER_RSA_ECB_OAEP);
        HANA_ALGORITHM_NAMES_TO_JAVA_CIPHERS.put("ARIA-256-CBC", CIPHER_ARIA_CBC_PKCS7);
    }
}

