/*
 * Decompiled with CFR 0.152.
 */
package com.sap.db.util;

import com.sap.db.annotations.NotThreadSafe;
import com.sap.db.jdbc.ColumnEncryptionKey;
import com.sap.db.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.db.util.CSEBlockCipher;
import com.sap.db.util.OutputBuffer;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.sql.SQLException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

@NotThreadSafe
public final class AesCbc
extends CSEBlockCipher {
    public static final String JAVA_ALGORITHM_NAME = "AES";
    public static final String HANA_ALGORITHM_NAME = "AES-256-CBC";
    public static final String TRANSFORMATION_NAME = "AES/CBC/PKCS5Padding";
    private final Cipher _cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
    private final KeyGenerator _keyGenerator = KeyGenerator.getInstance("AES");

    protected AesCbc(int keySize) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this._keyGenerator.init(keySize);
    }

    @Override
    public Key generateKey() throws SQLException {
        return this._keyGenerator.generateKey();
    }

    @Override
    public Key getKey(byte[] aesKeyBytes, String algorithmName) throws SQLException {
        return new SecretKeySpec(aesKeyBytes, 0, aesKeyBytes.length, this.getJavaAlgorithmName(algorithmName));
    }

    @Override
    public IvParameterSpec getRandomIv() throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidParameterSpecException {
        Cipher cipher = Cipher.getInstance(TRANSFORMATION_NAME);
        IvParameterSpec ivParameterSpec = cipher.getParameters().getParameterSpec(IvParameterSpec.class);
        return ivParameterSpec;
    }

    @Override
    public byte[] encrypt(Key publicKey, byte[] input, IvParameterSpec ivParameterSpec) throws SQLException {
        byte[] output;
        try {
            this._cipher.init(1, publicKey, ivParameterSpec);
            output = this._cipher.doFinal(input);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (InvalidAlgorithmParameterException | BadPaddingException | IllegalBlockSizeException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        return output;
    }

    @Override
    public byte[] encrypt(ColumnEncryptionKey cek, boolean isDeterministic, byte[] input) throws SQLException {
        byte[] output;
        try {
            IvParameterSpec ivParameterSpec = isDeterministic ? this.getDeterministicIv(cek.getKey(), input) : this.getRandomIv();
            this._cipher.init(1, cek.getKey(), ivParameterSpec);
            byte[] iv = ivParameterSpec.getIV();
            OutputBuffer outputBuffer = new OutputBuffer(iv.length + input.length);
            outputBuffer.write(iv);
            outputBuffer.write(input);
            output = this._cipher.doFinal(outputBuffer.getArray());
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (IOException | InvalidAlgorithmParameterException | NoSuchAlgorithmException | InvalidParameterSpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.encrypt.failed", e.getMessage());
        }
        return output;
    }

    @Override
    public byte[] decrypt(ColumnEncryptionKey cek, byte[] packet, int offset, int length) throws SQLException {
        byte[] output;
        int ivLength = this.getIVLength();
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(packet, offset, ivLength);
            this._cipher.init(2, cek.getKey(), ivParameterSpec);
            output = this._cipher.doFinal(packet, offset + ivLength, length - ivLength);
        }
        catch (InvalidKeyException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.crypto.extension.not_installed", e.getMessage());
        }
        catch (InvalidAlgorithmParameterException | BadPaddingException | IllegalBlockSizeException e) {
            throw SQLExceptionSapDB.newInstance((Throwable)e, "error.decrypt.failed", e.getMessage());
        }
        return output;
    }

    @Override
    public String getJavaAlgorithmName(String algorithmName) {
        if (algorithmName.equalsIgnoreCase(HANA_ALGORITHM_NAME)) {
            return JAVA_ALGORITHM_NAME;
        }
        return "UNKNOWN";
    }

    @Override
    public String getTransformationName(String algorithmName) {
        if (algorithmName.equalsIgnoreCase(HANA_ALGORITHM_NAME)) {
            return TRANSFORMATION_NAME;
        }
        return "UNKNOWN";
    }
}

