/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining.data.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.security.datamining.data.HasSubscriptionContext;
import com.sap.sse.security.datamining.data.HasUserContext;
import com.sap.sse.security.shared.subscription.Subscription;

public class SubscriptionWithContext
implements HasSubscriptionContext {
    private final HasUserContext userContext;
    private final Subscription subscription;

    public SubscriptionWithContext(HasUserContext userContext, Subscription subscription) {
        this.userContext = userContext;
        this.subscription = subscription;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.subscription == null ? 0 : (this.subscription.getSubscriptionId() == null ? 0 : this.subscription.getSubscriptionId().hashCode()));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SubscriptionWithContext other = (SubscriptionWithContext)obj;
        return !(this.subscription == null ? other.subscription != null : !Util.equalsWithNull((Object)this.subscription.getSubscriptionId(), (Object)other.subscription.getSubscriptionId()));
    }

    @Override
    public HasUserContext getUserContext() {
        return this.userContext;
    }

    @Override
    public String getPlanID() {
        return this.subscription.getPlanId();
    }

    @Override
    public String getCustomerId() {
        return this.subscription.getCustomerId();
    }

    @Override
    public String getCurrencyCode() {
        return this.subscription.getCurrencyCode();
    }

    @Override
    public String getProviderName() {
        return this.subscription.getProviderName();
    }

    @Override
    public String getSubscriptionStatus() {
        return this.subscription.getSubscriptionStatus();
    }

    @Override
    public Duration getDurationUntilExpiration() {
        return TimePoint.now().until(this.subscription.getCurrentTermEnd());
    }
}

