/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining.data.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.security.SecurityService;
import com.sap.sse.security.datamining.data.HasSessionContext;
import com.sap.sse.security.datamining.data.HasUserContext;
import com.sap.sse.security.shared.impl.User;
import java.util.Date;
import java.util.GregorianCalendar;
import org.apache.shiro.session.Session;

public class SessionWithContext
implements HasSessionContext {
    private final Session session;
    private final HasUserContext userContext;

    public SessionWithContext(final SecurityService securityService, Session session, final User user) {
        this.session = session;
        this.userContext = new HasUserContext(){

            @Override
            public User getUser() {
                return user;
            }

            @Override
            public SecurityService getSecurityService() {
                return securityService;
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.session == null ? 0 : this.session.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SessionWithContext other = (SessionWithContext)obj;
        return !(this.session == null ? other.session != null : !this.session.getId().equals(other.session.getId()));
    }

    @Override
    public HasUserContext getUserContext() {
        return this.userContext;
    }

    @Override
    public int getStartYear() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.session.getStartTimestamp());
        return gregorianCalendar.get(1);
    }

    @Override
    public String getStartMonth() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.session.getStartTimestamp());
        return String.format("%4d-%02d", gregorianCalendar.get(1), gregorianCalendar.get(2) + 1);
    }

    @Override
    public String getExpiryMonth() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.getExpiryTimePoint().asDate());
        return String.format("%4d-%02d", gregorianCalendar.get(1), gregorianCalendar.get(2) + 1);
    }

    @Override
    public Duration getDurationSinceLastAccess() {
        return this.session == null ? null : TimePoint.of((Date)this.session.getLastAccessTime()).until(TimePoint.now());
    }

    @Override
    public Duration getDurationUntilSessionExpiry() {
        return this.session == null ? null : TimePoint.now().until(this.getExpiryTimePoint());
    }

    private TimePoint getExpiryTimePoint() {
        return TimePoint.of((Date)this.session.getLastAccessTime()).plus(Duration.ofMillis((long)this.session.getTimeout()));
    }
}

