/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining.components;

import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.datamining.data.HasRoleOfUserGroupContext;
import com.sap.sse.security.datamining.data.HasUserGroupContext;
import com.sap.sse.security.datamining.data.impl.RoleOfUserGroupWithContext;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.RoleDefinition;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class SecurityRolesOfUserGroupRetrievalProcessor
extends AbstractRetrievalProcessor<HasUserGroupContext, HasRoleOfUserGroupContext> {
    public SecurityRolesOfUserGroupRetrievalProcessor(ExecutorService executor, Collection<Processor<HasRoleOfUserGroupContext, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasUserGroupContext.class, HasRoleOfUserGroupContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<HasRoleOfUserGroupContext> retrieveData(HasUserGroupContext element) {
        HashSet<HasRoleOfUserGroupContext> data = new HashSet<HasRoleOfUserGroupContext>();
        for (Map.Entry roleDefinitionAndForAll : element.getUserGroup().getRoleDefinitionMap().entrySet()) {
            if (this.isAborted()) break;
            Subject subject = SecurityUtils.getSubject();
            if (!subject.isPermitted(((RoleDefinition)roleDefinitionAndForAll.getKey()).getIdentifier().getStringPermission((HasPermissions.Action)HasPermissions.DefaultActions.READ))) continue;
            data.add(new RoleOfUserGroupWithContext(element, (RoleDefinition)roleDefinitionAndForAll.getKey(), (Boolean)roleDefinitionAndForAll.getValue()));
        }
        return data;
    }
}

