/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.security.datamining.components;

import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import com.sap.sse.security.datamining.data.HasPermissionContext;
import com.sap.sse.security.datamining.data.HasUserContext;
import com.sap.sse.security.shared.WildcardPermission;
import com.sap.sse.security.shared.WithQualifiedObjectIdentifier;
import com.sap.sse.security.shared.impl.PermissionAndRoleAssociation;
import com.sap.sse.security.shared.impl.User;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;

public abstract class AbstractSecurityPermissionsOfUserRetrievalProcessor<HUG extends HasUserContext, PWC extends HasPermissionContext>
extends AbstractRetrievalProcessor<HUG, PWC> {
    public AbstractSecurityPermissionsOfUserRetrievalProcessor(ExecutorService executor, Class<HUG> hasUserContextSpecialization, Class<PWC> permissionWithContextSpecialization, Collection<Processor<PWC, ?>> resultReceivers, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(hasUserContextSpecialization, permissionWithContextSpecialization, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
    }

    protected Iterable<PWC> retrieveData(HUG element) {
        HashSet<PWC> data = new HashSet<PWC>();
        for (WildcardPermission permission : element.getUser().getPermissions()) {
            if (this.isAborted()) break;
            WithQualifiedObjectIdentifier permissionAssociation = PermissionAndRoleAssociation.getWithQualifiedObjectIdentifier((WildcardPermission)permission, (User)element.getUser());
            if (!element.getSecurityService().hasCurrentUserReadPermission(permissionAssociation)) continue;
            data.add(this.createPermissionWithContext(element, permission));
        }
        return data;
    }

    protected abstract PWC createPermissionWithContext(HUG var1, WildcardPermission var2);
}

