/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.polars.datamining.components;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Leg;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.WindSource;
import com.sap.sailing.domain.common.impl.WindSpeedSteppingWithMaxDistance;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.tracking.GPSFixTrack;
import com.sap.sailing.domain.tracking.TrackedLegOfCompetitor;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindWithConfidence;
import com.sap.sailing.polars.datamining.data.HasCompetitorPolarContext;
import com.sap.sailing.polars.datamining.data.HasGPSFixPolarContext;
import com.sap.sailing.polars.datamining.data.impl.GPSFixWithPolarContext;
import com.sap.sailing.polars.datamining.data.impl.PolarStatisticImpl;
import com.sap.sailing.polars.datamining.data.impl.SpeedClusterGroup;
import com.sap.sailing.polars.datamining.shared.PolarDataMiningSettings;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.datamining.components.Processor;
import com.sap.sse.datamining.data.ClusterGroup;
import com.sap.sse.datamining.impl.components.AbstractRetrievalProcessor;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class PolarGPSFixRetrievalProcessor
extends AbstractRetrievalProcessor<HasCompetitorPolarContext, HasGPSFixPolarContext> {
    private final PolarDataMiningSettings settings;

    public PolarGPSFixRetrievalProcessor(ExecutorService executor, Collection<Processor<HasGPSFixPolarContext, ?>> resultReceivers, PolarDataMiningSettings settings, int retrievalLevel, String retrievedDataTypeMessageKey) {
        super(HasCompetitorPolarContext.class, HasGPSFixPolarContext.class, executor, resultReceivers, retrievalLevel, retrievedDataTypeMessageKey);
        this.settings = settings;
    }

    protected Iterable<HasGPSFixPolarContext> retrieveData(HasCompetitorPolarContext element) {
        ClusterGroup<Speed> windSpeedRangeGroup = this.toClusterGroup(this.settings.getWindSpeedStepping());
        TrackedRace trackedRace = element.getTrackedRace();
        Competitor competitor = element.getCompetitor();
        Leg leg = element.getLeg();
        GPSFixTrack track = trackedRace.getTrack(competitor);
        TrackedLegOfCompetitor trackedLeg = trackedRace.getTrackedLeg(competitor, leg);
        TimePoint startTime = trackedLeg.getStartTime();
        TimePoint finishTime = trackedLeg.getFinishTime();
        HashSet<HasGPSFixPolarContext> result = new HashSet<HasGPSFixPolarContext>();
        if (startTime != null && finishTime != null) {
            Set<WindSource> windSourcesToIgnoreForSpeed = PolarStatisticImpl.collectWindSourcesToIgnoreForSpeed(trackedRace, this.settings.useOnlyWindGaugesForWindSpeed());
            track.lockForRead();
            try {
                Iterable fixes = track.getFixes(startTime, true, finishTime, false);
                for (GPSFixMoving fix : fixes) {
                    GPSFixWithPolarContext potentialResult;
                    if (this.isAborted()) {
                        break;
                    }
                    WindWithConfidence wind = trackedRace.getWindWithConfidence(fix.getPosition(), fix.getTimePoint(), windSourcesToIgnoreForSpeed);
                    if (wind == null || this.settings.applyMinimumWindConfidence() && !(wind.getConfidence() >= this.settings.getMinimumWindConfidence()) || (potentialResult = new GPSFixWithPolarContext(fix, trackedRace, windSpeedRangeGroup, competitor, this.settings, (WindWithConfidence<Util.Pair<Position, TimePoint>>)wind, element)).getWindSpeedRange().getSignifier().equals("null") || track.hasDirectionChange(fix.getTimePoint(), 5.0)) continue;
                    result.add(potentialResult);
                }
            }
            finally {
                track.unlockAfterRead();
            }
        }
        return result;
    }

    private ClusterGroup<Speed> toClusterGroup(WindSpeedSteppingWithMaxDistance windSpeedStepping) {
        return SpeedClusterGroup.createSpeedClusterGroupFrom(windSpeedStepping);
    }
}

