/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.procedures;

import com.sap.sailing.landscape.SailingAnalyticsMetrics;
import com.sap.sailing.landscape.SailingAnalyticsProcess;
import com.sap.sailing.landscape.SailingReleaseRepository;
import com.sap.sailing.landscape.procedures.SailingProcessConfigurationVariables;
import com.sap.sse.common.Util;
import com.sap.sse.landscape.DefaultProcessConfigurationVariables;
import com.sap.sse.landscape.ProcessConfigurationVariable;
import com.sap.sse.landscape.Release;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.impl.AwsRegion;
import com.sap.sse.landscape.aws.orchestration.AwsApplicationConfiguration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class SailingAnalyticsApplicationConfiguration<ShardingKey>
extends AwsApplicationConfiguration<ShardingKey, SailingAnalyticsMetrics, SailingAnalyticsProcess<ShardingKey>> {
    private final Integer port;
    private final Integer telnetPort;
    private final Integer expeditionPort;
    private final Integer igtimiRiotPort;
    private final String serverDirectory;

    public static <BuilderT extends Builder<BuilderT, T, ShardingKey>, T extends AwsApplicationConfiguration<ShardingKey, SailingAnalyticsMetrics, SailingAnalyticsProcess<ShardingKey>>, ShardingKey> BuilderT builder() {
        BuilderImpl result = new BuilderImpl();
        return (BuilderT)result;
    }

    protected SailingAnalyticsApplicationConfiguration(BuilderImpl<?, ?, ShardingKey> builder) {
        super(builder);
        this.port = builder.getPort();
        this.telnetPort = builder.getTelnetPort();
        this.expeditionPort = builder.getExpeditionPort();
        this.igtimiRiotPort = builder.getIgtimiRiotPort();
        this.serverDirectory = builder.getServerDirectory();
    }

    protected Integer getPort() {
        return this.port;
    }

    protected Integer getTelnetPort() {
        return this.telnetPort;
    }

    protected Integer getExpeditionPort() {
        return this.expeditionPort;
    }

    protected Integer getIgtimiRiotPort() {
        return this.igtimiRiotPort;
    }

    protected String getServerDirectory() {
        return this.serverDirectory;
    }

    protected String getServerName() {
        return super.getServerName();
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, T, ShardingKey>, T extends AwsApplicationConfiguration<ShardingKey, SailingAnalyticsMetrics, SailingAnalyticsProcess<ShardingKey>>, ShardingKey>
    extends AwsApplicationConfiguration.Builder<BuilderT, T, ShardingKey, SailingAnalyticsMetrics, SailingAnalyticsProcess<ShardingKey>> {
        public static final int DEFAULT_PORT = 8888;
        public static final int DEFAULT_TELNET_PORT = 14888;
        public static final int DEFAULT_EXPEDITION_PORT = 2010;

        public BuilderT setPort(int var1);

        public BuilderT setTelnetPort(int var1);

        public BuilderT setExpeditionPort(int var1);

        public BuilderT setIgtimiRiotPort(int var1);

        public BuilderT setServerDirectory(String var1);
    }

    protected static class BuilderImpl<BuilderT extends Builder<BuilderT, T, ShardingKey>, T extends AwsApplicationConfiguration<ShardingKey, SailingAnalyticsMetrics, SailingAnalyticsProcess<ShardingKey>>, ShardingKey>
    extends AwsApplicationConfiguration.BuilderImpl<BuilderT, T, ShardingKey, SailingAnalyticsMetrics, SailingAnalyticsProcess<ShardingKey>>
    implements Builder<BuilderT, T, ShardingKey> {
        private Integer port;
        private Integer telnetPort;
        private Integer expeditionPort;
        private Integer igtimiRiotPort;
        private String serverDirectory;

        protected BuilderImpl() {
        }

        protected Integer getPort() {
            return this.port == null ? 8888 : this.port;
        }

        protected boolean isPortSet() {
            return this.port != null;
        }

        @Override
        public BuilderT setPort(int port) {
            this.port = port;
            return (BuilderT)((Builder)this.self());
        }

        protected Integer getTelnetPort() {
            return this.telnetPort == null ? 14888 : this.telnetPort;
        }

        protected boolean isTelnetPortSet() {
            return this.telnetPort != null;
        }

        @Override
        public BuilderT setTelnetPort(int telnetPort) {
            this.telnetPort = telnetPort;
            return (BuilderT)((Builder)this.self());
        }

        protected Integer getExpeditionPort() {
            return this.expeditionPort == null ? 2010 : this.expeditionPort;
        }

        protected boolean isExpeditionPortSet() {
            return this.expeditionPort != null;
        }

        @Override
        public BuilderT setExpeditionPort(int expeditionPort) {
            this.expeditionPort = expeditionPort;
            return (BuilderT)((Builder)this.self());
        }

        protected Integer getIgtimiRiotPort() {
            return this.igtimiRiotPort;
        }

        protected boolean isIgtimiRiotPortSet() {
            return this.igtimiRiotPort != null;
        }

        @Override
        public BuilderT setIgtimiRiotPort(int igtimiRiotPort) {
            this.igtimiRiotPort = igtimiRiotPort;
            return (BuilderT)((Builder)this.self());
        }

        protected String getServerDirectory() {
            return this.serverDirectory == null ? "/home/sailing/servers/" + this.getServerName() : this.serverDirectory;
        }

        protected boolean isServerDirectorySet() {
            return this.serverDirectory != null;
        }

        @Override
        public BuilderT setServerDirectory(String serverDirectory) {
            this.serverDirectory = serverDirectory;
            return (BuilderT)((Builder)this.self());
        }

        protected Optional<Release> getRelease() {
            return Optional.of(super.getRelease().orElse(SailingReleaseRepository.INSTANCE.getLatestDefaultRelease()));
        }

        protected String getServerName() {
            return super.getServerName();
        }

        protected AwsLandscape<ShardingKey> getLandscape() {
            return super.getLandscape();
        }

        protected AwsRegion getRegion() {
            return super.getRegion();
        }

        protected Map<ProcessConfigurationVariable, String> getUserData() {
            HashMap<ProcessConfigurationVariable, String> result = new HashMap<ProcessConfigurationVariable, String>(super.getUserData());
            this.addUserDataForPort(result, (ProcessConfigurationVariable)DefaultProcessConfigurationVariables.SERVER_PORT, this.getPort());
            this.addUserDataForPort(result, (ProcessConfigurationVariable)DefaultProcessConfigurationVariables.TELNET_PORT, this.getTelnetPort());
            this.addUserDataForPort(result, SailingProcessConfigurationVariables.EXPEDITION_PORT, this.getExpeditionPort());
            if (this.getIgtimiRiotPort() != null) {
                this.addUserDataForPort(result, SailingProcessConfigurationVariables.IGTIMI_RIOT_PORT, this.getIgtimiRiotPort());
            }
            ArrayList<String> newAdditionalJavaArgsVariableValue = new ArrayList<String>();
            newAdditionalJavaArgsVariableValue.add("${" + DefaultProcessConfigurationVariables.ADDITIONAL_JAVA_ARGS.name() + "}");
            Util.addAll(this.getAdditionalJavaArgs(), newAdditionalJavaArgsVariableValue);
            result.put((ProcessConfigurationVariable)DefaultProcessConfigurationVariables.ADDITIONAL_JAVA_ARGS, Util.joinStrings((String)" ", newAdditionalJavaArgsVariableValue));
            return result;
        }

        protected Iterable<String> getAdditionalJavaArgs() {
            ArrayList<String> result = new ArrayList<String>();
            Util.addAll(this.getAdditionalJavaArgsForSharedSecurity("sapsailing.com", "security-service"), result);
            result.add("-Dcom.sap.sse.branding=SAP");
            return result;
        }

        protected void addUserDataForPort(Map<ProcessConfigurationVariable, String> result, ProcessConfigurationVariable variable, Integer port) {
            if (this.getPort() != null) {
                result.put(variable, port.toString());
            }
        }

        public T build() throws Exception {
            SailingAnalyticsApplicationConfiguration result = new SailingAnalyticsApplicationConfiguration(this);
            return (T)((Object)result);
        }

        protected String getDefaultSecurityServiceReplicaSetHostname(String defaultDomainName, String defaultSecurityServiceReplicaSetName) {
            return String.valueOf(defaultSecurityServiceReplicaSetName) + "." + defaultDomainName;
        }

        protected Iterable<String> getAdditionalJavaArgsForSharedSecurity(String defaultDomainName, String defaultSecurityServiceReplicaSetName) {
            return Arrays.asList("-Dsecurity.sharedAcrossSubdomainsOf=" + defaultDomainName, "-Dsecurity.baseUrlForCrossDomainStorage=https://" + this.getDefaultSecurityServiceReplicaSetHostname(defaultDomainName, defaultSecurityServiceReplicaSetName), "-Dgwt.acceptableCrossDomainStorageRequestOriginRegexp=https?://(.*\\.)?" + defaultDomainName.replaceAll("\\.", "\\\\.") + "(:[0-9]*)?$");
        }

        protected String getAdditionalJavaArgForWindEstimation(String defaultDomainName) {
            return "-Dwindestimation.source.url=https://" + defaultDomainName;
        }

        protected String getAdditionalJavaArgForPolarData(String defaultDomainName) {
            return "-Dpolardata.source.url=https://" + defaultDomainName;
        }
    }
}

