/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.procedures;

import com.sap.sailing.landscape.SailingAnalyticsHost;
import com.sap.sailing.landscape.SailingAnalyticsProcess;
import com.sap.sailing.landscape.impl.SailingAnalyticsProcessImpl;
import com.sap.sailing.landscape.procedures.SailingAnalyticsApplicationConfiguration;
import com.sap.sailing.landscape.procedures.SailingAnalyticsHostSupplier;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Util;
import com.sap.sse.concurrent.ConcurrentHashBag;
import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.Process;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.aws.AwsAvailabilityZone;
import com.sap.sse.landscape.aws.AwsInstance;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.orchestration.AbstractAwsProcedureImpl;
import com.sap.sse.landscape.orchestration.Procedure;
import com.sap.sse.landscape.ssh.SshCommandChannel;
import java.util.HashSet;
import java.util.Optional;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeployProcessOnMultiServer<ShardingKey, HostT extends AwsInstance<ShardingKey>, ApplicationConfigurationT extends SailingAnalyticsApplicationConfiguration<ShardingKey>, ApplicationConfigurationBuilderT extends SailingAnalyticsApplicationConfiguration.Builder<ApplicationConfigurationBuilderT, ApplicationConfigurationT, ShardingKey>>
extends AbstractAwsProcedureImpl<ShardingKey>
implements Procedure<ShardingKey> {
    private static final Logger logger = Logger.getLogger(DeployProcessOnMultiServer.class.getName());
    private final SailingAnalyticsHost<ShardingKey> hostToDeployTo;
    private final ApplicationConfigurationT applicationConfiguration;
    private final Optional<Duration> optionalTimeout;
    private final Optional<String> optionalKeyName;
    private final byte[] privateKeyEncryptionPassphrase;
    private SailingAnalyticsProcess<ShardingKey> process;

    public static <BuilderT extends Builder<BuilderT, ShardingKey, HostT, ApplicationConfigurationT, ApplicationConfigurationBuilderT>, ShardingKey, HostT extends AwsInstance<ShardingKey>, ApplicationConfigurationT extends SailingAnalyticsApplicationConfiguration<ShardingKey>, ApplicationConfigurationBuilderT extends SailingAnalyticsApplicationConfiguration.Builder<ApplicationConfigurationBuilderT, ApplicationConfigurationT, ShardingKey>> Builder<BuilderT, ShardingKey, HostT, ApplicationConfigurationT, ApplicationConfigurationBuilderT> builder(ApplicationConfigurationBuilderT applicationConfigurationBuilder, SailingAnalyticsHost<ShardingKey> hostToDeployTo) {
        SailingAnalyticsApplicationConfiguration.BuilderImpl applicationConfigurationBuilderCast = (SailingAnalyticsApplicationConfiguration.BuilderImpl)applicationConfigurationBuilder;
        return new BuilderImpl(applicationConfigurationBuilderCast, hostToDeployTo);
    }

    protected DeployProcessOnMultiServer(BuilderImpl<?, ShardingKey, HostT, ApplicationConfigurationT, ApplicationConfigurationBuilderT> builder) throws Exception {
        super(builder);
        this.hostToDeployTo = builder.getHostToDeployTo();
        this.optionalTimeout = builder.getOptionalTimeout();
        this.optionalKeyName = builder.getOptionalKeyName();
        this.privateKeyEncryptionPassphrase = builder.getPrivateKeyEncryptionPassphrase();
        this.applicationConfiguration = (SailingAnalyticsApplicationConfiguration)((Object)builder.getApplicationConfigurationBuilder().build());
        assert (this.getHostToDeployTo() != null);
    }

    public void run() throws Exception {
        assert (this.getHostToDeployTo() != null);
        String serverDirectory = ((SailingAnalyticsApplicationConfiguration)((Object)this.applicationConfiguration)).getServerDirectory();
        logger.info("Deploying process to multi-server " + this.getHostToDeployTo() + " into directory " + serverDirectory);
        logger.fine("Using configuration:\n" + this.applicationConfiguration.getAsEnvironmentVariableAssignments());
        SshCommandChannel sshChannel = this.getHostToDeployTo().createRootSshChannel(this.optionalTimeout, this.optionalKeyName, this.privateKeyEncryptionPassphrase);
        String stdout = sshChannel.runCommandAndReturnStdoutAndLogStderr("su -l sailing -c \"mkdir -p " + serverDirectory.replaceAll("\"", "\\\\\"") + "; " + "sudo /usr/local/bin/cp_root_mail_properties " + ((SailingAnalyticsApplicationConfiguration)((Object)this.applicationConfiguration)).getServerName() + "; " + "cd " + serverDirectory.replaceAll("\"", "\\\\\"") + "; " + "echo '" + this.applicationConfiguration.getAsEnvironmentVariableAssignments().replaceAll("\"", "\\\\\"").replaceAll("\\$", "\\\\\\$") + "' | /usr/local/bin/refreshInstance.sh auto-install-from-stdin; ./start\";", "stderr: ", Level.WARNING);
        logger.info("stdout: " + stdout);
        this.process = new SailingAnalyticsProcessImpl<ShardingKey>(((SailingAnalyticsApplicationConfiguration)((Object)this.applicationConfiguration)).getPort(), this.getHostToDeployTo(), serverDirectory, ((SailingAnalyticsApplicationConfiguration)((Object)this.applicationConfiguration)).getTelnetPort(), ((SailingAnalyticsApplicationConfiguration)((Object)this.applicationConfiguration)).getServerName(), ((SailingAnalyticsApplicationConfiguration)((Object)this.applicationConfiguration)).getExpeditionPort(), ((SailingAnalyticsApplicationConfiguration)((Object)this.applicationConfiguration)).getIgtimiRiotPort(), this.getLandscape());
    }

    public SailingAnalyticsProcess<ShardingKey> getProcess() {
        return this.process;
    }

    private SailingAnalyticsHost<ShardingKey> getHostToDeployTo() {
        return this.hostToDeployTo;
    }

    public static interface Builder<BuilderT extends Builder<BuilderT, ShardingKey, HostT, ApplicationConfigurationT, ApplicationConfigurationBuilderT>, ShardingKey, HostT extends AwsInstance<ShardingKey>, ApplicationConfigurationT extends SailingAnalyticsApplicationConfiguration<ShardingKey>, ApplicationConfigurationBuilderT extends SailingAnalyticsApplicationConfiguration.Builder<ApplicationConfigurationBuilderT, ApplicationConfigurationT, ShardingKey>>
    extends AbstractAwsProcedureImpl.Builder<BuilderT, DeployProcessOnMultiServer<ShardingKey, HostT, ApplicationConfigurationT, ApplicationConfigurationBuilderT>, ShardingKey> {
        public BuilderT setKeyName(String var1);

        public BuilderT setPrivateKeyEncryptionPassphrase(byte[] var1);
    }

    public static class BuilderImpl<BuilderT extends Builder<BuilderT, ShardingKey, HostT, ApplicationConfigurationT, ApplicationConfigurationBuilderT>, ShardingKey, HostT extends AwsInstance<ShardingKey>, ApplicationConfigurationT extends SailingAnalyticsApplicationConfiguration<ShardingKey>, ApplicationConfigurationBuilderT extends SailingAnalyticsApplicationConfiguration.Builder<ApplicationConfigurationBuilderT, ApplicationConfigurationT, ShardingKey>>
    extends AbstractAwsProcedureImpl.BuilderImpl<BuilderT, DeployProcessOnMultiServer<ShardingKey, HostT, ApplicationConfigurationT, ApplicationConfigurationBuilderT>, ShardingKey>
    implements Builder<BuilderT, ShardingKey, HostT, ApplicationConfigurationT, ApplicationConfigurationBuilderT> {
        private final SailingAnalyticsApplicationConfiguration.BuilderImpl<ApplicationConfigurationBuilderT, ApplicationConfigurationT, ShardingKey> applicationConfigurationBuilder;
        private final SailingAnalyticsHost<ShardingKey> hostToDeployTo;
        private Optional<String> optionalKeyName = Optional.empty();
        private byte[] privateKeyEncryptionPassphrase;

        protected BuilderImpl(SailingAnalyticsApplicationConfiguration.BuilderImpl<ApplicationConfigurationBuilderT, ApplicationConfigurationT, ShardingKey> applicationConfigurationBuilder, SailingAnalyticsHost<ShardingKey> hostToDeployTo) {
            this.applicationConfigurationBuilder = applicationConfigurationBuilder;
            this.hostToDeployTo = hostToDeployTo;
        }

        public DeployProcessOnMultiServer<ShardingKey, HostT, ApplicationConfigurationT, ApplicationConfigurationBuilderT> build() throws Exception {
            assert (this.getHostToDeployTo() != null);
            assert (this.getApplicationConfigurationBuilder().getServerName() != null);
            if (this.getLandscape() == null) {
                if (this.getApplicationConfigurationBuilder().getLandscape() != null) {
                    this.setLandscape((Landscape)this.getApplicationConfigurationBuilder().getLandscape());
                } else {
                    this.setLandscape((Landscape)this.getHostToDeployTo().getLandscape());
                }
            }
            if (this.getApplicationConfigurationBuilder().getLandscape() == null) {
                this.getApplicationConfigurationBuilder().setLandscape(this.getLandscape());
            }
            if (this.getApplicationConfigurationBuilder().getRegion() == null) {
                this.getApplicationConfigurationBuilder().setRegion(this.getHostToDeployTo().getRegion());
            }
            if (!this.getApplicationConfigurationBuilder().isServerDirectorySet()) {
                this.getApplicationConfigurationBuilder().setServerDirectory("/home/sailing/servers/" + this.getApplicationConfigurationBuilder().getServerName());
            }
            if (!this.getApplicationConfigurationBuilder().isPortSet()) {
                this.getApplicationConfigurationBuilder().setPort(this.getNextAvailablePort(this.getHostToDeployTo(), 8888, Process::getPort));
            }
            if (!this.getApplicationConfigurationBuilder().isTelnetPortSet()) {
                this.getApplicationConfigurationBuilder().setTelnetPort(this.getNextAvailablePort(this.getHostToDeployTo(), 14888, ap -> {
                    try {
                        return ap.getTelnetPortToOSGiConsole(this.getOptionalTimeout(), this.optionalKeyName, this.privateKeyEncryptionPassphrase);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }));
            }
            if (!this.getApplicationConfigurationBuilder().isExpeditionPortSet()) {
                this.getApplicationConfigurationBuilder().setExpeditionPort(this.getNextAvailablePort(this.getHostToDeployTo(), 2010, ap -> {
                    try {
                        return ap.getExpeditionUdpPort(this.getOptionalTimeout(), this.optionalKeyName, this.privateKeyEncryptionPassphrase);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }));
            }
            if (!this.getApplicationConfigurationBuilder().isIgtimiRiotPortSet() && this.getApplicationConfigurationBuilder().getServerName().equals("wind")) {
                this.getApplicationConfigurationBuilder().setIgtimiRiotPort(6000);
            }
            return new DeployProcessOnMultiServer(this);
        }

        private int getNextAvailablePort(SailingAnalyticsHost<ShardingKey> hostToDeployTo, int defaultPort, Function<SailingAnalyticsProcess<ShardingKey>, Integer> portFetcher) throws Exception {
            logger.info("Scanning for available port on " + hostToDeployTo + ", starting at " + defaultPort);
            HashSet<Integer> occupiedPorts = new HashSet<Integer>();
            HashSet applicationProcessesToScan = new HashSet();
            Util.addAll((Iterable)hostToDeployTo.getApplicationProcesses(this.getOptionalTimeout(), this.optionalKeyName, this.privateKeyEncryptionPassphrase), applicationProcessesToScan);
            for (SailingAnalyticsProcess applicationProcess : applicationProcessesToScan) {
                occupiedPorts.add(portFetcher.apply(applicationProcess));
            }
            AwsAvailabilityZone azOfHostToDeployTo = hostToDeployTo.getAvailabilityZone();
            int numberOfSharedHostsInOtherAZs = 0;
            ConcurrentHashBag portsOccupiedInSharedHostsInOtherAZs = new ConcurrentHashBag();
            for (SailingAnalyticsHost sharedHost : this.getLandscape().getRunningHostsWithTagValue((Region)this.getApplicationConfigurationBuilder().getRegion(), "sailing-analytics-server", "___multi___", new SailingAnalyticsHostSupplier())) {
                if (sharedHost.getAvailabilityZone().equals(azOfHostToDeployTo)) continue;
                logger.info("...also scanning for available port on shared host " + sharedHost + " because it is in different availability zone");
                ++numberOfSharedHostsInOtherAZs;
                for (SailingAnalyticsProcess processOnSharedHostInOtherAZ : sharedHost.getApplicationProcesses(this.getOptionalTimeout(), this.optionalKeyName, this.privateKeyEncryptionPassphrase)) {
                    portsOccupiedInSharedHostsInOtherAZs.add((Object)portFetcher.apply(processOnSharedHostInOtherAZ));
                }
            }
            int port = defaultPort;
            while (port < Integer.MAX_VALUE && (occupiedPorts.contains(port) || numberOfSharedHostsInOtherAZs > 0 && portsOccupiedInSharedHostsInOtherAZs.count((Object)port) == numberOfSharedHostsInOtherAZs)) {
                if (!occupiedPorts.contains(port)) {
                    logger.info("Didn't choose port " + port + " because all " + numberOfSharedHostsInOtherAZs + " in other AZs occupy it.");
                }
                ++port;
            }
            logger.info("Identified " + port + " as the next available port, started at " + defaultPort);
            return port;
        }

        protected AwsLandscape<ShardingKey> getLandscape() {
            return super.getLandscape();
        }

        protected SailingAnalyticsHost<ShardingKey> getHostToDeployTo() {
            return this.hostToDeployTo;
        }

        protected SailingAnalyticsApplicationConfiguration.BuilderImpl<ApplicationConfigurationBuilderT, ApplicationConfigurationT, ShardingKey> getApplicationConfigurationBuilder() {
            return this.applicationConfigurationBuilder;
        }

        protected Optional<Duration> getOptionalTimeout() {
            return super.getOptionalTimeout();
        }

        @Override
        public BuilderT setPrivateKeyEncryptionPassphrase(byte[] privateKeyEncryptionPassphrase) {
            this.privateKeyEncryptionPassphrase = privateKeyEncryptionPassphrase;
            return (BuilderT)((Builder)this.self());
        }

        protected byte[] getPrivateKeyEncryptionPassphrase() {
            return this.privateKeyEncryptionPassphrase;
        }

        @Override
        public BuilderT setKeyName(String keyName) {
            this.optionalKeyName = Optional.ofNullable(keyName);
            return (BuilderT)((Builder)this.self());
        }

        protected Optional<String> getOptionalKeyName() {
            return this.optionalKeyName;
        }
    }
}

