/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.landscape.procedures;

import com.sap.sse.landscape.Landscape;
import com.sap.sse.landscape.Region;
import com.sap.sse.landscape.application.ApplicationProcessMetrics;
import com.sap.sse.landscape.aws.AmazonMachineImage;
import com.sap.sse.landscape.aws.AwsApplicationProcess;
import com.sap.sse.landscape.aws.AwsLandscape;
import com.sap.sse.landscape.aws.Tags;
import com.sap.sse.landscape.aws.TargetGroup;
import com.sap.sse.landscape.aws.orchestration.AwsApplicationConfiguration;
import com.sap.sse.landscape.orchestration.AbstractProcedureImpl;
import com.sap.sse.landscape.orchestration.Procedure;
import java.util.Optional;
import software.amazon.awssdk.services.ec2.model.InstanceType;

public class CreateLaunchTemplateAndAutoScalingGroup<ShardingKey, MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>>
extends AbstractProcedureImpl<ShardingKey>
implements Procedure<ShardingKey> {
    private static final int DEFAULT_MIN_REPLICAS = 1;
    private static final int DEFAULT_MAX_REPLICAS = 30;
    private final String replicaSetName;
    private final TargetGroup<ShardingKey> targetGroup;
    private final Region region;
    private final String keyName;
    private final InstanceType instanceType;
    private final String imageId;
    private final AwsApplicationConfiguration<ShardingKey, MetricsT, ProcessT> replicaConfiguration;
    private final Optional<Tags> tags;
    private final int minReplicas;
    private final int maxReplicas;
    private final int maxRequestsPerTarget;

    public static <ShardingKey, BuilderT extends Builder<ShardingKey, BuilderT, MetricsT, ProcessT>, MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>> Builder<ShardingKey, BuilderT, MetricsT, ProcessT> builder(AwsLandscape<ShardingKey> landscape, Region region, String replicaSetName, TargetGroup<ShardingKey> targetGroup) {
        return new BuilderImpl(landscape, region, replicaSetName, targetGroup);
    }

    protected <BuilderT extends Builder<ShardingKey, BuilderT, MetricsT, ProcessT>> CreateLaunchTemplateAndAutoScalingGroup(BuilderImpl<ShardingKey, BuilderT, MetricsT, ProcessT> builder) {
        super(builder);
        this.region = builder.getRegion();
        this.replicaSetName = builder.getReplicaSetName();
        this.targetGroup = builder.getTargetGroup();
        this.keyName = builder.getKeyName();
        this.imageId = builder.getImage().getId();
        this.instanceType = builder.getInstanceType();
        this.replicaConfiguration = builder.getReplicaConfiguration();
        this.tags = builder.getTags();
        this.minReplicas = builder.getMinReplicas();
        this.maxReplicas = builder.getMaxReplicas();
        this.maxRequestsPerTarget = builder.getMaxRequestsPerTarget();
    }

    public AwsLandscape<ShardingKey> getLandscape() {
        return (AwsLandscape)super.getLandscape();
    }

    public void run() throws Exception {
        this.getLandscape().createLaunchTemplateAndAutoScalingGroup(this.region, this.replicaSetName, this.tags, this.targetGroup, this.keyName, this.instanceType, this.imageId, this.replicaConfiguration, this.minReplicas, this.maxReplicas, this.maxRequestsPerTarget);
    }

    public static interface Builder<ShardingKey, BuilderT extends Builder<ShardingKey, BuilderT, MetricsT, ProcessT>, MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends Procedure.Builder<BuilderT, CreateLaunchTemplateAndAutoScalingGroup<ShardingKey, MetricsT, ProcessT>, ShardingKey> {
        public BuilderT setKeyName(String var1);

        public BuilderT setReplicaConfiguration(AwsApplicationConfiguration<ShardingKey, MetricsT, ProcessT> var1);

        public BuilderT setInstanceType(InstanceType var1);

        public BuilderT setImage(AmazonMachineImage<ShardingKey> var1);

        public BuilderT setTags(Tags var1);

        public BuilderT setMinReplicas(int var1);

        public BuilderT setMaxReplicas(int var1);

        public BuilderT setMaxRequestsPerTarget(int var1);
    }

    protected static class BuilderImpl<ShardingKey, BuilderT extends Builder<ShardingKey, BuilderT, MetricsT, ProcessT>, MetricsT extends ApplicationProcessMetrics, ProcessT extends AwsApplicationProcess<ShardingKey, MetricsT, ProcessT>>
    extends AbstractProcedureImpl.BuilderImpl<BuilderT, CreateLaunchTemplateAndAutoScalingGroup<ShardingKey, MetricsT, ProcessT>, ShardingKey>
    implements Builder<ShardingKey, BuilderT, MetricsT, ProcessT> {
        private final String replicaSetName;
        private final TargetGroup<ShardingKey> targetGroup;
        private final Region region;
        private String keyName;
        private AmazonMachineImage<ShardingKey> image;
        private InstanceType instanceType;
        private AwsApplicationConfiguration<ShardingKey, MetricsT, ProcessT> replicaConfiguration;
        private Optional<Tags> tags;
        private int minReplicas = 1;
        private int maxReplicas = 30;
        private int maxRequestsPerTarget = 15000;

        public BuilderImpl(AwsLandscape<ShardingKey> landscape, Region region, String replicaSetName, TargetGroup<ShardingKey> targetGroup) {
            this.replicaSetName = replicaSetName;
            this.targetGroup = targetGroup;
            this.region = region;
            this.setLandscape((Landscape)landscape);
        }

        @Override
        public BuilderT setKeyName(String keyName) {
            this.keyName = keyName;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setImage(AmazonMachineImage<ShardingKey> image) {
            this.image = image;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setInstanceType(InstanceType instanceType) {
            this.instanceType = instanceType;
            return (BuilderT)((Builder)this.self());
        }

        @Override
        public BuilderT setReplicaConfiguration(AwsApplicationConfiguration<ShardingKey, MetricsT, ProcessT> replicaConfiguration) {
            this.replicaConfiguration = replicaConfiguration;
            return (BuilderT)((Builder)this.self());
        }

        protected String getReplicaSetName() {
            return this.replicaSetName;
        }

        protected int getMinReplicas() {
            return this.minReplicas;
        }

        @Override
        public BuilderT setMinReplicas(int minReplicas) {
            this.minReplicas = minReplicas;
            return (BuilderT)((Builder)this.self());
        }

        protected int getMaxReplicas() {
            return this.maxReplicas;
        }

        @Override
        public BuilderT setMaxReplicas(int maxReplicas) {
            this.maxReplicas = maxReplicas;
            return (BuilderT)((Builder)this.self());
        }

        protected int getMaxRequestsPerTarget() {
            return this.maxRequestsPerTarget;
        }

        @Override
        public BuilderT setMaxRequestsPerTarget(int maxRequestsPerTarget) {
            this.maxRequestsPerTarget = maxRequestsPerTarget;
            return (BuilderT)((Builder)this.self());
        }

        protected TargetGroup<ShardingKey> getTargetGroup() {
            return this.targetGroup;
        }

        protected Region getRegion() {
            return this.region;
        }

        protected String getKeyName() {
            return this.keyName;
        }

        protected AmazonMachineImage<ShardingKey> getImage() {
            return this.image;
        }

        protected InstanceType getInstanceType() {
            return this.instanceType;
        }

        protected AwsApplicationConfiguration<ShardingKey, MetricsT, ProcessT> getReplicaConfiguration() {
            return this.replicaConfiguration;
        }

        protected Optional<Tags> getTags() {
            return this.tags;
        }

        @Override
        public BuilderT setTags(Tags tags) {
            this.tags = Optional.ofNullable(tags);
            return (BuilderT)((Builder)this.self());
        }

        public CreateLaunchTemplateAndAutoScalingGroup<ShardingKey, MetricsT, ProcessT> build() throws Exception {
            return new CreateLaunchTemplateAndAutoScalingGroup(this);
        }
    }
}

