/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.hanaexport.jaxrs.api;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.NoWindException;
import com.sap.sailing.domain.common.Tack;
import com.sap.sailing.domain.tracking.MarkPassing;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.hanaexport.jaxrs.api.AbstractPreparedInsertStatement;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.NavigableSet;

public class InsertRaceStatsStatement
extends AbstractPreparedInsertStatement<TrackedRaceWithCompetitorAndStartWaypoint> {
    private static final Duration DURATION_AFTER_START_TO_DECIDE_START_WINNER = Duration.ONE_SECOND.times(90L);

    protected InsertRaceStatsStatement(Connection connection) throws SQLException {
        super(connection.prepareStatement("INSERT INTO SAILING.\"RaceStats\" (\"race\", \"regatta\", \"competitorId\", \"rankOneBased\", \"distanceSailedInMeters\", \"elapsedTimeInSeconds\", \"avgCrossTrackErrorInMeters\", \"absoluteAvgCrossTrackErrorInMeters\", \"startDelayInSeconds\", \"distanceFromStartLineInMetersAtStart\", \"windwardDistanceFromStartLineInMetersAtStart\", \"speedWhenCrossingStartLineInKnots\", \"startTack\", \"rank90sAfterStart\") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);"));
    }

    @Override
    public void parameterizeStatement(TrackedRaceWithCompetitorAndStartWaypoint raceColumnFleetAndTrackedRace) throws SQLException {
        Tack startTack;
        double startDelayInSeconds;
        boolean didCompetitorStart;
        TrackedRace trackedRace = raceColumnFleetAndTrackedRace.getTrackedRace();
        Competitor competitor = raceColumnFleetAndTrackedRace.getCompetitor();
        TimePoint now = raceColumnFleetAndTrackedRace.getNow();
        this.getPreparedStatement().setString(1, trackedRace.getRace().getName());
        this.getPreparedStatement().setString(2, trackedRace.getTrackedRegatta().getRegatta().getName());
        this.getPreparedStatement().setString(3, competitor.getId().toString());
        this.getPreparedStatement().setInt(4, trackedRace.getRank(competitor, now));
        this.setDouble(5, this.metersOr0ForNull(trackedRace.getDistanceTraveled(competitor, now)));
        this.setDouble(6, this.secondsOr0ForNull(trackedRace.getTimeSailedSinceRaceStart(competitor, now)));
        this.setDouble(7, this.metersOr0ForNull(trackedRace.getAverageSignedCrossTrackError(competitor, now, false)));
        this.setDouble(8, this.metersOr0ForNull(trackedRace.getAverageAbsoluteCrossTrackError(competitor, now, false)));
        TimePoint startOfRace = trackedRace.getStartOfRace();
        if (raceColumnFleetAndTrackedRace.getStartWaypoint() != null && startOfRace != null) {
            NavigableSet competitorMarkPassings = trackedRace.getMarkPassings(competitor);
            trackedRace.lockForRead((Iterable)competitorMarkPassings);
            try {
                if (!Util.isEmpty((Iterable)competitorMarkPassings)) {
                    MarkPassing competitorStartMarkPassing = (MarkPassing)competitorMarkPassings.iterator().next();
                    TimePoint competitorStartTime = competitorStartMarkPassing.getTimePoint();
                    didCompetitorStart = competitorStartTime != null;
                    startDelayInSeconds = this.secondsOr0ForNull(startOfRace.until(competitorStartTime));
                    try {
                        startTack = trackedRace.getTack(competitor, competitorStartTime);
                    }
                    catch (NoWindException e) {
                        startTack = null;
                    }
                }
                startDelayInSeconds = 0.0;
                startTack = null;
                didCompetitorStart = false;
            }
            finally {
                trackedRace.unlockAfterRead((Iterable)competitorMarkPassings);
            }
        } else {
            startDelayInSeconds = 0.0;
            startTack = null;
            didCompetitorStart = false;
        }
        this.setDouble(9, startDelayInSeconds);
        if (startOfRace != null && didCompetitorStart) {
            this.setDouble(10, this.metersOr0ForNull(trackedRace.getDistanceToStartLine(competitor, startOfRace)));
            this.setDouble(11, this.metersOr0ForNull(trackedRace.getWindwardDistanceToFavoredSideOfStartLine(competitor, startOfRace)));
            Speed speedWhenCrossingStartLine = trackedRace.getSpeedWhenCrossingStartLine(competitor);
            this.setDouble(12, speedWhenCrossingStartLine == null ? 0.0 : speedWhenCrossingStartLine.getKnots());
            this.getPreparedStatement().setString(13, startTack == null ? null : startTack.name());
            this.getPreparedStatement().setInt(14, trackedRace.getRank(competitor, startOfRace.plus(DURATION_AFTER_START_TO_DECIDE_START_WINNER)));
        } else {
            this.setDouble(10, 0.0);
            this.setDouble(11, 0.0);
            this.setDouble(12, 0.0);
            this.getPreparedStatement().setString(13, null);
            this.getPreparedStatement().setInt(14, 0);
        }
    }

    static class TrackedRaceWithCompetitorAndStartWaypoint {
        private final TimePoint now;
        private final Waypoint startWaypoint;
        private final Competitor competitor;
        private final TrackedRace trackedRace;

        public TrackedRaceWithCompetitorAndStartWaypoint(TimePoint now, Waypoint startWaypoint, Competitor competitor, TrackedRace trackedRace) {
            this.now = now;
            this.startWaypoint = startWaypoint;
            this.competitor = competitor;
            this.trackedRace = trackedRace;
        }

        public TimePoint getNow() {
            return this.now;
        }

        public Waypoint getStartWaypoint() {
            return this.startWaypoint;
        }

        public Competitor getCompetitor() {
            return this.competitor;
        }

        public TrackedRace getTrackedRace() {
            return this.trackedRace;
        }
    }
}

