/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.hanaexport.jaxrs.api;

import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.SpeedWithConfidence;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.hanaexport.jaxrs.api.AbstractPreparedInsertStatement;
import com.sap.sse.common.Speed;
import com.sap.sse.common.Util;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;

public class InsertRaceStatement
extends AbstractPreparedInsertStatement<TrackedRaceWithRaceColumnAndFleet> {
    protected InsertRaceStatement(Connection connection) throws SQLException {
        super(connection.prepareStatement("INSERT INTO SAILING.\"Race\" (\"name\", \"regatta\", \"raceColumn\", \"fleet\", \"startOfTracking\", \"startOfRace\", \"endOfTracking\", \"endOfRace\", \"avgWindSpeedInKnots\", \"raceColumnIndexZeroBased\", \"gateStart\") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?);"));
    }

    @Override
    public void parameterizeStatement(TrackedRaceWithRaceColumnAndFleet raceColumnFleetAndTrackedRace) throws SQLException {
        TrackedRace trackedRace = raceColumnFleetAndTrackedRace.getTrackedRace();
        this.getPreparedStatement().setString(1, trackedRace.getRace().getName());
        this.getPreparedStatement().setString(2, trackedRace.getTrackedRegatta().getRegatta().getName());
        this.getPreparedStatement().setString(3, raceColumnFleetAndTrackedRace.getRaceColumn().getName());
        this.getPreparedStatement().setString(4, raceColumnFleetAndTrackedRace.getFleet() == null ? null : raceColumnFleetAndTrackedRace.getFleet().getName());
        if (trackedRace.getStartOfTracking() != null) {
            this.getPreparedStatement().setDate(5, new Date(trackedRace.getStartOfTracking().asMillis()));
        } else {
            this.getPreparedStatement().setDate(5, null);
        }
        if (trackedRace.getStartOfRace() != null) {
            this.getPreparedStatement().setDate(6, new Date(trackedRace.getStartOfRace().asMillis()));
        } else {
            this.getPreparedStatement().setDate(6, null);
        }
        if (trackedRace.getEndOfTracking() != null) {
            this.getPreparedStatement().setDate(7, new Date(trackedRace.getEndOfTracking().asMillis()));
        } else {
            this.getPreparedStatement().setDate(7, null);
        }
        if (trackedRace.getEndOfRace() != null) {
            this.getPreparedStatement().setDate(8, new Date(trackedRace.getEndOfRace().asMillis()));
        } else {
            this.getPreparedStatement().setDate(8, null);
        }
        SpeedWithConfidence averageWind = trackedRace.getAverageWindSpeedWithConfidenceWithNumberOfSamples(5);
        if (averageWind != null) {
            this.setDouble(9, ((Speed)averageWind.getObject()).getKnots());
        } else {
            this.setDouble(9, 0.0);
        }
        this.getPreparedStatement().setInt(10, Util.indexOf((Iterable)trackedRace.getTrackedRegatta().getRegatta().getRaceColumns(), (Object)raceColumnFleetAndTrackedRace.getRaceColumn()));
        Boolean gateStart = trackedRace.isGateStart();
        this.getPreparedStatement().setBoolean(11, gateStart == null ? false : gateStart);
    }

    static class TrackedRaceWithRaceColumnAndFleet {
        private final TrackedRace trackedRace;
        private final RaceColumn raceColumn;
        private final Fleet fleet;

        public TrackedRaceWithRaceColumnAndFleet(TrackedRace trackedRace, RaceColumn raceColumn, Fleet fleet) {
            this.trackedRace = trackedRace;
            this.raceColumn = raceColumn;
            this.fleet = fleet;
        }

        public TrackedRace getTrackedRace() {
            return this.trackedRace;
        }

        public RaceColumn getRaceColumn() {
            return this.raceColumn;
        }

        public Fleet getFleet() {
            return this.fleet;
        }
    }
}

