/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.hanaexport.jaxrs.api;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.hanaexport.jaxrs.api.AbstractPreparedInsertStatement;
import com.sap.sse.common.TimePoint;
import java.sql.Connection;
import java.sql.SQLException;

public class InsertRaceResultStatement
extends AbstractPreparedInsertStatement<RaceResult> {
    protected InsertRaceResultStatement(Connection connection) throws SQLException {
        super(connection.prepareStatement("INSERT INTO SAILING.\"RaceResult\" (\"regatta\", \"raceColumn\", \"fleet\", \"competitorId\", \"points\", \"discarded\", \"irm\", \"columnFactor\", \"netPoints\") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?);"));
    }

    @Override
    public void parameterizeStatement(RaceResult raceResult) throws SQLException {
        this.getPreparedStatement().setString(1, raceResult.getRegatta().getName());
        this.getPreparedStatement().setString(2, raceResult.getRaceColumn().getName());
        this.getPreparedStatement().setString(3, raceResult.getFleet() == null ? null : raceResult.getFleet().getName());
        this.getPreparedStatement().setString(4, raceResult.getCompetitor().getId().toString());
        Double totalPoints = raceResult.getLeaderboard().getTotalPoints(raceResult.getCompetitor(), raceResult.getRaceColumn(), raceResult.getNow());
        this.setDouble(5, totalPoints == null ? 0.0 : totalPoints);
        this.getPreparedStatement().setBoolean(6, raceResult.getLeaderboard().isDiscarded(raceResult.getCompetitor(), raceResult.getRaceColumn(), raceResult.getNow()));
        MaxPointsReason maxPointsReason = raceResult.getLeaderboard().getMaxPointsReason(raceResult.getCompetitor(), raceResult.getRaceColumn(), raceResult.getNow());
        this.getPreparedStatement().setString(7, (maxPointsReason == null ? MaxPointsReason.NONE : maxPointsReason).name());
        this.setDouble(8, raceResult.getLeaderboard().getScoringScheme().getScoreFactor(raceResult.getRaceColumn()));
        Double netPoints = raceResult.getLeaderboard().getNetPoints(raceResult.getCompetitor(), raceResult.getRaceColumn(), raceResult.getNow());
        this.setDouble(9, netPoints == null ? 0.0 : netPoints);
    }

    static class RaceResult {
        private final Regatta regatta;
        private final Leaderboard leaderboard;
        private final Competitor competitor;
        private final RaceColumn raceColumn;
        private final Fleet fleet;
        private final TimePoint now;

        public RaceResult(Regatta regatta, Leaderboard leaderboard, Competitor competitor, RaceColumn raceColumn, Fleet fleet, TimePoint now) {
            this.regatta = regatta;
            this.leaderboard = leaderboard;
            this.competitor = competitor;
            this.raceColumn = raceColumn;
            this.fleet = fleet;
            this.now = now;
        }

        public Regatta getRegatta() {
            return this.regatta;
        }

        public Leaderboard getLeaderboard() {
            return this.leaderboard;
        }

        public Competitor getCompetitor() {
            return this.competitor;
        }

        public RaceColumn getRaceColumn() {
            return this.raceColumn;
        }

        public Fleet getFleet() {
            return this.fleet;
        }

        public TimePoint getNow() {
            return this.now;
        }
    }
}

