/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.hanaexport.jaxrs.api;

import com.sap.sailing.domain.base.Competitor;
import com.sap.sailing.domain.base.Event;
import com.sap.sailing.domain.base.Fleet;
import com.sap.sailing.domain.base.RaceColumn;
import com.sap.sailing.domain.base.Regatta;
import com.sap.sailing.domain.base.Waypoint;
import com.sap.sailing.domain.common.ManeuverType;
import com.sap.sailing.domain.common.MaxPointsReason;
import com.sap.sailing.domain.common.ScoringSchemeType;
import com.sap.sailing.domain.leaderboard.Leaderboard;
import com.sap.sailing.domain.leaderboard.LeaderboardGroup;
import com.sap.sailing.domain.leaderboard.RegattaLeaderboard;
import com.sap.sailing.domain.leaderboard.ScoringScheme;
import com.sap.sailing.domain.leaderboard.caching.LeaderboardDTOCalculationReuseCache;
import com.sap.sailing.domain.ranking.RankingMetric;
import com.sap.sailing.domain.tracking.Maneuver;
import com.sap.sailing.domain.tracking.TrackedLeg;
import com.sap.sailing.domain.tracking.TrackedRace;
import com.sap.sailing.domain.tracking.WindLegTypeAndLegBearingAndORCPerformanceCurveCache;
import com.sap.sailing.hanaexport.HanaConnectionFactory;
import com.sap.sailing.hanaexport.jaxrs.api.InsertBoatClassStatement;
import com.sap.sailing.hanaexport.jaxrs.api.InsertCompetitorStatement;
import com.sap.sailing.hanaexport.jaxrs.api.InsertEventStatement;
import com.sap.sailing.hanaexport.jaxrs.api.InsertIrmStatement;
import com.sap.sailing.hanaexport.jaxrs.api.InsertLegStatement;
import com.sap.sailing.hanaexport.jaxrs.api.InsertLegStatsStatement;
import com.sap.sailing.hanaexport.jaxrs.api.InsertManeuverStatement;
import com.sap.sailing.hanaexport.jaxrs.api.InsertRaceResultStatement;
import com.sap.sailing.hanaexport.jaxrs.api.InsertRaceStatement;
import com.sap.sailing.hanaexport.jaxrs.api.InsertRaceStatsStatement;
import com.sap.sailing.hanaexport.jaxrs.api.InsertRegattaStatement;
import com.sap.sailing.hanaexport.jaxrs.api.InsertScoringSchemeStatement;
import com.sap.sailing.server.interfaces.RacingEventService;
import com.sap.sailing.shared.server.gateway.jaxrs.SharedAbstractSailingServerResource;
import com.sap.sse.ServerInfo;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.impl.SecuredSecurityTypes;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;
import org.apache.shiro.SecurityUtils;

@Path(value="/v1/exporter")
public class HanaCloudSacExportResource
extends SharedAbstractSailingServerResource {
    private static final Logger logger = Logger.getLogger(HanaCloudSacExportResource.class.getName());

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="clear")
    public Response clear(@FormParam(value="dbendpoint") String dbEndpoint, @FormParam(value="dbuser") String dbUser, @FormParam(value="dbpassword") String dbPassword) throws SQLException, IOException {
        SecurityUtils.getSubject().checkPermission(SecuredSecurityTypes.SERVER.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)SecuredSecurityTypes.ServerActions.CAN_EXPORT_MASTERDATA, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})));
        logger.info("Clearing HANA Cloud SAILING DB on behalf of user " + SecurityUtils.getSubject().getPrincipal());
        Connection connection = HanaConnectionFactory.INSTANCE.getConnection(Optional.ofNullable(dbEndpoint), Optional.ofNullable(dbUser), Optional.ofNullable(dbPassword));
        this.tryExecutingQueriesFromSqlResource("/cleartables.sql", connection);
        logger.info("Done clearing HANA Cloud SAILING DB on behalf of user " + SecurityUtils.getSubject().getPrincipal());
        return Response.ok().build();
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="export")
    public Response export(@QueryParam(value="leaderboardgroupid") List<String> leaderboardGroupIds, @QueryParam(value="eventid") List<String> eventIds, @FormParam(value="dbendpoint") String dbEndpoint, @FormParam(value="dbuser") String dbUser, @FormParam(value="dbpassword") String dbPassword) throws SQLException {
        SecurityUtils.getSubject().checkPermission(SecuredSecurityTypes.SERVER.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)SecuredSecurityTypes.ServerActions.CAN_EXPORT_MASTERDATA, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})));
        logger.info("Exporting HANA Cloud SAILING DB content on behalf of user " + SecurityUtils.getSubject().getPrincipal());
        RacingEventService racingEventService = this.getService();
        try {
            Connection connection = HanaConnectionFactory.INSTANCE.getConnection(Optional.ofNullable(dbEndpoint), Optional.ofNullable(dbUser), Optional.ofNullable(dbPassword));
            this.exportBoatClasses(racingEventService, connection);
            this.exportIrms(racingEventService, connection);
            this.exportScoringSchemes(racingEventService, connection);
            Iterable<Regatta> regattasToExport = this.getRegattasToExport(racingEventService, leaderboardGroupIds, eventIds);
            this.exportRaces(racingEventService, regattasToExport, connection);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem exporting data to HANA", e);
            throw e;
        }
        logger.info("Done exporting HANA Cloud SAILING DB content on behalf of user " + SecurityUtils.getSubject().getPrincipal());
        return Response.ok().build();
    }

    private Iterable<Regatta> getRegattasToExport(RacingEventService racingEventService, List<String> leaderboardGroupIds, List<String> eventIds) {
        HashSet<Regatta> result;
        HashSet<LeaderboardGroup> leaderboardGroups = new HashSet<LeaderboardGroup>();
        boolean atLeastOneIdProvided = false;
        if (leaderboardGroupIds != null) {
            for (String leaderboardGroupIdAsString : leaderboardGroupIds) {
                atLeastOneIdProvided = true;
                try {
                    leaderboardGroups.add(racingEventService.getLeaderboardGroupByID(UUID.fromString(leaderboardGroupIdAsString)));
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, "Couldn't parse " + leaderboardGroupIdAsString + " as a leaderboard group's UUID. Ignoring.");
                }
            }
        }
        if (eventIds != null) {
            for (String eventIdAsString : eventIds) {
                atLeastOneIdProvided = true;
                try {
                    Event event = racingEventService.getEvent((Serializable)UUID.fromString(eventIdAsString));
                    Util.addAll((Iterable)event.getLeaderboardGroups(), leaderboardGroups);
                }
                catch (IllegalArgumentException e) {
                    logger.log(Level.WARNING, "Couldn't parse " + eventIdAsString + " as an event's UUID. Ignoring.");
                }
            }
        }
        if (atLeastOneIdProvided) {
            HashSet<Regatta> resultSet = new HashSet<Regatta>();
            for (LeaderboardGroup leaderboardGroup : leaderboardGroups) {
                for (Leaderboard leaderboard : leaderboardGroup.getLeaderboards()) {
                    if (!leaderboard.getLeaderboardType().isRegattaLeaderboard()) continue;
                    resultSet.add(((RegattaLeaderboard)leaderboard).getRegatta());
                }
            }
            result = resultSet;
        } else {
            result = racingEventService.getAllRegattas();
        }
        return result;
    }

    private void exportIrms(RacingEventService racingEventService, Connection connection) throws SQLException {
        InsertIrmStatement insertIrms = new InsertIrmStatement(connection);
        insertIrms.insertBatch(Arrays.asList(MaxPointsReason.values()));
        insertIrms.executeBatch();
    }

    private void exportScoringSchemes(RacingEventService racingEventService, Connection connection) throws SQLException {
        InsertScoringSchemeStatement insertScoringScheme = new InsertScoringSchemeStatement(connection);
        ScoringSchemeType[] scoringSchemeTypeArray = ScoringSchemeType.values();
        int n = scoringSchemeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScoringSchemeType scoringSchemeType = scoringSchemeTypeArray[n2];
            ScoringScheme scoringScheme = racingEventService.getBaseDomainFactory().createScoringScheme(scoringSchemeType);
            insertScoringScheme.insertBatch(scoringScheme);
            ++n2;
        }
        insertScoringScheme.executeBatch();
    }

    private void exportBoatClasses(RacingEventService racingEventService, Connection connection) throws SQLException {
        InsertBoatClassStatement insertBoatClasses = new InsertBoatClassStatement(connection);
        insertBoatClasses.insertBatch(racingEventService.getBaseDomainFactory().getBoatClasses());
        insertBoatClasses.executeBatch();
    }

    private void exportRaces(RacingEventService racingEventService, Iterable<Regatta> regattasToExport, Connection connection) throws SQLException {
        TimePoint now = TimePoint.now();
        InsertEventStatement insertEvents = new InsertEventStatement(connection);
        InsertCompetitorStatement insertCompetitors = new InsertCompetitorStatement(connection);
        AlreadyInsertedContent alreadyInsertedContent = new AlreadyInsertedContent(insertEvents, insertCompetitors);
        InsertRegattaStatement insertRegattas = new InsertRegattaStatement(connection);
        InsertRaceStatement insertRaces = new InsertRaceStatement(connection);
        InsertRaceResultStatement insertRaceResults = new InsertRaceResultStatement(connection);
        InsertRaceStatsStatement insertRaceStats = new InsertRaceStatsStatement(connection);
        InsertLegStatement insertLegs = new InsertLegStatement(connection);
        InsertLegStatsStatement insertLegStats = new InsertLegStatsStatement(connection);
        InsertManeuverStatement insertManeuvers = new InsertManeuverStatement(connection);
        for (Regatta regatta : regattasToExport) {
            Event event;
            Leaderboard leaderboard = racingEventService.getLeaderboardByName(regatta.getName());
            if (leaderboard == null || (event = racingEventService.findEventContainingLeaderboardAndMatchingAtLeastOneCourseArea(leaderboard)) == null) continue;
            alreadyInsertedContent.ensureEventIsInserted(event);
            insertRegattas.insert(new InsertRegattaStatement.RegattaAndEvent(regatta, event));
            if (leaderboard == null) continue;
            for (RaceColumn raceColumn : leaderboard.getRaceColumns()) {
                for (Competitor competitor : raceColumn.getAllCompetitors()) {
                    alreadyInsertedContent.ensureCompetitorIsInserted(competitor);
                    Fleet fleet = raceColumn.getFleetOfCompetitor(competitor);
                    insertRaceResults.insertBatch(new InsertRaceResultStatement.RaceResult(regatta, leaderboard, competitor, raceColumn, fleet, now));
                }
                insertRaceResults.executeBatch();
                for (Fleet fleet : raceColumn.getFleets()) {
                    Waypoint startWaypoint;
                    TrackedRace trackedRace = raceColumn.getTrackedRace(fleet);
                    if (trackedRace != null) {
                        RankingMetric.RankingInfo rankingInfo = trackedRace.getRankingMetric().getRankingInfo(now);
                        LeaderboardDTOCalculationReuseCache cache = new LeaderboardDTOCalculationReuseCache(now);
                        insertRaces.insertBatch(new InsertRaceStatement.TrackedRaceWithRaceColumnAndFleet(trackedRace, raceColumn, fleet));
                        for (TrackedLeg trackedLeg : trackedRace.getTrackedLegs()) {
                            insertLegs.insertBatch(new InsertLegStatement.TrackedLegAndNow(now, trackedLeg));
                            for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
                                insertLegStats.insertBatch(new InsertLegStatsStatement.TrackedLegOfCompetitorRankingInfoCacheAndNow(now, rankingInfo, (WindLegTypeAndLegBearingAndORCPerformanceCurveCache)cache, trackedLeg.getTrackedLeg(competitor)));
                            }
                        }
                    }
                    Waypoint waypoint = startWaypoint = trackedRace == null ? null : trackedRace.getRace().getCourse().getFirstWaypoint();
                    if (trackedRace == null) continue;
                    for (Competitor competitor : trackedRace.getRace().getCompetitors()) {
                        insertRaceStats.insertBatch(new InsertRaceStatsStatement.TrackedRaceWithCompetitorAndStartWaypoint(now, startWaypoint, competitor, trackedRace));
                        LinkedHashMap<TimePoint, Maneuver> timepointUniqueManeuvers = new LinkedHashMap<TimePoint, Maneuver>();
                        for (Maneuver maneuver : trackedRace.getManeuvers(competitor, false)) {
                            if (maneuver.getType() != ManeuverType.TACK && maneuver.getType() != ManeuverType.JIBE && maneuver.getType() != ManeuverType.PENALTY_CIRCLE) continue;
                            timepointUniqueManeuvers.put(maneuver.getTimePoint(), maneuver);
                        }
                        for (Maneuver maneuver : timepointUniqueManeuvers.values()) {
                            insertManeuvers.insertBatch(new InsertManeuverStatement.ManeuverTrackedRaceAndCompetitor(maneuver, trackedRace, competitor));
                        }
                    }
                }
                insertRaces.executeBatch();
                insertLegs.executeBatch();
                insertLegStats.executeBatch();
                insertRaceStats.executeBatch();
                insertManeuvers.executeBatch();
            }
        }
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    @Path(value="createtables")
    public Response createTables(@QueryParam(value="drop") boolean drop, @FormParam(value="dbendpoint") String dbEndpoint, @FormParam(value="dbuser") String dbUser, @FormParam(value="dbpassword") String dbPassword) throws SQLException, IOException {
        SecurityUtils.getSubject().checkPermission(SecuredSecurityTypes.SERVER.getStringPermissionForTypeRelativeIdentifier((HasPermissions.Action)SecuredSecurityTypes.ServerActions.CAN_EXPORT_MASTERDATA, new TypeRelativeObjectIdentifier(new String[]{ServerInfo.getName()})));
        Connection connection = HanaConnectionFactory.INSTANCE.getConnection(Optional.ofNullable(dbEndpoint), Optional.ofNullable(dbUser), Optional.ofNullable(dbPassword));
        if (drop) {
            logger.info("Dropping HANA Cloud SAILING DB tables on behalf of user " + SecurityUtils.getSubject().getPrincipal());
            this.tryExecutingQueriesFromSqlResource("/droptables.sql", connection);
            logger.info("Done dropping HANA Cloud SAILING DB tables on behalf of user " + SecurityUtils.getSubject().getPrincipal());
        }
        logger.info("Creating HANA Cloud SAILING DB tables on behalf of user " + SecurityUtils.getSubject().getPrincipal());
        this.executeQueriesFromSqlResource("/createtables.sql", connection);
        logger.info("Done creating HANA Cloud SAILING DB tables on behalf of user " + SecurityUtils.getSubject().getPrincipal());
        return Response.ok().build();
    }

    private void tryExecutingQueriesFromSqlResource(String resourceWithSemicolonSeparatedStatements, Connection connection) throws IOException {
        String[] stringArray = this.getStatementsFromResource(resourceWithSemicolonSeparatedStatements);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String statementAsString = stringArray[n2];
            try {
                logger.fine("...executing " + statementAsString);
                connection.createStatement().execute(statementAsString);
            }
            catch (Exception e) {
                logger.info("Problem trying to execute " + statementAsString + "; continuing...");
            }
            ++n2;
        }
    }

    private String[] getStatementsFromResource(String resourceWithSemicolonSeparatedStatements) throws IOException {
        StringWriter sw = new StringWriter();
        IOUtils.copy((InputStream)((Object)((Object)this)).getClass().getResourceAsStream(resourceWithSemicolonSeparatedStatements), (Writer)sw);
        return sw.toString().split(";");
    }

    private void executeQueriesFromSqlResource(String resourceWithSemicolonSeparatedStatements, Connection connection) throws IOException, SQLException {
        String[] stringArray = this.getStatementsFromResource(resourceWithSemicolonSeparatedStatements);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String statementAsString = stringArray[n2];
            connection.createStatement().execute(statementAsString);
            ++n2;
        }
    }

    private class AlreadyInsertedContent {
        private final Set<Event> events = new HashSet<Event>();
        private final Set<Competitor> competitors = new HashSet<Competitor>();
        private final InsertCompetitorStatement insertCompetitors;
        private final InsertEventStatement insertEvents;

        public AlreadyInsertedContent(InsertEventStatement insertEvents, InsertCompetitorStatement insertCompetitors) {
            this.insertEvents = insertEvents;
            this.insertCompetitors = insertCompetitors;
        }

        public void ensureEventIsInserted(Event event) throws SQLException {
            if (!this.events.contains(event)) {
                this.events.add(event);
                this.insertEvents.insert(event);
            }
        }

        public void ensureCompetitorIsInserted(Competitor competitor) throws SQLException {
            if (!this.competitors.contains(competitor)) {
                this.competitors.add(competitor);
                this.insertCompetitors.insert(competitor);
            }
        }
    }
}

