/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.shared.server.gateway.jaxrs.api;

import com.sap.sailing.domain.common.MarkType;
import com.sap.sailing.domain.coursetemplate.CommonMarkProperties;
import com.sap.sailing.domain.coursetemplate.MarkTemplate;
import com.sap.sailing.domain.coursetemplate.impl.MarkTemplateImpl;
import com.sap.sailing.server.gateway.serialization.impl.MarkTemplateJsonSerializer;
import com.sap.sailing.shared.server.gateway.jaxrs.SharedAbstractSailingServerResource;
import com.sap.sse.common.Color;
import com.sap.sse.common.impl.RGBColor;
import com.sun.jersey.api.client.ClientResponse;
import java.util.UUID;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringEscapeUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Path(value="/v1/marktemplates")
public class MarkTemplateResource
extends SharedAbstractSailingServerResource {
    private Response getBadMarkTemplateValidationErrorResponse(String errorText) {
        return Response.status((Response.StatusType)ClientResponse.Status.BAD_REQUEST).entity((Object)(String.valueOf(StringEscapeUtils.escapeHtml((String)errorText)) + ".")).type("text/plain").build();
    }

    private Response getMarkTemplateNotFoundErrorResponse() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getMarkTemplates() throws Exception {
        Iterable markTemplateList = this.getSharedSailingData().getAllMarkTemplates();
        JSONArray result = new JSONArray();
        MarkTemplateJsonSerializer markTemplateSerializer = new MarkTemplateJsonSerializer();
        for (MarkTemplate markTemplates : markTemplateList) {
            result.add((Object)markTemplateSerializer.serialize((Object)markTemplates));
        }
        return Response.ok((Object)this.streamingOutput(result)).build();
    }

    @GET
    @Path(value="{markTemplateId}")
    @Produces(value={"application/json;charset=UTF-8"})
    public Response getMarkTemplate(@PathParam(value="markTemplateId") String markTemplateId) throws Exception {
        MarkTemplate markTemplate = this.getSharedSailingData().getMarkTemplateById(UUID.fromString(markTemplateId));
        if (markTemplate == null) {
            return this.getMarkTemplateNotFoundErrorResponse();
        }
        MarkTemplateJsonSerializer markTemplateSerializer = new MarkTemplateJsonSerializer();
        JSONObject serializedMarkTemplate = markTemplateSerializer.serialize((Object)markTemplate);
        return Response.ok((Object)this.streamingOutput(serializedMarkTemplate)).build();
    }

    @POST
    @Produces(value={"application/json;charset=UTF-8"})
    public Response createMarkTemplate(@FormParam(value="name") String name, @FormParam(value="shortName") String shortName, @FormParam(value="color") String rgbColor, @FormParam(value="shape") String shape, @FormParam(value="pattern") String pattern, @FormParam(value="markType") String markType) throws Exception {
        if (name == null || name.isEmpty()) {
            return this.getBadMarkTemplateValidationErrorResponse("name must be given");
        }
        String effectiveShortName = shortName == null || shortName.isEmpty() ? name : shortName;
        RGBColor color = null;
        if (rgbColor != null && rgbColor.length() > 0) {
            try {
                color = new RGBColor(rgbColor);
            }
            catch (IllegalArgumentException iae) {
                return this.getBadMarkTemplateValidationErrorResponse(String.format("invalid color %s", iae.getMessage()));
            }
        }
        MarkType type = null;
        if (markType != null && markType.length() > 0) {
            type = MarkType.valueOf((String)markType);
        }
        MarkTemplateImpl markTemplate = new MarkTemplateImpl(name, effectiveShortName, (Color)color, shape, pattern, type);
        MarkTemplate createdMarkTemplate = this.getSharedSailingData().createMarkTemplate((CommonMarkProperties)markTemplate);
        MarkTemplateJsonSerializer markTemplateSerializer = new MarkTemplateJsonSerializer();
        JSONObject serializedMarkTemplate = markTemplateSerializer.serialize((Object)createdMarkTemplate);
        return Response.ok((Object)this.streamingOutput(serializedMarkTemplate)).build();
    }
}

